/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskOhasdIntegrity;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class OHASDComponent
extends Component {
    OHASDComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 22: {
                boolean toUseHAinstall;
                if (VerificationUtil.isHAConfigured()) {
                    toUseHAinstall = true;
                } else if (VerificationUtil.isCRSInstalled()) {
                    toUseHAinstall = false;
                } else {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)"No CRS or HA is found installed on local node");
                    }
                    ReportUtil.printError(s_msgBundle.getMessage("5314", true));
                    this.m_resultSet.addResult(validNodeArr, 2);
                    return false;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("toUseHAinstall=" + toUseHAinstall));
                }
                TaskOhasdIntegrity taskOhasdI = new TaskOhasdIntegrity(validNodeArr, toUseHAinstall);
                retval &= taskOhasdI.perform();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"\n>>>> OHASDComponent:: Upload taskOhasdI >>>>>\n");
                }
                this.m_resultSet.uploadResultSet(taskOhasdI.getResultSet());
                return retval;
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    public String getComponentName() {
        return "OHASD";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9963", false);
    }
}

