/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskOLRIntegrity;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class OLRComponent
extends Component {
    private String m_olrLocation;

    OLRComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    protected boolean checkSetup() {
        ErrorDescription errDesc = null;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"==== OLR Component checkSetup");
        }
        if (!super.checkSetup()) {
            return false;
        }
        if (this.getValidNodeList() == null) {
            return false;
        }
        if (!VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSInstalled()) {
            errDesc = new ErrorDescription("5314", s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return true;
    }

    public boolean verify() {
        if (!this.checkSetup()) {
            return false;
        }
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 14: {
                TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(validNodeArr);
                boolean retval = taskOLRI.perform();
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)"\n>>>> OLRComponent:: Upload taskOLRI >>>>>\n");
                }
                this.m_resultSet.uploadResultSet(taskOLRI.getResultSet());
                return retval;
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    public String getComponentName() {
        return "OLR";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9964", false);
    }
}

