/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskScan;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ScanComponent
extends Component {
    ScanComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    protected boolean checkSetup() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (!super.checkSetup()) {
            return false;
        }
        if (this.getValidNodeList() == null) {
            return false;
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return true;
    }

    public boolean verify() {
        boolean retval;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (!(retval = this.checkSetup())) {
            return retval;
        }
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 21: {
                TaskScan taskScan = new TaskScan(crsNodes);
                retval &= taskScan.perform();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"\nUpload taskScan ResultSet\n");
                }
                this.m_resultSet.uploadResultSet(taskScan.getResultSet());
                return retval;
            }
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    public String getComponentName() {
        return "SCAN";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9965", false);
    }
}

