/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class SoftwareComponent
extends Component {
    private String m_product;
    private String m_productHome;
    private String m_release;

    SoftwareComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
        String oracleHome = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLEHOME);
        Trace.out((String)("==== ParamManager reports Oracle Home as: " + oracleHome));
        if (oracleHome != null) {
            this.m_product = "database";
            this.m_productHome = oracleHome;
            this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
        } else {
            this.m_product = "crs";
            String crsHome = VerificationUtil.getCRSHome();
            if (crsHome == null) {
                throw new ComponentInitException(s_msgBundle.getMessage("5301", false));
            }
            this.m_productHome = crsHome;
            String activeVersion = VerificationUtil.getCRSActiveVersion();
            if (activeVersion == null) {
                this.m_release = "11gR2";
            } else if (activeVersion.startsWith("11.2")) {
                this.m_release = "11gR2";
            } else if (activeVersion.startsWith("11.1")) {
                this.m_release = "11gR1";
            } else if (activeVersion.startsWith("10.2")) {
                this.m_release = "10gR2";
            } else if (activeVersion.startsWith("10.1")) {
                this.m_release = "10gR1";
            }
        }
    }

    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 16: {
                TaskSoftwareDistribution taskSD = new TaskSoftwareDistribution(crsNodes);
                taskSD.setNodeList(crsNodes);
                taskSD.setSoftwareComponent(this.m_product);
                taskSD.setSoftwareComponentHome(this.m_productHome);
                taskSD.setRelease(this.m_release);
                retval &= taskSD.perform();
                Trace.out((String)"\n>>>> SoftwareDistributionComponent:: Upload taskSD >>>>>\n");
                this.m_resultSet.uploadResultSet(taskSD.getResultSet());
                return !this.m_resultSet.anyFailure();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getComponentName() {
        return "SOFTWARE";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9966", false);
    }
}

