/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.TaskSpaceAvail;
import oracle.ops.verification.framework.param.Argument;

public class StorageComponent
extends Component {
    String m_location;
    long m_reqdSpace;
    String[] m_storageIDlist;
    String m_oracleFileType;

    StorageComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
        switch (this.m_verificationType) {
            case 1: {
                this.m_location = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_STORAGELOCATION);
                Trace.out((String)("==== ParamManager reports location as " + this.m_location));
                String reqSpace = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_DISKSPACE);
                this.m_reqdSpace = Long.parseLong(reqSpace);
                Trace.out((String)("==== ParamManager reports required as " + this.m_reqdSpace));
                break;
            }
            case 2: {
                this.m_storageIDlist = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_STORAGEIDLIST);
                this.m_oracleFileType = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLE_FILETYPE);
            }
        }
    }

    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 1: {
                TaskSpaceAvail taskSpcAvl = new TaskSpaceAvail(validNodeArr);
                taskSpcAvl.setLocation(this.m_location);
                taskSpcAvl.setReqdSpace(this.m_reqdSpace);
                Trace.out((String)"\n>>>> StorageComponent:: Upload taskSpcAvl >>>>>\n");
                this.m_resultSet.uploadResultSet(taskSpcAvl.getResultSet());
                return retval &= taskSpcAvl.perform();
            }
            case 2: {
                TaskSharedStorageAccess taskSSA = new TaskSharedStorageAccess(validNodeArr);
                taskSSA.setStorageIDlist(this.m_storageIDlist);
                taskSSA.setOracleFileType(this.getOracleFileType(this.m_oracleFileType));
                Trace.out((String)"\n>>>> StorageComponent:: Upload taskSSA >>>>>\n");
                this.m_resultSet.uploadResultSet(taskSSA.getResultSet());
                return retval &= taskSSA.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    private OracleFileType getOracleFileType(String typeFlag) {
        if ("software".equals(typeFlag)) {
            return OracleFileType.RAC_SOFTWARE;
        }
        if ("data".equals(typeFlag)) {
            return OracleFileType.RAC_DATA_FILES;
        }
        if ("ocr_vdisk".equals(typeFlag)) {
            return OracleFileType.RAC_OCR_VDISK;
        }
        return OracleFileType.RAC_DATA_FILES;
    }

    public String getComponentName() {
        return "STORAGE";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9967", false);
    }
}

