/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskUSMIntegrity;
import oracle.ops.verification.framework.engine.task.TaskUSMUdevChecks;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class USMComponent
extends Component {
    private String m_product;
    private String m_release;
    private String m_fileSystem;

    USMComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
        this.m_fileSystem = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_FILESYSTEM);
        Trace.out((String)("==== ParamManager reports File System is: " + this.m_fileSystem));
    }

    public boolean verify() {
        Trace.out((int)5, (String)"Commencing USM Integrity verify()...");
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 17: {
                if (!VerificationUtil.isUSMSupported()) {
                    ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9996", false, (Object[])new String[]{VerificationUtil.getCurrentOS() + " (" + VerificationUtil.getCurrentArch() + ")"}));
                    this.m_resultSet.addResult(crsNodes, 2);
                    return false;
                }
                this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
                TaskUSMIntegrity taskUSM = new TaskUSMIntegrity(crsNodes);
                taskUSM.setFileSystem(this.m_fileSystem);
                retval = taskUSM.perform();
                Trace.out((int)5, (String)"\n>>>> USMComponent: Upload taskUSM >>>>>\n");
                this.m_resultSet.uploadResultSet(taskUSM.getResultSet());
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                if (VerificationUtil.isUDEVSupported()) {
                    TaskUSMUdevChecks taskUSMdev = new TaskUSMUdevChecks(this.getNodeList());
                    retval = taskUSMdev.perform();
                    Trace.out((int)5, (String)"\n>>>> USMComponent: Upload taskUSMdev>>>>>\n");
                    this.m_resultSet.uploadResultSet(taskUSMdev.getResultSet());
                }
                return !this.m_resultSet.anyFailure();
            }
        }
        Trace.out((int)15, (String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getComponentName() {
        return "ACFS";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9969", false);
    }
}

