/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReqCFSSetup;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;

public class CFSSetupStage
extends Stage {
    private String[] m_CFSstorageLocation;
    private String m_fileSystem;

    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside CFSSetupStage:init()...");
        if (this.m_verificationMode == 1) {
            this.m_CFSstorageLocation = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_STORAGEIDLIST);
            Trace.out((String)("==== ParamManager reports CFS storage location list as " + this.m_CFSstorageLocation));
        } else {
            this.m_fileSystem = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_FILESYSTEM);
            Trace.out((String)("==== ParamManager reports File System as: " + this.m_fileSystem));
        }
    }

    CFSSetupStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            ParamPreReqCFSSetup param = new ParamPreReqCFSSetup();
            List<Task> haConfigStageTaskList = null;
            param.setStorageIDlist(this.m_CFSstorageLocation);
            haConfigStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CFS_SETUP, this.getValidNodeList(), param, this);
            this.addToCurrentTaskSet(haConfigStageTaskList.toArray(new Task[0]));
        } else {
            ParamPreReqCFSSetup param = new ParamPreReqCFSSetup();
            List<Task> haConfigStageTaskList = null;
            param.setFileSystem(this.m_fileSystem);
            haConfigStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_CFS_SETUP, this.getValidNodeList(), param, this);
            this.addToCurrentTaskSet(haConfigStageTaskList.toArray(new Task[0]));
        }
    }

    public void generateReport() {
    }
}

