/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterSvcSetupStage
extends Stage {
    private String[] m_OCRlocation;
    private String[] m_VdiskLocation;
    private String m_CRSHomeLocation;
    private String m_osdba;
    private String m_oraInv;
    private String m_asmgrp;
    private ParamPreReqCRSInst m_param;
    private String[] m_asmDev;
    private boolean m_ASMCheck;

    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside ClusterSvcSetupStage:init()...");
        if (this.m_verificationMode == 1) {
            this.m_OCRlocation = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_OCRLOCATION);
            Trace.out((String)("==== ParamManager reports OCR storage locations as " + VerificationUtil.strArr2List(this.m_OCRlocation)));
            this.m_VdiskLocation = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_VOTINGDISK);
            Trace.out((String)("==== ParamManager reports Voting Disk locations as " + VerificationUtil.strArr2List(this.m_VdiskLocation)));
            this.m_CRSHomeLocation = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_CRSHOME);
            Trace.out((String)("==== ParamManager reports CRS Home location as: " + this.m_CRSHomeLocation));
            this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
            Trace.out((String)("==== ParamManager reports OSDBA as: " + this.m_osdba));
            this.m_asmgrp = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ASMGRP);
            Trace.out((String)("==== ParamManager reports ASMADMIN group as: " + this.m_asmgrp));
            this.m_oraInv = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
            Trace.out((String)("==== ParamManager reports ORAINV as: " + this.m_oraInv));
            this.m_asmDev = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_ASM_DEVICES);
            Trace.out((String)("==== ParamManager reports ASM_DEVICES as: " + this.m_asmDev));
            this.m_ASMCheck = this.m_paramMgr.checkASM();
            Trace.out((String)("==== ParamManager reports Check-ASM as " + this.m_ASMCheck));
            this.m_param = new ParamPreReqCRSInst();
            if (this.m_osdba == null) {
                this.m_osdba = VerificationUtil.getDefaultDbaGroup();
            }
            if (this.m_oraInv == null) {
                this.m_oraInv = VerificationUtil.getDefaultOraInvGroup();
            }
            if (this.m_asmgrp == null) {
                this.m_asmgrp = VerificationUtil.getDefaultAsmGroup();
            }
            if (this.m_asmDev == null) {
                this.m_asmDev = VerificationUtil.getDefaultDiscoveryDevice();
            }
            this.m_param.setOSDBAgroup(this.m_osdba);
            this.m_param.setORAINVgroup(this.m_oraInv);
            this.m_param.setASMADMINgroup(this.m_asmgrp);
            this.m_param.setCRSHome(this.m_CRSHomeLocation);
            if (this.m_OCRlocation != null) {
                this.m_param.setOCRLoc(this.m_OCRlocation);
            }
            if (this.m_VdiskLocation != null) {
                this.m_param.setVotingLoc(this.m_VdiskLocation);
            }
            this.m_param.setASMDevice(this.m_asmDev);
            this.m_param.setASMCheck(this.m_ASMCheck);
        }
    }

    ClusterSvcSetupStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    protected boolean checkSetup() {
        super.checkSetup();
        String[] validNodesPreCRSchk = this.getValidNodeList();
        if (validNodesPreCRSchk == null || validNodesPreCRSchk.length == 0) {
            return false;
        }
        if (this.m_verificationMode == 1) {
            Trace.out((String)"==== Skipping CRS home check. n/a for pre check");
            return validNodesPreCRSchk.length == this.getNodeList().length;
        }
        String[] nodesWithCRSinstall = VerificationUtil.getNodesWithCRSInstall(validNodesPreCRSchk, this.m_resultSet);
        this.setValidNodeList(nodesWithCRSinstall);
        if (nodesWithCRSinstall == null) {
            return false;
        }
        return nodesWithCRSinstall.length == this.getNodeList().length;
    }

    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> crsInstStageTaskList = null;
            crsInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CRS_INST, this.getValidNodeList(), this.m_param, this);
            this.addToCurrentTaskSet(crsInstStageTaskList.toArray(new Task[0]));
        } else {
            List<Task> crsInstStageTaskList = null;
            crsInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_CRS_INST, this.getValidNodeList(), null, this);
            this.addToCurrentTaskSet(crsInstStageTaskList.toArray(new Task[0]));
        }
    }

    public void generateReport() {
    }
}

