/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.net.UnknownHostException;
import java.util.List;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DBConfigStage
extends Stage {
    private String m_oracleHome;
    private ParamPreReqDBConfig m_param;

    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside DBConfigStage:init()...");
        if (this.m_verificationMode == 1) {
            String errorMsg;
            this.m_oracleHome = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLEHOME);
            Trace.out((String)("==== ParamManager reports Oracle Home as: " + this.m_oracleHome));
            boolean ohomeExists = false;
            try {
                ohomeExists = new ClusterCmd().dirExists(VerificationUtil.getLocalHost(), this.m_oracleHome);
            }
            catch (UnknownHostException e) {
                ReportUtil.printError(s_msgBundle.getMessage("0002", false));
            }
            catch (ClusterException e) {
                Trace.out((String)("Could not check existence of  oracle home " + e.getMessage()));
                String errorMsg2 = s_msgBundle.getMessage("0006", true, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg2);
            }
            if (!ohomeExists) {
                String errorMsg3 = s_msgBundle.getMessage("4900", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg3);
            }
            this.m_param = new ParamPreReqDBConfig(this.m_oracleHome);
            String dbaGroup = null;
            String oraInvGroup = null;
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            try {
                dbaGroup = nativeSystem.getOracleGroup(this.m_oracleHome);
            }
            catch (NativeException e) {
                Trace.out((String)("ERROR: Problem in getting OSDBA group from Oracle Home: '" + this.m_oracleHome + "'"));
                Trace.out((Exception)((Object)e));
                String errorMsg4 = s_msgBundle.getMessage("4013", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg4);
            }
            if (dbaGroup == null) {
                errorMsg = s_msgBundle.getMessage("4013", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg);
            }
            if ((oraInvGroup = VerificationUtil.getOraInventoryGroup()) == null && nativeSystem.isUnixSystem()) {
                errorMsg = s_msgBundle.getMessage("0049", false);
                ReportUtil.printError(errorMsg);
            }
            this.m_param.setOSDBAgroup(dbaGroup);
            this.m_param.setOraInv(oraInvGroup);
            this.m_param.setCRSHome(VerificationUtil.getCRSHome());
            this.m_param.setHAHome(VerificationUtil.getHAHome());
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"OracleHome=%s, OSDBA=%s, OraInv=%s", (Object[])new Object[]{this.m_oracleHome, dbaGroup, oraInvGroup});
            }
        }
    }

    DBConfigStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> dbInstStageTaskList = null;
            dbInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, this.getValidNodeList(), this.m_param, this);
            this.addToCurrentTaskSet(dbInstStageTaskList.toArray(new Task[0]));
        }
    }

    public void generateReport() {
    }
}

