/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NodeAddStage
extends Stage {
    private String m_localNode;
    private String[] m_clusterNodes;
    private String[] m_newClusterNodes;
    private ParamPreReqNodeAddDel m_param;

    public void init() throws StageInitException {
        super.init();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.m_param = new ParamPreReqNodeAddDel();
        try {
            this.m_clusterNodes = VerificationUtil.getStaticNodelist();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n== Cluster nodelist: " + VerificationUtil.strArr2List(this.m_clusterNodes) + "\n== Parameter node(s): " + VerificationUtil.strArr2List(this.m_nodeList) + "\n"));
            }
            ArrayList<String> clusterList = new ArrayList<String>(Arrays.asList(this.m_clusterNodes));
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("== clusterList: " + ((Object)clusterList).toString()));
            }
            for (String node : this.m_nodeList) {
                if (clusterList.contains(node)) continue;
                clusterList.add(node);
            }
            this.m_newClusterNodes = clusterList.toArray(new String[clusterList.size()]);
            this.m_param.setNewClusterNodes(this.m_newClusterNodes);
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("==== NODELISTNOTFOUNDEXCEPTION: \n==== Could not get the local host name. \n" + e.getMessage()));
            Trace.stackTrace((Throwable)e);
            throw new StageInitException(new String[]{s_msgBundle.getMessage("4853", false), s_msgBundle.getMessage("4909", false), e.getMessage()});
        }
        if (this.m_verificationMode == 1) {
            // empty if block
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Node Add list: " + VerificationUtil.strArr2List(this.m_nodeList)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    NodeAddStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    protected boolean checkSetup() {
        ErrorDescription errDesc = null;
        String errMsg = null;
        ArrayList<String> clusterList = null;
        ArrayList<String> validNewNodeList = null;
        String[] validClusterNodeList = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        boolean saveMode = ReportUtil.getMode();
        ReportUtil.setMode(false);
        super.checkSetup(this.m_clusterNodes);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Checking cluster nodes for setup: " + VerificationUtil.strArr2List(this.m_clusterNodes)));
        }
        ReportUtil.setMode(saveMode);
        validClusterNodeList = this.getValidNodeList();
        if (validClusterNodeList == null) {
            ReportUtil.printError(s_msgBundle.getMessage("7610", true) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
            }
            return false;
        }
        try {
            this.m_localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("==== UNKNOWNHOSTEXCEPTION: \n==== Could not get the local host name. \n" + uhe.getMessage()));
                Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
            }
            ReportUtil.printError(uhe.getMessage());
            String errmsg = LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(errmsg);
            return false;
        }
        clusterList = new ArrayList<String>(Arrays.asList(validClusterNodeList));
        this.m_param.setValidClusterNodes(validClusterNodeList);
        this.m_param.setNodes(this.m_nodeList);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Valid cluster nodes after setup: " + VerificationUtil.strArr2List(validClusterNodeList)));
        }
        this.getResultSet().clear();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Checking command line nodes for setup: " + VerificationUtil.strArr2List(this.m_nodeList)));
        }
        this.setValidNodeList(new String[0]);
        super.checkSetup(this.m_nodeList);
        this.m_param.setValidNodes(this.getValidNodeList());
        validNewNodeList = new ArrayList<String>(Arrays.asList(this.getValidNodeList()));
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Valid command line nodes after setup: " + VerificationUtil.strArr2List(this.getValidNodeList())));
        }
        for (String node : validNewNodeList) {
            if (clusterList.contains(node)) continue;
            clusterList.add(node);
        }
        this.m_param.setValidNewClusterNodes(clusterList.toArray(new String[0]));
        this.m_param.setValidNewNodesList(validNewNodeList.toArray(new String[0]));
        if (validNewNodeList.size() == 0) {
            this.m_resultSet.setStatus(3);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
            }
            return false;
        }
        errDesc = new ErrorDescription("7593", s_msgBundle);
        try {
            if (!VerificationUtil.isCRSInstalledOnLocalNode()) {
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(this.m_localNode, 4);
                ReportUtil.printError(errDesc.getErrorMessage());
                Trace.out((String)"==== CRS NOT INSTALLEED ON LOCAL HOST.");
                errMsg = s_msgBundle.getMessage("0007", false);
                ReportUtil.printError(errMsg);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
                }
                return false;
            }
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("==== UNKNOWNHOSTEXCEPTION: \n==== Could not get the local host name. \n" + uhe.getMessage()));
            Trace.stackTrace((Throwable)uhe);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + uhe.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_localNode, 4);
            ReportUtil.printError(errDesc.getErrorMessage());
            String errmsg = LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(errmsg);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
            }
            return false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("== Parameters: \n" + this.m_param.toString()));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return this.getValidNodeList() != null;
    }

    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        String errMsg;
        Object errDesc = null;
        boolean fail = false;
        ArrayList<String> existingClusterNodeList = new ArrayList<String>(Arrays.asList(this.m_clusterNodes));
        ArrayList<String> validNewClusterNodes = new ArrayList<String>(Arrays.asList(this.m_param.getValidNewClusterNodes()));
        ArrayList<String> nodesNotInClusterList = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        nodesNotInClusterList = new ArrayList<String>(Arrays.asList(this.m_nodeList));
        nodesNotInClusterList.removeAll(existingClusterNodeList);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n\n  Node(s) specified on command line: " + VerificationUtil.strArr2List(this.m_nodeList) + "\n  Cluster nodes: " + VerificationUtil.strArr2List(this.m_clusterNodes) + "\n  New cluster list: " + VerificationUtil.strArr2List(this.m_newClusterNodes) + "\n  Nodes NOT in cluster: " + nodesNotInClusterList + "\n"));
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n Getting CRSHome.");
        }
        String crsHome = VerificationUtil.getCRSHome();
        try {
            VIPAddress vipAddr;
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n Getting VIP resource for node: " + this.m_clusterNodes[0] + "\n CRSHome: " + crsHome));
            }
            VIP clusterVIP = new VIP(this.m_clusterNodes[0], crsHome);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n Getting VIPAddress resource.");
            }
            if ((vipAddr = clusterVIP.getVIPAddress()) == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\n Could not get VIP resource for node: " + this.m_clusterNodes[0] + "\n CRSHome: " + crsHome));
                }
                errMsg = s_msgBundle.getMessage("4858", false, (Object[])new String[]{this.m_clusterNodes[0]});
                ReportUtil.printWarning(errMsg + LSEP);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            }
        }
        catch (VirtualIPException vipe) {
            Trace.out((String)("VIRTUAL_IP_EXCEPTION: \n======= NO VIP Interface names found! =======" + (Object)((Object)vipe)));
        }
        if (this.m_verificationMode == 1) {
            for (String node : this.m_nodeList) {
                if (!existingClusterNodeList.contains(node)) continue;
                errMsg = s_msgBundle.getMessage("4865", false, (Object[])new String[]{node});
                ReportUtil.printWarning(errMsg);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("\n Node (" + node + ") already in cluster.\n" + " Cluster nodes: " + existingClusterNodeList));
            }
            Object[] clusterNodes = this.m_param.getValidClusterNodes();
            Object[] newClusterNodes = this.m_param.getValidNewClusterNodes();
            Arrays.sort(clusterNodes);
            Arrays.sort(newClusterNodes);
            if (!Arrays.equals(clusterNodes, newClusterNodes)) {
                List<Task> nodeAddStageTaskList = null;
                nodeAddStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_NODE_ADD, this.m_param.getValidNodes(), this.m_param, this);
                this.addToCurrentTaskSet(nodeAddStageTaskList.toArray(new Task[0]));
            } else {
                Trace.out((String)("NO WORK!!\n Parameters: " + this.m_param.toString()));
            }
        } else {
            String[] validNodes = this.m_param.getValidNodes();
            ArrayList<String> addValidNodes = new ArrayList<String>();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nParameters: " + this.m_param.toString()));
            }
            if (validNodes.length != 0) {
                for (String node3 : validNodes) {
                    if (!nodesNotInClusterList.contains(node3)) {
                        addValidNodes.add(node3);
                        continue;
                    }
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\nNode not in cluster: " + node3));
                    }
                    errMsg = s_msgBundle.getMessage("4853", false);
                    String cause = s_msgBundle.getMessage("7006", false, (Object[])new String[]{node3});
                    String action = s_msgBundle.getMessage("4034", false);
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                    this.m_resultSet.addResult(node3, 3);
                    ReportUtil.printError(errMsg + LSEP + cause + LSEP);
                    fail = true;
                }
                if (addValidNodes.size() != 0) {
                    validNodes = addValidNodes.toArray(new String[0]);
                    this.m_param.setValidNodes(validNodes);
                    List<Task> nodeAddStageTaskList = null;
                    nodeAddStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_NODE_ADD, validNodes, this.m_param, this);
                    this.addToCurrentTaskSet(nodeAddStageTaskList.toArray(new Task[0]));
                }
            } else {
                fail = true;
            }
        }
        if (!fail) {
            this.m_resultSet.setStatus(1);
        } else {
            this.m_resultSet.setStatus(3);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.m_resultSet.traceResultSet("Post NodeAdd");
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4439", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4492", false);
    }

    public void generateReport() {
        ResultSet m_stageResultSet = this.getResultSet();
        m_stageResultSet.traceResultSet("*** results BEFORE node purge...");
        Hashtable stageRT = m_stageResultSet.getResultTable();
        for (String node : this.m_clusterNodes) {
            stageRT.remove(node);
        }
        m_stageResultSet.setStatus();
        m_stageResultSet.traceResultSet("*** results AFTER node purge...");
    }
}

