/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RDBMSInstallStage
extends Stage {
    private String m_oracleHome;
    private boolean m_oracleHomeOnCFS;
    private String m_osdba;
    private String m_oraInv;
    private ParamPreReqDBInst m_param = null;
    private boolean m_ASMCheck;
    private boolean m_USMCheck;
    private String[] m_ASMDGList;

    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside RDBMSInstallStage:init()...");
        if (this.m_verificationMode == 1) {
            this.m_oracleHome = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_ORACLEHOME);
            Trace.out((String)("==== ParamManager reports Oracle Home as: " + this.m_oracleHome));
            this.m_oracleHomeOnCFS = this.m_paramMgr.checkArgCfsOh();
            Trace.out((String)("==== ParamManager reports OracleHome-On-CFS as: " + this.m_oracleHomeOnCFS));
            this.m_ASMCheck = this.m_paramMgr.checkASM();
            Trace.out((String)("==== ParamManager reports Check-ASM as " + this.m_ASMCheck));
            this.m_USMCheck = this.m_paramMgr.checkUSM();
            Trace.out((String)("==== ParamManager reports Check-USM as " + this.m_USMCheck));
            this.m_ASMDGList = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_ASM_DISKGROUP);
            if (this.m_ASMDGList != null) {
                for (String dg : this.m_ASMDGList) {
                    Trace.out((int)5, (String)("==== ParamManager reports dg as " + dg));
                }
            }
            this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
            Trace.out((String)("==== ParamManager reports OSDBA as: " + this.m_osdba));
            if (this.m_osdba == null) {
                this.m_osdba = VerificationUtil.getDefaultDbaGroup();
            }
            this.m_oraInv = VerificationUtil.getOraInventoryGroup();
            Trace.out((String)"Entering values into ParamPreReqDBInst...");
            this.m_param = new ParamPreReqDBInst();
            this.m_param.setOraInv(this.m_oraInv);
            this.m_param.setOSDBAgroup(this.m_osdba);
            this.m_param.setOrclHomeOnOCFS(this.m_oracleHomeOnCFS);
            this.m_param.setCRSHome(VerificationUtil.getCRSHome());
            this.m_param.setHAHome(VerificationUtil.getHAHome());
            this.m_param.setASMCheck(this.m_ASMCheck);
            this.m_param.setUSMCheck(this.m_USMCheck);
            this.m_param.setASMDGList(this.m_ASMDGList);
        }
    }

    RDBMSInstallStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> dbInstStageTaskList = null;
            dbInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_INST, this.getValidNodeList(), this.m_param, this);
            this.addToCurrentTaskSet(dbInstStageTaskList.toArray(new Task[0]));
        }
    }

    public void generateReport() {
    }
}

