/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationTask;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Stage
implements VerificationConstants,
MultiTaskHandler {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected String[] m_nodeList;
    protected String[] m_validNodeList;
    protected int m_verificationMode;
    private Vector m_currentTaskSet = new Vector();
    protected ParamManager m_paramMgr;
    protected ResultSet m_resultSet = new ResultSet();

    Stage(int verificationMode) throws StageInitException {
        Trace.out((String)"Inside constructor of Stage(mode)...");
        this.m_verificationMode = verificationMode;
    }

    public void init() throws StageInitException {
        Trace.out((String)"Inside init of Stage...");
        try {
            this.m_paramMgr = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            throw new StageInitException(e.getMessage());
        }
        try {
            this.m_nodeList = VerificationUtil.getNodelist();
        }
        catch (NodelistNotFoundException e) {
            throw new StageInitException(e.getMessage());
        }
    }

    protected String[] getNodeList() {
        return this.m_nodeList;
    }

    protected String[] getValidNodeList() {
        return this.m_validNodeList;
    }

    protected void setValidNodeList(String[] validNodeList) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n Setting Valid Node list to: " + VerificationUtil.strArr2List(validNodeList)));
        }
        this.m_validNodeList = validNodeList;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public abstract void generateReport();

    protected abstract void setTaskList() throws TaskFactoryException, PreReqNotSupportedException;

    protected boolean checkSetup() {
        return this.checkSetup(this.getNodeList());
    }

    protected boolean checkSetup(String[] nodeList) {
        String[] succNodeArr = nodeList;
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        Trace.out((String)" Performing checkSetup for stage...");
        TaskNodeConnectivity taskNodeReach = new TaskNodeConnectivity(nodeList);
        taskNodeReach.setTaskType(1);
        boolean nodeReachSucc = taskNodeReach.perform();
        this.m_resultSet.uploadResultSet(taskNodeReach.getResultSet());
        if (!nodeReachSucc) {
            taskNodeReach.getResultSet().getSuccNodes(succNodes, failNodes);
            if (succNodes.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4095", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            ReportUtil.printWarning(s_msgBundle.getMessage("4096", false));
            ReportUtil.sureprintNodelist(failNodes);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(succNodes);
            succNodeArr = succNodes.toArray(new String[succNodes.size()]);
        }
        TaskAdminPrivileges taskUserEquiv = new TaskAdminPrivileges(succNodeArr, "user_equiv");
        taskUserEquiv.setCheckNodeReach(false);
        boolean userEquivSucc = taskUserEquiv.perform();
        this.m_resultSet.uploadResultSet(taskUserEquiv.getResultSet());
        if (!userEquivSucc) {
            succNodes.clear();
            failNodes.clear();
            taskUserEquiv.getResultSet().getSuccNodes(succNodes, failNodes);
            if (succNodes.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4008", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            ReportUtil.printWarning(s_msgBundle.getMessage("4009", false));
            ReportUtil.sureprintNodelist(failNodes);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(succNodes);
            succNodeArr = succNodes.toArray(new String[succNodes.size()]);
        }
        succNodes.clear();
        failNodes.clear();
        boolean destLocSucc = VerificationUtil.checkDestLoc(succNodeArr, this.m_resultSet, succNodes, failNodes, true);
        if (succNodes.size() > 0) {
            succNodeArr = succNodes.toArray(new String[succNodes.size()]);
            this.setValidNodeList(succNodeArr);
        }
        boolean succ = null == succNodeArr ? false : succNodeArr.length == nodeList.length;
        return succ;
    }

    public final boolean verify() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Inside Stage.verify()...");
        }
        this.checkSetup();
        if (null == this.getValidNodeList()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n ==== NO VALID NODES ====");
            }
            return false;
        }
        try {
            this.setTaskList();
        }
        catch (TaskFactoryException e) {
            this.m_resultSet.addResult(this.getValidNodeList(), 2);
            this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (PreReqNotSupportedException e) {
            this.m_resultSet.addResult(this.getValidNodeList(), 2);
            this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n Tasks in Task Set List: ");
            for (int dbgi = 0; dbgi < this.m_currentTaskSet.size(); ++dbgi) {
                Task trcTask = (Task)this.m_currentTaskSet.get(dbgi);
                Trace.out((String)("TaskSet task: \n" + trcTask.getClass().getName()));
                if (!trcTask.hasSubtasks()) continue;
                try {
                    List<VerificationTask> subTaskList = trcTask.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        Trace.out((String)("         sub-task: \n" + subTask.getClass().getName()));
                    }
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.getValidNodeList(), 2);
                    this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
        }
        while (this.m_currentTaskSet.size() != 0) {
            Task task;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("m_currentTaskSet.size=" + this.m_currentTaskSet.size()));
            }
            if ((task = (Task)this.m_currentTaskSet.firstElement()).hasSubtasks()) {
                this.m_currentTaskSet.remove(0);
                try {
                    this.m_currentTaskSet.addAll(0, task.getSubtasks());
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.getValidNodeList(), 2);
                    this.m_resultSet.addErrorDescription(this.getValidNodeList(), new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            boolean taskResult = task.perform();
            this.m_resultSet.uploadResultSet(task.getResultSet());
            switch (task.getActionOnCompletion()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (taskResult) break;
                    return false;
                }
                case 3: {
                    if (taskResult || this.actionOnTaskError(task)) break;
                    return false;
                }
                case 4: {
                    if (this.actionOnTaskCompletion(task)) break;
                    return false;
                }
            }
        }
        this.generateReport();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Stage.verify(): setting status and exiting...");
        }
        return this.m_resultSet.getStatus() == 1 || this.m_resultSet.getStatus() == 4;
    }

    public synchronized Vector getCurrentTaskSet() {
        return this.m_currentTaskSet;
    }

    public synchronized void addToCurrentTaskSet(Task task) {
        this.m_currentTaskSet.addElement(task);
    }

    public synchronized void addToCurrentTaskSet(Task[] taskArr) {
        for (int i = 0; i < taskArr.length; ++i) {
            this.m_currentTaskSet.addElement(taskArr[i]);
        }
    }

    public synchronized void removeFromCurrentTaskSet(Task task) {
        this.m_currentTaskSet.removeElement(task);
    }

    public boolean actionOnTaskError(Task task) {
        Trace.out((String)"Inside stage:actionOnTaskError()...");
        return true;
    }

    public boolean actionOnTaskCompletion(Task task) {
        Trace.out((String)"Inside stage:actionOnTaskCompletion()...");
        return true;
    }
}

