/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReqUSMConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class USMConfigStage
extends Stage {
    private String m_asmgrp;
    private String[] m_asmdev;
    private String[] m_asmdskgrp;

    public void init() throws StageInitException {
        super.init();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Inside USMConfigStage:init()...");
        }
        if (this.m_verificationMode == 1) {
            this.m_asmdev = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_ASM_DEVICES);
            if (Trace.isTraceEnabled() && this.m_asmdev != null) {
                Trace.out((String)("==== ParamManager reports ASM device as : " + this.m_asmdev[0]));
            }
            this.m_asmgrp = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ASMGRP);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("==== ParamManager reports ASM group as : : " + this.m_asmgrp));
            }
        } else {
            this.m_asmdskgrp = this.m_paramMgr.getMultiPartArgVal(Argument.ARG_ASM_DISKGROUP);
        }
    }

    USMConfigStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            ParamPreReqUSMConfig param = new ParamPreReqUSMConfig();
            param.setASMDeviceArr(this.m_asmdev);
            param.setAsmGrp(this.m_asmgrp);
            List<Task> usmCfgStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_USM_CONFIG, this.getValidNodeList(), param, this);
            this.addToCurrentTaskSet(usmCfgStageTaskList.toArray(new Task[0]));
        } else {
            String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(this.getValidNodeList(), this.m_resultSet);
            if (null == crsNodes) {
                return;
            }
            List<Task> usmCfgStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_USM_CONFIG, crsNodes, null, this);
            this.addToCurrentTaskSet(usmCfgStageTaskList.toArray(new Task[0]));
        }
    }

    public void generateReport() {
    }
}

