/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoaderException;
import oracle.ops.verification.framework.engine.task.SoftwareDistributionFileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CompSoftwareConfigLoader {
    static final String CHAR_INDIRECTION = "$";
    static final String TAG_ROOTSOFTWARE_COMPONENTS = "SoftwareComponents";
    static final String TAG_SOFTWARE_COMPONENT = "SoftwareComponent";
    static final String TAG_COMPONENT_NAME = "Name";
    static final String TAG_COMPONENT_HOME = "Home";
    static final String TAG_FILE = "File";
    static final String TAG_FILE_NAME = "Name";
    static final String TAG_FILE_EXT = "Ext";
    static final String TAG_FILE_PATH = "Path";
    static final String TAG_FILE_ABS_PATH = "AbsolutePath";
    static final String TAG_FILE_OWNER = "Owner";
    static final String TAG_FILE_GROUP = "Group";
    static final String TAG_FILE_PERMISSIONS = "Permissions";
    private String m_conDataFile;
    private String m_compHome;
    private String m_comp;

    CompSoftwareConfigLoader(String filename, String softwareComponent, String softwareComponentHome) {
        this.m_conDataFile = filename;
        this.m_compHome = softwareComponentHome;
        this.m_comp = softwareComponent;
    }

    final HashMap load() throws CompSoftwareConfigLoaderException {
        try {
            Element relm;
            String rootElm;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            DefaultHandler handler = new DefaultHandler();
            parser.setErrorHandler(handler);
            String conDataFile = this.m_conDataFile;
            if (!VerificationUtil.isAbsoluteURI(conDataFile)) {
                conDataFile = new File(conDataFile).toURI().toString();
            }
            Document doc = parser.parse(conDataFile);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Parser validation set to: " + parser.isValidating()));
                Trace.out((String)(this.m_conDataFile + " is well-formed"));
            }
            if (!(rootElm = (relm = doc.getDocumentElement()).getTagName()).equalsIgnoreCase(TAG_ROOTSOFTWARE_COMPONENTS)) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"ERROR: Invalid root element");
                }
                throw new CompSoftwareConfigLoaderException("Invalid root element. Expected='SoftwareComponents' Found='" + rootElm + "'");
            }
            NodeList softwareComponents = relm.getElementsByTagName(TAG_SOFTWARE_COMPONENT);
            LinkedHashMap compFileListHash = new LinkedHashMap();
            for (int k = 0; k < softwareComponents.getLength(); ++k) {
                Element softwareComponent = (Element)softwareComponents.item(k);
                ArrayList<SoftwareDistributionFileInfo> compFileList = new ArrayList<SoftwareDistributionFileInfo>();
                String compName = softwareComponent.getAttribute("Name");
                if (!compName.equals(this.m_comp)) continue;
                NodeList files = softwareComponent.getElementsByTagName(TAG_FILE);
                for (int i = 0; i < files.getLength(); ++i) {
                    SoftwareDistributionFileInfo fileInfo = this.readCompFile((Element)files.item(i), this.m_compHome);
                    compFileList.add(fileInfo);
                }
                compFileListHash.put(compName, compFileList);
            }
            return compFileListHash;
        }
        catch (SAXException e) {
            String errtxt = "'" + this.m_conDataFile + " is not well-formed. ";
            throw new CompSoftwareConfigLoaderException(errtxt + e.getMessage());
        }
        catch (IOException e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
    }

    private SoftwareDistributionFileInfo readCompFile(Element distributedFileElem, String compHome) {
        String filePerms;
        String fileGroup;
        String fileCompRelativePath;
        SoftwareDistributionFileInfo fileInfo = new SoftwareDistributionFileInfo();
        if (!compHome.endsWith(Character.toString(File.separatorChar))) {
            compHome.concat(Character.toString(File.separatorChar));
        }
        String filePath = distributedFileElem.getAttribute(TAG_FILE_PATH);
        String fileName = distributedFileElem.getAttribute("Name");
        String fileExt = distributedFileElem.getAttribute(TAG_FILE_EXT);
        if (this.isVariable(fileExt)) {
            fileExt = this.resolveVariable(fileExt);
        }
        if (!(fileCompRelativePath = filePath).endsWith(Character.toString(File.separatorChar))) {
            fileCompRelativePath = fileCompRelativePath + Character.toString(File.separatorChar);
        }
        fileCompRelativePath = fileCompRelativePath + fileName;
        if (fileExt != null && fileExt.length() > 0) {
            fileCompRelativePath = fileCompRelativePath + fileExt;
        }
        String absoluteFilePath = fileCompRelativePath;
        if (!new File(fileCompRelativePath).isAbsolute()) {
            if (!compHome.endsWith(Character.toString(File.separatorChar))) {
                compHome = compHome + Character.toString(File.separatorChar);
            }
            absoluteFilePath = compHome + fileCompRelativePath;
        }
        fileInfo.setFileName(absoluteFilePath);
        String fileOwner = this.getOptionalAttributeValue(distributedFileElem, TAG_FILE_OWNER);
        if (this.isVariable(fileOwner)) {
            fileOwner = this.resolveVariable(fileOwner);
        }
        if (fileOwner != null) {
            fileInfo.setFileOwner(fileOwner);
        }
        if (this.isVariable(fileGroup = this.getOptionalAttributeValue(distributedFileElem, TAG_FILE_GROUP))) {
            fileGroup = this.resolveVariable(fileGroup);
        }
        if (fileGroup != null) {
            fileInfo.setFileGroup(fileGroup);
        }
        if ((filePerms = this.getOptionalAttributeValue(distributedFileElem, TAG_FILE_PERMISSIONS)) != null && filePerms.length() > 0) {
            fileInfo.setFilePermissions(filePerms);
        }
        return fileInfo;
    }

    private boolean isVariable(String value) {
        return value != null && value.startsWith(CHAR_INDIRECTION);
    }

    private String resolveVariable(String variable) {
        return VerificationUtil.getVariableValue(variable.substring(CHAR_INDIRECTION.length()));
    }

    private String getOptionalAttributeValue(Element elem, String key) {
        String attributeValue = null;
        if (elem.hasAttribute(key)) {
            attributeValue = elem.getAttribute(key);
        }
        return attributeValue;
    }
}

