/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.OSVerCompatXMLDocumentException;
import oracle.ops.verification.framework.engine.task.OSVerCompatXMLEntry;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSVerCompatXMLDocument {
    private String m_document;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    static final String TAG_ROOTOSVER_COMPAT = "USMOSVersionCompatibility";
    static final String TAG_CRS_RELEASE = "Release";
    static final String TAG_VALUE = "Value";
    static final String TAG_OSVERSION = "OSVersion";
    static final String TAG_VERSION = "Version";
    static final String TAG_MATCH = "Match";

    public OSVerCompatXMLDocument(String document) {
        this.m_document = document;
    }

    public List<OSVerCompatXMLEntry> load(String reqdRelease) throws OSVerCompatXMLDocumentException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            DefaultHandler handler = new DefaultHandler();
            parser.setErrorHandler(handler);
            Trace.out((String)("Parsing XML document " + this.m_document));
            Document doc = parser.parse(new String("file:") + this.m_document);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Parser validation set to: " + parser.isValidating()));
                Trace.out((String)(this.m_document + " is well-formed"));
            }
            Trace.out((String)("Get the root element for " + this.m_document));
            Element relm = doc.getDocumentElement();
            String rootElm = relm.getTagName();
            Trace.out((String)"Verify the root name to be USMOSVersionCompatibility");
            if (!rootElm.equalsIgnoreCase(TAG_ROOTOSVER_COMPAT)) {
                Trace.out((int)15, (String)"ERROR: Invalid root element");
                throw new OSVerCompatXMLDocumentException("Invalid root element. Expected='USMOSVersionCompatibility' Found='" + rootElm + "'");
            }
            NodeList crsReleases = relm.getElementsByTagName(TAG_CRS_RELEASE);
            ArrayList<OSVerCompatXMLEntry> supportedList = new ArrayList<OSVerCompatXMLEntry>();
            boolean foundcrs = false;
            for (int k = 0; k < crsReleases.getLength(); ++k) {
                Element crsRelease = (Element)crsReleases.item(k);
                String relvalue = crsRelease.getAttribute(TAG_VALUE);
                Trace.out((String)("Release value found in XML file is " + relvalue));
                if (!relvalue.equals(reqdRelease)) continue;
                Trace.out((String)"We found the release we are looking for.");
                foundcrs = true;
                NodeList suppvers = crsRelease.getElementsByTagName(TAG_OSVERSION);
                Trace.out((String)("Number of Supported versions entries found = " + suppvers.getLength()));
                for (int i = 0; i < suppvers.getLength(); ++i) {
                    OSVerCompatXMLEntry curosversion = this.readEntry((Element)suppvers.item(i));
                    supportedList.add(curosversion);
                }
            }
            if (!foundcrs) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("OSVerCompatXMLDocument: load() Invalid CRS release specified :" + reqdRelease));
                }
                throw new OSVerCompatXMLDocumentException(s_msgBundle.getMessage("4957", true, (Object[])new String[]{reqdRelease, this.m_document}));
            }
            if (crsReleases.getLength() <= 0) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("OSVerCompatXMLDocument: load() Empty list of supported versions for release " + reqdRelease));
                }
                throw new OSVerCompatXMLDocumentException(s_msgBundle.getMessage("4958", true, (Object[])new String[]{this.m_document}));
            }
            return supportedList;
        }
        catch (SAXException e) {
            throw new OSVerCompatXMLDocumentException(s_msgBundle.getMessage("4959", true, (Object[])new String[]{this.m_document}) + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new OSVerCompatXMLDocumentException(e.getMessage());
        }
        catch (IOException e) {
            throw new OSVerCompatXMLDocumentException(e.getMessage());
        }
    }

    private OSVerCompatXMLEntry readEntry(Element versionEntry) {
        String vers = versionEntry.getAttribute(TAG_VERSION);
        String matchtype = versionEntry.getAttribute(TAG_MATCH);
        Trace.out((String)("Attributes read from XML document: Version=" + vers + " ; Matchtype=" + matchtype));
        OSVerCompatXMLEntry curosversion = new OSVerCompatXMLEntry(vers, matchtype);
        return curosversion;
    }
}

