/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.TaskCompletionEvent;
import oracle.ops.verification.framework.engine.task.TaskCompletionEventMulticaster;
import oracle.ops.verification.framework.engine.task.TaskCompletionListener;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Task
implements VerificationConstants,
TaskCompletionListener,
VerificationTask {
    protected static MessageBundle s_msgBundle;
    public static final int CONTINUE = 1;
    public static final int STOP_ON_ERROR = 2;
    public static final int ACTION_ON_ERROR = 3;
    public static final int ACTION_ON_COMPLETION = 4;
    protected String[] m_nodeList;
    private int m_actionOnCompletion;
    protected ResultSet m_resultSet = new ResultSet();
    private boolean m_fixupReqd = VerificationUtil.getDefaultFixupRequirement();
    private HashMap<String, String> m_fixupGenErrors = new HashMap();
    private MultiTaskHandler m_multiTaskHandler;
    private boolean m_diagnosticMode = false;
    private Vector m_tasksWaitedFor = new Vector();
    private TaskCompletionListener m_taskCompletionListener;
    private boolean m_hasSubtasks;
    private Task[] m_subtasks;
    private boolean m_isTaskOver;
    private boolean m_runBefore = false;
    protected String m_elementName;
    protected String m_description;
    protected SeverityType m_taskSeverity = SeverityType.CRITICAL;
    private static ParamManager pm;
    public static boolean m_isCLImode;
    public static boolean m_isAPImode;

    public Task() {
        this(null, 1);
    }

    public Task(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public Task(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        this.m_multiTaskHandler = multiTaskHandler;
        this.m_actionOnCompletion = actionOnCompletion;
    }

    public Task(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public Task(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public Task(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        this.m_nodeList = nodeList;
        this.m_multiTaskHandler = multiTaskHandler;
        this.m_actionOnCompletion = actionOnCompletion;
    }

    public String[] getNodeList() {
        return this.m_nodeList;
    }

    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public boolean performTask() {
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return true;
    }

    public boolean performDiagnostics() {
        return true;
    }

    public final boolean perform() {
        boolean resultVal = !this.performTask() ? (this.m_diagnosticMode ? this.performDiagnostics() : false) : true;
        if (this.m_multiTaskHandler != null) {
            if (this.m_taskCompletionListener != null) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"Inside Task:perform() - sending events...");
                }
                TaskCompletionEvent completionEvent = new TaskCompletionEvent(this, 2000);
                this.m_taskCompletionListener.taskCompleted(completionEvent);
            }
            this.m_multiTaskHandler.removeFromCurrentTaskSet(this);
        }
        this.m_isTaskOver = true;
        return resultVal;
    }

    public void setActionOnCompletion(int actionOnCompletion) {
        this.m_actionOnCompletion = actionOnCompletion;
    }

    public int getActionOnCompletion() {
        return this.m_actionOnCompletion;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public synchronized Vector getTasksWaitedFor() {
        return this.m_tasksWaitedFor;
    }

    public synchronized boolean isEmptyTasksWaitedFor() {
        return this.m_tasksWaitedFor.isEmpty();
    }

    public synchronized void waitFor(Task task) {
        this.m_tasksWaitedFor.addElement(task);
        task.addTaskCompletionListener(this);
    }

    public synchronized void waitFor(Task[] taskArr) {
        for (int i = 0; i < taskArr.length; ++i) {
            this.m_tasksWaitedFor.addElement(taskArr[i]);
            taskArr[i].addTaskCompletionListener(this);
        }
    }

    public synchronized void removeFromTasksWaitedFor(Task task) {
        this.m_tasksWaitedFor.removeElement(task);
    }

    @Override
    public void taskCompleted(TaskCompletionEvent e) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Inside Task:taskCompleted()...");
        }
        this.removeFromTasksWaitedFor(e.getTask());
        if (this.isEmptyTasksWaitedFor() && this.m_multiTaskHandler != null) {
            this.m_multiTaskHandler.addToCurrentTaskSet(this);
        }
    }

    public synchronized void addTaskCompletionListener(TaskCompletionListener l) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Inside Task:addTaskCompletionListener()...");
        }
        this.m_taskCompletionListener = TaskCompletionEventMulticaster.add(this.m_taskCompletionListener, l);
    }

    protected void setFixup(boolean fixupReqd) {
        this.m_fixupReqd = fixupReqd;
    }

    protected boolean isFixupReqd() {
        return this.m_fixupReqd;
    }

    @Override
    public String getElementName() {
        if (this.m_elementName != null) {
            return this.m_elementName;
        }
        return this.getDefaultElementName();
    }

    public abstract String getDefaultElementName();

    @Override
    public String getDescription() {
        if (this.m_description != null) {
            return this.m_description;
        }
        return this.getDefaultDescription();
    }

    public abstract String getDefaultDescription();

    @Override
    public VerificationResultSet verify() throws SubtasksNotCompleteException, VerificationException {
        return this.verify(VerificationUtil.getDefaultFixupRequirement());
    }

    @Override
    public VerificationResultSet verify(boolean fixup) throws SubtasksNotCompleteException, VerificationException {
        if (this.m_runBefore) {
            this.m_resultSet = new ResultSet();
        }
        if (this.m_hasSubtasks) {
            int i;
            for (i = 0; i < this.m_subtasks.length; ++i) {
                if (this.m_subtasks[i].isTaskOver()) continue;
                throw new SubtasksNotCompleteException(s_msgBundle.getMessage("7500", false));
            }
            for (i = 0; i < this.m_subtasks.length; ++i) {
                this.m_resultSet.uploadResultSet(this.m_subtasks[i].getResultSet(), true);
            }
        } else {
            this.m_fixupReqd = fixup;
            this.perform();
        }
        this.m_runBefore = true;
        this.m_resultSet.traceResultSet("=== m_resultSet before return from verify() ===");
        return this.m_resultSet;
    }

    @Override
    public boolean hasSubtasks() {
        return this.m_hasSubtasks;
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        if (this.m_hasSubtasks) {
            return Arrays.asList(this.m_subtasks);
        }
        throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
    }

    public boolean isTaskOver() {
        return this.m_isTaskOver;
    }

    public void setSubtasks(Task[] subtasks) {
        this.m_subtasks = subtasks;
    }

    public void setHasSubtasks(boolean hasSubtasks) {
        this.m_hasSubtasks = hasSubtasks;
    }

    public void setElementName(String elementName) {
        this.m_elementName = elementName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setMultiTaskHandler(MultiTaskHandler multiTaskHandler) {
        this.m_multiTaskHandler = multiTaskHandler;
    }

    public ArrayList<String> getFixupFiles(String node, ResultSet resultSet) {
        ErrorDescription errDesc;
        String errMsg;
        File fileRef;
        String fixupRootDir = VerificationUtil.getFixupRootDir();
        if (!VerificationUtil.isFixupRootDirSettled(fixupRootDir)) {
            if (fixupRootDir == null || fixupRootDir.length() == 0) {
                String errMsg2 = s_msgBundle.getMessage("7508", false) + s_msgBundle.getMessage("7700", false);
                resultSet.addErrorDescription(new ErrorDescription(errMsg2));
                this.addFixupGenError("-", errMsg2);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)(fixupRootDir == null ? "fixupRootDir is NULL" : "fixupRootDir is empty string"));
                }
                return null;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("fixupRootDir is: '" + fixupRootDir + "'"));
            }
            if (!(fileRef = new File(fixupRootDir)).isAbsolute()) {
                String errMsg3 = s_msgBundle.getMessage("7508", false) + s_msgBundle.getMessage("7701", true);
                resultSet.addErrorDescription(new ErrorDescription(errMsg3, s_msgBundle, "7701"));
                this.addFixupGenError("-", errMsg3);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"fixupRootDir is not specified with an absolute pathname.");
                }
                return null;
            }
            if (fileRef.exists()) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("fixupRootDir: '" + fixupRootDir + "' exists."));
                }
                if (!fileRef.isDirectory()) {
                    String errMsg4 = s_msgBundle.getMessage("7508", false) + s_msgBundle.getMessage("7702", true, (Object[])new String[]{fixupRootDir});
                    resultSet.addErrorDescription(new ErrorDescription(errMsg4, s_msgBundle, "7702"));
                    this.addFixupGenError("-", errMsg4);
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"fixupRootDir is not a directory.");
                    }
                    return null;
                }
                if (!fileRef.canWrite()) {
                    String errMsg5 = s_msgBundle.getMessage("7508", false) + s_msgBundle.getMessage("7703", true, (Object[])new String[]{fixupRootDir});
                    resultSet.addErrorDescription(new ErrorDescription(errMsg5, s_msgBundle, "7703"));
                    this.addFixupGenError("-", errMsg5);
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"fixupRootDir is not writable.");
                    }
                    return null;
                }
                boolean dirCleaned = false;
                errMsg = s_msgBundle.getMessage("7555", false, (Object[])new String[]{fixupRootDir});
                try {
                    dirCleaned = new ClusterCmd().removeDirectory(new String[]{VerificationUtil.getLocalHost()}, fixupRootDir, true);
                }
                catch (UnknownHostException uhe) {
                    errMsg = errMsg + LSEP + uhe.getMessage();
                }
                catch (ClusterException ce) {
                    errMsg = errMsg + LSEP + ce.getMessage();
                }
                if (!dirCleaned) {
                    resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    this.addFixupGenError("-", errMsg);
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)errMsg);
                    }
                    return null;
                }
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("The contents of directory '" + fixupRootDir + "' were successfully deleted"));
                }
            } else if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("fixupRootDir: '" + fixupRootDir + "' doesnot exist; It will be created"));
            }
            boolean fixupRootDirCreated = false;
            errMsg = s_msgBundle.getMessage("7704", true, (Object[])new String[]{fixupRootDir});
            try {
                fixupRootDirCreated = fileRef.mkdir();
            }
            catch (SecurityException e) {
                errMsg = errMsg + LSEP + e.getMessage();
            }
            if (!fixupRootDirCreated) {
                resultSet.addErrorDescription(new ErrorDescription(errMsg, s_msgBundle, "7704"));
                this.addFixupGenError("-", errMsg);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)errMsg);
                }
                return null;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("fixupRootDir: '" + fixupRootDir + "' was successfully created"));
            }
            VerificationUtil.markFixupRootDirAsSettled(fixupRootDir);
        }
        String fixupNodeDir = fixupRootDir + FSEP + node;
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("fixupNodeDir is: '" + fixupNodeDir + "'"));
        }
        if (!(fileRef = new File(fixupNodeDir)).exists()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("fixupNodeDir: '" + fixupNodeDir + "' doesnot exist; It will be created"));
            }
            boolean fixupNodeDirCreated = false;
            errDesc = new ErrorDescription("7705", new String[]{fixupNodeDir}, s_msgBundle);
            errMsg = errDesc.getErrorMessage();
            try {
                fixupNodeDirCreated = fileRef.mkdir();
            }
            catch (SecurityException e) {
                errMsg = errMsg + LSEP + e.getMessage();
            }
            if (!fixupNodeDirCreated) {
                resultSet.addErrorDescription(node, errDesc);
                this.addFixupGenError(node, errMsg);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)errMsg);
                }
                return null;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("fixupNodeDir: '" + fixupNodeDir + "' was successfully created"));
            }
        } else if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("fixupNodeDir: '" + fixupNodeDir + "' exists"));
        }
        String[] fixupFiles = new String[]{"fixup.response", "fixup.enable"};
        ArrayList<String> fileList = new ArrayList<String>();
        for (int i = 0; i < fixupFiles.length; ++i) {
            String fileName = fixupNodeDir + FSEP + fixupFiles[i];
            fileRef = new File(fileName);
            errDesc = new ErrorDescription("7706", new String[]{fileName}, s_msgBundle);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Checking the existence of fixup file : '" + fileName + "'"));
            }
            try {
                if (!fileRef.createNewFile()) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("Fixup file '" + fileName + "' already exists"));
                    } else if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("Fixup file '" + fileName + "' didn't exist; It was successfully created"));
                    }
                }
            }
            catch (IOException e) {
                errMsg = errDesc.getErrorMessage() + LSEP + e.getMessage();
                errDesc.setErrorMessage(errMsg);
                resultSet.addErrorDescription(node, errDesc);
                this.addFixupGenError(node, errMsg);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)errMsg);
                }
                return null;
            }
            catch (SecurityException e) {
                errMsg = errDesc.getErrorMessage() + LSEP + e.getMessage();
                errDesc.setErrorMessage(errMsg);
                resultSet.addErrorDescription(node, errDesc);
                this.addFixupGenError(node, errMsg);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)errMsg);
                }
                return null;
            }
            fileList.add(fileName);
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("fileList[0]=" + fileList.get(0)));
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("fileList[1]=" + fileList.get(1)));
        }
        return fileList;
    }

    public void addFixupGenError(String node, String errMsg) {
        String existingMsg = this.m_fixupGenErrors.get(node);
        if (existingMsg == null || !existingMsg.equals(errMsg)) {
            this.m_fixupGenErrors.put(node, errMsg);
        }
    }

    public void reportFixupGenErrors() {
        for (String msg : this.m_fixupGenErrors.values()) {
            ReportUtil.printError(msg);
        }
    }

    @Override
    public SeverityType getSeverity() {
        return this.m_taskSeverity;
    }

    public void setSeverity(SeverityType taskSeverity) {
        this.m_taskSeverity = taskSeverity;
    }

    protected boolean hasRunBefore() {
        return this.m_runBefore;
    }

    static {
        block2: {
            s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
            pm = null;
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                if (!Trace.isLevelEnabled((int)1)) break block2;
                Trace.out((Exception)e);
            }
        }
        m_isCLImode = pm.getMode() == ParamManager.OperationMode.MODE_CLI;
        m_isAPImode = pm.getMode() == ParamManager.OperationMode.MODE_API;
    }
}

