/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.impl.verification.SharedStorageResultSetImpl;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskASMDeviceChecks
extends Task {
    String[] m_deviceString = null;
    private final int DEV_OWNER = 1;
    private final int DEV_GROUP = 2;
    private final int DEV_PERMS = 3;
    private final int DEV_SIZE = 4;
    private boolean m_mute = false;
    private final String DEV_OWNER_STR = "Owner";
    private final String DEV_GROUP_STR = "Group";
    private final String DEV_PERMS_STR = "Permissions";
    private final String DEV_SIZE_STR = "Size";
    private static final String FILE_STATUS_FAILED = "1";
    private List<String> m_deviceListAll;
    private SharedStorageResultSetImpl m_ssResSetImpl = new SharedStorageResultSetImpl();
    private TaskSharedStorageAccess.StorageThread[] m_stThreadArr;
    private Vector<TaskSharedStorageAccess.StorageThread> m_sharedSet;
    private Vector<TaskSharedStorageAccess.StorageThread> m_nonSharedSet;
    private boolean m_verifySharedness = true;
    private String m_referenceOwner;
    private String m_referenceGroup;
    private String m_referencePermissions;

    public TaskASMDeviceChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskASMDeviceChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskASMDeviceChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public SharedStorageResultSetImpl getSharedStorageResultSetImpl() {
        return this.m_ssResSetImpl;
    }

    public void setDeviceString(String[] devicestring) {
        this.m_deviceString = devicestring;
    }

    public void setDeviceString(String devicestring) {
        this.m_deviceString = new String[]{devicestring};
    }

    public TaskSharedStorageAccess.StorageThread[] getSharedStorageThreadArray() {
        return this.m_stThreadArr;
    }

    public String[] getDeviceString() {
        return this.m_deviceString;
    }

    public void setMute(boolean mute) {
        this.m_mute = mute;
    }

    public void setVerifySharedness(boolean bool) {
        this.m_verifySharedness = bool;
    }

    public void setReferenceOwner(String owner) {
        this.m_referenceOwner = owner;
    }

    public void setReferenceGroup(String group) {
        this.m_referenceGroup = group;
    }

    public void setReferencePermissions(String permissions) {
        this.m_referencePermissions = permissions;
    }

    @Override
    public boolean performTask() {
        if (Trace.isTraceEnabled()) {
            Trace.out((int)5, (String)"Performing device checks for ASM ");
        }
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4385", false));
        }
        if (this.m_deviceString == null) {
            this.m_deviceString = VerificationUtil.getDefaultDiscoveryDevice();
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("No device string was specified on the command line. Using default ASM discovery string " + this.m_deviceString));
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5194", false, (Object[])new String[]{Arrays.asList(this.m_deviceString).toString()}));
        }
        this.expandDevicePaths();
        this.performASMDeviceChecks();
        if (this.m_ssResSetImpl.allSuccess()) {
            Trace.out((int)5, (String)"ResultSet shows alll Success");
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("4386", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        this.m_ssResSetImpl.setStatus(3);
        ReportUtil.printResult(s_msgBundle.getMessage("4387", false));
        ReportUtil.sureblankln();
        return false;
    }

    public void performASMDeviceChecks() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        HashMap<String, Vector<StorageInfo>> storageInfoMap = new HashMap<String, Vector<StorageInfo>>();
        if (this.m_verifySharedness) {
            TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(this.m_nodeList);
            taskSSAccess.setOutputMuted(true);
            String[] devArrAll = this.m_deviceListAll.toArray(new String[this.m_deviceListAll.size()]);
            if (Trace.isTraceEnabled()) {
                for (int j = 0; j < devArrAll.length; ++j) {
                    Trace.out((int)5, (String)("Discovered device : " + devArrAll[j]));
                }
            }
            taskSSAccess.setStorageIDlist(devArrAll);
            taskSSAccess.setCheckOCFS(false);
            taskSSAccess.performTask();
            this.m_ssResSetImpl = taskSSAccess.getSharedStorageResultSetImpl();
            this.m_stThreadArr = taskSSAccess.threadList;
            Vector<TaskSharedStorageAccess.StorageThread> stThreadList = new Vector<TaskSharedStorageAccess.StorageThread>();
            Hashtable<String, TaskSharedStorageAccess.StorageThread> ht = new Hashtable<String, TaskSharedStorageAccess.StorageThread>();
            for (int i = 0; i < this.m_stThreadArr.length; ++i) {
                String key = this.m_stThreadArr[i].getStoragePath();
                TaskSharedStorageAccess.StorageThread sthrd = (TaskSharedStorageAccess.StorageThread)ht.get(key);
                if (null != sthrd) continue;
                Trace.out((int)5, (String)("Inserting key >" + key + "< into hash table."));
                ht.put(key, this.m_stThreadArr[i]);
            }
            Enumeration enumht = ht.elements();
            while (enumht.hasMoreElements()) {
                TaskSharedStorageAccess.StorageThread st = (TaskSharedStorageAccess.StorageThread)enumht.nextElement();
                Trace.out((int)5, (String)("Adding storage >" + st.getStoragePath() + "< into vector"));
                stThreadList.add(st);
            }
            this.m_nonSharedSet = new Vector();
            Vector<TaskSharedStorageAccess.StorageThread> sharedSet = this.verifySharedness(stThreadList, this.m_nonSharedSet);
            this.m_sharedSet = sharedSet;
            for (TaskSharedStorageAccess.StorageThread storageThread : sharedSet) {
                String path = storageThread.getStoragePath();
                Vector<StorageInfo> stInfoSet = storageThread.getStorageInfoVector();
                storageInfoMap.put(path, stInfoSet);
            }
        } else {
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet fileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(this.m_nodeList, this.m_deviceListAll, fileInfoResultSet);
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                fileInfoResultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                fileInfoResultSet.addErrorDescription(errDesc);
                return;
            }
            Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
            Hashtable<String, ArrayList<String>> failedFileHT = new Hashtable<String, ArrayList<String>>();
            Hashtable<String, ArrayList<String>> fileNodeListHT = new Hashtable<String, ArrayList<String>>();
            for (String node : this.m_nodeList) {
                Result result = (Result)fileInforResultTable.get(node);
                if (result != null && result.getStatus() == 1) {
                    Hashtable nodeFileHT = (Hashtable)result.getResultInfoSet().elementAt(0);
                    for (String file : nodeFileHT.keySet()) {
                        FileInfo nodeFileInfo = (FileInfo)nodeFileHT.get(file);
                        if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) {
                            fileInfoResultSet.addResult(node, 3);
                            String failedFile = nodeFileInfo.getFileName();
                            ArrayList<String> fileErrors = (ArrayList<String>)failedFileHT.get(failedFile);
                            ArrayList<String> failedNodeList = (ArrayList<String>)fileNodeListHT.get(failedFile);
                            if (fileErrors == null) {
                                fileErrors = new ArrayList<String>();
                            }
                            fileErrors.add(nodeFileInfo.getErrorString());
                            failedFileHT.put(failedFile, fileErrors);
                            if (failedNodeList == null) {
                                failedNodeList = new ArrayList<String>();
                            }
                            failedNodeList.add(node);
                            fileNodeListHT.put(failedFile, failedNodeList);
                            continue;
                        }
                        StorageInfo st = new StorageInfo();
                        st.setNode(node);
                        st.setName(nodeFileInfo.getFileName());
                        st.setOwner(nodeFileInfo.getFileOwner());
                        st.setGroup(nodeFileInfo.getFileGroup());
                        st.setPermissions(nodeFileInfo.getFilePermissions());
                        st.setSize(new StorageSize(0.0, StorageUnit.BYTE));
                        Vector<StorageInfo> storageInfoList = storageInfoMap.get(nodeFileInfo.getFileName());
                        if (storageInfoList == null) {
                            storageInfoList = new Vector();
                            storageInfoMap.put(nodeFileInfo.getFileName(), storageInfoList);
                        }
                        storageInfoList.add(st);
                    }
                    if (failedFileHT.size() == 0) continue;
                    for (String file : failedFileHT.keySet()) {
                        storageInfoMap.remove(file);
                        String fileErrors = VerificationUtil.strCollection2String((Collection)failedFileHT.get(file), VerificationConstants.LSEP);
                        String errorNodes = VerificationUtil.strCollection2String((Collection)fileNodeListHT.get(file));
                        String msg = s_msgBundle.getMessage("9994", true, (Object[])new String[]{file, errorNodes});
                        ReportUtil.printError(msg);
                        ReportUtil.sureprintln(fileErrors);
                        ErrorDescription error = new ErrorDescription(msg);
                        fileInfoResultSet.addErrorDescription(((List)fileNodeListHT.get(file)).toArray(new String[0]), error);
                    }
                    continue;
                }
                String msg = s_msgBundle.getMessage("9995", true, (Object[])new String[]{node});
                ReportUtil.printError(msg);
                ErrorDescription error = new ErrorDescription(msg);
                fileInfoResultSet.addErrorDescription(node, error);
            }
            this.m_ssResSetImpl.uploadResultSet(fileInfoResultSet, false);
        }
        if (storageInfoMap.size() > 0) {
            this.verifyAttribPermissions(storageInfoMap, 1, "Owner", this.m_referenceOwner, "5115", "5116", "5117", "5118", "9991");
            this.verifyAttribPermissions(storageInfoMap, 2, "Group", this.m_referenceGroup, "5119", "5120", "5121", "5122", "9992");
            this.verifyAttribPermissions(storageInfoMap, 3, "Permissions", this.m_referencePermissions, "5123", "5124", "5125", "5126", "9993");
            this.verifyAttribPermissions(storageInfoMap, 4, "Size", null, "5127", "5128", "5129", "5130", null);
        }
        this.m_resultSet.uploadResultSet(this.m_ssResSetImpl, false);
    }

    private Vector<TaskSharedStorageAccess.StorageThread> verifySharedness(Vector<TaskSharedStorageAccess.StorageThread> sharedSet, Vector<TaskSharedStorageAccess.StorageThread> nonSharedSubSet) {
        Trace.out((int)2, (String)"Entry");
        Vector<TaskSharedStorageAccess.StorageThread> sharedSubset = new Vector<TaskSharedStorageAccess.StorageThread>();
        Trace.out((int)5, (String)("Size of sharedSet is " + sharedSet.size()));
        if (sharedSet == null || sharedSet.size() <= 0) {
            Trace.out((int)5, (String)"Shared Storage set is empty.");
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5100", true));
            this.m_ssResSetImpl.setStatus(3);
            this.m_ssResSetImpl.addErrorDescription(errorDesc);
            ReportUtil.printResult(s_msgBundle.getMessage("5195", true));
            ReportUtil.sureblankln();
            return sharedSubset;
        }
        Enumeration<TaskSharedStorageAccess.StorageThread> setEnum = sharedSet.elements();
        while (setEnum.hasMoreElements()) {
            TaskSharedStorageAccess.StorageThread stThread = setEnum.nextElement();
            Vector<StorageInfo> stInfoSet = stThread.getStorageInfoVector();
            String path = null;
            if (stThread.isShared()) {
                Trace.out((int)5, (String)("Size of stInfoSet = " + stInfoSet.size()));
                path = stThread.getStoragePath();
                String typeStr = stInfoSet.firstElement().getTypeStr();
                Trace.out((int)5, (String)("Shared path = " + path));
                Trace.out((int)5, (String)("Shared device type = " + typeStr));
                this.m_ssResSetImpl.addResult(this.m_nodeList, 1);
                sharedSubset.add(stThread);
                continue;
            }
            path = stThread.getStoragePath();
            String errMsg = null;
            if (stInfoSet != null && stInfoSet.size() > 0) {
                Trace.out((int)5, (String)("Path " + path + " is not shared, but available on at least one node."));
                String typeStr = stInfoSet.firstElement().getTypeStr();
                errMsg = s_msgBundle.getMessage("5149", true, (Object[])new String[]{path, typeStr});
            } else {
                Trace.out((int)5, (String)("Path " + path + " is an invalid path."));
                errMsg = s_msgBundle.getMessage("5150", true, (Object[])new String[]{path});
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_ssResSetImpl.addResult(this.m_nodeList, 3);
            this.m_ssResSetImpl.addErrorDescription(errorDesc);
            nonSharedSubSet.add(stThread);
        }
        if (!this.m_mute && sharedSubset.size() + nonSharedSubSet.size() > 0) {
            this.reportVerifySharedness(sharedSubset, nonSharedSubSet);
        }
        Trace.out((int)2, (String)"Exit");
        return sharedSubset;
    }

    public void reportVerifySharedness(Vector<TaskSharedStorageAccess.StorageThread> sharedSubset, Vector<TaskSharedStorageAccess.StorageThread> nonSharedSubset) {
        String typeStr;
        String path;
        Vector<StorageInfo> stInfoSet;
        TaskSharedStorageAccess.StorageThread stThread;
        Trace.out((int)2, (String)"Entry");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5101", false));
        ReportUtil.sureblankln();
        if (sharedSubset.size() > 0) {
            if (!this.m_mute) {
                ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8055", false), s_msgBundle.getMessage("8056", false));
            }
            Enumeration<TaskSharedStorageAccess.StorageThread> sharedEnum = sharedSubset.elements();
            while (sharedEnum.hasMoreElements()) {
                stThread = sharedEnum.nextElement();
                stInfoSet = stThread.getStorageInfoVector();
                path = stThread.getStoragePath();
                typeStr = stInfoSet.firstElement().getTypeStr();
                ReportUtil.surewriteRecord(path, typeStr);
            }
        }
        if (nonSharedSubset.size() > 0) {
            Enumeration<TaskSharedStorageAccess.StorageThread> nonSharedEnum = nonSharedSubset.elements();
            while (nonSharedEnum.hasMoreElements()) {
                stThread = nonSharedEnum.nextElement();
                stInfoSet = stThread.getStorageInfoVector();
                path = stThread.getStoragePath();
                if (stInfoSet != null && stInfoSet.size() > 0) {
                    Trace.out((int)5, (String)("Path " + path + " is not shared, but available on at least one node."));
                    typeStr = stInfoSet.firstElement().getTypeStr();
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5149", true, (Object[])new String[]{path, typeStr}));
                    continue;
                }
                Trace.out((int)5, (String)("Path " + path + " is an invalid path."));
                ReportUtil.sureprintln(s_msgBundle.getMessage("5150", true, (Object[])new String[]{path}));
            }
        }
        Trace.out((int)2, (String)"Exit");
    }

    private void verifyAttribPermissions(HashMap<String, Vector<StorageInfo>> storageInfoMap, int attrib, String header, String reference, String strtitle, String strpass, String strinconsistent, String strfail, String strincosistentRef) {
        Trace.out((int)2, (String)"Entry");
        Iterator<Vector<StorageInfo>> iter = storageInfoMap.values().iterator();
        StorageInfo firstst = null;
        if (iter.hasNext()) {
            firstst = iter.next().firstElement();
        }
        if (firstst.getType() == 1 && !this.getAttrib(attrib, firstst).equals("UNSUPPORTED")) {
            Trace.out((String)("Performing " + header + " permissions check..."));
            Trace.out((String)("Check if each device has same " + header + " on all nodes..."));
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            if (!this.m_mute) {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage(strtitle, false));
            }
            boolean overallfail = false;
            Set<String> pathSet = storageInfoMap.keySet();
            for (String path : pathSet) {
                HashMap<String, List<String>> hmap = this.getHashMapbyAttribute(storageInfoMap.get(path), attrib);
                if (hmap.size() == 1) {
                    String message;
                    Trace.out((int)5, (String)("Device " + path + " has same " + header + " on all nodes."));
                    String nodeValue = hmap.keySet().toArray(new String[0])[0];
                    if (reference == null || reference.length() == 0 || reference.equals(nodeValue)) {
                        message = s_msgBundle.getMessage(strpass, false, (Object[])new String[]{path});
                        this.m_ssResSetImpl.addResult(this.m_nodeList, 1);
                        if (this.m_mute) continue;
                        ReportUtil.sureprintln(message);
                        continue;
                    }
                    Trace.out((int)5, (String)("Device " + path + " " + header + " did not match the reference " + reference));
                    overallfail = true;
                    message = s_msgBundle.getMessage(strincosistentRef, false, (Object[])new String[]{path, reference, hmap.toString()});
                    this.m_ssResSetImpl.addResult(this.m_nodeList, 3);
                    this.m_ssResSetImpl.addErrorDescription(new ErrorDescription(message));
                    if (this.m_mute) continue;
                    ReportUtil.sureprintln(message);
                    continue;
                }
                overallfail = true;
                Trace.out((int)5, (String)("Device " + path + " has different " + header + " across all nodes."));
                String message = s_msgBundle.getMessage(strinconsistent, false, (Object[])new String[]{path, hmap.toString()});
                this.m_ssResSetImpl.addResult(this.m_nodeList, 3);
                this.m_ssResSetImpl.addErrorDescription(new ErrorDescription(message));
                if (this.m_mute) continue;
                ReportUtil.sureprintln(message);
            }
            if (overallfail) {
                Trace.out((int)5, (String)("Check for " + header + " at least one path failed. Test failed."));
                if (!this.m_mute) {
                    ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage(strfail, false));
                }
            }
        }
    }

    private HashMap<String, List<String>> getHashMapbyAttribute(Vector<StorageInfo> stInfoSet, int attrib) {
        Trace.out((int)2, (String)"Entry");
        String strattrib = null;
        HashMap<String, List<String>> hmap = new HashMap<String, List<String>>();
        Enumeration<StorageInfo> shrEnum = stInfoSet.elements();
        while (shrEnum.hasMoreElements()) {
            StorageInfo strgInfo = shrEnum.nextElement();
            strattrib = this.getAttrib(attrib, strgInfo);
            if (strattrib == null) continue;
            List<String> ndList = hmap.get(strattrib);
            if (ndList == null) {
                ndList = new ArrayList<String>();
                hmap.put(strattrib, ndList);
                Trace.out((int)5, (String)("Adding new entry into hmap for attribute " + attrib));
            }
            ndList.add(strgInfo.getNode());
        }
        Trace.out((int)2, (String)"Exit");
        return hmap;
    }

    private String getAttrib(int attrib, StorageInfo strgInfo) {
        String strattrib;
        switch (attrib) {
            case 1: {
                strattrib = strgInfo.getOwner();
                break;
            }
            case 2: {
                strattrib = strgInfo.getGroup();
                break;
            }
            case 3: {
                strattrib = strgInfo.getPermissions();
                break;
            }
            case 4: {
                StorageSize strgsize = strgInfo.getSize();
                if (strgsize.compareTo(new StorageSize(-2.0, StorageUnit.BYTE)) != 0) {
                    strattrib = new String(strgsize.toString());
                    Trace.out((int)5, (String)("Size of disk = " + strattrib));
                    break;
                }
                strattrib = new String("UNSUPPORTED");
                break;
            }
            default: {
                strattrib = null;
            }
        }
        return strattrib;
    }

    private void expandDevicePaths() {
        Trace.out((int)2, (String)"Entry");
        this.m_deviceListAll = new ArrayList<String>();
        for (String device : this.m_deviceString) {
            List m_deviceList = new ArrayList();
            if (VerificationUtil.containsWildCard(device)) {
                GlobalExecution globalExec = new GlobalExecution();
                ResultSet rsltSet = new ResultSet();
                String[] node = new String[]{"localnode"};
                String cmd = VerificationUtil.getFileListCommand() + " " + device;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("expandDevicePaths: Command is : " + cmd));
                }
                globalExec.runGenericCmd(node, cmd, rsltSet);
                Result result = rsltSet.getResult(node[0]);
                if (result.getStatus() == 1 || result.getStatus() == 4) {
                    String outStr = (String)result.getResultInfoSet().firstElement();
                    Trace.out((String)("outStr=" + outStr));
                    String exitStat = VerificationUtil.fetchVerificationResult(outStr);
                    Trace.out((String)("exitStat=" + exitStat));
                    if (exitStat != null && exitStat.contentEquals("0")) {
                        String[] cmdOut = (String[])result.getResultInfoSet().get(1);
                        m_deviceList = VerificationUtil.parseFileListOutput(cmdOut);
                        if (Trace.isLevelEnabled((int)5)) {
                            for (int i = 0; i < cmdOut.length; ++i) {
                                Trace.out((String)("expandDevicePaths: Command output is : " + cmdOut[i]));
                            }
                        }
                        this.m_deviceListAll.addAll(m_deviceList);
                        continue;
                    }
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Failed to expand wildcarded device string " + device));
                    }
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5193", true, (Object[])new String[]{device}));
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Wildcard expansion operation failed for device string " + device));
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("5193", true, (Object[])new String[]{device}));
                continue;
            }
            this.m_deviceListAll.add(device);
        }
    }

    public Vector<TaskSharedStorageAccess.StorageThread> getSharedSetVector() {
        return this.m_sharedSet;
    }

    public Vector<TaskSharedStorageAccess.StorageThread> getNonSharedSetVector() {
        return this.m_nonSharedSet;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4444", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4496", false);
    }
}

