/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskBinaryMatching;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskBinaryMatching
extends Task {
    protected String m_exeHome;

    public TaskBinaryMatching(String[] nodeList, String exeHome) {
        this(nodeList, exeHome, null, 1);
    }

    public TaskBinaryMatching(String[] nodeList, String exeHome, MultiTaskHandler multiTaskHandler) {
        this(nodeList, exeHome, multiTaskHandler, 1);
    }

    public TaskBinaryMatching(String[] nodeList, String oracleHome, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_exeHome = oracleHome;
    }

    public boolean performTask() {
        Trace.out((String)"Performing binary matching task... ");
        this.performBinaryMatching();
        this.m_resultSet.setStatus();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9901", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9902", false));
        return false;
    }

    void performBinaryMatching() {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("9900", false));
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("9904", false));
        ReportUtil.sureblankln();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        if (validNodeArr == null) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9905", true, (Object[])this.m_nodeList));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        if (validNodeArr.length == this.m_nodeList.length) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9906", false));
            ReportUtil.sureblankln();
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9903", false));
            ReportUtil.sureblankln();
        }
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet lsinventoryRS = new ResultSet();
        ResultSet oracleBinaryNMRS = new ResultSet();
        sTaskBinaryMatching sTask = new sTaskBinaryMatching(this);
        String cmd = sTask.getLSInventoryCommand();
        globalExec.runGenericCmd(validNodeArr, cmd, lsinventoryRS);
        this.m_resultSet.uploadResultSet(lsinventoryRS);
        globalExec.getBugSym(validNodeArr, this.m_exeHome, oracleBinaryNMRS);
        this.m_resultSet.uploadResultSet(oracleBinaryNMRS);
        ArrayList<String> OPatchFailedNodeList = new ArrayList<String>();
        ArrayList<String> NMFailedNodeList = new ArrayList<String>();
        HashMap bugNodeSummaryMap = new HashMap();
        ArrayList<String> loclMatchFailedNodeList = new ArrayList<String>();
        for (String node : validNodeArr) {
            String bugsStr;
            ArrayList<String> nodeList;
            String message;
            List<String> lsInventoryBugList = null;
            List<String> oracleBinaryBugList = null;
            Result lsInventoryResult = lsinventoryRS.getResult(node);
            if (lsInventoryResult.getStatus() != 1 && lsInventoryResult.getStatus() != 4) {
                this.m_resultSet.addResult(node, 2);
                String message2 = s_msgBundle.getMessage("9907", false);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(message2));
                Trace.out((String)"opatch lsinventory command returned operation failed");
                OPatchFailedNodeList.add(node);
                continue;
            }
            String execTaskLSInvOutput = (String)lsInventoryResult.getResultInfoSet().firstElement();
            Trace.out((String)("execTaskLSInvOutput=" + execTaskLSInvOutput));
            boolean execTaskLSInvEres = VerificationUtil.fetchExecResult(execTaskLSInvOutput);
            String execTaskLSInvExitStat = VerificationUtil.fetchVerificationResult(execTaskLSInvOutput);
            String execTaskLSInvErrString = VerificationUtil.fetchError(execTaskLSInvOutput);
            if (!execTaskLSInvEres || !execTaskLSInvExitStat.equals("0")) {
                this.m_resultSet.addResult(node, 2);
                String message3 = s_msgBundle.getMessage("9907", false);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(message3));
                if (execTaskLSInvErrString != null && execTaskLSInvErrString.length() != 0) {
                    this.m_resultSet.getResult(node).addErrorInfo(execTaskLSInvErrString);
                }
                Trace.out((String)"opatch lsinventory command returned operation failed");
                OPatchFailedNodeList.add(node);
                continue;
            }
            String[] execTaskLSInvValue = (String[])lsInventoryResult.getResultInfoSet().get(1);
            lsInventoryBugList = sTask.parseLSInvCommandOutput(execTaskLSInvValue);
            Result OBNMResult = oracleBinaryNMRS.getResult(node);
            if (OBNMResult.getStatus() != 1 && OBNMResult.getStatus() != 4) {
                this.m_resultSet.addResult(node, 2);
                message = s_msgBundle.getMessage("9908", false);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(message));
                Trace.out((String)"NM command on Oracle executable returned operation failed");
                NMFailedNodeList.add(node);
                continue;
            }
            oracleBinaryBugList = Arrays.asList((String[])OBNMResult.getResultInfoSet().firstElement());
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Node:" + node + " bugs from opatch inventory=" + VerificationUtil.strList2List(lsInventoryBugList)));
                Trace.out((String)("Node:" + node + " bugs from oracle executable=" + VerificationUtil.strList2List(oracleBinaryBugList)));
            }
            if (!((Object)lsInventoryBugList).equals(oracleBinaryBugList)) {
                this.m_resultSet.addResult(node, 3);
                message = s_msgBundle.getMessage("9909", false);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(message));
                Trace.out((String)"opatch lsinventory output did not match buglist from oracle executable");
                loclMatchFailedNodeList.add(node);
            }
            if ((nodeList = (ArrayList<String>)bugNodeSummaryMap.get(bugsStr = VerificationUtil.strList2List(lsInventoryBugList))) == null) {
                nodeList = new ArrayList<String>();
            }
            nodeList.add(node);
        }
        if (OPatchFailedNodeList.size() != 0) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9911", false));
            ReportUtil.sureprintNodelist(OPatchFailedNodeList.toArray(new String[0]));
        }
        if (NMFailedNodeList.size() != 0) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9912", false));
            ReportUtil.sureprintNodelist(NMFailedNodeList.toArray(new String[0]));
        }
        if (loclMatchFailedNodeList.size() != 0) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9913", false));
            ReportUtil.sureprintNodelist(loclMatchFailedNodeList.toArray(new String[0]));
        }
        if (bugNodeSummaryMap.keySet().size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5010", false));
            ArrayList accrossFailedNodeList = new ArrayList();
            for (List nodeList : bugNodeSummaryMap.values()) {
                accrossFailedNodeList.addAll(nodeList);
            }
            ReportUtil.sureprintNodelist(accrossFailedNodeList.toArray(new String[0]));
        }
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("6501", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("6701", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

