/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskDaemonLiveliness;
import oracle.ops.verification.framework.engine.task.TaskNTP;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ResourceState;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskCTSSIntegrity
extends Task {
    Hashtable<String, Vector<Object>> ctssResultNodeTable = new Hashtable();
    boolean m_mute = false;
    boolean m_noctss = false;
    String CTSS_OBSERVER_STATUS_TXT = "CRS-4700:";
    String CTSS_ACTIVE_STATUS_TXT = "CRS-4701:";
    String CTSS_OFFSET_MSG_TXT = "CRS-4702:";
    String CTSS_OFFLINE_STATUS_TXT = "CRS-4703:";

    public TaskCTSSIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskCTSSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskCTSSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        boolean integrityResult;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Performing Oracle Cluster Time Synchronization Service verification task... ");
        }
        if ((integrityResult = this.performCTSSIntegrityChecks()) && this.m_resultSet.allSuccess()) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9651", false));
            }
            return true;
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9652", true));
        }
        return false;
    }

    boolean performCTSSIntegrityChecks() {
        String[] validNodeArr;
        block67: {
            try {
                ParamManager pm = ParamManager.getInstance();
                this.m_noctss = pm.checkArgNoCtss();
            }
            catch (UninitializedParamManagerException e) {
                if (!Trace.isLevelEnabled((int)1)) break block67;
                Trace.out((Exception)e);
            }
        }
        if (this.m_noctss) {
            return this.doRunNTPChecks(this.m_nodeList);
        }
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9675", false));
        }
        if ((validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet)) == null) {
            String errMsg = s_msgBundle.getMessage("9676", true, (Object[])this.m_nodeList);
            if (!this.m_mute) {
                ReportUtil.sureprintln(errMsg);
            }
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        if (validNodeArr.length == this.m_nodeList.length) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9678", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
        } else {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9665", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
        }
        if (!this.m_noctss) {
            String activeCRSVer = null;
            try {
                activeCRSVer = VerificationUtil.getCRSActiveVersion();
            }
            catch (Exception e) {
                Trace.out((Exception)e);
                Trace.out((String)"Continuing...");
            }
            if (activeCRSVer == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Failed to retrieve active version for CRS");
                }
                String errMsg = s_msgBundle.getMessage("5300", true);
                ReportUtil.sureprintln(errMsg);
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(validNodeArr, errorDesc);
                this.m_resultSet.addResult(validNodeArr, 2);
                return false;
            }
            if (VerificationUtil.isVersionPre(activeCRSVer, "11.2")) {
                if (!this.m_mute) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("9692", false));
                }
                if (!this.m_mute) {
                    ReportUtil.sureblankln();
                }
                this.m_noctss = true;
            }
        }
        if (this.m_noctss) {
            return this.doRunNTPChecks(this.m_nodeList);
        }
        Vector<String> resokNodes = new Vector<String>();
        boolean allResOK = this.checkCTSSResources(validNodeArr, resokNodes);
        if (!allResOK) {
            return false;
        }
        validNodeArr = resokNodes.toArray(new String[resokNodes.size()]);
        boolean ret = false;
        VerificationCommand[] ctssCmdArray = new VerificationCommand[validNodeArr.length];
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((int)5, (String)("Node List to run CTSS Check command " + Arrays.asList(validNodeArr)));
        }
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9679", false));
        }
        String stateCmd = VerificationUtil.getCTSSCheckCommand();
        GlobalExecution globalExec = new GlobalExecution();
        for (int j = 0; j < validNodeArr.length; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd};
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("CTSS command args: " + Arrays.asList(arg)));
            }
            String[] env = null;
            ctssCmdArray[j] = new VerificationCommand(validNodeArr[j], arg, env);
        }
        new GlobalHandler().submit((Command[])ctssCmdArray, 0, this.m_resultSet);
        if (!this.m_resultSet.anySuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Global failure executing ctss command " + stateCmd));
            }
            String message = s_msgBundle.getMessage("9653", false, (Object[])new String[]{stateCmd});
            ErrorDescription errorDesc = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(validNodeArr, errorDesc);
            if (!this.m_mute) {
                ReportUtil.printError(message);
            }
            return false;
        }
        Vector<String> failNodes = new Vector<String>();
        for (int nodeIndex = 0; nodeIndex < validNodeArr.length; ++nodeIndex) {
            VerificationCommand ctssCmd = ctssCmdArray[nodeIndex];
            Result result = ctssCmd.getResult();
            String node = ctssCmd.getNode();
            if (result.getStatus() == 1) {
                String output = ctssCmd.getOutput();
                if (output == null) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Error retreiving output of crsctl check ctss command on node " + node));
                    }
                    String errMsg = s_msgBundle.getMessage("9654", true, (Object[])new String[]{stateCmd, node});
                    if (!this.m_mute) {
                        ReportUtil.println(errMsg);
                    }
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    result.addErrorDescription(errorDesc);
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    this.m_resultSet.addResult(node, 2);
                    failNodes.add(node);
                    continue;
                }
                Vector<Object> valVec = new Vector<Object>();
                Object offset = null;
                Object master = null;
                valVec.add(result);
                boolean ok = this.parseCTSSOutput(output, valVec);
                Trace.out((String)("value vector size " + valVec.size()));
                if (!ok) {
                    Trace.out((String)("Error parsing output of crsctl check ctss command:" + LSEP + "Output=" + output));
                    result.setStatus(3);
                    String errMsg = s_msgBundle.getMessage("9655", true, (Object[])new String[]{node, output});
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    result.addErrorDescription(errorDesc);
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    this.m_resultSet.addResult(node, 3);
                    if (!this.m_mute) {
                        ReportUtil.sureprintln(errMsg);
                    }
                    failNodes.add(node);
                    continue;
                }
                this.ctssResultNodeTable.put(node, valVec);
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Error executing ctss check command on node " + node));
            }
            String errMsg = s_msgBundle.getMessage("9656", true, (Object[])new String[]{node, result.getErrMessage()});
            if (!this.m_mute) {
                ReportUtil.sureprintln(errMsg);
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            result.addErrorDescription(errorDesc);
            this.m_resultSet.addErrorDescription(node, errorDesc);
            failNodes.add(node);
        }
        if (this.ctssResultNodeTable.size() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Error executing ctss check command on all nodes ");
            }
            String errMsg = s_msgBundle.getMessage("9657", true, (Object[])new String[]{stateCmd});
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errorDesc);
            if (!this.m_mute) {
                ReportUtil.sureprintln(errMsg);
            }
            return false;
        }
        if (failNodes.size() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"CTSS query execution passed on all nodes tested.");
            }
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("9684", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
        } else {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"CTSS query execution failed on some nodes.");
            }
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("9680", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
        }
        boolean active = false;
        boolean observer = false;
        Vector<String> activeNodes = new Vector<String>();
        Vector<String> observNodes = new Vector<String>();
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9681", false));
        }
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("9698", false));
        }
        if (!this.m_mute) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("9688", false));
        }
        Enumeration<String> e = this.ctssResultNodeTable.keys();
        while (e.hasMoreElements()) {
            String node = e.nextElement();
            Object[] objArr = this.ctssResultNodeTable.get(node).toArray();
            if (((Boolean)objArr[1]).booleanValue()) {
                if (!this.m_mute) {
                    ReportUtil.writeRecord(node, s_msgBundle.getMessage("9689", false));
                }
                activeNodes.add(node);
                active = true;
                continue;
            }
            if (!this.m_mute) {
                ReportUtil.writeRecord(node, s_msgBundle.getMessage("9690", false));
            }
            observNodes.add(node);
            observer = true;
        }
        if (active && observer) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Inconsistent CTSS status reported, with nodes " + activeNodes + " in Active state, and nodes " + observNodes + " in Observer state. All nodes should be in the same state."));
            }
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("9664", true, (Object[])new String[]{activeNodes.toString(), observNodes.toString()}));
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("9664", true, (Object[])new String[]{activeNodes.toString(), observNodes.toString()}));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            this.m_resultSet.addResult(validNodeArr, 3);
            this.m_resultSet.addErrorDescription(errorDesc);
            return false;
        }
        if (observer) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9666", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            String[] nodeArr = observNodes.toArray(new String[observNodes.size()]);
            ret = this.doRunNTPChecks(nodeArr);
        }
        if (active) {
            ret = this.checkActiveNodeResults(this.ctssResultNodeTable);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("performCTSSIntegrityChecks(): Returning with value: " + ret));
        }
        return ret;
    }

    private boolean doRunNTPChecks(String[] nodeArr) {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            boolean ntpRes = this.checkNTPOnNT(nodeArr);
            if (ntpRes) {
                return true;
            }
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9691", true));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            this.m_resultSet.addResult(nodeArr, 2);
            return false;
        }
        TaskNTP taskNTP = new TaskNTP(nodeArr);
        taskNTP.performTask();
        this.m_resultSet.uploadResultSet(taskNTP.getResultSet());
        return this.m_resultSet.getStatus() == 1 || this.m_resultSet.getStatus() == 4;
    }

    private boolean checkNTPOnNT(String[] nodeArr) {
        TaskDaemonLiveliness w32Time = new TaskDaemonLiveliness(nodeArr);
        TaskDaemonLiveliness ntpDaemon = new TaskDaemonLiveliness(nodeArr);
        w32Time.setDaemonName("W32Time");
        ntpDaemon.setDaemonName("NTP");
        Trace.out((String)"performing check for \"Windows Time\" (W32Time) service");
        boolean ret = w32Time.perform();
        ResultSet daemonCheckResultSet = w32Time.getResultSet();
        if (daemonCheckResultSet.allSuccess()) {
            Trace.out((String)"All nodes have \"Windows Time\" service");
            this.m_resultSet.uploadResultSet(daemonCheckResultSet);
            return ret;
        }
        if (daemonCheckResultSet.anySuccess()) {
            Trace.out((String)"Only some nodes have \"Windows Time\" service");
            Vector<String> failNodes = new Vector<String>();
            Vector succNodes = new Vector();
            daemonCheckResultSet.getSuccNodes(succNodes, failNodes);
            Trace.out((String)("failed nodes are" + VerificationUtil.strVect2List(failNodes)));
            return false;
        }
        Trace.out((String)"performing check for ntpd service");
        ret = ntpDaemon.perform();
        daemonCheckResultSet = ntpDaemon.getResultSet();
        if (daemonCheckResultSet.allSuccess()) {
            Trace.out((String)"All nodes have ntpd service");
            this.m_resultSet.uploadResultSet(daemonCheckResultSet);
            return ret;
        }
        if (daemonCheckResultSet.anySuccess()) {
            Trace.out((String)"Only some nodes have ntpd service. signal error");
            Vector<String> failNodes = new Vector<String>();
            Vector succNodes = new Vector();
            daemonCheckResultSet.getSuccNodes(succNodes, failNodes);
            Trace.out((String)("failed nodes are" + VerificationUtil.strVect2List(failNodes)));
            return false;
        }
        Trace.out((String)"no native time synchronization service found. CTSS should have been active.");
        return false;
    }

    private boolean checkActiveNodeResults(Hashtable<String, Vector<Object>> ctssResultNodeTable) {
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9682", false));
        }
        float offsetLimit = VerificationUtil.getCTSSOffsetLimit();
        boolean ret = false;
        Vector<String> offsetOKNodes = new Vector<String>();
        Vector<String> offsetBadNodes = new Vector<String>();
        Enumeration<String> e = ctssResultNodeTable.keys();
        boolean nodesOK = false;
        String refNode = null;
        boolean hdrPrinted = false;
        while (e.hasMoreElements()) {
            String node = e.nextElement();
            Object[] objArr = ctssResultNodeTable.get(node).toArray();
            if (!((Boolean)objArr[1]).booleanValue() || objArr[2] == null) continue;
            float curOffset = ((Float)objArr[2]).floatValue();
            if (!hdrPrinted) {
                if (!this.m_mute) {
                    ReportUtil.println(s_msgBundle.getMessage("9687", false, (Object[])new String[]{new Float(offsetLimit).toString()}));
                }
                if (!this.m_mute) {
                    ReportUtil.println(s_msgBundle.getMessage("9699", false));
                }
                if (!this.m_mute) {
                    ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("9685", false), s_msgBundle.getMessage("8018", false));
                }
                hdrPrinted = true;
            }
            if (Math.abs(curOffset) < offsetLimit) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Offset " + curOffset + " is within limits of threshold " + offsetLimit + " on node " + node));
                }
                if (!this.m_mute) {
                    ReportUtil.writeRecord(node, Float.toString(curOffset), ReportUtil.PASSED);
                }
                nodesOK = true;
                offsetOKNodes.add(node);
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Offset " + curOffset + " is NOT within limits of threshold " + offsetLimit + " on node " + node));
            }
            if (!this.m_mute) {
                ReportUtil.writeRecord(node, Float.toString(curOffset), ReportUtil.FAILED);
            }
            this.m_resultSet.getResult(node).setStatus(3);
            nodesOK = false;
            offsetBadNodes.add(node);
        }
        if (offsetBadNodes.size() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Time Offset from reference node " + refNode + " is within limits on the following nodes where CTSS was queried."));
            }
            if (!this.m_mute) {
                ReportUtil.blankln();
            }
            if (!this.m_mute) {
                ReportUtil.println(s_msgBundle.getMessage("9660", false, (Object[])new String[]{offsetOKNodes.toString()}));
            }
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("9683", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            ret = true;
        } else {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Time Offset from reference node " + refNode + " is not within limits on the following nodes where CTSS was queried."));
            }
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("9661", true, (Object[])new String[]{offsetBadNodes.toString()}));
            }
            this.m_resultSet.addResult(offsetBadNodes.toArray(new String[offsetBadNodes.size()]), 3);
            ret = false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("checkActiveNodeResults(): Returning with value: " + ret));
        }
        return ret;
    }

    boolean parseCTSSOutput(String output, Vector<Object> valVec) {
        String[] outArr = output.split("\\n");
        boolean ret = false;
        if (Trace.isLevelEnabled((int)5)) {
            for (int i = 0; i < outArr.length; ++i) {
                Trace.out((String)("Output Split Line " + i + "=" + outArr[i]));
            }
        }
        if (outArr[0].contains(this.CTSS_OBSERVER_STATUS_TXT)) {
            Trace.out((String)"Observer state");
            valVec.add(new Boolean(false));
            ret = true;
        } else if (outArr[0].contains(this.CTSS_ACTIVE_STATUS_TXT)) {
            boolean err = false;
            Trace.out((String)"Active state");
            valVec.add(new Boolean(true));
            String[] offArr = outArr[1].split(":");
            if (offArr.length > 1 && outArr[1].contains(this.CTSS_OFFSET_MSG_TXT)) {
                try {
                    valVec.add(new Float(offArr[2]));
                    Trace.out((String)("Added Float to vector: " + offArr[2]));
                }
                catch (NumberFormatException e) {
                    Trace.out((String)("Number not correct" + outArr[1]));
                    valVec.clear();
                    ret = false;
                    err = true;
                }
            }
            if (!err) {
                if (valVec.size() != 3) {
                    valVec.clear();
                    ret = false;
                } else {
                    ret = true;
                }
            }
        } else if (outArr[0].equalsIgnoreCase(this.CTSS_OFFLINE_STATUS_TXT)) {
            Trace.out((String)"ctss service offline");
            ret = false;
        } else {
            Trace.out((String)"invalid output");
            ret = false;
        }
        return ret;
    }

    private boolean checkCTSSResources(String[] validNodeArr, Vector<String> resokNodes) {
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("9677", false));
        }
        String resstatCmd = VerificationUtil.getCTSSResStatCommand();
        VerificationCommand[] ctssCmdArray = new VerificationCommand[validNodeArr.length];
        for (int j = 0; j < validNodeArr.length; ++j) {
            String[] arg = new String[]{"-rungencmd", resstatCmd};
            String[] env = null;
            ctssCmdArray[j] = new VerificationCommand(validNodeArr[j], arg, env);
        }
        new GlobalHandler().submit((Command[])ctssCmdArray, 0, this.m_resultSet);
        if (!this.m_resultSet.anySuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Global failure checking CTSS resource status with command " + resstatCmd));
            }
            String message = s_msgBundle.getMessage("9668", false, (Object[])new String[]{resstatCmd});
            ErrorDescription errorDesc = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(validNodeArr, errorDesc);
            this.m_resultSet.addResult(validNodeArr, 2);
            if (!this.m_mute) {
                ReportUtil.printError(message);
            }
            return false;
        }
        Vector<String> failNodes = new Vector<String>();
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("9697", false));
        }
        if (!this.m_mute) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
        }
        for (int nodeIndex = 0; nodeIndex < validNodeArr.length; ++nodeIndex) {
            VerificationCommand ctssCmd = ctssCmdArray[nodeIndex];
            Result result = ctssCmd.getResult();
            String node = ctssCmd.getNode();
            this.m_resultSet.addResult(node, result);
            if (result.getStatus() == 1) {
                String output = ctssCmd.getOutput();
                if (output == null) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Error retreiving output of crsctl check ctss command on node " + node));
                    }
                    String errMsg = s_msgBundle.getMessage("9654", true, (Object[])new String[]{resstatCmd, node});
                    if (!this.m_mute) {
                        ReportUtil.sureprintln(errMsg);
                    }
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    result.addErrorDescription(errorDesc);
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    this.m_resultSet.addResult(node, 2);
                    failNodes.add(node);
                    if (this.m_mute) continue;
                    ReportUtil.writeRecord(node, ReportUtil.FAILED);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Parsing command output: " + output));
                }
                ResourceState resst = ResourceState.checkState(output);
                switch (resst) {
                    case ONLINE: 
                    case INTERMEDIATE: {
                        resokNodes.add(node);
                        if (this.m_mute) break;
                        ReportUtil.writeRecord(node, ReportUtil.PASSED);
                        break;
                    }
                    case OFFLINE: 
                    case UNKNOWN: {
                        failNodes.add(node);
                        if (!this.m_mute) {
                            ReportUtil.writeRecord(node, ReportUtil.FAILED);
                        }
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Error parsing output of crsctl check ctss command:" + LSEP + "Output=" + output));
                        }
                        result.setStatus(3);
                        String errMsg = s_msgBundle.getMessage("9671", true, (Object[])new String[]{resstatCmd, node});
                        if (!this.m_mute) {
                            ReportUtil.println(errMsg);
                        }
                        ErrorDescription errorDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node, errorDesc);
                        break;
                    }
                }
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Error executing ctss resource check on node " + node));
            }
            String errMsg = s_msgBundle.getMessage("9670", true, (Object[])new String[]{resstatCmd, node});
            if (!this.m_mute) {
                ReportUtil.sureprintln(errMsg);
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            result.setStatus(2);
            this.m_resultSet.addErrorDescription(node, errorDesc);
            this.m_resultSet.addResult(node, 2);
            failNodes.add(node);
            if (this.m_mute) continue;
            ReportUtil.writeRecord(node, ReportUtil.FAILED);
        }
        if (resokNodes.size() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("All nodes for which CTSS resource state was checked failed the check: Nodes: " + Arrays.asList(failNodes)));
            }
            String errMsg = s_msgBundle.getMessage("9672", true, (Object[])failNodes.toArray(new String[failNodes.size()]));
            if (!this.m_mute) {
                ReportUtil.printResult(errMsg);
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errorDesc);
            return false;
        }
        if (resokNodes.size() != this.m_nodeList.length) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("CTSS resource status check succeeded on the following nodes: " + Arrays.asList(resokNodes)));
            }
            String errMsg = s_msgBundle.getMessage("9673", false, (Object[])resokNodes.toArray(new String[resokNodes.size()]));
            if (!this.m_mute) {
                ReportUtil.printResult(errMsg);
            }
        } else {
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("9674", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
        }
        return true;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9662", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9663", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

