/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskContainerFreeSpace
extends Task {
    public String m_localNode = null;
    private static boolean m_visited = false;
    private Vector<String> m_location;
    private Vector<StorageSize> m_reqdSpaceSize;
    private Vector<nodeMntPnt> m_nodeMntPnt;
    private Vector<SeverityType> m_severities;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1056", false);

    public TaskContainerFreeSpace() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Constructor");
        }
    }

    public boolean setSubTasks(TaskFreeSpace[] subtaskArr) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.setHasSubtasks(true);
        this.setSubtasks(subtaskArr);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return true;
    }

    public TaskContainerFreeSpace(String location, StorageSize size, boolean temp, SeverityType severity) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Instantiation entry (Double)");
        }
        this.addPathDetails(location, size, temp, severity);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Instantiation exit (Double)");
        }
    }

    public void addPathDetails(String location, StorageSize size, boolean temp, SeverityType severity) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Instantiation entry (Double)");
        }
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("\n\n    Updating location vectors with: \n    Location:  " + location + "\n    Size:      " + ReportUtil.unitizeSize(size, 1)));
        }
        if (temp) {
            int i;
            Trace.out((String)"checking if temp dir exists");
            ClusterCmd clusterCmd = new ClusterCmd();
            boolean allFailed = false;
            Vector<String> failedNodes = null;
            try {
                clusterCmd.dirExists(this.m_nodeList, location);
            }
            catch (ClusterException e) {
                Trace.out((String)("temp dir doesn't exist on all nodes" + e.getMessage()));
                failedNodes = new Vector(this.m_nodeList.length);
                for (i = 0; i < this.m_nodeList.length; ++i) {
                    failedNodes.add(this.m_nodeList[i]);
                }
            }
            catch (ClusterOperationException e) {
                Trace.out((String)("temp dir doesn't exist on some nodes" + e.getMessage()));
                failedNodes = new Vector<String>();
                for (i = 0; i < this.m_nodeList.length; ++i) {
                    try {
                        if (e.getStatus(this.m_nodeList[i]) == 0) continue;
                        failedNodes.add(this.m_nodeList[i]);
                        continue;
                    }
                    catch (NoSuchNodeException ne) {
                        Trace.out((String)("no such node exception for node" + this.m_nodeList[i]));
                        Trace.out((Exception)((Object)ne));
                    }
                }
            }
            try {
                if (failedNodes != null && failedNodes.size() > 0) {
                    clusterCmd.createDirInNodes(failedNodes.toArray(new String[0]), location);
                }
            }
            catch (ClusterException e) {
                Trace.out((String)("error creating temp dir in failed nodes" + e.getMessage()));
                String msg = s_msgBundle.getMessage("7509", true, (Object[])new String[]{location});
                ReportUtil.sureprintln(msg);
            }
        }
        if (this.m_location == null) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"New Vectors");
            }
            this.m_location = new Vector();
            this.m_reqdSpaceSize = new Vector();
            this.m_nodeMntPnt = new Vector();
            this.m_severities = new Vector();
        }
        if (this.m_location.contains(location)) {
            int elemIdx = this.m_location.indexOf(location, 0);
            StorageSize prevSize = this.m_reqdSpaceSize.elementAt(elemIdx);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Increasing size for Location: " + location + " from: " + ReportUtil.unitizeSize(prevSize, 1)));
            }
            prevSize.add(size);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)(" Size increased to: " + ReportUtil.unitizeSize(prevSize, 1)));
            }
        } else {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Adding to existing Vectors");
            }
            this.m_location.add(location);
            this.m_reqdSpaceSize.add(size);
            this.m_severities.add(severity);
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Location: " + location + " Size: " + ReportUtil.unitizeSize(size, 1)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Instantiation exit (Double)");
        }
    }

    public TaskFreeSpace[] getTaskFreeSpaceList() {
        int j;
        int i;
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace(this);
        ResultSet rsltSet = new ResultSet();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n\n    There are " + this.m_location.size() + " locations to process."));
        }
        for (i = 0; i < this.m_location.size(); ++i) {
            NativeSystem nativeSystem;
            StorageSize locSize = this.m_reqdSpaceSize.elementAt(i);
            SeverityType severity = this.m_severities.elementAt(i);
            boolean found = false;
            String loc = this.m_location.elementAt(i);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n\n    Processing location: " + i + " location: " + loc));
            }
            StorageSize sizeReqKB = locSize;
            String cmd = sTask.getCommand(loc);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n\n    Executing command: " + cmd + "\n    on nodeList:      " + VerificationUtil.strArr2List(this.m_nodeList)));
            }
            if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
                globalExec.runGenericCmd(this.m_nodeList, cmd, rsltSet);
            } else {
                globalExec.getSpaceCmd(this.m_nodeList, loc, rsltSet);
            }
            Hashtable t = rsltSet.getResultTable();
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                nodeMntPnt newNodeMntPnt;
                String mountPoint;
                StorageSize sizeAvailKB;
                String node = (String)e.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() == 2) {
                    sizeAvailKB = new StorageSize(0.0, StorageUnit.BYTE);
                    mountPoint = "UNKNOWN";
                } else {
                    String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
                    String sizeTxt = sTask.getData(cmdOut, 4);
                    mountPoint = sTask.getData(cmdOut, 6);
                    sizeAvailKB = new StorageSize(new Double(sizeTxt), StorageUnit.MBYTE);
                }
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\n\n    Processing:  \n    Node:        " + node + "\n    Location:    " + loc + "\n    Mount Point: " + mountPoint));
                }
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\n\n    Number of elements in m_nodeMntPnt vector: " + this.m_nodeMntPnt.size()));
                }
                if (this.m_nodeMntPnt.size() < 1) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"\n\n    Adding first vector element for m_nodeMntPnt");
                    }
                    found = true;
                    newNodeMntPnt = new nodeMntPnt(loc, node, mountPoint, sizeReqKB, sizeAvailKB, severity);
                    this.m_nodeMntPnt.add(newNodeMntPnt);
                } else {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("\n\n    Searching vector m_nodeMntPnt for node: " + node + " and mount point: " + mountPoint));
                    }
                    for (j = 0; j < this.m_nodeMntPnt.size(); ++j) {
                        nodeMntPnt nodeMP = this.m_nodeMntPnt.elementAt(j);
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("\n\n    Processing m_nodeMntPnt for node: " + nodeMP.nmp_node + " and mount point: " + nodeMP.nmp_mountPoint));
                        }
                        if (!nodeMP.nmp_node.contentEquals(node) || !nodeMP.nmp_mountPoint.contentEquals(mountPoint)) continue;
                        found = true;
                        nodeMP.addNodeMntPnt(loc, sizeReqKB);
                        break;
                    }
                }
                if (!found) {
                    newNodeMntPnt = new nodeMntPnt(loc, node, mountPoint, sizeReqKB, sizeAvailKB, severity);
                    this.m_nodeMntPnt.add(newNodeMntPnt);
                }
                found = false;
            }
        }
        String bootStrapPath = null;
        String mntPnt = null;
        if (ParamManager.isRuncluvfy() && !m_visited) {
            try {
                this.m_localNode = VerificationUtil.getLocalHost();
                bootStrapPath = VerificationUtil.getCVHome();
                mntPnt = this.getMntPnt(bootStrapPath);
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)uhe.getMessage());
            }
        }
        TaskFreeSpace[] taskFS = new TaskFreeSpace[this.m_nodeMntPnt.size()];
        for (i = 0; i < this.m_nodeMntPnt.size(); ++i) {
            nodeMntPnt nodeMP = this.m_nodeMntPnt.elementAt(i);
            if (ParamManager.isRuncluvfy() && !m_visited && this.m_localNode != null && this.m_localNode.equalsIgnoreCase(nodeMP.nmp_node) && mntPnt != null && !mntPnt.equals("UNKNOWN") && mntPnt.equals(nodeMP.nmp_mountPoint)) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("    Before adding bootstrap size \n    Mount Point: " + nodeMP.nmp_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(nodeMP.nmp_availMntPntSize, 1)));
                }
                m_visited = this.ignoreBootStrapSpace(nodeMP, bootStrapPath);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("    After adding bootstrap size \n    Mount Point: " + nodeMP.nmp_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(nodeMP.nmp_availMntPntSize, 1)));
                }
            }
            if (Trace.isLevelEnabled((int)3)) {
                String[] sizes = new String[nodeMP.nmp_reqdLocSize.size()];
                for (j = 0; j < nodeMP.nmp_reqdLocSize.size(); ++j) {
                    StorageSize size = (StorageSize)nodeMP.nmp_reqdLocSize.elementAt(j);
                    sizes[j] = ReportUtil.unitizeSize(size, 1);
                }
                Trace.out((String)("\n\n    Building Task List with: \n    Location:    " + VerificationUtil.strVect2List(nodeMP.nmp_locations) + "\n    Node:        " + nodeMP.nmp_node + "\n    Mount Point: " + nodeMP.nmp_mountPoint + "\n    Size(s):     " + VerificationUtil.strArr2List(sizes) + "\n    Total Size:  " + ReportUtil.unitizeSize(nodeMP.nmp_reqdMntPntSize, 1) + "\n    Avail Size:  " + ReportUtil.unitizeSize(nodeMP.nmp_availMntPntSize, 1) + "\n\n"));
            }
            taskFS[i] = new TaskFreeSpace(nodeMP.nmp_locations, nodeMP.nmp_node, nodeMP.nmp_mountPoint, nodeMP.nmp_reqdLocSize, nodeMP.nmp_reqdMntPntSize, nodeMP.nmp_availMntPntSize);
            taskFS[i].setSeverity(nodeMP.nmp_severity);
        }
        return taskFS;
    }

    public String getMntPnt(String loc) {
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace();
        String cmd = sTask.getCommand(loc);
        ResultSet rsltSet = new ResultSet();
        String mountPoint = "UNKNOWN";
        globalExec.runGenericCmd(new String[]{this.m_localNode}, cmd, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Result result = (Result)t.get(this.m_localNode);
        if (result.getStatus() == 1) {
            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
            mountPoint = sTask.getData(cmdOut, 6);
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("   Location  :" + loc + "\n" + "   Mnt Point :" + mountPoint));
        }
        return mountPoint;
    }

    public boolean ignoreBootStrapSpace(nodeMntPnt nodeMP, String bsLoc) {
        VerificationCommand cmdOP;
        Result result;
        Trace.out((String)"Inside ignoreBootStrapSpace().....");
        ResultSet rsltSet = new ResultSet();
        String[] arg = new String[]{"-getdirsize", bsLoc};
        String[] env = null;
        VerificationCommand[] cmd = new VerificationCommand[]{new VerificationCommand(this.m_localNode, arg, env)};
        boolean cmdResult = new GlobalHandler().submit((Command[])cmd, 0, rsltSet);
        if (cmdResult && (result = (Result)rsltSet.getResultTable().get(this.m_localNode)).getStatus() == 1 && (cmdOP = cmd[0]).getVfyCode() == 0) {
            String cmdOut = cmdOP.getOutput();
            if (cmdOut == null) {
                return false;
            }
            String[] op = (cmdOut = cmdOut.trim()).split("\n");
            if (op.length > 0) {
                cmdOut = op[0];
            }
            StorageSize sizeAvail = new StorageSize(new Double(cmdOut), StorageUnit.BYTE);
            nodeMP.nmp_availMntPntSize.add(sizeAvail);
            return true;
        }
        return false;
    }

    public boolean performTask() {
        return true;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4438", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4491", false);
    }

    private class nodeMntPnt {
        private Vector<String> nmp_locations = new Vector();
        private String nmp_node;
        private String nmp_mountPoint;
        private Vector<StorageSize> nmp_reqdLocSize = new Vector();
        private StorageSize nmp_reqdMntPntSize;
        private StorageSize nmp_availMntPntSize;
        private SeverityType nmp_severity;

        private nodeMntPnt(String loc, String node, String mntPnt, StorageSize size, StorageSize availSize, SeverityType severity) {
            this.nmp_locations.add(loc);
            this.nmp_node = node;
            this.nmp_mountPoint = mntPnt;
            this.nmp_reqdLocSize.add(size);
            this.nmp_reqdMntPntSize = size;
            this.nmp_availMntPntSize = availSize;
            this.nmp_severity = severity;
            if (Trace.isLevelEnabled((int)3)) {
                String[] sizes = new String[this.nmp_reqdLocSize.size()];
                for (int i = 0; i < this.nmp_reqdLocSize.size(); ++i) {
                    StorageSize locSize = this.nmp_reqdLocSize.elementAt(i);
                    sizes[i] = ReportUtil.unitizeSize(locSize, 1);
                }
                Trace.out((String)("\n\n    Adding new m_nodeMntPnt vector: \n    Location:      " + VerificationUtil.strVect2List(this.nmp_locations) + "\n    Node:          " + this.nmp_node + "\n    Mount Point:   " + this.nmp_mountPoint + "\n    Reqd Size:     " + VerificationUtil.strArr2List(sizes) + "\n    Req. Mnt Size: " + ReportUtil.unitizeSize(this.nmp_reqdMntPntSize, 1) + "\n    Avail Size:    " + ReportUtil.unitizeSize(this.nmp_availMntPntSize, 1) + "\n    Severity:    " + (Object)((Object)this.nmp_severity)));
            }
        }

        private void addNodeMntPnt(String loc, StorageSize size) {
            StorageSize locSize;
            int i;
            String[] sizes;
            if (Trace.isLevelEnabled((int)3)) {
                sizes = new String[this.nmp_reqdLocSize.size()];
                for (i = 0; i < this.nmp_reqdLocSize.size(); ++i) {
                    locSize = this.nmp_reqdLocSize.elementAt(i);
                    sizes[i] = ReportUtil.unitizeSize(locSize, 1);
                }
                Trace.out((String)("\n\n    Updating m_nodeMntPnt vector (before): \n    Location:      " + VerificationUtil.strVect2List(this.nmp_locations) + "\n    Node:          " + this.nmp_node + "\n    Mount Point:   " + this.nmp_mountPoint + "\n    Reqd Size:     " + VerificationUtil.strArr2List(sizes) + "\n    Req. Mnt Size: " + ReportUtil.unitizeSize(this.nmp_reqdMntPntSize, 1) + "\n    Avail Size:    " + ReportUtil.unitizeSize(this.nmp_availMntPntSize, 1)));
            }
            this.nmp_locations.add(loc);
            this.nmp_reqdLocSize.add(size);
            this.nmp_reqdMntPntSize.add(size);
            if (Trace.isLevelEnabled((int)3)) {
                sizes = new String[this.nmp_reqdLocSize.size()];
                for (i = 0; i < this.nmp_reqdLocSize.size(); ++i) {
                    locSize = this.nmp_reqdLocSize.elementAt(i);
                    sizes[i] = ReportUtil.unitizeSize(locSize, 1);
                }
                Trace.out((String)("\n\n    Updating m_nodeMntPnt vector (after): \n    Location:     " + VerificationUtil.strVect2List(this.nmp_locations) + "\n    Node:         " + this.nmp_node + "\n    Mount Point:  " + this.nmp_mountPoint + "\n    Reqd Size:    " + VerificationUtil.strArr2List(sizes) + "\n    Req. Mnt Size: " + ReportUtil.unitizeSize(this.nmp_reqdMntPntSize, 1) + "\n    Avail Size:    " + ReportUtil.unitizeSize(this.nmp_availMntPntSize, 1)));
            }
        }
    }
}

