/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDaemonLiveliness
extends Task {
    private String m_daemonTag;
    private String m_daemonDispName;
    private String m_daemonIntlName;

    public TaskDaemonLiveliness(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskDaemonLiveliness(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskDaemonLiveliness(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setDaemonName(String daemonTag) {
        this.m_daemonTag = daemonTag;
    }

    public boolean performTask() {
        Trace.out((String)"Performing Daemon Liveliness verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4028", false));
        ResultSet resultSet = new ResultSet();
        this.m_daemonDispName = VerificationUtil.getDaemonDisplayName(this.m_daemonTag);
        if (this.m_daemonDispName == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        this.m_daemonIntlName = VerificationUtil.getDaemonInternalName(this.m_daemonTag);
        if (this.m_daemonIntlName == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        boolean livelinessResult = new GlobalExecution().checkDaemonLiveliness(this.m_nodeList, this.m_daemonIntlName, resultSet);
        Trace.out((String)"TaskDaemonLiveliness:   checkDaemonLiveliness() performed!!");
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4029", false, (Object[])new String[]{this.m_daemonDispName}));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8003", false));
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String running;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                Trace.out((String)("Daemon '" + this.m_daemonDispName + "' is running on node: '" + node + "'"));
                this.m_resultSet.addResult(node, 1);
                running = ReportUtil.YES;
            } else if (result.getStatus() == 3) {
                Trace.out((String)("Daemon '" + this.m_daemonDispName + "' is not running on node: '" + node + "'"));
                this.m_resultSet.addResult(node, 3);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7590", true, (Object[])new String[]{this.m_daemonDispName, node}), s_msgBundle, "7590");
                this.m_resultSet.addErrorDescription(node, errDesc);
                running = ReportUtil.NO;
            } else {
                Trace.out((String)("Daemon Liveliness result couldn't be obtained from node: '" + node + "'"));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7591", true, (Object[])new String[]{this.m_daemonDispName, node}), s_msgBundle, "7591");
                this.m_resultSet.addErrorDescription(node, errDesc);
                this.m_resultSet.addResult(node, 2);
                running = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord(node, running);
        }
        this.m_resultSet.traceResultSet("\n====ResultSet returned by TaskDaemonLiveliness verification task====\n");
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4030", false, (Object[])new String[]{this.m_daemonDispName}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("4031", false, (Object[])new String[]{this.m_daemonDispName}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4432", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4483", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

