/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCFSSetup;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.ParamPreReqHAConfig;
import oracle.cluster.verification.ParamPreReqHWOSSetup;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.ParamPreReqUSMConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.XmlTaskFactory;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.OCRInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskASMDeviceChecks;
import oracle.ops.verification.framework.engine.task.TaskCFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCRSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCTSSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterMgrIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCoreFileNameConsistency;
import oracle.ops.verification.framework.engine.task.TaskCurrentGroupID;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskHAIntegrity;
import oracle.ops.verification.framework.engine.task.TaskNTP;
import oracle.ops.verification.framework.engine.task.TaskNodeAddDelete;
import oracle.ops.verification.framework.engine.task.TaskNodeAppCreation;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.TaskOCRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskOLRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.engine.task.TaskPinNodes;
import oracle.ops.verification.framework.engine.task.TaskScan;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.TaskTimeZoneSetting;
import oracle.ops.verification.framework.engine.task.TaskUSMDriverChecks;
import oracle.ops.verification.framework.engine.task.TaskUSMIntegrity;
import oracle.ops.verification.framework.engine.task.TaskUSMUdevChecks;
import oracle.ops.verification.framework.engine.task.TaskUserMask;
import oracle.ops.verification.framework.engine.task.TaskUserNotInGroup;
import oracle.ops.verification.framework.engine.task.TaskUsersWithSameID;
import oracle.ops.verification.framework.engine.task.TaskVotingDisk;
import oracle.ops.verification.framework.engine.task.sTaskFactory;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFactory {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static TaskFactory _taskFactory;
    private ParamPreReq m_param;

    private TaskFactory() throws TaskFactoryException {
    }

    public static synchronized TaskFactory getInstance() throws TaskFactoryException {
        if (_taskFactory == null) {
            _taskFactory = new TaskFactory();
        }
        return _taskFactory;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param) throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> taskList = null;
        this.m_param = param;
        switch (vfyType) {
            case PREREQ_CRS_INST: {
                taskList = this.getTaskListPreCRSInst(nodeList);
                break;
            }
            case POSTREQ_CRS_INST: {
                taskList = this.getTaskListPostCRSInst(nodeList);
                break;
            }
            case PREREQ_DB_INST: {
                taskList = this.getTaskListPreDBInst(nodeList);
                break;
            }
            case PREREQ_DB_CONFIG: {
                taskList = this.getTaskListPreDBConfig(nodeList);
                break;
            }
            case PREREQ_SI_HA_INST: {
                taskList = this.getTaskListPreSIHAInst(nodeList);
                break;
            }
            case PREREQ_SI_DB_INST: {
                taskList = this.getTaskListPreSIDBInst(nodeList);
                break;
            }
            case PREREQ_SI_DB_CONFIG: {
                taskList = this.getTaskListPreSIDBConfig(nodeList);
                break;
            }
            case PREREQ_SI_HA_CONFIG: {
                taskList = this.getTaskListPreHAConfig(nodeList);
                break;
            }
            case POSTREQ_SI_HA_CONFIG: {
                taskList = this.getTaskListPostHAConfig(nodeList);
                break;
            }
            case POSTREQ_HWOS_SETUP: {
                taskList = this.getTaskListPostHWOSSetup(nodeList);
                break;
            }
            case PREREQ_CFS_SETUP: {
                taskList = this.getTaskListPreCFSSetup(nodeList);
                break;
            }
            case POSTREQ_CFS_SETUP: {
                taskList = this.getTaskListPostCFSSetup(nodeList);
                break;
            }
            case PREREQ_NODE_ADD: {
                taskList = this.getTaskListPreNodeAdd(nodeList);
                break;
            }
            case POSTREQ_NODE_ADD: {
                taskList = this.getTaskListPostNodeAdd(nodeList);
                break;
            }
            case POSTREQ_NODE_DEL: {
                taskList = this.getTaskListPostNodeDel(nodeList);
                break;
            }
            case SYSREQ_CRS: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case SYSREQ_DB: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case SYSREQ_SI_HA: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case SYSREQ_SI_DB: {
                taskList = this.getTaskListSysReq(nodeList, vfyType);
                break;
            }
            case PREREQ_USM_CONFIG: {
                taskList = this.getTaskListPreUSMConfig(nodeList);
                break;
            }
            case POSTREQ_USM_CONFIG: {
                taskList = this.getTaskListPostUSMConfig(nodeList);
            }
        }
        List<Task> sosdTaskList = new sTaskFactory(this).getTaskList(vfyType, nodeList, param);
        if (sosdTaskList != null && sosdTaskList.size() > 0) {
            taskList.addAll(sosdTaskList);
        }
        return taskList;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, ParamPreReq param, MultiTaskHandler multiTaskHandler) throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> taskList = this.getTaskList(vfyType, nodeList, param);
        for (Task task : taskList) {
            if (task.hasSubtasks()) {
                try {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask subTask : subTaskList) {
                        ((Task)subTask).setMultiTaskHandler(multiTaskHandler);
                    }
                    continue;
                }
                catch (SubtasksUnavailableException e) {
                    throw new TaskFactoryException(e);
                }
            }
            task.setMultiTaskHandler(multiTaskHandler);
        }
        return taskList;
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, (ParamPreReq)null);
    }

    public List<Task> getTaskList(VerificationType vfyType, String[] nodeList, MultiTaskHandler multiTaskHandler) throws TaskFactoryException, PreReqNotSupportedException {
        return this.getTaskList(vfyType, nodeList, null, multiTaskHandler);
    }

    private List<Task> getTaskListPreCRSInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        String[] pathArr;
        String installOption;
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqCRSInst param = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqCRSInst)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7511", false));
            }
            param = (ParamPreReqCRSInst)this.m_param;
        }
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        String niList = VerificationUtil.getVariableValue("INTERCONNECT_LIST");
        String[] interconnectLst = null;
        String[] interFaceLst = null;
        if (niList != null) {
            Trace.out((int)5, (String)("INTERCONNECT_LIST: '" + niList + "'"));
            interconnectLst = VerificationUtil.string2strArr(niList);
            interFaceLst = new String[interconnectLst.length];
            for (int i = 0; i < interconnectLst.length; ++i) {
                int start = interconnectLst[i].indexOf(34) + 1;
                int end = interconnectLst[i].indexOf(34, start);
                interFaceLst[i] = interconnectLst[i].substring(start, end);
            }
            Trace.out((int)5, (String)("NodeCon Interfaces: '" + VerificationUtil.strArr2String(interFaceLst)));
            taskNodeCon.setInterfaceList(interFaceLst);
        }
        if ((installOption = VerificationUtil.getVariableValue("INSTALL_OPTION")) == null || !installOption.equalsIgnoreCase("UPGRADE")) {
            Trace.out((String)"Adding node connectivity task");
            taskList.add(taskNodeCon);
        }
        Trace.out((String)("installOption: '" + installOption + "'"));
        TaskSharedStorageAccess taskSSAccessOCR = null;
        if (param != null && (pathArr = param.getOCRLoc()) != null) {
            for (String path : pathArr) {
                taskSSAccessOCR = new TaskSharedStorageAccess(nodeList);
                taskSSAccessOCR.setStorageIDlist(new String[]{path});
                taskSSAccessOCR.setCheckWritableFS(false);
                taskSSAccessOCR.setOCRLocationFlag(true);
                taskList.add(taskSSAccessOCR);
            }
        }
        TaskSharedStorageAccess taskSSAccessVdisk = null;
        if (param != null && (pathArr = param.getVotingLoc()) != null) {
            for (String path : pathArr) {
                taskSSAccessVdisk = new TaskSharedStorageAccess(nodeList);
                taskSSAccessVdisk.setStorageIDlist(new String[]{path});
                taskSSAccessVdisk.setCheckWritableFS(false);
                taskSSAccessVdisk.setVDiskLocationFlag(true);
                taskList.add(taskSSAccessVdisk);
            }
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_CRS_INST);
        taskList.addAll(sysReqTaskList);
        TaskASMDeviceChecks taskASMDevChecks = null;
        boolean isAPIMode = false;
        try {
            isAPIMode = ParamManager.getInstance().getMode() == ParamManager.OperationMode.MODE_API;
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        if (isAPIMode) {
            String asmDeviceString = VerificationUtil.getVariableValue("ASM_DISKGROUP_DISKS");
            String string = asmDeviceString = asmDeviceString == null ? asmDeviceString : VerificationUtil.getVariableValue("ASM_DISK_DISCOVERY_STRING");
            if (asmDeviceString != null) {
                String[] devarr = asmDeviceString.split(",");
                taskASMDevChecks = new TaskASMDeviceChecks(nodeList);
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("Device string using VerificationUtil.getVariableValue = " + VerificationUtil.strArr2List(devarr)));
                }
                taskASMDevChecks.setVerifySharedness(false);
                taskASMDevChecks.setDeviceString(devarr);
                if (new SystemFactory().CreateSystem().isUnixSystem()) {
                    taskASMDevChecks.setReferenceOwner(VerificationUtil.getVariableValue("INSTALL_USER"));
                    taskASMDevChecks.setReferenceGroup(VerificationUtil.getVariableValue("ASM_GROUP"));
                    taskASMDevChecks.setReferencePermissions(VDMUtil.getDefaultAsmDisksPermissions());
                }
            }
        } else if (param.getASMCheck() && param != null) {
            String[] devarr = param.getASMDevice();
            taskASMDevChecks = new TaskASMDeviceChecks(nodeList);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Device string from ParamPreReqCRSInst = " + VerificationUtil.strArr2List(devarr)));
            }
            taskASMDevChecks.setDeviceString(devarr);
        }
        if (taskASMDevChecks != null) {
            taskList.add(taskASMDevChecks);
        }
        if (nativeSystem.isUnixSystem()) {
            TaskCoreFileNameConsistency taskCore = new TaskCoreFileNameConsistency(nodeList);
            taskList.add(taskCore);
            TaskUserNotInGroup taskRoot = new TaskUserNotInGroup(nodeList, VerificationUtil.getDefaultCRSUser(), "root");
            taskList.add(taskRoot);
            if (!VerificationUtil.isCVUTestEnv()) {
                TaskUserMask taskUM = new TaskUserMask(nodeList, VerificationUtil.getDefaultUmask());
                taskList.add(taskUM);
            }
            TaskNTP taskNTP = new TaskNTP(nodeList);
            String reqRel = VerificationUtil.getRequestedRelease();
            if (reqRel == null || VerificationUtil.isVersionPost(reqRel, "11.2")) {
                taskNTP.setPreCheck(true);
            }
            taskList.add(taskNTP);
        }
        return taskList;
    }

    private List<Task> getTaskListPreDBInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqDBInst param = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqDBInst)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7512", false));
            }
            param = (ParamPreReqDBInst)this.m_param;
        }
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        String niList = VerificationUtil.getVariableValue("INTERCONNECT_LIST");
        String[] interconnectLst = null;
        String[] interFaceLst = null;
        if (niList != null) {
            Trace.out((int)5, (String)("INTERCONNECT_LIST: '" + niList + "'"));
            interconnectLst = VerificationUtil.string2strArr(niList);
            interFaceLst = new String[interconnectLst.length];
            for (int i = 0; i < interconnectLst.length; ++i) {
                int start = interconnectLst[i].indexOf(34) + 1;
                int end = interconnectLst[i].indexOf(34, start);
                interFaceLst[i] = interconnectLst[i].substring(start, end);
            }
            Trace.out((int)5, (String)("NodeCon Interfaces: '" + VerificationUtil.strArr2String(interFaceLst)));
            taskNodeCon.setInterfaceList(interFaceLst);
        }
        TaskCFSIntegrity taskCFSIntg = null;
        if (param != null && param.orclHomeOnOCFS()) {
            taskCFSIntg = new TaskCFSIntegrity(nodeList, param.getOrclHome());
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_DB_INST);
        TaskCRSIntegrity taskCRSIntg = new TaskCRSIntegrity(nodeList);
        TaskClusterMgrIntegrity taskCluMgrIntg = new TaskClusterMgrIntegrity(nodeList);
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(nodeList);
        TaskUSMIntegrity taskUSMIntg = new TaskUSMIntegrity(nodeList);
        TaskUserMask taskUM = new TaskUserMask(nodeList, VerificationUtil.getDefaultUmask());
        taskList.addAll(sysReqTaskList);
        if (nativeSystem.isUnixSystem() && !VerificationUtil.isCVUTestEnv()) {
            taskList.add(taskUM);
        }
        if (param != null && param.orclHomeOnOCFS()) {
            taskList.add(taskCFSIntg);
        }
        taskList.add(taskCRSIntg);
        taskList.add(taskCluMgrIntg);
        String reqRel = VerificationUtil.getRequestedRelease();
        if (reqRel == null || reqRel.equalsIgnoreCase("10gR2")) {
            Trace.out((String)"==== Nodeapp check added for pre dbinst check");
            taskList.add(taskNodeApp);
        }
        Trace.out((int)5, (String)"Now attempting USM Integrity...");
        if (param != null && (param.getASMCheck() || param.getUSMCheck())) {
            Trace.out((int)5, (String)"Condition for USM Integrity check satisfied.");
            String[] dgList = param.getASMDGList();
            if (dgList != null) {
                Trace.out((int)5, (String)"Adding USM Integrity task to task list");
                taskUSMIntg.setVerificationType(VerificationType.PREREQ_DB_INST);
                taskUSMIntg.setASMDGList(dgList);
                taskList.add(taskUSMIntg);
            }
        }
        if (reqRel != null && (reqRel.equalsIgnoreCase("10gR1") || reqRel.equalsIgnoreCase("10gR2") || reqRel.equalsIgnoreCase("11gR1"))) {
            TaskPinNodes taskPN = new TaskPinNodes(nodeList);
            taskList.add(taskPN);
            if (nativeSystem.isUnixSystem()) {
                TaskCoreFileNameConsistency taskCore = new TaskCoreFileNameConsistency(nodeList);
                taskList.add(taskCore);
                TaskNTP taskNTP = new TaskNTP(nodeList);
                taskList.add(taskNTP);
            }
        } else {
            TaskCTSSIntegrity taskCTSS = new TaskCTSSIntegrity(nodeList);
            taskList.add(taskCTSS);
        }
        TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
        taskTZ.setTaskType(1);
        taskList.add(taskTZ);
        return taskList;
    }

    private List<Task> getTaskListPreDBConfig(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        String orclHome = null;
        ParamPreReqDBConfig pdc = null;
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqDBConfig)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7603", false));
            }
            pdc = (ParamPreReqDBConfig)this.m_param;
            orclHome = pdc.getOrclHome();
        }
        ArrayList<Task> taskList = new ArrayList<Task>();
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        String niList = VerificationUtil.getVariableValue("INTERCONNECT_LIST");
        String[] interconnectLst = null;
        String[] interFaceLst = null;
        if (niList != null) {
            Trace.out((int)5, (String)("INTERCONNECT_LIST: '" + niList + "'"));
            interconnectLst = VerificationUtil.string2strArr(niList);
            interFaceLst = new String[interconnectLst.length];
            for (int i = 0; i < interconnectLst.length; ++i) {
                int start = interconnectLst[i].indexOf(34) + 1;
                int end = interconnectLst[i].indexOf(34, start);
                interFaceLst[i] = interconnectLst[i].substring(start, end);
            }
            Trace.out((int)5, (String)("NodeCon Interfaces: '" + VerificationUtil.strArr2String(interFaceLst)));
            taskNodeCon.setInterfaceList(interFaceLst);
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_DB_CONFIG);
        taskList.addAll(sysReqTaskList);
        TaskCRSIntegrity taskCRSI = new TaskCRSIntegrity(nodeList);
        taskList.add(taskCRSI);
        TaskNodeAppCreation taskNAC = new TaskNodeAppCreation(nodeList);
        taskList.add(taskNAC);
        TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
        taskTZ.setTaskType(1);
        taskList.add(taskTZ);
        return taskList;
    }

    private List<Task> getTaskListPreSIDBConfig(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        String orclHome = null;
        ParamPreReqDBConfig pdc = null;
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqDBConfig)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7603", false));
            }
            pdc = (ParamPreReqDBConfig)this.m_param;
            orclHome = pdc.getOrclHome();
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_DB_CONFIG);
        ArrayList<Task> taskList = new ArrayList<Task>(sysReqTaskList);
        try {
            if (new ClusterwareInfo().isHAConfigured()) {
                TaskHAIntegrity taskHAI = new TaskHAIntegrity(nodeList);
                taskList.add(taskHAI);
                TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(nodeList);
                taskOLRI.setHomeType("HA");
                taskList.add(taskOLRI);
            }
        }
        catch (InstallException e) {
            throw new TaskFactoryException(e);
        }
        return taskList;
    }

    private List<Task> getTaskListPreSIHAInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_HA_INST);
        ArrayList<Task> taskList = new ArrayList<Task>(sysReqTaskList);
        return taskList;
    }

    private List<Task> getTaskListPreSIDBInst(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_DB_INST);
        ArrayList<Task> taskList = new ArrayList<Task>(sysReqTaskList);
        try {
            if (new ClusterwareInfo().isHAConfigured()) {
                TaskHAIntegrity taskHAI = new TaskHAIntegrity(nodeList);
                taskList.add(taskHAI);
                TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(nodeList);
                taskOLRI.setHomeType("HA");
                taskList.add(taskOLRI);
            }
        }
        catch (InstallException e) {
            throw new TaskFactoryException(e);
        }
        return taskList;
    }

    private List<Task> getTaskListPreHAConfig(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqHAConfig param = null;
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqHAConfig)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7604", false));
            }
            param = (ParamPreReqHAConfig)this.m_param;
        }
        List<Task> sysReqTaskList = this.getTaskListSysReq(nodeList, VerificationType.PREREQ_SI_HA_CONFIG);
        taskList.addAll(sysReqTaskList);
        return taskList;
    }

    private List<Task> getTaskListPostCRSInst(String[] nodeList) throws TaskFactoryException {
        String crsUser;
        ArrayList<Task> taskList = new ArrayList<Task>();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        TaskClusterMgrIntegrity taskCluMgrIntg = new TaskClusterMgrIntegrity(nodeList);
        TaskClusterIntegrity taskCluIntg = new TaskClusterIntegrity(nodeList);
        TaskOCRIntegrity taskOCRIntg = new TaskOCRIntegrity(nodeList);
        TaskCRSIntegrity taskCRSIntg = new TaskCRSIntegrity(nodeList);
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(nodeList);
        TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(nodeList);
        TaskScan taskScan = new TaskScan(nodeList);
        TaskUSMUdevChecks taskOCRUdev = null;
        TaskUSMUdevChecks taskVDiskUdev = null;
        TaskCTSSIntegrity taskCTSS = new TaskCTSSIntegrity(nodeList);
        if (VerificationUtil.isUDEVSupported()) {
            taskOCRUdev = new TaskUSMUdevChecks(nodeList);
            taskOCRUdev.setOCRUDevCheck();
            taskVDiskUdev = new TaskUSMUdevChecks(nodeList);
            taskVDiskUdev.setVDiskUDevCheck();
        }
        TaskTimeZoneSetting taskTZ = new TaskTimeZoneSetting(nodeList);
        taskTZ.setTaskType(1);
        taskList.add(taskTZ);
        TaskVotingDisk taskVoteDsk = new TaskVotingDisk();
        boolean checkUSMIntg = false;
        TaskUSMIntegrity taskUSMIntg = null;
        try {
            Trace.out((int)5, (String)("CRS Home retrieved = >" + VerificationUtil.getCRSHome() + "<"));
            ClusterInfo ci = new ClusterInfo(VerificationUtil.getCRSHome());
            OCRInfo ocrInfo = ClusterInfo.getOCRLocations((Version)new Version());
            String ocrLocation = ocrInfo.getDisk();
            Trace.out((int)5, (String)("OCR Location retrieved = >" + ocrLocation + "<"));
            if (ocrLocation.contains("+")) {
                taskUSMIntg = new TaskUSMIntegrity(nodeList);
                taskUSMIntg.setOCRonASM(true);
                checkUSMIntg = true;
            }
        }
        catch (ClusterInfoException e) {
            Trace.out((int)5, (String)("Exception while attempting to instantiate ClusterInfo class" + (Object)((Object)e)));
        }
        taskList.add(taskCluMgrIntg);
        TaskUserMask taskUM = new TaskUserMask(nodeList, VerificationUtil.getDefaultUmask());
        if (nativeSystem.isUnixSystem()) {
            if (VerificationUtil.isUDEVSupported()) {
                taskList.add(taskOCRUdev);
                taskList.add(taskVDiskUdev);
            }
            if (!VerificationUtil.isCVUTestEnv()) {
                taskList.add(taskUM);
            }
        }
        taskList.add(taskCluIntg);
        taskList.add(taskOCRIntg);
        taskList.add(taskCRSIntg);
        String actCRSVer = VerificationUtil.getCRSActiveVersion();
        if (actCRSVer != null) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Active CRS Version is: " + actCRSVer));
            }
            if (!actCRSVer.startsWith("10.1")) {
                Trace.out((String)"==== Adding nodeapp & scan tasks to post crsinst stage");
                taskList.add(taskNodeApp);
                taskList.add(taskScan);
            }
        } else {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Active CRS Version is NULL");
            }
            if (!VerificationUtil.isVersionPre(actCRSVer, "11.2")) {
                taskOLRI.setHomeType("CRS");
                taskList.add(taskOLRI);
            }
        }
        if (checkUSMIntg) {
            taskList.add(taskUSMIntg);
        }
        taskList.add(taskVoteDsk);
        if (nativeSystem.isUnixSystem() && (crsUser = HeavyWeightVerificationUtil.getCRSUser()) != null) {
            TaskUserNotInGroup taskRoot = new TaskUserNotInGroup(nodeList, crsUser, "root");
            taskList.add(taskRoot);
        }
        if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
            taskList.add(taskCTSS);
        }
        return taskList;
    }

    private List<Task> getTaskListPostHAConfig(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        TaskHAIntegrity taskHAIntg = new TaskHAIntegrity(nodeList);
        TaskOLRIntegrity taskOLRIntg = new TaskOLRIntegrity(nodeList);
        taskOLRIntg.setHomeType("HA");
        taskList.add(taskHAIntg);
        taskList.add(taskOLRIntg);
        return taskList;
    }

    private List<Task> getTaskListPostHWOSSetup(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqHWOSSetup param = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (this.m_param != null) {
            if (!(this.m_param instanceof ParamPreReqHWOSSetup)) {
                throw new TaskFactoryException(s_msgBundle.getMessage("7606", false));
            }
            param = (ParamPreReqHWOSSetup)this.m_param;
        }
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        taskList.add(taskNodeCon);
        if (nativeSystem.isUnixSystem()) {
            TaskUsersWithSameID taskMultRootUID = new TaskUsersWithSameID(nodeList, "0");
            taskList.add(taskMultRootUID);
        }
        if (param != null && param.getStorageIDlist() != null) {
            TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(nodeList);
            taskSSAccess.setStorageIDlist(param.getStorageIDlist());
            taskList.add(taskSSAccess);
        }
        return taskList;
    }

    private List<Task> getTaskListPreCFSSetup(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqCFSSetup param = null;
        if (this.m_param == null) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7516", false));
        }
        if (!(this.m_param instanceof ParamPreReqCFSSetup)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7605", false));
        }
        param = (ParamPreReqCFSSetup)this.m_param;
        TaskNodeConnectivity taskNodeCon = new TaskNodeConnectivity(nodeList);
        taskNodeCon.setTaskType(0);
        taskList.add(taskNodeCon);
        if (param != null && param.getStorageIDlist() != null) {
            TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(nodeList);
            taskSSAccess.setStorageIDlist(param.getStorageIDlist());
            taskList.add(taskSSAccess);
        }
        return taskList;
    }

    private List<Task> getTaskListPostCFSSetup(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqCFSSetup param = null;
        if (this.m_param == null) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7516", false));
        }
        if (!(this.m_param instanceof ParamPreReqCFSSetup)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7605", false));
        }
        param = (ParamPreReqCFSSetup)this.m_param;
        TaskCFSIntegrity taskCFSIntg = new TaskCFSIntegrity(nodeList, param.getFileSystem());
        taskList.add(taskCFSIntg);
        return taskList;
    }

    private List<Task> getTaskListPreNodeAdd(String[] nodeList) throws TaskFactoryException, PreReqNotSupportedException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        String crsHome = VerificationUtil.getCRSHome();
        String[] newClusterNodes = null;
        Object validNodes = null;
        Object errMsg = null;
        String localNode = null;
        ParamPreReqNodeAddDel param = null;
        if (this.m_param == null || !(this.m_param instanceof ParamPreReqNodeAddDel)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        param = (ParamPreReqNodeAddDel)this.m_param;
        String[] clusterNodes = param.getValidClusterNodes();
        newClusterNodes = param.getValidNewClusterNodes();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n Parameters: " + param.toString()));
        }
        try {
            VIPAddress vipAddr;
            localNode = VerificationUtil.getLocalHost();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n Getting VIP resource for node: " + clusterNodes[0] + "\n CRSHome: " + crsHome));
            }
            VIP clusterVIP = new VIP(clusterNodes[0], crsHome);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n Getting VIPAddress resource.");
            }
            if ((vipAddr = clusterVIP.getVIPAddress()) != null) {
                String[] interfaceNames = vipAddr.getInterfaces();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\n Interface names: " + VerificationUtil.strArr2List(interfaceNames)));
                }
                TaskNodeConnectivity taskVIPConnectivity = new TaskNodeConnectivity(newClusterNodes);
                taskVIPConnectivity.setTaskType(0);
                taskVIPConnectivity.setInterfaceList(interfaceNames);
                taskList.add(taskVIPConnectivity);
            }
        }
        catch (VirtualIPException vipe) {
            Trace.out((String)("VIRTUAL_IP_EXCEPTION: \n\n======= NO VIP Interface names found! =======" + (Object)((Object)vipe)));
        }
        catch (UnknownHostException e) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + e));
            localNode = "localnode";
        }
        TaskNodeAddDelete taskNodeAdd = new TaskNodeAddDelete(nodeList);
        taskNodeAdd.setClusterNodes(clusterNodes);
        taskNodeAdd.setNewClusterNodes(newClusterNodes);
        taskNodeAdd.setLocalNode(localNode);
        taskNodeAdd.setTaskType(0);
        taskList.add(taskNodeAdd);
        TaskPeerCompatibility taskPeerCompat = new TaskPeerCompatibility();
        taskPeerCompat.setReferenceNode(localNode);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n Peer: local node: " + localNode + "\n Peer: node list: " + VerificationUtil.strArr2List(nodeList)));
        }
        taskPeerCompat.setNodeList(param.getValidNewNodesList());
        TaskNodeConnectivity taskNodeConnectivity = new TaskNodeConnectivity(param.getValidNewClusterNodes());
        taskNodeConnectivity.setTaskType(0);
        taskList.add(taskNodeConnectivity);
        List<Task> sysReqTaskList = this.getTaskListSysReq(param.getValidNewNodesList(), VerificationType.PREREQ_NODE_ADD);
        taskList.addAll(sysReqTaskList);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            TaskUserNotInGroup taskUserNotRoot = new TaskUserNotInGroup(nodeList, VerificationUtil.getDefaultCRSUser(), "root");
            taskList.add(taskUserNotRoot);
            String actCRSVer = VerificationUtil.getCRSActiveVersion();
            TaskNTP taskNTP = new TaskNTP(nodeList);
            if (VerificationUtil.isVersionPost(actCRSVer, "11.2")) {
                taskNTP.setPreCheck(true);
            }
            taskList.add(taskNTP);
        }
        return taskList;
    }

    private List<Task> getTaskListPostNodeAdd(String[] nodeList) throws TaskFactoryException {
        String actCRSVer;
        ArrayList<Task> taskList = new ArrayList<Task>();
        String crsHome = VerificationUtil.getCRSHome();
        String[] validNodes = null;
        String[] newClusterNodes = null;
        String localNode = null;
        ParamPreReqNodeAddDel param = null;
        boolean nodeInCluster = false;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (this.m_param == null || !(this.m_param instanceof ParamPreReqNodeAddDel)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        param = (ParamPreReqNodeAddDel)this.m_param;
        String[] clusterNodes = param.getValidClusterNodes();
        validNodes = param.getValidNodes();
        newClusterNodes = param.getValidNewClusterNodes();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nParameters: " + param.toString()));
        }
        ArrayList<String> clusterList = new ArrayList<String>(Arrays.asList(newClusterNodes));
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            localNode = "localnode";
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + e));
        }
        try {
            VIPAddress vipAddr;
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("\n Getting VIP resource for node: " + clusterNodes[0] + "\n CRSHome: " + crsHome));
            }
            VIP clusterVIP = new VIP(clusterNodes[0], crsHome);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n Getting VIPAddress resource.");
            }
            if ((vipAddr = clusterVIP.getVIPAddress()) != null) {
                String[] interfaceNames = vipAddr.getInterfaces();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\n Interface names: " + VerificationUtil.strArr2List(interfaceNames)));
                }
                TaskNodeConnectivity taskVIPConnectivity = new TaskNodeConnectivity(newClusterNodes);
                taskVIPConnectivity.setTaskType(0);
                taskVIPConnectivity.setInterfaceList(interfaceNames);
                taskList.add(taskVIPConnectivity);
            }
        }
        catch (VirtualIPException vipe) {
            Trace.out((String)("VIRTUAL_IP_EXCEPTION: \n======= NO VIP Interface names found! =======\n" + (Object)((Object)vipe)));
        }
        TaskClusterIntegrity taskClusterIntegrity = new TaskClusterIntegrity(newClusterNodes);
        taskList.add(taskClusterIntegrity);
        TaskNodeAddDelete taskNodeAdd = new TaskNodeAddDelete(validNodes);
        taskNodeAdd.setClusterNodes(clusterNodes);
        taskNodeAdd.setNewClusterNodes(newClusterNodes);
        taskNodeAdd.setLocalNode(localNode);
        taskNodeAdd.setTaskType(0);
        taskList.add(taskNodeAdd);
        TaskPeerCompatibility taskPeerCompat = new TaskPeerCompatibility();
        taskPeerCompat.setReferenceNode(localNode);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n Peer: local node: " + localNode + "\n Peer: node list: " + VerificationUtil.strArr2List(newClusterNodes)));
        }
        taskPeerCompat.setNodeList(param.getValidNewNodesList());
        TaskNodeConnectivity taskNodeConnectivity = new TaskNodeConnectivity(newClusterNodes);
        taskNodeConnectivity.setTaskType(0);
        taskList.add(taskNodeConnectivity);
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(newClusterNodes);
        TaskScan taskScan = new TaskScan(nodeList);
        taskList.add(taskNodeApp);
        taskList.add(taskScan);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            TaskUserNotInGroup taskUserNotRoot = new TaskUserNotInGroup(nodeList, VerificationUtil.getDefaultCRSUser(), "root");
            taskList.add(taskUserNotRoot);
        }
        if (VerificationUtil.isVersionPost(actCRSVer = VerificationUtil.getCRSActiveVersion(), "11.2")) {
            TaskCTSSIntegrity taskCTSS = new TaskCTSSIntegrity(nodeList);
            taskList.add(taskCTSS);
        }
        return taskList;
    }

    private List<Task> getTaskListPostNodeDel(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        String[] clusterNodes = null;
        ParamPreReqNodeAddDel param = null;
        if (this.m_param == null || !(this.m_param instanceof ParamPreReqNodeAddDel)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7609", false));
        }
        param = (ParamPreReqNodeAddDel)this.m_param;
        clusterNodes = param.getValidClusterNodes();
        TaskNodeAddDelete taskNodeDel = new TaskNodeAddDelete(nodeList);
        taskNodeDel.setClusterNodes(clusterNodes);
        taskNodeDel.setTaskType(1);
        taskList.add(taskNodeDel);
        return taskList;
    }

    private List<Task> getTaskListPreUSMConfig(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        ParamPreReqUSMConfig pusmc = null;
        if (!(this.m_param instanceof ParamPreReqUSMConfig)) {
            throw new TaskFactoryException(s_msgBundle.getMessage("7607", false));
        }
        pusmc = (ParamPreReqUSMConfig)this.m_param;
        TaskCRSIntegrity taskCRSIntg = new TaskCRSIntegrity(nodeList);
        TaskASMDeviceChecks taskASMDevChecks = new TaskASMDeviceChecks(nodeList);
        String[] devarr = pusmc.getASMDeviceArr();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Device string from ParamPreReqUSMConfig = " + devarr));
        }
        taskASMDevChecks.setDeviceString(devarr);
        TaskUSMDriverChecks taskUSMDriverChecks = new TaskUSMDriverChecks(nodeList);
        Trace.out((int)5, (String)"Adding USM driver checks to task list");
        taskList.add(taskCRSIntg);
        taskList.add(taskASMDevChecks);
        taskList.add(taskUSMDriverChecks);
        return taskList;
    }

    private List<Task> getTaskListPostUSMConfig(String[] nodeList) throws TaskFactoryException {
        ArrayList<Task> taskList = new ArrayList<Task>();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        TaskUSMIntegrity taskUSMIntegrity = new TaskUSMIntegrity(nodeList);
        taskList.add(taskUSMIntegrity);
        if (VerificationUtil.isUDEVSupported()) {
            TaskUSMUdevChecks taskUSMDevCheck = new TaskUSMUdevChecks(nodeList);
            taskList.add(taskUSMDevCheck);
        }
        return taskList;
    }

    private List<Task> getTaskListSysReq(String[] nodeList, VerificationType verType) throws TaskFactoryException, PreReqNotSupportedException {
        Task[] taskArr;
        String release = null;
        String osDBAGroup = null;
        String oraInvGroup = null;
        String oracleHome = null;
        String asmAdminGroup = null;
        boolean asmCheck = false;
        String crsHome = null;
        String haHome = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        try {
            if (this.m_param != null) {
                if (this.m_param instanceof ParamPreReqDBInst) {
                    release = ((ParamPreReqDBInst)this.m_param).getRelease();
                    osDBAGroup = ((ParamPreReqDBInst)this.m_param).getOSDBAgroup();
                    oraInvGroup = ((ParamPreReqDBInst)this.m_param).getOraInv();
                    oracleHome = ((ParamPreReqDBInst)this.m_param).getOrclHome();
                    crsHome = ((ParamPreReqDBInst)this.m_param).getCRSHome();
                    haHome = ((ParamPreReqDBInst)this.m_param).getHAHome();
                } else if (this.m_param instanceof ParamPreReqCRSInst) {
                    release = ((ParamPreReqCRSInst)this.m_param).getRelease();
                    osDBAGroup = ((ParamPreReqCRSInst)this.m_param).getOSDBAgroup();
                    oraInvGroup = ((ParamPreReqCRSInst)this.m_param).getORAINVgroup();
                    asmAdminGroup = ((ParamPreReqCRSInst)this.m_param).getASMADMINgroup();
                    asmCheck = ((ParamPreReqCRSInst)this.m_param).getASMCheck();
                    crsHome = ((ParamPreReqCRSInst)this.m_param).getCRSHome();
                } else if (this.m_param instanceof ParamPreReqDBConfig) {
                    release = ((ParamPreReqDBConfig)this.m_param).getRelease();
                    oracleHome = ((ParamPreReqDBConfig)this.m_param).getOrclHome();
                    crsHome = ((ParamPreReqDBConfig)this.m_param).getCRSHome();
                    haHome = ((ParamPreReqDBConfig)this.m_param).getHAHome();
                    oraInvGroup = ((ParamPreReqDBConfig)this.m_param).getOraInv();
                    osDBAGroup = ((ParamPreReqDBConfig)this.m_param).getOSDBAgroup();
                } else if (this.m_param instanceof ParamPreReqHAConfig) {
                    osDBAGroup = ((ParamPreReqHAConfig)this.m_param).getOSDBA();
                    oraInvGroup = ((ParamPreReqHAConfig)this.m_param).getOraInv();
                }
            }
            if (osDBAGroup != null) {
                VerificationUtil.setVariableValue("DBA_GROUP", osDBAGroup);
            }
            if (oraInvGroup != null) {
                VerificationUtil.setVariableValue("INSTALL_GROUP", oraInvGroup);
            }
            if (oracleHome != null) {
                VerificationUtil.setVariableValue("ORACLE_HOME", oracleHome);
                VerificationUtil.setVariableValue("RAC_HOME", oracleHome);
            }
            if (crsHome != null) {
                VerificationUtil.setVariableValue("CRS_HOME", crsHome);
            }
            if (haHome != null) {
                VerificationUtil.setVariableValue("HA_HOME", haHome);
            }
            if (asmCheck && asmAdminGroup != null) {
                VerificationUtil.setVariableValue("ASM_GROUP", asmAdminGroup);
            }
            String xmlFile = release != null ? VerificationUtil.getPreReqXmlPath(verType, release) : VerificationUtil.getPreReqXmlPath(verType);
            XmlTaskFactory xtf = XmlTaskFactory.getInstance();
            taskArr = xtf.getTasks(xmlFile, VerificationUtil.getUniqueDistributionID(), nodeList);
        }
        catch (XmlFilePathException xfpe) {
            throw new TaskFactoryException(xfpe);
        }
        catch (XmlParserException xpe) {
            throw new TaskFactoryException(xpe);
        }
        for (Task task : taskArr) {
            task.setNodeList(nodeList);
            if (!task.hasSubtasks()) continue;
            try {
                for (VerificationTask subTask : task.getSubtasks()) {
                    ((Task)subTask).setNodeList(nodeList);
                }
            }
            catch (SubtasksUnavailableException sue) {
                throw new TaskFactoryException(sue);
            }
        }
        ArrayList<Task> taskList = new ArrayList<Task>(Arrays.asList(taskArr));
        if (nativeSystem.isUnixSystem()) {
            TaskUsersWithSameID taskMultRootUID = new TaskUsersWithSameID(nodeList, "0");
            taskList.add(taskMultRootUID);
            if (verType.equals((Object)VerificationType.PREREQ_CRS_INST) || verType.equals((Object)VerificationType.PREREQ_DB_INST) || verType.equals((Object)VerificationType.PREREQ_DB_CONFIG) || verType.equals((Object)VerificationType.PREREQ_SI_HA_INST) || verType.equals((Object)VerificationType.PREREQ_SI_HA_CONFIG)) {
                TaskCurrentGroupID taskCurGrpID = new TaskCurrentGroupID();
                taskCurGrpID.setNodeList(nodeList);
                taskList.add(taskCurGrpID);
            }
        }
        return taskList;
    }
}

