/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFreeSpace
extends TaskContainerFreeSpace {
    Vector<String> m_locations;
    String m_nodeFreeSpc;
    String m_mountPoint;
    Vector<StorageSize> m_reqdLocSize;
    StorageSize m_reqdMntSize;
    StorageSize m_availMntSize;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1056", false);

    public TaskFreeSpace(Vector<String> locations, String node, String mountPoint, Vector<StorageSize> reqdSize, StorageSize mntSize, StorageSize availSize) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.m_locations = locations;
        this.m_nodeFreeSpc = node;
        this.m_mountPoint = mountPoint;
        this.m_reqdLocSize = reqdSize;
        this.m_reqdMntSize = mntSize;
        this.m_availMntSize = availSize;
        if (Trace.isLevelEnabled((int)1)) {
            String[] sizes = new String[this.m_reqdLocSize.size()];
            for (int i = 0; i < this.m_reqdLocSize.size(); ++i) {
                StorageSize size = this.m_reqdLocSize.elementAt(i);
                sizes[i] = ReportUtil.unitizeSize(size, 1);
            }
            Trace.out((String)("\n\n    Location: " + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations) + "\n    Node: " + this.m_nodeFreeSpc + "\n    Mount Point: " + this.m_mountPoint + "\n    Size(s): " + VerificationUtil.strArr2List(sizes) + "\n    Total Size: " + ReportUtil.unitizeSize(this.m_reqdMntSize, 1) + "\n    Avail Size: " + ReportUtil.unitizeSize(this.m_availMntSize, 1) + "\n\n"));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    @Override
    public String[] getNodeList() {
        String[] nodeList = new String[]{this.m_nodeFreeSpc};
        return nodeList;
    }

    @Override
    public boolean performTask() {
        String comment;
        ErrorDescription errDesc;
        String loc;
        int i;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (this.hasRunBefore()) {
            this.refreshAvailableSize(this.m_locations.elementAt(0));
        }
        if (Trace.isLevelEnabled((int)5)) {
            String[] sizes = new String[this.m_reqdLocSize.size()];
            for (int j = 0; j < this.m_reqdLocSize.size(); ++j) {
                StorageSize size = this.m_reqdLocSize.elementAt(j);
                sizes[j] = ReportUtil.unitizeSize(size, 1);
            }
            Trace.out((String)("\n\n Performing Task for: \n    Location: " + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations) + "\n    Node: " + this.m_nodeFreeSpc + "\n    Mount Point: " + this.m_mountPoint + "\n    Size(s): " + VerificationUtil.strArr2List(sizes) + "\n    Total Size: " + ReportUtil.unitizeSize(this.m_reqdMntSize, 1) + "\n    Avail Size: " + ReportUtil.unitizeSize(this.m_availMntSize, 1) + "\n\n"));
        }
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
        ReportUtil.writeColHeaders(ReportUtil.PATH, ReportUtil.NODENAME, ReportUtil.MNTPNT, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        if (this.m_mountPoint.contentEquals("UNKNOWN")) {
            for (i = 0; i < this.m_locations.size(); ++i) {
                loc = this.m_locations.elementAt(i);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("4001", true, (Object[])new String[]{loc}), s_msgBundle, "4001");
                this.m_resultSet.addResult(this.m_nodeFreeSpc, 2);
                this.m_resultSet.addErrorDescription(errDesc);
            }
            comment = ReportUtil.FAILED;
        } else {
            if (this.m_availMntSize.compareTo(this.m_reqdMntSize) >= 0) {
                this.m_resultSet.addResult(this.m_nodeFreeSpc, 1);
                comment = ReportUtil.PASSED;
            } else {
                this.m_resultSet.addResult(this.m_nodeFreeSpc, 3);
                for (i = 0; i < this.m_locations.size(); ++i) {
                    loc = this.m_locations.elementAt(i);
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7501", true, (Object[])new String[]{loc, this.m_nodeFreeSpc, ReportUtil.unitizeSize(this.m_reqdMntSize, 1)}), s_msgBundle, "7501");
                    this.m_resultSet.addErrorDescription(errDesc);
                }
                comment = ReportUtil.FAILED;
            }
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setHasResultValues(true);
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setExpectedValue(ReportUtil.unitizeSize(this.m_reqdMntSize, 1));
            this.m_resultSet.getResult(this.m_nodeFreeSpc).setActualValue(ReportUtil.unitizeSize(this.m_availMntSize, 1));
        }
        for (i = 0; i < this.m_locations.size(); ++i) {
            loc = this.m_locations.elementAt(i);
            ReportUtil.writeRecord(loc, this.m_nodeFreeSpc, this.m_mountPoint, ReportUtil.unitizeSize(this.m_availMntSize, 1), ReportUtil.unitizeSize(this.m_reqdMntSize, 1), comment);
            if (!Trace.isLevelEnabled((int)5)) continue;
            Trace.out((String)("\n\n    Node:      " + this.m_nodeFreeSpc + "\n    Location:  " + loc + "\n    Available: " + ReportUtil.unitizeSize(this.m_availMntSize, 1) + "\n    Required:  " + ReportUtil.unitizeSize(this.m_reqdMntSize, 1) + "\n\n"));
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"Exit");
            }
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations)}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return false;
    }

    private void refreshAvailableSize(String loc) {
        NativeSystem nativeSystem;
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace(this);
        String cmd = sTask.getCommand(loc);
        ResultSet rsltSet = new ResultSet();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\n\n    Executing command: " + cmd + "\n    on node:      " + this.m_nodeFreeSpc));
        }
        if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            globalExec.runGenericCmd(new String[]{this.m_nodeFreeSpc}, cmd, rsltSet);
        } else {
            globalExec.getSpaceCmd(new String[]{this.m_nodeFreeSpc}, loc, rsltSet);
        }
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        Result result = (Result)t.get(this.m_nodeFreeSpc);
        if (result == null || result.getStatus() == 2) {
            this.m_availMntSize = new StorageSize(0.0, StorageUnit.BYTE);
            this.m_mountPoint = "UNKNOWN";
        } else {
            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
            String sizeTxt = sTask.getData(cmdOut, 4);
            this.m_availMntSize = new StorageSize(new Double(sizeTxt), StorageUnit.MBYTE);
        }
        if (ParamManager.isRuncluvfy()) {
            this.bootStrapSizeAdjustment();
        }
    }

    private void bootStrapSizeAdjustment() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry bootStrapSizeAdjustment()..");
        }
        Trace.out((String)"In bootStrapSizeAdjustment..");
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
            if (localNode.equals(this.m_nodeFreeSpc)) {
                this.m_localNode = VerificationUtil.getLocalHost();
                String bootStrapPath = VerificationUtil.getCVHome();
                String mntPnt = this.getMntPnt(bootStrapPath);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\nMount Point " + mntPnt + "\n" + "Location   " + bootStrapPath));
                }
                if (this.m_mountPoint.equals(mntPnt)) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("    Before adding bootstrap size \n    Mount Point: " + this.m_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(this.m_availMntSize, 1)));
                    }
                    this.addBootStrapSpace(bootStrapPath);
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("    After adding bootstrap size \n    Mount Point: " + this.m_mountPoint + "    Avail size : " + ReportUtil.unitizeSize(this.m_availMntSize, 1)));
                    }
                }
            }
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)uhe.getMessage());
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)" Exit ");
        }
    }

    public boolean addBootStrapSpace(String bsLoc) {
        VerificationCommand cmdOP;
        Result result;
        Trace.out((String)"Inside addBootStrapSpace().....");
        ResultSet rsltSet = new ResultSet();
        String[] arg = new String[]{"-getdirsize", bsLoc};
        String[] env = null;
        VerificationCommand[] cmd = new VerificationCommand[]{new VerificationCommand(this.m_localNode, arg, env)};
        boolean cmdResult = new GlobalHandler().submit((Command[])cmd, 0, rsltSet);
        if (cmdResult && (result = (Result)rsltSet.getResultTable().get(this.m_localNode)).getStatus() == 1 && (cmdOP = cmd[0]).getVfyCode() == 0) {
            String cmdOut = cmdOP.getOutput();
            if (cmdOut == null) {
                return false;
            }
            String[] op = (cmdOut = cmdOut.trim()).split("\n");
            if (op.length > 0) {
                cmdOut = op[0];
            }
            StorageSize sizeAvail = new StorageSize(new Double(cmdOut), StorageUnit.BYTE);
            this.m_availMntSize.add(sizeAvail);
            return true;
        }
        return false;
    }

    private String getDisplayLocations(String node, Vector<String> location) {
        StringBuffer strBuf = new StringBuffer("");
        if (location != null) {
            boolean first = true;
            for (int i = 0; i < location.size(); ++i) {
                if (location.elementAt(i) == null) continue;
                if (first) {
                    first = false;
                } else {
                    strBuf.append(",");
                }
                strBuf.append(node + ":" + location.elementAt(i));
            }
        }
        return strBuf.toString();
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4408", false) + ": " + this.getDisplayLocations(this.m_nodeFreeSpc, this.m_locations);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4458", false);
    }
}

