/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.QueryTypes;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGNSIntegrity
extends Task {
    String m_localName = null;

    public TaskGNSIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskGNSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskGNSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public boolean performTask() {
        Trace.out((String)"Performing GNS Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5202", false));
        this.performGNSIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5203", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5204", false));
        return false;
    }

    void performGNSIntegrityChecks() {
        boolean isGNSRunningOnNode = false;
        ArrayList<String> gnsRunningNodes = new ArrayList<String>();
        String fullyQualifiedDomainName = null;
        GNSFactory gnsFactory = null;
        try {
            if (this.m_localName == null) {
                this.m_localName = VerificationUtil.getLocalHost();
            }
        }
        catch (UnknownHostException uhe) {
            this.m_localName = "localnode";
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: while getting local node" + uhe));
        }
        ReportUtil.println(s_msgBundle.getMessage("5206", false));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        try {
            String msg;
            Trace.out((String)"getting GNS factory");
            gnsFactory = GNSFactory.getInstance();
            GNS gns = gnsFactory.getGNS();
            for (String nodeName : this.m_nodeList) {
                Trace.out((String)("converting" + nodeName + "to Node"));
                Node node = this.getNode(nodeName);
                boolean isEnabled = gns.isEnabled(node);
                boolean nodeRunningState = gns.isRunning(node);
                if (!isGNSRunningOnNode) {
                    if (nodeRunningState) {
                        Trace.out((String)("first node with running GNS :" + nodeName));
                        gnsRunningNodes.add(nodeName);
                        isGNSRunningOnNode = true;
                        QueryTypes queryTypes = QueryTypes.SUBDOMAIN;
                        fullyQualifiedDomainName = gns.query(queryTypes);
                        Trace.out((String)("obtained FQDN=" + fullyQualifiedDomainName));
                    }
                } else if (nodeRunningState) {
                    Trace.out((String)("more than one node running GNS. Current:" + nodeName + "first:" + (String)gnsRunningNodes.get(0)));
                    gnsRunningNodes.add(nodeName);
                }
                ReportUtil.writeRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
            }
            if (gnsRunningNodes.size() > 1) {
                Trace.out((String)"gns running on more than one node");
                this.m_resultSet.addResult(this.m_nodeList, 3);
                msg = s_msgBundle.getMessage("5210", true, (Object[])new String[]{VerificationUtil.strList2List(gnsRunningNodes)});
                ErrorDescription errDesc = new ErrorDescription(msg);
                ReportUtil.sureprintln(msg);
                this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
                return;
            }
            if (gnsRunningNodes.size() == 0) {
                Trace.out((String)"No GNS on any nodes");
                this.m_resultSet.addResult(this.m_localName, 3);
                msg = s_msgBundle.getMessage("5211", true);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
                ReportUtil.sureprintln(msg);
                return;
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5212", false));
        }
        catch (NodeException e) {
            this.displayGNSFailureMessage((Exception)((Object)e));
            return;
        }
        catch (VIPNotFoundException e) {
            this.displayGNSFailureMessage((Exception)((Object)e));
            return;
        }
        catch (ServerException e) {
            this.displayGNSFailureMessage((Exception)((Object)e));
            return;
        }
        catch (GNSException e) {
            this.displayGNSFailureMessage((Exception)((Object)e));
            return;
        }
        catch (SoftwareModuleException e) {
            this.displayGNSFailureMessage((Exception)((Object)e));
            return;
        }
        catch (NotExistsException e) {
            this.displayGNSFailureMessage((Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            Trace.out((String)("exception : " + e + "  " + e.getMessage()));
            e.printStackTrace();
            this.m_resultSet.addResult(this.m_localName, 3);
            String msg = s_msgBundle.getMessage("5213", true);
            ErrorDescription errorDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errorDesc);
            ReportUtil.sureprintln(msg);
            return;
        }
        ReportUtil.println(s_msgBundle.getMessage("5208", false));
        boolean isGNSVIPRunningOnSameNode = false;
        ArrayList<String> gnsVIPRunningNodes = new ArrayList<String>();
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("5207", false));
        Trace.out((String)"starting GNS-VIP resource check");
        try {
            GNSVIP gnsVIP = gnsFactory.getVIP();
            for (String nodeName : this.m_nodeList) {
                Node node = this.getNode(nodeName);
                boolean isEnabled = gnsVIP.isEnabled(node);
                boolean nodeRunningState = gnsVIP.isRunning(node);
                if (!isGNSVIPRunningOnSameNode) {
                    if (nodeRunningState) {
                        Trace.out((String)("first node with running GNSVIP :" + nodeName));
                        gnsVIPRunningNodes.add(nodeName);
                        if (((String)gnsRunningNodes.get(0)).equalsIgnoreCase(nodeName)) {
                            isGNSVIPRunningOnSameNode = true;
                        }
                    }
                } else if (nodeRunningState) {
                    Trace.out((String)("more than one node running GNS-VIP. Current:" + nodeName + "first:" + (String)gnsVIPRunningNodes.get(0)));
                    gnsVIPRunningNodes.add(nodeName);
                    isGNSVIPRunningOnSameNode = false;
                }
                ReportUtil.writeRecord(nodeName, nodeRunningState ? ReportUtil.YES : ReportUtil.NO, isEnabled ? ReportUtil.YES : ReportUtil.NO);
            }
        }
        catch (VIPNotFoundException e) {
            this.displayGNSVIPFailureMessage((Exception)((Object)e));
            return;
        }
        catch (ServerException e) {
            this.displayGNSVIPFailureMessage((Exception)((Object)e));
            return;
        }
        catch (SoftwareModuleException e) {
            this.displayGNSVIPFailureMessage((Exception)((Object)e));
            return;
        }
        catch (NodeException e) {
            this.displayGNSVIPFailureMessage((Exception)((Object)e));
            return;
        }
        if (!isGNSVIPRunningOnSameNode) {
            String msg;
            if (gnsVIPRunningNodes.size() > 0) {
                Trace.out((String)"GNS and GNS-VIP are on different machines");
                this.m_resultSet.addResult((String)gnsVIPRunningNodes.get(0), 3);
                msg = s_msgBundle.getMessage("5219", true, (Object[])new String[]{VerificationUtil.strList2List(gnsVIPRunningNodes), VerificationUtil.strList2List(gnsRunningNodes)});
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.getResult((String)gnsVIPRunningNodes.get(0)).addErrorDescription(errDesc);
                return;
            }
            Trace.out((String)"No GNSVIP on any nodes");
            this.m_resultSet.addResult(this.m_localName, 3);
            msg = s_msgBundle.getMessage("5220", true);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.getResult(this.m_localName).addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return;
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5209", false));
        String fullyQualifiedMachineName = this.m_nodeList[0] + "." + fullyQualifiedDomainName;
        ReportUtil.println(s_msgBundle.getMessage("5214", false, (Object[])new String[]{fullyQualifiedMachineName}));
        Trace.out((String)("FQMN = " + fullyQualifiedMachineName));
        InetAddress[] allIPs = null;
        try {
            allIPs = InetAddress.getAllByName(fullyQualifiedMachineName);
        }
        catch (UnknownHostException e) {
            Trace.out((String)"UKE while trying to get IP's for FDQN");
            String msg = LSEP + s_msgBundle.getMessage("5217", true, (Object[])new String[]{fullyQualifiedMachineName});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(msg);
            return;
        }
        Trace.out((String)("FQMN has " + allIPs.length + "IP's"));
        if (allIPs.length == 0) {
            String msg = LSEP + s_msgBundle.getMessage("5218", true, (Object[])new String[]{fullyQualifiedMachineName});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 3);
            ReportUtil.sureprintln(msg);
            return;
        }
        String[] allIPStringArray = new String[allIPs.length];
        for (int i = 0; i < allIPs.length; ++i) {
            allIPStringArray[i] = allIPs[i].getHostAddress();
        }
        boolean[] nodeConArray = new boolean[allIPs.length];
        VerifyNetwork vfyNet = new VerifyNetwork();
        boolean reach = false;
        try {
            reach = vfyNet.checkReachFromLocalNode(allIPStringArray, nodeConArray);
        }
        catch (NetworkException e) {
            String msg = LSEP + s_msgBundle.getMessage("5216", true, (Object[])new String[]{fullyQualifiedMachineName, VerificationUtil.strArr2String(allIPStringArray)});
        }
        if (reach) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5215", false));
        } else {
            ArrayList<String> unReachableIPs = new ArrayList<String>();
            for (int i = 0; i < allIPs.length; ++i) {
                if (nodeConArray[i]) continue;
                unReachableIPs.add(allIPStringArray[i]);
            }
            String msg = LSEP + s_msgBundle.getMessage("5216", true, (Object[])new String[]{fullyQualifiedMachineName, VerificationUtil.strList2List(unReachableIPs)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(msg);
        }
    }

    private void displayGNSFailureMessage(Exception e) {
        Trace.out((String)("Node exception : " + e.getMessage()));
        this.m_resultSet.addResult(this.m_localName, 3);
        String msg = s_msgBundle.getMessage("5213", true) + LSEP + e.getMessage();
        ErrorDescription errDesc = new ErrorDescription(msg);
        this.m_resultSet.addErrorDescription(errDesc);
        ReportUtil.sureprintln(msg);
    }

    private void displayGNSVIPFailureMessage(Exception e) {
        Trace.out((String)("Node exception : " + e.getMessage()));
        this.m_resultSet.addResult(this.m_localName, 3);
        String msg = s_msgBundle.getMessage("5205", true) + LSEP + e.getMessage();
        ErrorDescription errDesc = new ErrorDescription(msg);
        this.m_resultSet.addErrorDescription(errDesc);
        ReportUtil.sureprintln(msg);
    }

    private Node getNode(String node) throws ServerException, NodeException {
        ServerFactory sf = ServerFactory.getInstance();
        return sf.getNode(node);
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4445", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5200", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

