/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGroupExistence
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1052", false);
    private String m_group;

    public TaskGroupExistence(String group) {
        this.m_group = group;
    }

    public boolean performTask() {
        ErrorDescription errDesc;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet grpRsltSet = new ResultSet();
        globalExec.checkGroup(this.m_nodeList, this.m_group, grpRsltSet);
        this.m_resultSet.uploadResultSet(grpRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable<Object, Vector<Object>> grpIdTable = new Hashtable<Object, Vector<Object>>();
        Hashtable ht = grpRsltSet.getResultTable();
        Enumeration<Object> e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String grpStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                grpStatus = ReportUtil.EXIST;
                comment = ReportUtil.PASSED;
                String grpID = (String)result.getResultInfoSet().elementAt(1);
                VerificationUtil.updateResultMap(grpIdTable, grpID, node);
            } else if (result.getStatus() == 3) {
                grpStatus = ReportUtil.NOTEXIST;
                comment = ReportUtil.FAILED;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7539", true, (Object[])new String[]{this.m_group, node}), s_msgBundle, "7539");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            } else {
                grpStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7540", true, (Object[])new String[]{node}), s_msgBundle, "7540");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, grpStatus, comment);
        }
        if (grpIdTable.size() > 1) {
            String errorMsg = s_msgBundle.getMessage("4020", true, (Object[])new String[]{this.m_group});
            ReportUtil.printError(errorMsg);
            errDesc = new ErrorDescription(errorMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            e = grpIdTable.keys();
            StringBuffer grpIdsDisplayString = new StringBuffer();
            boolean first = true;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Vector<Object> nodeVector = grpIdTable.get(key);
                String nodes = VerificationUtil.strVect2List(nodeVector);
                if (first) {
                    first = false;
                    grpIdsDisplayString.append("[");
                } else {
                    grpIdsDisplayString.append("; ");
                }
                grpIdsDisplayString.append(key + ":" + nodes);
                String errorMessage = s_msgBundle.getMessage("4021", false, (Object[])new String[]{key, nodes});
                ReportUtil.sureprintln(errorMessage);
            }
            grpIdsDisplayString.append("]");
            ErrorDescription grpIdsED = new ErrorDescription(errorMsg + " " + grpIdsDisplayString.toString(), s_msgBundle, "4020");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, grpIdsED);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
            return true;
        }
        this.reportFixupGenErrors();
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_group}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4409", false) + ": " + this.m_group;
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4459", false, (Object[])new String[]{this.m_group});
    }

    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet grpRsltSet = new ResultSet();
        globalExec.checkGroup(this.m_nodeList, this.m_group, grpRsltSet);
        Hashtable ht = grpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                String grpID = (String)result.getResultInfoSet().elementAt(1);
                result.getResultInfoSet().add(0, this.m_group + "(" + grpID + ")");
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NOTEXIST);
            result.setStatus(1);
        }
        return grpRsltSet;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9972", false, (Object[])new String[]{this.m_group});
    }
}

