/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.sTaskGroupMembership;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.fixup.UserAndGroupFixes;

public class TaskGroupMembership
extends PeerCompatibleTask {
    private String m_user;
    private String m_group;
    private boolean m_primary;
    private sTaskGroupMembership s_sTaskGroupMembership;

    public TaskGroupMembership(String user, String group) {
        this(user, group, false);
    }

    public TaskGroupMembership(String user, String group, boolean primary) {
        this.m_user = user;
        this.m_group = group;
        this.m_primary = primary;
        this.s_sTaskGroupMembership = new sTaskGroupMembership();
    }

    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        boolean testFailed = false;
        globalExec.checkUsrInGrp(this.m_nodeList, this.m_user, this.m_group, this.m_primary ? 1 : 3, usrGrpRsltSet);
        this.m_resultSet.uploadResultSet(usrGrpRsltSet);
        if (!this.m_primary) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4302", false, (Object[])new String[]{this.m_user, this.m_group}));
        } else {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("4022", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
        }
        if (this.m_primary) {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8013", false), s_msgBundle.getMessage("8014", false), s_msgBundle.getMessage("8015", false), s_msgBundle.getMessage("8016", false), s_msgBundle.getMessage("8001", false));
        } else {
            ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8013", false), s_msgBundle.getMessage("8014", false), s_msgBundle.getMessage("8015", false), s_msgBundle.getMessage("8001", false));
        }
        Hashtable ht = usrGrpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String primeG;
            String uInG;
            String grp;
            String usr;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                usr = ReportUtil.YES;
                grp = ReportUtil.YES;
                uInG = ReportUtil.YES;
                primeG = ReportUtil.YES;
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                boolean primaryGrp;
                boolean usrExists = ((String)result.getResultInfoSet().get(0)).equals(this.m_user);
                boolean usrInGrp = ((String)result.getResultInfoSet().get(1)).equals(this.m_group);
                boolean bl = primaryGrp = ((String)result.getResultInfoSet().get(2)).length() != 0;
                if (!usrExists) {
                    usr = ReportUtil.NO;
                    grp = ReportUtil.NOT_APPLICABLE;
                    uInG = ReportUtil.NOT_APPLICABLE;
                    primeG = ReportUtil.NOT_APPLICABLE;
                    comment = ReportUtil.FAILED;
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7537", true, (Object[])new String[]{this.m_user, node}), s_msgBundle, "7537");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                } else if (!usrInGrp) {
                    usr = ReportUtil.YES;
                    grp = ReportUtil.YES;
                    uInG = ReportUtil.NO;
                    primeG = ReportUtil.NOT_APPLICABLE;
                    comment = ReportUtil.FAILED;
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7566", false, (Object[])new String[]{this.m_user, this.m_group, node}), s_msgBundle, "7566");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    if (this.isFixupReqd()) {
                        this.fixupGroupMembership(node);
                    }
                } else {
                    usr = ReportUtil.YES;
                    grp = ReportUtil.YES;
                    uInG = ReportUtil.YES;
                    comment = ReportUtil.PASSED;
                    primeG = ReportUtil.YES;
                    if (this.m_primary && !primaryGrp) {
                        primeG = ReportUtil.NO;
                        comment = ReportUtil.FAILED;
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7567", false, (Object[])new String[]{this.m_group, this.m_user, node}), s_msgBundle, "7567");
                        this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                        if (this.isFixupReqd()) {
                            this.fixupGroupMembership(node);
                        }
                    } else {
                        this.m_resultSet.addResult(node, 1);
                    }
                }
            } else {
                usr = ReportUtil.UNKNOWN;
                grp = ReportUtil.UNKNOWN;
                uInG = ReportUtil.NOT_APPLICABLE;
                primeG = ReportUtil.NOT_APPLICABLE;
                comment = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7568", false, (Object[])new String[]{this.m_user, this.m_group, node}), s_msgBundle, "7568");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            if (this.m_primary) {
                ReportUtil.writeRecord(node, usr, grp, uInG, primeG, comment);
            } else {
                ReportUtil.writeRecord(node, usr, grp, uInG, comment);
            }
            if (comment.equalsIgnoreCase(ReportUtil.PASSED)) continue;
            testFailed = true;
        }
        if (testFailed) {
            this.reportFixupGenErrors();
            if (!this.m_primary) {
                ReportUtil.printResult(s_msgBundle.getMessage("4304", false, (Object[])new String[]{this.m_user, this.m_group}));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("4024", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
            }
            ReportUtil.printErrorNodes(this.m_resultSet);
            return false;
        }
        if (!this.m_primary) {
            ReportUtil.printResult(s_msgBundle.getMessage("4303", false, (Object[])new String[]{this.m_user, this.m_group}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4023", false, (Object[])new String[]{this.m_user, this.m_group, s_msgBundle.getMessage("8500", false)}));
        }
        if (this.m_primary && !VerificationUtil.getCurrentGroup().equalsIgnoreCase(this.m_group)) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4309", false, (Object[])new String[]{VerificationUtil.getCurrentGroup(), this.m_group, this.m_user}));
        }
        return true;
    }

    private void fixupGroupMembership(String node) {
        StringBuilder elementName = new StringBuilder();
        ArrayList<String> fileList = this.getFixupFiles(node, this.m_resultSet);
        if (fileList != null) {
            OipcfFixUpResult fixupRslt;
            OipcrIResult oResult = OipcrResult.FAILED_RESULT;
            String sExpectedValue = "user=" + this.m_user + ",group=" + this.m_group;
            NonLocalEntity nonLocal = this.isUserAndGroupLocal(node);
            if (nonLocal != NonLocalEntity.NONE) {
                Trace.out((String)"user or group not local. Fixup cannot be generated");
                String errMsg = nonLocal == NonLocalEntity.USER ? s_msgBundle.getMessage("7729", true, (Object[])new String[]{this.m_user, this.m_group, node}) : s_msgBundle.getMessage("7730", true, (Object[])new String[]{this.m_user, this.m_group, node});
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                this.addFixupGenError(node, errMsg);
                return;
            }
            OipcrResultDetails oResData = new OipcrResultDetails(null, (Object)sExpectedValue, oResult);
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            oResDetails.add(oResData);
            oResult = new OipcrResult(oResDetails);
            if (!this.m_primary) {
                Trace.out((String)("generating fixup to add user " + this.m_user + " to group " + this.m_group));
                fixupRslt = UserAndGroupFixes.addUserToGroups(null, (String)node, (OipcrIResult)oResult, fileList);
            } else {
                Trace.out((String)("generating fixup to add user " + this.m_user + " to group " + this.m_group));
                fixupRslt = UserAndGroupFixes.changePrimaryGroupForUsers(null, (String)node, (OipcrIResult)oResult, fileList);
            }
            if (fixupRslt.getFixUpResult() != OipcfFixUpResult.PASSED) {
                Trace.out((String)"Fixup generation failed");
                String errMsg = s_msgBundle.getMessage("7726", false, (Object[])new String[]{this.m_user, this.m_group, node});
                OiixException oiEx = fixupRslt.getFixUpException();
                if (oiEx != null) {
                    errMsg = errMsg + LSEP + oiEx.getErrorMessage();
                }
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)errMsg);
                }
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg, s_msgBundle, "7726"));
                this.addFixupGenError(node, errMsg);
            } else {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Fixup was successfully generated for setting membership of user '" + this.m_user + "' with group '" + this.m_group + "' on node '" + node + "'"));
                }
                this.m_resultSet.getResult(node).setFixupAvailable(true);
            }
        }
    }

    private NonLocalEntity isUserAndGroupLocal(String node) {
        NonLocalEntity noLo = NonLocalEntity.USER;
        do {
            ResultSet isLocalRsltSet = new ResultSet();
            VerificationCommand[] vfyCmd = new VerificationCommand[1];
            String checkCommand = noLo == NonLocalEntity.USER ? this.s_sTaskGroupMembership.getLocalCheckCommand("user", this.m_user) : this.s_sTaskGroupMembership.getLocalCheckCommand("group", this.m_group);
            if (checkCommand == null) {
                Trace.out((String)"command is empty");
                return noLo;
            }
            String[] arg = new String[]{"-rungencmd", checkCommand};
            String[] env = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            vfyCmd[0] = new VerificationCommand(node, arg, env);
            Trace.out((String)("executing " + checkCommand));
            new GlobalHandler().submit((Command[])vfyCmd, 0, isLocalRsltSet);
            if (vfyCmd[0].getResult().getStatus() != 1) {
                Trace.out((String)("existance check failed on " + node + " with " + vfyCmd[0].getResult().getStatus()));
                return noLo;
            }
            if (vfyCmd[0].getVfyCode() != 0) {
                Trace.out((String)"User/group not found");
                return noLo;
            }
            switch (noLo) {
                case USER: {
                    noLo = NonLocalEntity.GROUP;
                    break;
                }
                default: {
                    noLo = NonLocalEntity.NONE;
                }
            }
        } while (noLo != NonLocalEntity.NONE);
        return noLo;
    }

    public String getDefaultElementName() {
        StringBuilder elementName = new StringBuilder();
        elementName.append(s_msgBundle.getMessage("4410", false) + ": " + this.m_group);
        if (this.m_primary) {
            elementName.append("(" + s_msgBundle.getMessage("8500", false) + ")");
        }
        return elementName.toString();
    }

    public String getDefaultDescription() {
        if (this.m_primary) {
            return s_msgBundle.getMessage("4461", false, (Object[])new String[]{this.m_user, this.m_group});
        }
        return s_msgBundle.getMessage("4460", false, (Object[])new String[]{this.m_user, this.m_group});
    }

    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet usrGrpRsltSet = new ResultSet();
        boolean testFailed = false;
        globalExec.checkUsrInGrp(this.m_nodeList, this.m_user, this.m_group, this.m_primary ? 1 : 3, usrGrpRsltSet);
        Hashtable ht = usrGrpRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                result.getResultInfoSet().add(0, ReportUtil.YES);
                continue;
            }
            if (result.getStatus() != 3) continue;
            result.getResultInfoSet().add(0, ReportUtil.NO);
            result.setStatus(1);
        }
        return usrGrpRsltSet;
    }

    public String getElementDisplayName() {
        String group = this.m_group;
        if (this.m_primary) {
            group = group + " (" + s_msgBundle.getMessage("8500", false) + ")";
        }
        return s_msgBundle.getMessage("9973", false, (Object[])new String[]{this.m_user, group});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NonLocalEntity {
        USER,
        GROUP,
        NONE;

    }
}

