/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskHAIntegrity
extends Task {
    public TaskHAIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskHAIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskHAIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public boolean performTask() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Performing HA Integrity verification task... ");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4115", false));
        this.performHAIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4116", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4117", false));
        return false;
    }

    void performHAIntegrityChecks() {
        ResultSet haCheckResultSet = new ResultSet();
        Hashtable haCheckOutput = new Hashtable();
        GlobalExecution globalExec = new GlobalExecution();
        ErrorDescription errDesc = null;
        String exeHome = VerificationUtil.getHAHome();
        if (exeHome == null) {
            errDesc = new ErrorDescription("4112", s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)"HA HOME not found.");
            }
            return;
        }
        String cmdSpec = exeHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "crsctl check has";
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Command Syntax: " + cmdSpec));
        }
        haCheckOutput = globalExec.runExeWithOutput(this.m_nodeList, cmdSpec, haCheckResultSet);
        String output = (String)haCheckOutput.get(this.m_nodeList[0]);
        String errText = VerificationUtil.fetchVerificationValue(output);
        String exitStat = VerificationUtil.fetchVerificationResult(output);
        errDesc = new ErrorDescription("4118", s_msgBundle);
        if (exitStat != null && !exitStat.contentEquals("0")) {
            haCheckResultSet.addResult(this.m_nodeList[0], 2);
        } else if (output.contains("CRS-4638")) {
            haCheckResultSet.addResult(this.m_nodeList[0], 1);
        } else {
            haCheckResultSet.addResult(this.m_nodeList[0], 3);
        }
        if (exitStat != null && !exitStat.contentEquals("0") && errText != null && errText.length() != 0) {
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + errText);
            haCheckResultSet.addErrorDescription(errDesc);
            ReportUtil.printError(errDesc.getErrorMessage());
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\nNode: " + this.m_nodeList[0] + "\nOutput: " + output + "\nerrText: '" + errText + "' " + "\nexitStat: '" + exitStat + "'"));
        }
        this.m_resultSet.uploadResultSet(haCheckResultSet);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4437", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4488", false);
    }
}

