/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class TaskHostsFile
extends Task {
    private String[] m_nodeList = null;

    public TaskHostsFile(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet hostsFileRsltSet = new ResultSet();
        boolean hostsFilechk = true;
        globalExec.checkHostsFile(this.m_nodeList, hostsFileRsltSet);
        this.m_resultSet.uploadResultSet(hostsFileRsltSet);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4188", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable hostsTable = new Hashtable();
        Hashtable ht = hostsFileRsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String status;
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                comment = new String("");
                status = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                comment = s_msgBundle.getMessage("4191", false);
                status = ReportUtil.FAILED;
                errDesc = new ErrorDescription("4190", s_msgBundle);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                hostsFilechk = false;
            } else {
                comment = ReportUtil.UNKNOWN;
                status = ReportUtil.FAILED;
                errDesc = new ErrorDescription("4192", s_msgBundle);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                hostsFilechk = false;
            }
            ReportUtil.writeRecord(node, status, comment);
        }
        if (hostsFilechk) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4189", false));
        } else {
            ReportUtil.printError(s_msgBundle.getMessage("4190", true));
        }
        return hostsFilechk;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1069", false);
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4560", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4561", false);
    }
}

