/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Step;
import oracle.ops.verification.framework.engine.task.sTaskKernelParam;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.InvalidStepException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.fixup.KernelFixes;

public class TaskKernelParam
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1060", false);
    private String m_paramName;
    private String m_expectedValue;
    private RangeOfValue m_exepctedRange;
    private List<Step> m_expectedStepList = new ArrayList<Step>();
    private String m_refElemName;
    private Hashtable m_htPhysicalMemoryResult;
    private boolean m_physicalMemoryFetched = false;

    public TaskKernelParam(String name, String val) {
        this.m_paramName = name;
        this.m_expectedValue = val;
    }

    public TaskKernelParam(String name, RangeOfValue range) {
        this.m_paramName = name;
        this.m_exepctedRange = range;
    }

    public TaskKernelParam(String name) {
        this.m_paramName = name;
    }

    public void addStep(RangeOfValue range, StorageUnit unit, float multiplier) throws InvalidStepException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Inside addStep: range = " + range + ", unit = " + (Object)((Object)unit) + ", mulitplier = " + multiplier));
        }
        this.m_expectedStepList.add(new Step(range, unit, multiplier));
    }

    public boolean performTask() {
        this.performVerification();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_paramName}));
            return true;
        }
        this.reportFixupGenErrors();
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_paramName}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void performVerification() {
        ResultSet knlparamRsltSet = new ResultSet();
        sTaskKernelParam sTask = new sTaskKernelParam(this);
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getKerParam(this.m_nodeList, this.m_paramName, knlparamRsltSet);
        this.m_resultSet.uploadResultSet(knlparamRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_paramName}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.CONFIGURED, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = knlparamRsltSet.getResultTable();
        Enumeration e = t.keys();
        String reqdValueInString = null;
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            reqdValueInString = this.getExpectedValue(node);
            if (reqdValueInString == null) continue;
            Result result = (Result)t.get(node);
            boolean verified = false;
            if (result.getStatus() == 1) {
                ArrayList<String> fileList;
                String comment;
                RangeOfValue rov;
                Object avl = result.getResultInfoSet().elementAt(0);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("AVL = " + avl));
                }
                if (avl == null || avl.toString().trim().length() == 0) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("FAILED:: No value returned for param: " + this.m_paramName + " on node:" + node));
                    }
                    ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, reqdValueInString, ReportUtil.FAILED);
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7544", true, (Object[])new String[]{this.m_paramName, node}), s_msgBundle, "7544");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 2);
                    continue;
                }
                String fullParamName = sTask.getName((avl = sTask.getData(avl.toString(), this.m_paramName)).toString(), this.m_paramName);
                if (fullParamName != null) {
                    this.m_paramName = fullParamName;
                }
                if (avl instanceof RangeOfValue) {
                    if (this.m_exepctedRange == null) {
                        try {
                            rov = new RangeOfValue(RangeType.INTEGER);
                            rov.include(RangeOperator.EQ, reqdValueInString);
                            verified = ((RangeOfValue)avl).contains(rov);
                        }
                        catch (InvalidRangeManipulationException e1) {
                            verified = false;
                        }
                    } else {
                        try {
                            verified = ((RangeOfValue)avl).equals(this.m_exepctedRange);
                        }
                        catch (InvalidRangeManipulationException e1) {
                            verified = false;
                        }
                    }
                } else if (this.m_exepctedRange == null) {
                    verified = Double.parseDouble(avl.toString()) >= Double.parseDouble(reqdValueInString);
                } else {
                    try {
                        rov = new RangeOfValue(RangeType.INTEGER);
                        rov.include(RangeOperator.GE, avl);
                        verified = rov.contains(this.m_exepctedRange);
                    }
                    catch (InvalidRangeManipulationException e1) {
                        verified = false;
                    }
                }
                if (verified) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available value for kernel parameter '" + this.m_paramName + "' =" + avl));
                    }
                    ReportUtil.writeRecord(node, avl.toString(), reqdValueInString, ReportUtil.PASSED);
                    this.m_resultSet.getResult(node).setHasResultValues(true);
                    this.m_resultSet.getResult(node).setExpectedValue(reqdValueInString);
                    this.m_resultSet.getResult(node).setActualValue(avl.toString());
                    continue;
                }
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Result.VERIFICATION_FAILED:: available value for kernel parameter '" + this.m_paramName + "' =" + avl));
                }
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7543", true, (Object[])new String[]{this.m_paramName, node, reqdValueInString, avl.toString()}), s_msgBundle, "7543");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(reqdValueInString);
                this.m_resultSet.getResult(node).setActualValue(avl.toString());
                if (m_isCLImode && this.m_paramName.contains("ip_local_port_range") && SeverityType.IGNORABLE.equals((Object)this.m_taskSeverity)) {
                    this.m_resultSet.addResult(node, 4);
                    comment = ReportUtil.FAILED_IGNORABLE;
                } else {
                    this.m_resultSet.addResult(node, 3);
                    comment = ReportUtil.FAILED;
                }
                ReportUtil.writeRecord(node, avl.toString(), reqdValueInString, comment);
                if (!this.isFixupReqd() || (fileList = this.getFixupFiles(node, this.m_resultSet)) == null) continue;
                OipcrIResult oResult = OipcrResult.FAILED_RESULT;
                String param_name = this.m_paramName.equals("aio-max-nr") ? "aio_max_nr" : this.m_paramName;
                String sExpectedValue = this.m_exepctedRange == null ? param_name + "=" + reqdValueInString : param_name + "=" + this.m_exepctedRange.getBoundedRangeString();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("sExpectedValue = '" + sExpectedValue + "'"));
                }
                String sActualValue = avl instanceof RangeOfValue ? param_name + "=" + ((RangeOfValue)avl).getBoundedRangeString() : param_name + "=" + avl.toString();
                Trace.out((int)1, (String)("sActualValue = '" + sActualValue + "'"));
                OipcrResultDetails oResData = new OipcrResultDetails((Object)sActualValue, (Object)sExpectedValue, oResult);
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                oResDetails.add(oResData);
                oResult = new OipcrResult(oResDetails);
                OipcfFixUpResult fixupRslt = KernelFixes.enableKernelFixes(null, (String)node, (OipcrIResult)oResult, fileList);
                if (fixupRslt.getFixUpResult() != OipcfFixUpResult.PASSED) {
                    String errMsg = s_msgBundle.getMessage("7722", true, (Object[])new String[]{this.m_paramName, node});
                    OiixException oiEx = fixupRslt.getFixUpException();
                    if (oiEx != null) {
                        errMsg = errMsg + LSEP + oiEx.getErrorMessage();
                    }
                    Trace.out((int)1, (String)errMsg);
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg, s_msgBundle, "7722"));
                    this.addFixupGenError(node, errMsg);
                    continue;
                }
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Fixup was successfully generated for setting kernel parameter '" + this.m_paramName + "' on node '" + node + "'"));
                }
                this.m_resultSet.getResult(node).setFixupAvailable(true);
                continue;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus()));
            }
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, reqdValueInString, ReportUtil.FAILED);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7544", true, (Object[])new String[]{this.m_paramName, node}), s_msgBundle, "7544");
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
        }
    }

    private String getExpectedValue(String node) {
        if (this.m_expectedStepList.size() == 0) {
            return this.m_exepctedRange == null ? this.m_expectedValue : this.m_exepctedRange.toString();
        }
        if (!this.m_physicalMemoryFetched) {
            this.m_physicalMemoryFetched = true;
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet memRsltSet = new ResultSet();
            globalExec.checkMemory(this.m_nodeList, 0L, memRsltSet);
            this.m_resultSet.uploadResultSet(memRsltSet);
            this.m_htPhysicalMemoryResult = memRsltSet.getResultTable();
        }
        Result resultMem = (Result)this.m_htPhysicalMemoryResult.get(node);
        Trace.out((String)("resultMem.getStatus() ::" + resultMem.getStatus()));
        if (resultMem.getStatus() == 1) {
            StorageSize avlMemBytes = (StorageSize)resultMem.getResultInfoSet().firstElement();
            StorageSize reqdSizeSS = null;
            boolean stepFound = false;
            StorageUnit unit = StorageUnit.BYTE;
            for (Step step : this.m_expectedStepList) {
                unit = step.getUnit();
                try {
                    if (!step.getRange().contains(avlMemBytes)) {
                        continue;
                    }
                }
                catch (InvalidRangeManipulationException irme) {
                    if (!Trace.isTraceEnabled()) break;
                    Trace.out((Exception)irme);
                    break;
                }
                stepFound = true;
                Trace.out((String)(" stepFound " + stepFound));
                reqdSizeSS = new StorageSize(avlMemBytes.sizeIn(unit) * (double)step.getMultiplier(), unit);
                if (!Trace.isTraceEnabled()) break;
                Trace.out((String)("multiplier=" + step.getMultiplier() + " avl memory=" + avlMemBytes + " reqd value = " + reqdSizeSS));
                break;
            }
            if (!stepFound) {
                this.m_resultSet.setStatus(2);
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("9807", false, (Object[])new String[]{this.m_paramName, node}));
                this.m_resultSet.addErrorDescription(errDesc);
                return null;
            }
            return Double.toString(reqdSizeSS.sizeIn(StorageUnit.BYTE));
        }
        if (resultMem.getStatus() != 1) {
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7531", false, (Object[])new String[]{node}));
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
        }
        this.m_resultSet.addResult(node, 3);
        return null;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4411", false) + ": " + this.m_paramName;
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4462", false, (Object[])new String[]{this.m_paramName});
    }

    public ResultSet performPeer() throws VerificationException {
        ResultSet knlparamRsltSet = new ResultSet();
        sTaskKernelParam sTask = new sTaskKernelParam(this);
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getKerParam(this.m_nodeList, this.m_paramName, knlparamRsltSet);
        Hashtable t = knlparamRsltSet.getResultTable();
        Enumeration e = t.keys();
        Object reqdValueInString = null;
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            boolean verified = false;
            if (result.getStatus() != 1) continue;
            Object avl = result.getResultInfoSet().elementAt(0);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("AVL = " + avl));
            }
            if (avl == null || avl.toString().trim().length() == 0) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("FAILED:: No value returned for param: " + this.m_paramName + " on node:" + node));
                }
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7544", true, (Object[])new String[]{this.m_paramName, node}), s_msgBundle, "7544");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 2);
                avl = ReportUtil.UNKNOWN;
            } else {
                avl = sTask.getData(avl.toString(), this.m_paramName);
            }
            if (avl instanceof RangeOfValue) {
                result.getResultInfoSet().add(0, ((RangeOfValue)avl).getBoundedRangeString());
                continue;
            }
            result.getResultInfoSet().add(0, avl);
        }
        return knlparamRsltSet;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9974", false, (Object[])new String[]{this.m_paramName});
    }
}

