/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskKernelVersion
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1062", false);
    private String m_version;

    public TaskKernelVersion(String version) {
        this.m_version = version;
    }

    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet knlverRsltSet = new ResultSet();
        globalExec.checkKernelVersion(this.m_nodeList, this.m_version, knlverRsltSet);
        this.m_resultSet.uploadResultSet(knlverRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = knlverRsltSet.getResultTable();
        Enumeration e = t.keys();
        Hashtable<Object, Vector<Object>> version = new Hashtable<Object, Vector<Object>>();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String avl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avl = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.OPERATION_SUCCESSFUL:: available kernel version=" + avl));
                ReportUtil.writeRecord(node, avl, this.m_version, ReportUtil.PASSED);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(this.m_version);
                this.m_resultSet.getResult(node).setActualValue(avl);
                VerificationUtil.updateResultMap(version, avl, node);
                continue;
            }
            if (result.getStatus() == 3) {
                avl = (String)result.getResultInfoSet().firstElement();
                Trace.out((String)("Result.VERIFICATION_FAILED:: available kernel version=" + avl));
                ReportUtil.writeRecord(node, avl, this.m_version, ReportUtil.FAILED);
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7541", false, (Object[])new String[]{node, this.m_version, avl}));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(this.m_version);
                this.m_resultSet.getResult(node).setActualValue(avl);
                continue;
            }
            Trace.out((String)("FAILED:: result.getStatus()=" + result.getStatus()));
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.m_version, ReportUtil.FAILED);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7542", false, (Object[])new String[]{node}), s_msgBundle, "7542");
            this.m_resultSet.getResult(node).addErrorDescription(errDesc);
        }
        if (version.size() > 1) {
            ReportUtil.printWarning(s_msgBundle.getMessage("7524", true));
            int ovrAllStatus = this.m_resultSet.getStatus();
            Enumeration keys1 = version.keys();
            while (keys1.hasMoreElements()) {
                String key = (String)keys1.nextElement();
                String nodeAryStr = VerificationUtil.strVect2List((Vector)version.get(key));
                ReportUtil.sureprintln(s_msgBundle.getMessage("7525", false, (Object[])new String[]{key, nodeAryStr}));
                this.m_resultSet.addResult((Vector)version.get(key), 4);
            }
            this.m_resultSet.setStatus(ovrAllStatus);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4412", false);
    }

    public String getDefaultDescription() {
        Object[] msgParams = new String[]{this.m_version};
        return s_msgBundle.getMessage("4463", false, msgParams);
    }

    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet knlverRsltSet = new ResultSet();
        globalExec.checkKernelVersion(this.m_nodeList, "", knlverRsltSet);
        return knlverRsltSet;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1062", false);
    }
}

