/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskDaemonLiveliness;
import oracle.ops.verification.framework.engine.task.TimeServer;
import oracle.ops.verification.framework.engine.task.TimeServerNode;
import oracle.ops.verification.framework.engine.task.sTaskNTP;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNTP
extends Task {
    boolean m_mute = false;
    boolean m_preCheck = false;
    sTaskNTP s_sTaskNTP = new sTaskNTP();

    public TaskNTP(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNTP(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNTP(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9601", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9501", false);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing network time synchronization verification");
        }
        this.performNTPChecks();
        if (this.m_resultSet.allSuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"ResultSet shows alll Success");
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            if (!this.m_mute) {
                ReportUtil.printResult(s_msgBundle.getMessage("5400", false));
            }
            if (!this.m_mute) {
                ReportUtil.sureblankln();
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"ResultSet shows at least one failure");
        }
        if (!this.m_mute) {
            ReportUtil.printResult(s_msgBundle.getMessage("5401", false));
        }
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        return false;
    }

    public void performNTPChecks() {
        Vector<String> confokVec = new Vector<String>();
        ResultSet locrs = new ResultSet();
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5422", false));
        }
        boolean ret = this.doConfigFileCheck(locrs, this.m_nodeList, confokVec);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Return value from doConfigFileCheck() is " + ret));
        }
        if (!ret) {
            if (this.m_preCheck) {
                if (!this.m_mute) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5428", false));
                }
                Trace.out((String)"PreCheck flag set. Setting overall status to SUCCESSFUL");
                this.m_resultSet.addResult(this.m_nodeList, 1);
            } else {
                if (!this.m_mute) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5414", true));
                }
                this.m_resultSet.uploadResultSet(locrs);
            }
            return;
        }
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Proceeding with Daemon check...");
        }
        ret = this.doDaemonCheck(locrs, this.m_nodeList);
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5415", true));
            }
            return;
        }
        ret = this.doSlewingCheck(locrs, confokVec);
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5436", true, (Object[])new String[]{this.s_sTaskNTP.getNTPDSlewingOption()}));
            }
            return;
        }
        ret = this.doSlewingSysConfigCheck(locrs, confokVec);
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5470", true, (Object[])new String[]{this.s_sTaskNTP.getNTPDBootConfigFile(), this.s_sTaskNTP.getNTPDSlewingOption()}));
            }
            return;
        }
        if (!this.s_sTaskNTP.isNTPQSupported()) {
            return;
        }
        Hashtable<String, TimeServer> tsTable = new Hashtable<String, TimeServer>();
        ret = this.doTimeServerCheck(locrs, tsTable, confokVec);
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        if (!ret) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5416", true));
            }
            return;
        }
        ret = this.doOffsetCheck(tsTable, confokVec);
    }

    private boolean doConfigFileCheck(ResultSet locrs, String[] nList, Vector<String> confokVec) {
        boolean ctssalternate;
        Vector<String> noConfMsgVec = new Vector<String>();
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5420", false));
        }
        String fileLoc = this.s_sTaskNTP.getNTPConfigFile();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Checking availability of NTP config file " + fileLoc + " on all nodes."));
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean ret = false;
        globalExec.checkFileExistence(nList, fileLoc, locrs);
        confokVec.clear();
        Hashtable cfresultHT = locrs.getResultTable();
        Enumeration e = cfresultHT.keys();
        Vector<String> noConfVec = new Vector<String>();
        Vector<String> notRunVec = new Vector<String>();
        while (e.hasMoreElements()) {
            ErrorDescription errorDesc;
            Result result;
            String curNode = (String)e.nextElement();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("==== Analyzing NTP config file chk result for node " + curNode));
            }
            if ((result = (Result)cfresultHT.get(curNode)) != null && 3 == result.getStatus()) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("==== configuration file is missing for " + curNode));
                }
                noConfVec.add(curNode);
                String errmsg = s_msgBundle.getMessage("5402", true, (Object[])new String[]{fileLoc, curNode});
                errorDesc = new ErrorDescription(errmsg);
                locrs.addErrorDescription(curNode, errorDesc);
                noConfMsgVec.add(errmsg);
                continue;
            }
            if (result == null || 1 != result.getStatus()) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("==== NTP config file chk did not run on " + curNode));
                }
                notRunVec.add(curNode);
                String errormsg = s_msgBundle.getMessage("5403", true, (Object[])new String[]{fileLoc, curNode});
                errorDesc = new ErrorDescription(errormsg);
                locrs.addErrorDescription(curNode, errorDesc);
                noConfMsgVec.add(errormsg);
                continue;
            }
            if (result == null || 1 != result.getStatus()) continue;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("==== NTP config file chk did run correctly on " + curNode));
            }
            confokVec.add(curNode);
            ret = true;
        }
        boolean bl = ctssalternate = confokVec.isEmpty() && this.m_preCheck;
        if (confokVec.isEmpty()) {
            ret = false;
        }
        if (!(confokVec.isEmpty() && this.m_preCheck || this.m_mute)) {
            for (int j = 0; j < noConfMsgVec.size(); ++j) {
                ReportUtil.printError((String)noConfMsgVec.get(j));
            }
        }
        if (notRunVec.isEmpty() && noConfVec.isEmpty()) {
            if (!this.m_mute) {
                ReportUtil.println(s_msgBundle.getMessage("5404", false, (Object[])new String[]{fileLoc}));
            }
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5419", false));
            }
        } else {
            if (!noConfVec.isEmpty()) {
                if (!this.m_mute && !ctssalternate) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5405", true, (Object[])new String[]{fileLoc}));
                }
                if (!this.m_mute && !ctssalternate) {
                    ReportUtil.sureprintNodelist(noConfVec);
                }
            }
            if (!notRunVec.isEmpty()) {
                if (!this.m_mute && !ctssalternate) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5421", true));
                }
                if (!this.m_mute && !ctssalternate) {
                    ReportUtil.sureprintNodelist(notRunVec);
                }
            }
        }
        return ret;
    }

    private boolean doDaemonCheck(ResultSet locrs, String[] nlist) {
        String dmnName = this.s_sTaskNTP.getNTPDaemonName();
        TaskDaemonLiveliness taskDaemon = new TaskDaemonLiveliness(nlist);
        taskDaemon.setDaemonName(dmnName);
        boolean ret = taskDaemon.perform();
        locrs.uploadResultSet(taskDaemon.getResultSet());
        return ret;
    }

    private boolean doTimeServerCheck(ResultSet locrs, Hashtable<String, TimeServer> tsTable, Vector<String> confokVec) {
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5417", false));
        }
        boolean tsOK = this.getTimeServerInfo(locrs, tsTable, confokVec);
        boolean atLeastOne = false;
        if (tsOK) {
            Enumeration<String> e = tsTable.keys();
            while (e.hasMoreElements()) {
                String tsID = e.nextElement();
                TimeServer tServer = tsTable.get(tsID);
                if (tServer.getNodeTable().size() == confokVec.size()) {
                    atLeastOne = true;
                    if (this.m_mute) continue;
                    ReportUtil.println(s_msgBundle.getMessage("5407", false, (Object[])new String[]{tsID}));
                    continue;
                }
                String[] tsNodeList = tServer.getNodeList();
                String nodeString = VerificationUtil.strArr2String(tsNodeList);
                if (this.m_mute) continue;
                ReportUtil.sureprintln(s_msgBundle.getMessage("5408", true, (Object[])new String[]{tsID, nodeString}));
            }
            if (atLeastOne && !this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5409", false));
            }
        } else {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Error getting Time Server Info on all nodes");
            }
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5410", true));
            }
        }
        return atLeastOne;
    }

    private boolean getTimeServerInfo(ResultSet locrs, Hashtable<String, TimeServer> tsTable, Vector<String> confokVec) {
        VerificationCommand[] driverCmdArray = new VerificationCommand[confokVec.size()];
        String[] okNodeList = confokVec.toArray(new String[confokVec.size()]);
        String stateCmd = this.s_sTaskNTP.getNTPQueryCommand();
        for (int j = 0; j < okNodeList.length; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd};
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            String[] env = null;
            driverCmdArray[j] = new VerificationCommand(okNodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, locrs);
        if (!locrs.anySuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Global failure executing NTP query command ");
            }
            String message = s_msgBundle.getMessage("5411", true, (Object[])new String[0]);
            ErrorDescription errorDesc = new ErrorDescription(message);
            locrs.addErrorDescription(okNodeList, errorDesc);
            if (!this.m_mute) {
                ReportUtil.printError(message);
            }
            return false;
        }
        boolean validOutput = false;
        for (int nodeIndex = 0; nodeIndex < okNodeList.length; ++nodeIndex) {
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = driverCmd.getNode();
            String output = driverCmd.getOutput();
            if (output != null) {
                String[] tsLineArray;
                result.addResultInfo(output);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Output from NTP query command on node " + node + " is =" + output));
                }
                if ((tsLineArray = this.s_sTaskNTP.parseNTPQueryOutput(output)) != null) {
                    for (String tsline : tsLineArray) {
                        String serverID = this.s_sTaskNTP.getIDFromNTPOutput(tsline);
                        if (serverID != null && serverID.length() > 0 && !serverID.contains("LOCAL")) {
                            TimeServer tserv = tsTable.get(serverID);
                            if (tserv == null) {
                                tserv = new TimeServer(serverID);
                                tsTable.put(serverID, tserv);
                            }
                            tserv.addToNodeTable(okNodeList[nodeIndex], tsline);
                            validOutput = true;
                            continue;
                        }
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)("Parsing of NTP query output line FAILED. Line=" + tsline));
                    }
                } else if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Parsing of NTP query output FAILED: Output=" + output));
                }
            }
            if (validOutput || !Trace.isLevelEnabled((int)5)) continue;
            Trace.out((String)("NTP query on node " + okNodeList[nodeIndex] + " did NOT produce valid output."));
        }
        return validOutput;
    }

    private boolean doOffsetCheck(Hashtable<String, TimeServer> tsTable, Vector<String> okNodeVec) {
        boolean chkok = false;
        boolean nodesOK = false;
        Enumeration<String> e = tsTable.keys();
        float offsetLimit = this.s_sTaskNTP.getNTPOffsetLimit();
        if (!this.m_mute) {
            ReportUtil.sureblankln();
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5418", false));
        }
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("5426", false, (Object[])new String[]{okNodeVec.toString()}));
        }
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("5446", false));
        }
        while (e.hasMoreElements()) {
            nodesOK = false;
            String srvrID = e.nextElement();
            TimeServer nextTS = tsTable.get(srvrID);
            boolean hdrPrinted = false;
            Hashtable<String, TimeServerNode> nodeHT = nextTS.getNodeTable();
            if (nodeHT.size() == okNodeVec.size()) {
                Enumeration<String> en = nodeHT.keys();
                while (en.hasMoreElements()) {
                    String node;
                    TimeServerNode tsNode;
                    float nodeOffset;
                    if (!hdrPrinted) {
                        ReportUtil.blankln();
                        ReportUtil.println(s_msgBundle.getMessage("5427", false, (Object[])new String[]{srvrID, new Float(offsetLimit).toString()}));
                        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("9685", false), s_msgBundle.getMessage("8018", false));
                        hdrPrinted = true;
                    }
                    if (Math.abs(nodeOffset = (tsNode = nodeHT.get(node = en.nextElement())).getOffset()) < offsetLimit) {
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Offset " + nodeOffset + " of Time Server " + srvrID + " is within limits of threshold " + offsetLimit + " on node " + node));
                        }
                        ReportUtil.writeRecord(node, Float.toString(nodeOffset), ReportUtil.PASSED);
                        nodesOK = true;
                        continue;
                    }
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Offset " + nodeOffset + " of Time Server " + srvrID + " is NOT within limits of threshold " + offsetLimit + " on node " + node));
                    }
                    if (!this.m_mute) {
                        ReportUtil.sureprintln(s_msgBundle.getMessage("5413", true, (Object[])new String[]{node, Float.toString(nodeOffset), Float.toString(offsetLimit), srvrID}));
                    }
                    ReportUtil.writeRecord(node, Float.toString(nodeOffset), ReportUtil.FAILED);
                    nodesOK = false;
                }
                if (nodesOK) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Time Server " + srvrID + " has time offsets within limits on all nodes where NTP query succeeded."));
                    }
                    if (!this.m_mute) {
                        ReportUtil.println(s_msgBundle.getMessage("5425", false, (Object[])new String[]{srvrID, okNodeVec.toString()}));
                    }
                }
            }
            if (!nodesOK) continue;
            chkok = true;
        }
        if (chkok && okNodeVec.size() == this.m_nodeList.length) {
            if (!this.m_mute) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5423", false));
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5424", true));
        }
        this.m_resultSet.addResult(this.m_nodeList, 3);
        return false;
    }

    private boolean doSlewingCheck(ResultSet locrs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        VerificationCommand[] driverCmdArray = new VerificationCommand[okVectorSize];
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        String stateCmd = this.s_sTaskNTP.getNTPDCommandLine("commandline");
        String slewOption = this.s_sTaskNTP.getNTPDSlewingOption();
        for (int j = 0; j < okVectorSize; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd};
            String[] env = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            driverCmdArray[j] = new VerificationCommand(okNodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, locrs);
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5444", false, (Object[])new String[]{slewOption}));
        }
        if (!locrs.anySuccess()) {
            Trace.out((String)"Global failure executing NTP Slewing command ");
            String message = s_msgBundle.getMessage("5442", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            return false;
        }
        if (!this.m_mute) {
            ReportUtil.println(s_msgBundle.getMessage("5437", false));
        }
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        for (int nodeIndex = 0; nodeIndex < okVectorSize; ++nodeIndex) {
            String slewedmode = ReportUtil.UNKNOWN;
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            String node = driverCmd.getNode();
            if (result.getStatus() == 1) {
                String cmdline = driverCmd.getOutput();
                if (cmdline != null) {
                    boolean slewingPresent;
                    result.addResultInfo(cmdline);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("NTPD commandline on node " + node + " is =" + cmdline));
                    }
                    if (slewingPresent = this.s_sTaskNTP.parseNTPDCommandLine(cmdline, "commandline")) {
                        Trace.out((String)(" node:" + node + ": is slewed"));
                        this.m_resultSet.addResult(node, 1);
                        slewedmode = ReportUtil.YES;
                    } else {
                        Trace.out((String)("node:" + node + ": is not slewed"));
                        this.m_resultSet.addResult(node, 3);
                        ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5439", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5439");
                        this.m_resultSet.addErrorDescription(node, errDesc);
                        slewedmode = ReportUtil.NO;
                    }
                }
            } else {
                this.m_resultSet.addResult(node, 2);
                Trace.out((String)("NTPD commandline couldn't be obtained from node: '" + node + "'"));
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5440", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5440");
                this.m_resultSet.addErrorDescription(node, errDesc);
                slewedmode = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord(node, slewedmode);
        }
        if (this.m_resultSet.allSuccess()) {
            if (!this.m_mute) {
                ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5441", false, (Object[])new String[]{slewOption}));
            }
            return true;
        }
        if (!this.m_mute) {
            ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5443", false));
        }
        if (!this.m_mute) {
            ReportUtil.printErrorNodes(this.m_resultSet);
        }
        return false;
    }

    private boolean doSlewingSysConfigCheck(ResultSet locrs, Vector<String> confokVec) {
        int okVectorSize = confokVec.size();
        VerificationCommand[] driverCmdArray = new VerificationCommand[okVectorSize];
        String[] okNodeList = confokVec.toArray(new String[okVectorSize]);
        String bootOptionCmd = this.s_sTaskNTP.getNTPDCommandLine("startup");
        String slewOption = this.s_sTaskNTP.getNTPDSlewingOption();
        String bootConfigFile = this.s_sTaskNTP.getNTPDBootConfigFile();
        for (int j = 0; j < okVectorSize; ++j) {
            String[] arg = new String[]{"-rungencmd", bootOptionCmd};
            String[] env = null;
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Command args: " + Arrays.asList(arg)));
            }
            driverCmdArray[j] = new VerificationCommand(okNodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, locrs);
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5445", false, (Object[])new String[]{bootConfigFile, slewOption}));
        }
        if (!locrs.anySuccess()) {
            Trace.out((String)"Global failure executing NTP Boot configuration slewing command ");
            String message = s_msgBundle.getMessage("5475", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            return false;
        }
        if (!this.m_mute) {
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5471", false));
        }
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("5438", false));
        for (int nodeIndex = 0; nodeIndex < okVectorSize; ++nodeIndex) {
            String slewedmode = ReportUtil.UNKNOWN;
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            String node = driverCmd.getNode();
            if (result.getStatus() == 1) {
                String bootCmdline = driverCmd.getOutput();
                if (bootCmdline != null) {
                    boolean slewingPresent;
                    result.addResultInfo(bootCmdline);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("NTPD boot configuration on node " + node + " is =" + bootCmdline));
                    }
                    if (slewingPresent = this.s_sTaskNTP.parseNTPDCommandLine(bootCmdline, "startup")) {
                        Trace.out((String)(" node:" + node + ": is slewed"));
                        this.m_resultSet.addResult(node, 1);
                        slewedmode = ReportUtil.YES;
                    } else {
                        Trace.out((String)("node:" + node + ": is not slewed"));
                        this.m_resultSet.addResult(node, 3);
                        ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5472", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5472");
                        this.m_resultSet.addErrorDescription(node, errDesc);
                        slewedmode = ReportUtil.NO;
                    }
                }
            } else {
                this.m_resultSet.addResult(node, 2);
                Trace.out((String)("NTPD boot config couldn't be obtained from node: '" + node + "'"));
                ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5473", true, (Object[])new String[]{slewOption, node}), s_msgBundle, "5473");
                this.m_resultSet.addErrorDescription(node, errDesc);
                slewedmode = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord(node, slewedmode);
        }
        if (this.m_resultSet.allSuccess()) {
            if (!this.m_mute) {
                ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5474", false));
            }
            return true;
        }
        if (!this.m_mute) {
            ReportUtil.printResult(LSEP + s_msgBundle.getMessage("5476", false));
        }
        if (!this.m_mute) {
            ReportUtil.printErrorNodes(this.m_resultSet);
        }
        return false;
    }

    public void setPreCheck(boolean preCheck) {
        this.m_preCheck = preCheck;
    }

    public boolean getPreCheck() {
        return this.m_preCheck;
    }
}

