/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskCRSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskNodeAppCreation;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskNodeAddDelete
extends Task {
    public static final int NODEADD = 0;
    public static final int NODEDELETE = 1;
    private int m_taskType = 0;
    private String m_localNode;
    private String[] m_newClusterNodes;
    private String[] m_clusterNodes;
    private ResultSet m_stageResultSet;

    public TaskNodeAddDelete(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNodeAddDelete(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNodeAddDelete(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setTaskType(int type) {
        this.m_taskType = type;
    }

    public void setNewClusterNodes(String[] newClusterNodes) {
        this.m_newClusterNodes = newClusterNodes;
    }

    public void setClusterNodes(String[] clusterNodes) {
        this.m_clusterNodes = clusterNodes;
    }

    public void setLocalNode(String node) {
        this.m_localNode = node;
    }

    public void setStageResultSet(ResultSet stageResultSet) {
        this.m_stageResultSet = stageResultSet;
    }

    public boolean performTask() {
        TaskCRSIntegrity taskCRSIntegrity;
        boolean retval;
        ErrorDescription errDesc = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (!(retval = (taskCRSIntegrity = new TaskCRSIntegrity(this.m_clusterNodes)).performTask())) {
            this.m_resultSet.addResult(this.m_nodeList, 3);
        }
        if (Trace.isLevelEnabled((int)5)) {
            if (this.m_taskType == 0) {
                Trace.out((String)"Performing NODE ADD checks.");
            } else if (this.m_taskType == 1) {
                Trace.out((String)"Performing NODE DELETE checks.");
            } else {
                Trace.out((String)("Task Type: " + this.m_taskType));
            }
        }
        this.m_resultSet.setStatus(1);
        if (this.m_taskType == 0) {
            block28: {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4861", false));
                String crsHome = VerificationUtil.getCRSHome();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\n Checking CRSHome '" + crsHome + "' for sharedness."));
                }
                ReportUtil.println(LSEP + s_msgBundle.getMessage("4871", false));
                this.checkSharedCRSPath(crsHome, true, OracleFileType.RAC_SOFTWARE);
                Object oracleHome = null;
                Version verCRSSoft = VerificationUtil.getCRSSoftwareVersionObj();
                if (verCRSSoft == null) {
                    errDesc = new ErrorDescription("4869", s_msgBundle);
                    ReportUtil.printError(errDesc.getErrorMessage());
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    this.m_resultSet.addErrorDescription(errDesc);
                    return false;
                }
                String ocrLoc = null;
                try {
                    ClusterInfo ci = new ClusterInfo(crsHome, verCRSSoft);
                    ocrLoc = ClusterInfo.getOCRLocation((Version)verCRSSoft);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n Checking OCRLoc '" + ocrLoc + "' for sharedness."));
                    }
                    if (!VerificationUtil.isASMPath(ocrLoc)) {
                        ReportUtil.println(LSEP + s_msgBundle.getMessage("4872", false));
                        this.checkSharedPath(ocrLoc, false, OracleFileType.RAC_OCR_VDISK);
                    }
                }
                catch (ClusterInfoException ce) {
                    errDesc = new ErrorDescription(ce.getMessage());
                    this.m_resultSet.addErrorDescription(errDesc);
                    if (!Trace.isLevelEnabled((int)5)) break block28;
                    Trace.out((String)("CLUSTERINFOEXCEPTION: \n" + (Object)((Object)ce)));
                }
            }
            Vector allSets = new Vector();
            boolean status = true;
            int numNodes = this.m_clusterNodes.length;
            int minNodesReq = numNodes < 2 ? numNodes : 2;
        } else if (this.m_taskType == 1) {
            ReportUtil.println(LSEP);
            TaskNodeAppCreation taskNAC = new TaskNodeAppCreation(this.m_nodeList);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n Checking for remnants of NODEAPPS for nodes: " + VerificationUtil.strArr2List(this.m_nodeList) + " \n Expecting cluster nodes to be: " + VerificationUtil.strArr2List(this.m_clusterNodes) + "\n"));
            }
            boolean saveMode = ReportUtil.getMode();
            ReportUtil.setMode(false);
            taskNAC.setNodesWithCRS(this.m_clusterNodes);
            taskNAC.setDeletedResource(true);
            retval = taskNAC.performCommonTask(this.m_nodeList, false);
            ReportUtil.setMode(saveMode);
            ResultSet nacRS = taskNAC.getResultSet();
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"\n Finished with NODEAPP check, reporting results");
            }
            if (nacRS.anySuccess()) {
                Object errorDesc = null;
                Hashtable t = nacRS.getResultTable();
                Enumeration e = t.keys();
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)t.get(node);
                    TaskNodeAppCreation.TaskNACData nodeappData = (TaskNodeAppCreation.TaskNACData)result.getResultInfoSet().firstElement();
                    if (Trace.isLevelEnabled((int)5)) {
                        String nodeappStatus = nodeappData.getStatus() == 1 ? "ONLINE" : (nodeappData.getStatus() == 0 ? "EXIST_OFFLINE" : (nodeappData.getStatus() == 210 ? "NOTEXIST" : "UNKNOWN"));
                        Trace.out((String)("\nNodeapp: '" + nodeappData.getName() + "' Status: " + nodeappStatus));
                    }
                    if (nodeappData.getStatus() != 1 && nodeappData.getStatus() != 0) continue;
                    this.m_resultSet.setStatus(3);
                    errDesc = new ErrorDescription("4868", new String[]{nodeappData.getName(), node}, s_msgBundle);
                    this.m_resultSet.addErrorDescription(node, errDesc);
                    this.m_resultSet.addResult(node, 3);
                    ReportUtil.printError(errDesc.getErrorMessage());
                }
            } else {
                this.m_resultSet.setStatus(1);
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.println(LSEP);
            if (this.m_taskType == 0) {
                ReportUtil.printResult(s_msgBundle.getMessage("4852", false) + LSEP);
            } else {
                ReportUtil.printResult(LSEP + s_msgBundle.getMessage("4855", false));
            }
            return true;
        }
        this.m_resultSet.traceResultSet("Node Add/Delete ResultSet trace.\n");
        ReportUtil.println(LSEP);
        if (this.m_taskType == 0) {
            ReportUtil.printResult(s_msgBundle.getMessage("4853", false) + LSEP);
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4856", false) + LSEP);
        }
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void checkSharedPath(String path, boolean checkCreWri, OracleFileType fileType) {
        block23: {
            VerifyStorage checkPathSt = new VerifyStorage();
            Vector<String> succNodes = new Vector<String>();
            Vector<String> failNodes = new Vector<String>();
            String basePath = null;
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"Entry");
            }
            basePath = path.substring(0, path.lastIndexOf(FSEP));
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n Path    : " + path + "\n BasePath: " + basePath));
            }
            String errMsg = s_msgBundle.getMessage("4853", false);
            String cause = s_msgBundle.getMessage("4859", false, (Object[])new String[]{path});
            String action = s_msgBundle.getMessage("4860", false, (Object[])new String[]{path});
            try {
                if (checkPathSt.isShared(path, this.m_newClusterNodes, fileType)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n\n  Path: " + path + " shared."));
                    }
                    ReportUtil.println(s_msgBundle.getMessage("4061", false, (Object[])new String[]{path}));
                } else if (this.m_clusterNodes.length > 1 && checkPathSt.isShared(path, this.m_clusterNodes, fileType)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n\n Path: '" + path + "' shared on existing nodes but not new node."));
                    }
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg, cause, action));
                    ReportUtil.println(s_msgBundle.getMessage("4866", false, (Object[])new String[]{path}));
                } else if (checkCreWri && VerificationUtil.pathExists(this.m_nodeList, path, 0, succNodes, failNodes)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n\n Path: " + path + "\n IDENTICAL but NOT shared!"));
                    }
                    this.m_resultSet.addResult(this.m_newClusterNodes, 1);
                    ReportUtil.println(s_msgBundle.getMessage("4870", false, (Object[])new String[]{path}));
                } else if (checkCreWri && VerificationUtil.isDirPathWritable(this.m_nodeList, basePath, succNodes, failNodes)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n\n Path: '" + path + "' does not exist but can be created."));
                    }
                    this.m_resultSet.addResult(this.m_newClusterNodes, 1);
                    ReportUtil.println(s_msgBundle.getMessage("4870", false, (Object[])new String[]{path}));
                } else {
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    this.m_resultSet.addErrorDescription(failNodes.toArray(new String[failNodes.size()]), new ErrorDescription(errMsg, cause, action));
                    if (checkCreWri) {
                        ReportUtil.printError(s_msgBundle.getMessage("4864", true, (Object[])new String[]{path}) + LSEP);
                    } else {
                        ReportUtil.printError(s_msgBundle.getMessage("4866", true, (Object[])new String[]{path}) + LSEP);
                    }
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("\n Path: '" + path + "' NOT shared.\n"));
                    }
                }
            }
            catch (StorageException se) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg, cause, action));
                ReportUtil.println(s_msgBundle.getMessage("4859", false, (Object[])new String[]{path}));
                if (Trace.isLevelEnabled((int)5)) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("STORAGEEXCEPTION: \n" + se));
                    }
                    Trace.out((String)("\n\n  Path: " + path + " NOT shared."));
                }
            }
            catch (MultiNodeException mne) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg, cause, action));
                ReportUtil.println(s_msgBundle.getMessage("4859", false, (Object[])new String[]{path}));
                if (!Trace.isLevelEnabled((int)5)) break block23;
                Trace.out((String)("MULTINODEEXCEPTION: \n" + mne));
                Trace.out((String)("\n\n  Path: " + path + " NOT shared."));
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    private void checkSharedCRSPath(String path, boolean checkCreWri, OracleFileType fileType) {
        VerifyStorage checkPathSt = new VerifyStorage();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        String basePath = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        basePath = path.substring(0, path.lastIndexOf(FSEP));
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n Path    : " + path + "\n BasePath: " + basePath));
        }
        String errMsg = s_msgBundle.getMessage("4853", false);
        String cause = s_msgBundle.getMessage("4859", true, (Object[])new String[]{path});
        String action = s_msgBundle.getMessage("4860", false, (Object[])new String[]{path});
        if (checkCreWri && VerificationUtil.pathExists(this.m_nodeList, path, 0, succNodes, failNodes)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n\n Path: " + path + "\n IDENTICAL but NOT shared!"));
            }
            this.m_resultSet.addResult(this.m_newClusterNodes, 1);
            ReportUtil.println(s_msgBundle.getMessage("4870", false, (Object[])new String[]{path}));
        } else if (checkCreWri && VerificationUtil.isDirPathWritable(this.m_nodeList, basePath, succNodes, failNodes)) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n\n Path: '" + path + "' does not exist but can be created."));
            }
            this.m_resultSet.addResult(this.m_newClusterNodes, 1);
            ReportUtil.println(s_msgBundle.getMessage("4870", false, (Object[])new String[]{path}));
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 3);
            this.m_resultSet.addErrorDescription(failNodes.toArray(new String[failNodes.size()]), new ErrorDescription(errMsg, cause, action));
            if (checkCreWri) {
                ReportUtil.printError(s_msgBundle.getMessage("4864", true, (Object[])new String[]{path}) + LSEP);
            } else {
                ReportUtil.printError(s_msgBundle.getMessage("4866", true, (Object[])new String[]{path}) + LSEP);
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\n Path: '" + path + "' NOT shared.\n"));
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    private String[] getSharedPaths(Vector sharedSets, int minNodesReq) {
        Vector<String> returnPathList = new Vector<String>();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        Enumeration setEnum = sharedSets.elements();
        while (setEnum.hasMoreElements()) {
            SharedStorageSet sharedSet = (SharedStorageSet)setEnum.nextElement();
            if (sharedSet.getNumNodes() < minNodesReq) continue;
            Enumeration storageEnum = sharedSet.getSharedSet().elements();
            Hashtable<String, Vector<String>> pathTable = new Hashtable<String, Vector<String>>();
            Vector<String> pathList = new Vector<String>();
            Vector<String> nodeList = null;
            while (storageEnum.hasMoreElements()) {
                StorageInfo stInfo = (StorageInfo)storageEnum.nextElement();
                String key = stInfo.getName();
                nodeList = (Vector<String>)pathTable.get(key);
                if (null == nodeList) {
                    pathList.add(key);
                    nodeList = new Vector<String>();
                    pathTable.put(key, nodeList);
                }
                if (nodeList.contains(stInfo.getNode())) continue;
                nodeList.add(stInfo.getNode());
            }
            String path = null;
            Enumeration pathEnum = pathList.elements();
            Object line = null;
            while (pathEnum.hasMoreElements()) {
                path = (String)pathEnum.nextElement();
                if (returnPathList.contains(path)) continue;
                returnPathList.add(path);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("\n Adding path: " + path));
            }
        }
        String[] returnArrayList = new String[returnPathList.size()];
        for (int i = 0; i < returnPathList.size(); ++i) {
            returnArrayList[i] = (String)returnPathList.get(i);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\n Storage paths to be check for sharedness: \n" + VerificationUtil.strArr2List(returnArrayList)));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return returnArrayList;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4439", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4492", false);
    }
}

