/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNodeAppCreation
extends Task
implements HALiterals {
    private String[] m_arrNodesWithCRS;
    private String m_statCmd;
    private Vector m_vAgileNodes;
    private boolean m_isVersionTB = false;
    private boolean m_deletedResource = false;
    String NODEAPP_VIP = "vip";
    String NODEAPP_ONS = "ons";
    String NODEAPP_EONS = "eons";
    String NODEAPP_GSD = "gsd";
    String NODEAPP_NETWORK = "net1.network";
    public static final int RC_UNKNOWN = -1;
    public static final int RC_EXIST = 0;
    public static final int RC_ONLINE = 1;
    public static final int RC_NOTEXIST = 210;
    public static final int RC_NOCRSD = 184;
    private static final String ERRTXT_184 = "CRS-0184";
    private static final String ERRTXT_202 = "CRS-0202";
    private static final String ERRTXT_210 = "CRS-0210";
    private static final String ERRTXT_4535 = "CRS-4535";
    private static final String ERRTXT_4000 = "CRS-4000";
    private static final String ERRTXT_2613 = "CRS-2613";
    private static final String ERRTXT_4655 = "CRS-4655";
    private static final String NAMETXT = "NAME=";
    private static final String STATETXT = "STATE=";
    private static final String ONLINETXT = "ONLINE";
    private static final String RES_PREFIX = "ora.";
    private static final int MAX_CMD_LEN = 180;
    private Hashtable m_vipHash;
    private Hashtable m_netHash;
    private Hashtable m_onsHash;
    private Hashtable m_gsdHash;
    private Hashtable m_eonsHash;

    public TaskNodeAppCreation(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNodeAppCreation(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNodeAppCreation(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setNodesWithCRS(String[] nodesWithCRS) {
        this.m_arrNodesWithCRS = nodesWithCRS;
    }

    public void setDeletedResource(boolean newVal) {
        this.m_deletedResource = newVal;
    }

    public boolean performTask() {
        boolean taskRes = true;
        Trace.out((String)"Performing NodeApp Creation Verification Task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4550", false));
        ReportUtil.sureblankln();
        this.m_arrNodesWithCRS = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        if (this.m_arrNodesWithCRS == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            Trace.out((String)"==== CRS is not installed on any node.");
            return false;
        }
        Trace.out((String)("==== Nodes with CRS installed is: " + this.m_arrNodesWithCRS.length));
        return this.performCommonTask(this.m_arrNodesWithCRS, true);
    }

    public boolean performCommonTask(String[] nodeList, boolean uploadRes) {
        if (this.m_arrNodesWithCRS == null) {
            Trace.out((String)"No nodes with CRS installed identified.");
            return false;
        }
        if (!this.determineCRSVersion(nodeList)) {
            return false;
        }
        if (VerificationUtil.isLocalNodeOperation()) {
            try {
                String localHost = VerificationUtil.getLocalHost();
                this.m_vAgileNodes = new Vector(1);
                this.m_vAgileNodes.add(localHost);
            }
            catch (UnknownHostException uhe) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errorDesc = new ErrorDescription("0002", s_msgBundle);
                this.m_resultSet.addErrorDescription(errorDesc);
                Trace.out((String)"==== Could not get the local host name .");
                Trace.out((Exception)uhe);
                ReportUtil.printError(s_msgBundle.getMessage("0002", false));
                return false;
            }
        }
        try {
            String[] nodes = VerificationUtil.getUserEquivalentNodes(VerificationUtil.getStaticNodelist());
            this.m_vAgileNodes = new Vector(nodes.length);
            for (int k = 0; k < nodes.length; ++k) {
                this.m_vAgileNodes.add(nodes[k]);
            }
        }
        catch (NodelistNotFoundException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription("0001", s_msgBundle);
            this.m_resultSet.addErrorDescription(errorDesc);
            Trace.out((String)"==== Could not get the static nodelist.");
            Trace.out((Exception)e);
            ReportUtil.printError(s_msgBundle.getMessage("0001", false));
            return false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("\nAgileNode list: " + VerificationUtil.strArr2List(nodeList) + "\n"));
        }
        String crsHome = VerificationUtil.getCRSHome();
        this.m_statCmd = this.m_isVersionTB ? crsHome + FSEP + "bin" + FSEP + "crsctl stat res " : crsHome + FSEP + "bin" + FSEP + "crs_stat ";
        ResultSet vipResultSet = new ResultSet();
        this.m_vipHash = new Hashtable(nodeList.length);
        this.createHashStatus(nodeList, this.m_vipHash);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n\n*** ABOUT TO DO VIP APP CHECK ***\n\n");
        }
        this.performAppCheck("VIP", this.NODEAPP_VIP, this.m_vipHash, vipResultSet, false, nodeList);
        ResultSet onsResultSet = new ResultSet();
        this.m_onsHash = new Hashtable(nodeList.length);
        this.createHashStatus(nodeList, this.m_onsHash);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n\n*** ABOUT TO DO ONS APP CHECK ***\n\n");
        }
        this.performAppCheck("ONS", this.NODEAPP_ONS, this.m_onsHash, onsResultSet, true, nodeList);
        ResultSet gsdResultSet = new ResultSet();
        this.m_gsdHash = new Hashtable(nodeList.length);
        this.createHashStatus(nodeList, this.m_gsdHash);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"\n\n*** ABOUT TO DO GSD APP CHECK ***\n\n");
        }
        this.performAppCheck("GSD", this.NODEAPP_GSD, this.m_gsdHash, gsdResultSet, true, nodeList);
        ResultSet netResultSet = new ResultSet();
        if (this.m_isVersionTB) {
            ResultSet eonsResultSet = new ResultSet();
            this.m_eonsHash = new Hashtable(nodeList.length);
            this.createHashStatus(nodeList, this.m_eonsHash);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n\n*** ABOUT TO DO EONS APP CHECK ***\n\n");
            }
            this.performAppCheck("EONS", this.NODEAPP_EONS, this.m_eonsHash, eonsResultSet, true, nodeList);
            this.m_netHash = new Hashtable(nodeList.length);
            this.createHashStatus(nodeList, this.m_netHash);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"\n\n*** ABOUT TO DO NETWORK APP CHECK ***\n\n");
            }
            this.performAppCheck("NETWORK", this.NODEAPP_NETWORK, this.m_netHash, netResultSet, true, nodeList);
        }
        if (uploadRes) {
            this.m_resultSet.uploadResultSet(vipResultSet);
            if (this.m_isVersionTB) {
                this.m_resultSet.uploadResultSet(netResultSet);
            }
        }
        return this.m_resultSet.allSuccess();
    }

    String[] getResourceNames(String[] nodelist, String appName, Vector failNodes) {
        Vector<String> resVector = new Vector<String>(nodelist.length);
        String[] resList = null;
        for (int i = 0; i < nodelist.length; ++i) {
            Trace.out((String)("==== nodelist loop: " + nodelist[i]));
            if (this.m_isVersionTB) {
                if (appName.equals("vip") || appName.equals("VIP")) {
                    if (!this.m_deletedResource) {
                        resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + this.NODEAPP_VIP + " -n " + nodelist[i].toLowerCase());
                        continue;
                    }
                    for (int k = 0; k < this.m_arrNodesWithCRS.length; ++k) {
                        resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + this.NODEAPP_VIP + " -n " + this.m_arrNodesWithCRS[k].toLowerCase());
                    }
                    continue;
                }
                if (appName.equals("gsd") || appName.equals("GSD")) {
                    if (this.m_deletedResource) continue;
                    resVector.add(RES_PREFIX + this.NODEAPP_GSD + " -n " + nodelist[i].toLowerCase());
                    continue;
                }
                if (appName.equals("ons") || appName.equals("ONS")) {
                    if (this.m_deletedResource) continue;
                    resVector.add(RES_PREFIX + this.NODEAPP_ONS + " -n " + nodelist[i].toLowerCase());
                    continue;
                }
                if (appName.equals("eons") || appName.equals("EONS")) {
                    if (this.m_deletedResource) continue;
                    resVector.add(RES_PREFIX + this.NODEAPP_EONS + " -n " + nodelist[i].toLowerCase());
                    continue;
                }
                if (appName.equals("net1.network") || appName.equals("NET1.NETWORK")) {
                    if (this.m_deletedResource) continue;
                    resVector.add(RES_PREFIX + this.NODEAPP_NETWORK + " -n " + nodelist[i].toLowerCase());
                    continue;
                }
                Trace.out((String)("==== Res. App. unknown: " + appName));
                continue;
            }
            if (appName.equals("vip") || appName.equals("VIP")) {
                resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + this.NODEAPP_VIP);
                continue;
            }
            if (appName.equals("gsd") || appName.equals("GSD")) {
                resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + this.NODEAPP_GSD);
                continue;
            }
            if (appName.equals("ons") || appName.equals("ONS")) {
                resVector.add(RES_PREFIX + nodelist[i].toLowerCase() + "." + this.NODEAPP_ONS);
                continue;
            }
            Trace.out((String)("==== Res. App. unknown: " + appName));
        }
        resList = resVector.toArray(new String[resVector.size()]);
        return resList;
    }

    private boolean removeFromAgileList(String node) {
        boolean result = this.m_vAgileNodes.remove(node);
        Trace.out((String)("==== Removal status of node '" + node + "': " + result));
        return result;
    }

    private String[] getAgileNodelist() {
        String[] agileNodes = this.m_vAgileNodes.toArray(new String[this.m_vAgileNodes.size()]);
        Trace.out((String)("==== Agile node count: " + agileNodes.length));
        for (int i = 0; i < agileNodes.length; ++i) {
            Trace.out((String)("\t" + agileNodes[i]));
        }
        return agileNodes;
    }

    private String getNodenameFromResname(String res) {
        String node = res.substring(res.indexOf(46) + 1, res.lastIndexOf(46));
        Trace.out((String)("Node name '" + node + "' was retrieved from " + res));
        return node;
    }

    private void createHashStatus(String[] nodelist, Hashtable ht) {
        ht.clear();
        for (int i = 0; i < nodelist.length; ++i) {
            ht.put(nodelist[i], new Integer(-1));
        }
    }

    private void performAppCheck(String appName, String appSuffix, Hashtable hash, ResultSet resultSet, boolean optional, String[] nodeList) {
        String[] resList;
        ResultSet tmpRSet = new ResultSet();
        Vector failNodes = new Vector();
        String upappName = appName.toUpperCase();
        String endTag = "";
        if (!ReportUtil.isVerbose()) {
            endTag = optional ? s_msgBundle.getMessage("9404", false) : s_msgBundle.getMessage("9405", false);
            endTag = "(" + endTag + ")";
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("4551", false, (Object[])new String[]{appName}) + endTag);
        failNodes.clear();
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("About to get resource names for: \nappName: " + appName + "\nappSuffix: " + appSuffix + "\nnodes with CRS: " + VerificationUtil.strArr2List(this.m_arrNodesWithCRS) + "\nnodes on CMD line: " + VerificationUtil.strArr2List(nodeList) + "\n"));
        }
        if ((resList = this.getResourceNames(nodeList, appSuffix, failNodes)).length == 0) {
            ReportUtil.printError(s_msgBundle.getMessage("4552", false, (Object[])new String[]{appName}));
            resultSet.addResult(this.m_arrNodesWithCRS, 5);
            for (String node : this.m_arrNodesWithCRS) {
                resultSet.addErrorDescription(node, new ErrorDescription(s_msgBundle.getMessage("4554", true, (Object[])new String[]{appName, node}), s_msgBundle, "4554"));
            }
            return;
        }
        if (failNodes.size() != 0) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4553", false, (Object[])new String[]{upappName}));
            ReportUtil.sureprintNodelist(failNodes);
            String[] tmpNodeList = failNodes.toArray(new String[failNodes.size()]);
            resultSet.addResult(tmpNodeList, 5);
            for (String node : tmpNodeList) {
                resultSet.addErrorDescription(node, new ErrorDescription(s_msgBundle.getMessage("4554", true, (Object[])new String[]{appName, node}), s_msgBundle, "4554"));
            }
        }
        this.checkNodeApp(resList, hash, tmpRSet);
        this.updateResult(resList, appName, hash, resultSet, optional);
        this.reportResult(resultSet, optional);
    }

    private void checkNodeApp(String[] resList, Hashtable statusHT, ResultSet resultSet) {
        Trace.out((String)"==== Checking Nodeapp:");
        Vector<String> vUnresolvedRes = new Vector<String>(resList.length);
        Vector<String> vCurrentUnresolvedRes = new Vector<String>(resList.length);
        for (int k = 0; k < resList.length; ++k) {
            int nodeFlagIndex;
            String resource = this.m_isVersionTB ? ((nodeFlagIndex = resList[k].indexOf(" -n ")) != -1 ? resList[k].substring(0, nodeFlagIndex) : resList[k]) : resList[k];
            vUnresolvedRes.add(resource);
            vCurrentUnresolvedRes.add(resList[k]);
            Trace.out((String)("==== Unresolved res added as: " + resource));
        }
        Trace.out((String)("**** UnRRes count at the beginning : " + vUnresolvedRes.size()));
        String[] agileNodes = this.getAgileNodelist();
        int urResCount = 0;
        int cmdCount = 0;
        String[] cmdList = null;
        String[] cmdNodeList = null;
        int resIndex = 0;
        Hashtable<String, String> commandsHT = new Hashtable<String, String>(agileNodes.length);
        Hashtable nodeToResHT = new Hashtable();
        Hashtable<String, String> nodeToCurrentUnresolvedResHT = new Hashtable<String, String>();
        int maxNumberofLoops = agileNodes.length * resList.length + 1;
        Trace.out((String)("max iteration set to :" + maxNumberofLoops));
        while (maxNumberofLoops-- >= 0 && !vUnresolvedRes.isEmpty()) {
            String resName;
            resIndex = 0;
            agileNodes = this.getAgileNodelist();
            Trace.out((String)("==== Number of agile nodes: " + agileNodes.length));
            if (agileNodes.length == 0) {
                Trace.out((String)("==== Responsive node count reached 0.  Could not check these resources: " + VerificationUtil.strVect2List(vUnresolvedRes)));
                break;
            }
            urResCount = vUnresolvedRes.size();
            Trace.out((String)("==== Number of resources to check: " + urResCount));
            nodeToResHT.clear();
            if (this.m_isVersionTB) {
                nodeToCurrentUnresolvedResHT.clear();
            }
            commandsHT.clear();
            boolean bResAvail = true;
            for (int n = 0; n < agileNodes.length && bResAvail; ++n) {
                boolean bLoaded = false;
                String cmdStr = this.m_statCmd;
                String cmdNodeName = agileNodes[n];
                Vector<String> vResListForNode = new Vector<String>();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Processing AGILE node: " + cmdNodeName + "\ncmdStr: " + cmdStr + "\nagileNodes length: " + agileNodes.length + "\nn: " + n + "bResAvail: " + bResAvail + "\n "));
                }
                if (this.m_isVersionTB) {
                    int location;
                    String currentRes = (String)vCurrentUnresolvedRes.elementAt(resIndex);
                    cmdStr = cmdStr + " " + currentRes;
                    vResListForNode.add(currentRes);
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("cmdStr: " + cmdStr + " "));
                    }
                    if (resIndex == urResCount) {
                        Trace.out((String)"===== No more resources to load");
                        bResAvail = false;
                    }
                    if ((location = cmdStr.indexOf(" -n ")) != -1) {
                        cmdNodeName = cmdStr.substring(location += " -n ".length());
                    } else {
                        int begin = RES_PREFIX.length();
                        int end = currentRes.length() - ".".length() - this.NODEAPP_VIP.length();
                        cmdNodeName = currentRes.substring(begin, end);
                    }
                    boolean isAgile = false;
                    for (int g = 0; g < agileNodes.length; ++g) {
                        if (!cmdNodeName.equalsIgnoreCase(agileNodes[g])) continue;
                        isAgile = true;
                        break;
                    }
                    if (!isAgile) {
                        Trace.out((String)("node not agile:" + cmdNodeName));
                        cmdNodeName = agileNodes[n];
                        if (location != -1) {
                            StringBuilder sb = new StringBuilder(cmdStr.substring(0, location));
                            sb.append(cmdNodeName);
                            cmdStr = sb.toString();
                            int resNodeLocation = currentRes.indexOf(" -n ") + " -n ".length();
                            StringBuilder sb1 = new StringBuilder(currentRes.substring(0, resNodeLocation));
                            sb1.append(cmdNodeName);
                            vCurrentUnresolvedRes.setElementAt(sb1.toString(), resIndex);
                        }
                    }
                    nodeToCurrentUnresolvedResHT.put(cmdNodeName, (String)vCurrentUnresolvedRes.elementAt(resIndex));
                    if (++resIndex == urResCount) {
                        Trace.out((String)"===== No more resources to load");
                        bResAvail = false;
                    }
                    Trace.out((String)("TB command cmdstr=" + cmdStr + " cmdnode=" + cmdNodeName));
                } else {
                    int iCapacity = 180 - this.m_statCmd.length();
                    while (!bLoaded) {
                        if (resIndex == urResCount) {
                            Trace.out((String)"==== No more resources to load");
                            bResAvail = false;
                            break;
                        }
                        resName = vUnresolvedRes.elementAt(resIndex);
                        if (iCapacity >= resName.length()) {
                            cmdStr = cmdStr + " " + resName;
                            iCapacity -= resName.length();
                            ++resIndex;
                            vResListForNode.add(resName);
                            continue;
                        }
                        bLoaded = true;
                    }
                }
                nodeToResHT.put(cmdNodeName, vResListForNode);
                commandsHT.put(cmdNodeName, cmdStr);
                Trace.out((String)("==== Command added: " + cmdStr));
            }
            cmdCount = commandsHT.size();
            cmdList = new String[cmdCount];
            cmdNodeList = new String[cmdCount];
            Enumeration e = commandsHT.keys();
            int index = 0;
            while (e.hasMoreElements()) {
                cmdNodeList[index] = (String)e.nextElement();
                cmdList[index] = (String)commandsHT.get(cmdNodeList[index]);
                ++index;
            }
            Trace.out((String)("==== Executing on " + cmdCount + " nodes."));
            GlobalExecution globalExec = new GlobalExecution();
            Hashtable crsstatOutputHT = globalExec.runExeWithOutput(cmdNodeList, cmdList, resultSet);
            block6: for (int j = 0; j < cmdCount; ++j) {
                String output = (String)crsstatOutputHT.get(cmdNodeList[j]);
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\nCommand output for: " + cmdNodeList[j] + "\nOutput: " + output + "\n"));
                }
                Vector payloadV = (Vector)nodeToResHT.get(cmdNodeList[j]);
                Hashtable resStatusHT = this.analyzeResult(output, payloadV);
                Enumeration statEnum = resStatusHT.keys();
                Trace.out((String)("status available for " + resStatusHT.size() + "elements"));
                while (statEnum.hasMoreElements()) {
                    resName = (String)statEnum.nextElement();
                    int status = (Integer)resStatusHT.get(resName);
                    String nodename = this.m_isVersionTB ? cmdNodeList[j] : this.getNodenameFromResname(resName);
                    Trace.out((String)("==== Nodeapp status for '" + nodename + "' is:" + status));
                    if (statusHT.containsKey(nodename)) {
                        statusHT.put(nodename, new Integer(status));
                    } else {
                        Trace.out((String)"Status update in case insensitive way");
                        Enumeration nodeList = statusHT.keys();
                        while (nodeList.hasMoreElements()) {
                            String keyNodeName = (String)nodeList.nextElement();
                            if (!keyNodeName.equalsIgnoreCase(nodename)) continue;
                            Trace.out((String)("Reporting status for node :" + keyNodeName));
                            statusHT.put(keyNodeName, new Integer(status));
                        }
                    }
                    if (status == 0 || status == 210 || status == 1) {
                        Trace.out((String)("==== Resolved resource : " + resName));
                        boolean result = vUnresolvedRes.remove(resName);
                        Trace.out((String)("==== Res removal status : " + result));
                        if (!result) {
                            Trace.out((String)("Problem removing resource : " + resName));
                            this.removeFromAgileList(cmdNodeList[j]);
                        }
                        String resolvedRes = (String)nodeToCurrentUnresolvedResHT.get(nodename);
                        vCurrentUnresolvedRes.remove(resolvedRes);
                        continue;
                    }
                    Trace.out((String)("==== Removing unresponsive node " + cmdNodeList[j]));
                    this.removeFromAgileList(cmdNodeList[j]);
                    continue block6;
                }
            }
            Trace.out((String)("==== Number of node res checked: " + cmdCount));
            Trace.out((String)("=== remaining loop count = " + (maxNumberofLoops - 1)));
        }
        Trace.out((String)(" loops remaining = " + maxNumberofLoops));
    }

    private Hashtable analyzeResult(String output, Vector payLoadV) {
        boolean bOpSuc = true;
        Hashtable<Object, Integer> statusHT = new Hashtable<Object, Integer>(payLoadV.size());
        Trace.out((String)"==== Inside analyzeResult ");
        if (!VerificationUtil.fetchExecResult(output)) {
            Trace.out((String)"==== Execution result is NULL. Status for every one will be marked as: -1");
            bOpSuc = false;
        }
        String exitStatus = VerificationUtil.fetchVerificationResult(output);
        Trace.out((String)("==== Verification result: " + exitStatus));
        if (bOpSuc && exitStatus == null) {
            Trace.out((String)"==== Verification result is NULL. Status for every one will be marked as: -1");
            bOpSuc = false;
        }
        String txtVal = VerificationUtil.fetchVerificationValue(output);
        if (!bOpSuc || txtVal == null || txtVal.length() == 0) {
            int status = -1;
            Trace.out((String)("unknown status operation status =" + bOpSuc + "cmd output=" + txtVal));
            for (int i = 0; i < payLoadV.size(); ++i) {
                statusHT.put(payLoadV.elementAt(i), new Integer(status));
            }
            return statusHT;
        }
        boolean res_exists = false;
        boolean res_online = false;
        String resName = null;
        String[] outlist = VerificationUtil.getTokensAsArray(txtVal, "\n");
        for (int l = 0; l < outlist.length; ++l) {
            int r;
            int i;
            if (this.m_isVersionTB) {
                if (outlist[l].startsWith(ERRTXT_4535)) {
                    int status = 184;
                    Trace.out((String)"==== CRS not available. Marking all the res as NOCRSD before exiting.");
                    for (i = 0; i < payLoadV.size(); ++i) {
                        statusHT.put(payLoadV.elementAt(i), new Integer(status));
                        Trace.out((String)("Marked " + payLoadV.elementAt(i) + " as no crs"));
                    }
                    return statusHT;
                }
                if (outlist[l].startsWith(ERRTXT_2613)) {
                    Trace.out((String)"==== Case 2613");
                    for (r = 0; r < payLoadV.size(); ++r) {
                        resName = (String)payLoadV.elementAt(r);
                        if (-1 == outlist[l].indexOf(resName)) continue;
                        Trace.out((String)("==== Marking '" + resName + "' as NOTEXIST"));
                        statusHT.put(resName, new Integer(210));
                        break;
                    }
                }
                if (outlist[l].startsWith(ERRTXT_4655)) {
                    Trace.out((String)"==== Case 4655");
                    for (r = 0; r < payLoadV.size(); ++r) {
                        resName = (String)payLoadV.elementAt(r);
                        if (-1 == outlist[l].indexOf(resName)) continue;
                        Trace.out((String)("==== Marking '" + resName + "' as NOTEXIST"));
                        statusHT.put(resName, new Integer(210));
                        break;
                    }
                }
            } else {
                if (outlist[l].startsWith(ERRTXT_184)) {
                    int status = 184;
                    for (i = 0; i < payLoadV.size(); ++i) {
                        statusHT.put(payLoadV.elementAt(i), new Integer(status));
                    }
                    Trace.out((String)"==== CRS not available. Marking all the res as NOCRSD before exiting.");
                    return statusHT;
                }
                if (outlist[l].startsWith(ERRTXT_202)) {
                    int status = 210;
                    for (i = 0; i < payLoadV.size(); ++i) {
                        statusHT.put(payLoadV.elementAt(i), new Integer(status));
                    }
                    Trace.out((String)"==== No resource has been registered. Marking all the res as NOTEXIST before exiting.");
                    return statusHT;
                }
                if (outlist[l].startsWith(ERRTXT_210)) {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"==== Case 210");
                    }
                    for (r = 0; r < payLoadV.size(); ++r) {
                        resName = (String)payLoadV.elementAt(r);
                        if (-1 == outlist[l].indexOf(resName)) continue;
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("==== Marking '" + resName + "' as NOTEXIST"));
                        }
                        statusHT.put(resName, new Integer(210));
                        break;
                    }
                }
            }
            if (outlist[l].startsWith(NAMETXT)) {
                resName = outlist[l].substring(NAMETXT.length());
                res_exists = true;
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("==== Marking res '" + resName + "' as EXIST"));
                }
            }
            if (!outlist[l].startsWith(STATETXT)) continue;
            if (-1 != outlist[l].indexOf(ONLINETXT)) {
                res_online = true;
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)("==== " + resName + ": ONLINE"));
                continue;
            }
            res_online = false;
            if (!Trace.isLevelEnabled((int)1)) continue;
            Trace.out((String)("==== " + resName + ": OFFLINE"));
        }
        if (res_exists) {
            if (res_online) {
                statusHT.put(resName, new Integer(1));
            } else {
                statusHT.put(resName, new Integer(0));
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return statusHT;
    }

    private void updateResult(String[] resList, String appName, Hashtable hash, ResultSet resultSet, boolean optional) {
        Enumeration e = hash.keys();
        String resourceName = null;
        while (e.hasMoreElements()) {
            int status;
            String node = (String)e.nextElement();
            for (String resName : resList) {
                if (resName.indexOf(appName.toLowerCase()) == -1 || resName.indexOf(node) == -1) continue;
                resourceName = resName;
                break;
            }
            Result result = resultSet.getResult(node);
            ErrorDescription errorDesc = null;
            Integer resStatus = (Integer)hash.get(node);
            TaskNACData nacData = null;
            if (result == null) {
                result = new Result(node);
            }
            switch (resStatus) {
                case 1: {
                    status = 1;
                    nacData = new TaskNACData(resourceName, 1);
                    result.addResultInfo(nacData);
                    break;
                }
                case 0: {
                    status = optional ? 4 : 3;
                    nacData = new TaskNACData(resourceName, 0);
                    result.addResultInfo(nacData);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("4557", false, (Object[])new String[]{appName, node}));
                    break;
                }
                case 210: {
                    status = optional ? 4 : 3;
                    nacData = new TaskNACData(resourceName, 210);
                    result.addResultInfo(nacData);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("4555", true, (Object[])new String[]{appName, node}), s_msgBundle, "4555");
                    break;
                }
                default: {
                    status = 2;
                    nacData = new TaskNACData("UNKNOWN", -1);
                    result.addResultInfo(nacData);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("4556", true, (Object[])new String[]{appName, node}), s_msgBundle, "4556");
                }
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== App status: " + resStatus + ". Adding Result for node " + node + " with status " + status));
                Trace.out((String)nacData.toString());
            }
            result.setStatus(status);
            resultSet.addResult(node, result);
            if (errorDesc == null) continue;
            resultSet.addErrorDescription(node, errorDesc);
        }
    }

    private void reportResult(ResultSet rsltSet, boolean optional) {
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        String req = optional ? ReportUtil.NO : ReportUtil.YES;
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.REQUIRED, ReportUtil.STATUS, ReportUtil.COMMENT);
        while (e.hasMoreElements()) {
            String comment;
            String appStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                appStatus = ReportUtil.ONLINE;
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3 || result.getStatus() == 4) {
                appStatus = ReportUtil.NOTEXIST;
                comment = optional ? ReportUtil.IGNORED : ReportUtil.FAILED;
            } else {
                appStatus = ReportUtil.UNKNOWN;
                comment = optional ? ReportUtil.IGNORED : ReportUtil.FAILED;
            }
            ReportUtil.writeRecord(node, req, appStatus, comment);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("9401", false));
        } else {
            String msgID = optional ? "9403" : "9402";
            ReportUtil.printResult(s_msgBundle.getMessage(msgID, false));
            ReportUtil.printErrorNodes(rsltSet);
        }
        ReportUtil.sureblankln();
    }

    private boolean determineCRSVersion(String[] nodeList) {
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            String errMsg = s_msgBundle.getMessage("5300", false);
            ReportUtil.printError(errMsg);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            this.m_resultSet.addResult(nodeList, 2);
            return false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nCRSActiveVersion: " + activeCRSVer));
        }
        if (activeCRSVer.startsWith("11.2")) {
            this.m_isVersionTB = true;
        }
        return true;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4425", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4476", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }

    public class TaskNACData {
        private String na_Name;
        private int na_Status;

        public TaskNACData(String name, int status) {
            this.na_Name = name;
            this.na_Status = status;
        }

        public String getName() {
            return this.na_Name;
        }

        public int getStatus() {
            return this.na_Status;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String status = null;
            switch (this.na_Status) {
                case 1: {
                    status = "RC_ONLINE";
                    break;
                }
                case 0: {
                    status = "RC_EXIST";
                    break;
                }
                case 210: {
                    status = "RC_NOTEXIST";
                    break;
                }
                default: {
                    status = "UNKNOWN";
                }
            }
            sb.append("    App Name: '" + this.na_Name + "' Status: " + status);
            return sb.toString();
        }
    }
}

