/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.impl.verification.NetworkInterfaceInfoImpl;
import oracle.cluster.impl.verification.NodeConnectivityResultSetImpl;
import oracle.cluster.impl.verification.SubnetAndInterfaceInfoImpl;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskHostsFile;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.TCPMatrix;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class TaskNodeConnectivity
extends Task {
    public static final int NODECON = 0;
    public static final int NODEREACH = 1;
    public static final String IPCON_KEY = "IPCON";
    public static final String INFCON_KEY = "INFCON";
    public static final String NODEREACH_KEY = "NODEREACH";
    private String[] m_IPAddrList;
    private String[] m_interfaceList;
    private int m_taskType = 0;
    private String m_srcNode = null;
    private VerifyNetwork m_vfyNet = new VerifyNetwork();
    private NodeConnectivityResultSetImpl m_nodeConResSetImpl = new NodeConnectivityResultSetImpl();

    public TaskNodeConnectivity() {
        this(null, 1);
    }

    public TaskNodeConnectivity(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskNodeConnectivity(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public TaskNodeConnectivity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskNodeConnectivity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskNodeConnectivity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setInterfaceList(String[] interfaceList) {
        this.m_interfaceList = interfaceList;
    }

    public void setIPAddrList(String[] IPAddrList) {
        this.m_IPAddrList = IPAddrList;
    }

    public void setTaskType(int type) {
        this.m_taskType = type;
    }

    public void setSourceNode(String srcNode) {
        this.m_srcNode = srcNode;
    }

    public NodeConnectivityResultSetImpl getNodeConnectivityResultSetImpl() {
        return this.m_nodeConResSetImpl;
    }

    public boolean performTask() {
        boolean retVal = false;
        if (this.m_IPAddrList != null && this.m_IPAddrList.length != this.m_nodeList.length) {
            ReportUtil.printError(s_msgBundle.getMessage("4079", false) + LSEP);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        if (this.m_taskType == 0) {
            Trace.out((String)"Performing Node Connectivity verification task... \n");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4063", false));
            if (this.m_nodeList == null) {
                Trace.out((String)"NULL 'nodelist'");
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (nativeSystem.isUnixSystem()) {
                TaskHostsFile taskNHF = new TaskHostsFile(this.m_nodeList);
                taskNHF.performTask();
            }
            if (this.m_interfaceList != null) {
                Trace.out((String)("\nUsing interfaceList: '" + VerificationUtil.strArr2List(this.m_interfaceList) + "'"));
                retVal = this.verifyIfCon();
            } else {
                Trace.out((String)"interfaceList is NULL");
                retVal = this.verifyNodeCon();
            }
            ReportUtil.sureblankln();
            if (!this.m_resultSet.anyFailure()) {
                ReportUtil.printResult(s_msgBundle.getMessage("4086", false));
            } else {
                ReportUtil.printResult(s_msgBundle.getMessage("4087", false));
            }
        } else if (this.m_taskType == 1) {
            Trace.out((String)"_nw_:Performing Node Reachability verification task... \n");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4078", false));
            boolean[] nodeConArray = new boolean[this.m_nodeList.length];
            VerifyNetwork vfyNet = new VerifyNetwork();
            if (this.m_srcNode != null) {
                if (!VerificationUtil.isUserEquivalenceOnNode(this.m_srcNode, true)) {
                    Trace.out((String)"Node Reach Equivalence check failed from source node.\n");
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
                Trace.out((String)"Performing Node Reachability from source node...\n");
                retVal = vfyNet.checkReachFromSrcNode(this.m_nodeList, nodeConArray, this.m_srcNode);
            } else {
                try {
                    this.m_srcNode = VerificationUtil.getLocalHost();
                    Trace.out((String)"Performing Node Reachability from local node...\n");
                    retVal = vfyNet.checkReachFromLocalNode(this.m_nodeList, nodeConArray);
                }
                catch (UnknownHostException uhe) {
                    ReportUtil.sureprintln(uhe.getMessage());
                    retVal = false;
                }
                catch (NetworkException ne) {
                    retVal = false;
                }
            }
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                String node = this.m_nodeList[i];
                if (nodeConArray[i]) {
                    this.m_resultSet.addResult(node, 1);
                    continue;
                }
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("4083", false, (Object[])new String[]{this.m_srcNode}), s_msgBundle, "4083"));
            }
            this.reportNodeReach(this.m_srcNode, this.m_nodeList, nodeConArray, retVal);
        }
        ReportUtil.sureblankln();
        return retVal;
    }

    private boolean verifyNodeCon() {
        Subnet okSubnet;
        Iterator okSubnetIter;
        ConMatrix matrix;
        Subnet subnet;
        Vector nodeInfoList = new Vector(this.m_nodeList.length);
        MultiNodeException mne = null;
        boolean retVal = false;
        boolean foundVIPOk = false;
        boolean foundAnyValidSubnet = false;
        boolean TCPCon = false;
        boolean foundPrivate = false;
        boolean foundPrivateSameName = false;
        int numOkNodes = this.m_nodeList.length;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        try {
            this.m_vfyNet.getInterfaceInfo(this.m_nodeList, nodeInfoList);
        }
        catch (NetworkException ne) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.printError(ne.getMessage());
        }
        catch (MultiNodeException mnException) {
            mne = mnException;
        }
        numOkNodes = nodeInfoList.size();
        if (0 == numOkNodes) {
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                String node = this.m_nodeList[i];
                this.m_resultSet.addResult(node, 2);
                String errMsg = s_msgBundle.getMessage("4087", false);
                String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{node});
                String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{node});
                this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            }
            ReportUtil.printError(s_msgBundle.getMessage("4080", true));
            return false;
        }
        if (null != mne) {
            Vector okNodes = this.reportMultiNodeException(mne, this.m_nodeList);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(okNodes);
        }
        this.reportNodeInfo(nodeInfoList);
        ReportUtil.sureblankln();
        Collection subnets = Subnet.classifyToSubnets(nodeInfoList);
        Vector subnetList = new Vector(subnets);
        Vector matrixList = new Vector(subnetList.size());
        Vector tcpMatrixList = new Vector(subnetList.size());
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("subnetList size: " + subnetList.size()));
        }
        if (m_isAPImode) {
            this.getNodeConnAPIData(subnetList);
        }
        try {
            foundAnyValidSubnet = this.m_vfyNet.checkSubnetCon(subnetList, matrixList);
            TCPCon = this.m_vfyNet.checkSubnetTCPCon(subnetList, tcpMatrixList);
        }
        catch (NetworkException ne) {
            Trace.out((Exception)ne);
            ReportUtil.printError(ne.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            retVal = false;
            return false;
        }
        Iterator subnetIter = subnetList.iterator();
        Iterator matrixIter = matrixList.iterator();
        Iterator tcpMatrixIter = tcpMatrixList.iterator();
        while (subnetIter.hasNext()) {
            subnet = (Subnet)subnetIter.next();
            matrix = (ConMatrix)matrixIter.next();
            TCPMatrix tcpMatrix = (TCPMatrix)tcpMatrixIter.next();
            this.reportNodeCon(matrix);
            this.reportTCPCon(subnet.getSubnet(), tcpMatrix);
        }
        subnetIter = subnetList.iterator();
        matrixIter = matrixList.iterator();
        while (subnetIter.hasNext()) {
            subnet = (Subnet)subnetIter.next();
            matrix = (ConMatrix)matrixIter.next();
            if (matrix.getStatus() != 1) continue;
            boolean warningIssued = false;
            okSubnetIter = subnet.getVIPOkSubnets(numOkNodes).iterator();
            block8: while (okSubnetIter.hasNext()) {
                foundVIPOk = true;
                warningIssued = false;
                okSubnet = (Subnet)okSubnetIter.next();
                this.reportVIPOkInterfaces(okSubnet);
                for (String node : subnet.getNodes()) {
                    for (InterfaceInfo inf : subnet.getInterfacesByNode(node)) {
                        if (!inf.getGateway().equals("0.0.0.0") || !inf.getDefGateway().equals("UNKNOWN")) continue;
                        String errMsg = s_msgBundle.getMessage("6019", false, (Object[])new String[]{okSubnet.getSubnet()});
                        this.m_resultSet.addResult(node, 4);
                        this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg));
                        ReportUtil.printWarning(errMsg);
                        warningIssued = true;
                        break;
                    }
                    if (!warningIssued) continue;
                    continue block8;
                }
            }
        }
        subnetIter = subnetList.iterator();
        matrixIter = matrixList.iterator();
        while (subnetIter.hasNext()) {
            subnet = (Subnet)subnetIter.next();
            matrix = (ConMatrix)matrixIter.next();
            if (matrix.getStatus() != 1) continue;
            okSubnetIter = subnet.getPrivateOkSubnets(numOkNodes, true).iterator();
            while (okSubnetIter.hasNext()) {
                foundPrivateSameName = true;
                okSubnet = (Subnet)okSubnetIter.next();
                this.reportPrivateOkInterfaces(okSubnet);
            }
        }
        if (!foundPrivateSameName) {
            subnetIter = subnetList.iterator();
            matrixIter = matrixList.iterator();
            while (subnetIter.hasNext()) {
                subnet = (Subnet)subnetIter.next();
                matrix = (ConMatrix)matrixIter.next();
                if (matrix.getStatus() != 1) continue;
                okSubnetIter = subnet.getPrivateOkSubnets(numOkNodes, false).iterator();
                while (okSubnetIter.hasNext()) {
                    foundPrivate = true;
                    okSubnet = (Subnet)okSubnetIter.next();
                    this.reportPrivateOkInterfaces(okSubnet);
                }
            }
        }
        if (!foundVIPOk) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4101", false));
        }
        if (!foundPrivateSameName && foundPrivate) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4103", false));
        } else if (!foundPrivateSameName) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4102", false));
        }
        boolean bl = retVal = numOkNodes == this.m_nodeList.length && foundAnyValidSubnet;
        if (retVal) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 2);
        }
        return retVal;
    }

    private boolean verifyIfCon() {
        int i;
        int i2;
        MultiNodeException mne = null;
        boolean retVal = true;
        boolean[] ifResults = new boolean[this.m_interfaceList.length];
        String[] ifNames = new String[this.m_interfaceList.length];
        Vector nodeInfoList = new Vector(this.m_nodeList.length);
        Vector subnetList = new Vector();
        for (i2 = 0; i2 < ifResults.length; ++i2) {
            ifResults[i2] = true;
        }
        for (i2 = 0; i2 < this.m_interfaceList.length; ++i2) {
            int index = this.m_interfaceList[i2].indexOf(58);
            ifNames[i2] = -1 != index ? this.m_interfaceList[i2].substring(0, index) : this.m_interfaceList[i2];
        }
        try {
            this.m_vfyNet.getInterfaceInfo(this.m_nodeList, nodeInfoList);
        }
        catch (NetworkException ne) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.printError(ne.getMessage());
        }
        catch (MultiNodeException mnException) {
            mne = mnException;
        }
        int numOkNodes = nodeInfoList.size();
        if (0 == numOkNodes) {
            for (int i3 = 0; i3 < this.m_nodeList.length; ++i3) {
                String node = this.m_nodeList[i3];
                this.m_resultSet.addResult(node, 2);
                String errMsg = s_msgBundle.getMessage("4087", false);
                String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{node});
                String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{node});
                this.m_resultSet.getResult(node).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            }
            ReportUtil.printError(s_msgBundle.getMessage("4080", true) + LSEP);
            return false;
        }
        if (null != mne) {
            Vector okNodes = this.reportMultiNodeException(mne, this.m_nodeList);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(okNodes);
        }
        this.reportNodeInfo(nodeInfoList);
        ReportUtil.blankln();
        Vector<String> badNodeList = new Vector<String>();
        for (i = 0; i < ifNames.length; ++i) {
            boolean foundBadNode = false;
            Vector interfaces = new Vector();
            for (NodeInfo nodeInfo : nodeInfoList) {
                Collection nodeIfList = nodeInfo.getInterfacesByName(ifNames[i]);
                if (nodeIfList.size() == 0) {
                    if (!foundBadNode) {
                        badNodeList = new Vector();
                    }
                    badNodeList.add(nodeInfo.getName());
                    foundBadNode = true;
                    continue;
                }
                interfaces.addAll(nodeIfList);
            }
            if (interfaces.size() == 0) {
                ifResults[i] = false;
                ReportUtil.printError(s_msgBundle.getMessage("6001", true, (Object[])new String[]{ifNames[i]}) + LSEP);
                continue;
            }
            Collection tmpSubnetList = Subnet.classifyToSubnets(interfaces, false);
            Trace.out((String)("NumSubnets : " + tmpSubnetList.size()));
            if (foundBadNode) {
                ReportUtil.printError(s_msgBundle.getMessage("6002", true, (Object[])new String[]{ifNames[i]}));
                ReportUtil.sureprintNodelist(badNodeList);
            }
            subnetList.addAll(tmpSubnetList);
        }
        Vector matrixList = new Vector(subnetList.size());
        Trace.out((String)("subnetList size: " + subnetList.size()));
        if (m_isAPImode) {
            this.getNodeConnAPIData(subnetList);
        }
        try {
            this.m_vfyNet.checkSubnetCon(subnetList, matrixList);
        }
        catch (NetworkException ne) {
            Trace.out((Exception)ne);
            ReportUtil.printError(ne.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            retVal = false;
            return false;
        }
        Iterator subnetIter = subnetList.iterator();
        Iterator matrixIter = matrixList.iterator();
        for (i = 0; i < ifResults.length; ++i) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4088", false, (Object[])new String[]{ifNames[i]}));
            if (!ifResults[i]) {
                retVal = false;
                ReportUtil.printResult(s_msgBundle.getMessage("4090", false, (Object[])new String[]{ifNames[i]}));
                continue;
            }
            Subnet subnet = (Subnet)subnetIter.next();
            ConMatrix matrix = (ConMatrix)matrixIter.next();
            if (subnet.getNumNodes() != numOkNodes || matrix.getStatus() != 1) {
                retVal = false;
            }
            this.reportIfCon(matrix, ifNames[i], numOkNodes);
        }
        boolean bl = retVal = retVal && this.m_nodeList.length == numOkNodes;
        if (retVal) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else {
            this.m_resultSet.addResult(this.m_nodeList, 2);
        }
        return retVal;
    }

    private void reportVIPOkInterfaces(Subnet subnet) {
        ReportUtil.sureprintln("");
        ReportUtil.sureprintln(s_msgBundle.getMessage("4104", false, (Object[])new String[]{subnet.getSubnet()}));
        this.reportInterfacesInSubnet(subnet);
    }

    private void reportPrivateOkInterfaces(Subnet subnet) {
        ReportUtil.sureprintln("");
        ReportUtil.sureprintln(s_msgBundle.getMessage("4105", false, (Object[])new String[]{subnet.getSubnet()}));
        this.reportInterfacesInSubnet(subnet);
    }

    private void reportInterfacesInSubnet(Subnet subnet) {
        for (String node : subnet.getNodes()) {
            ReportUtil.sureprint(node);
            for (InterfaceInfo inf : subnet.getInterfacesByNode(node)) {
                ReportUtil.sureprint(" " + inf.getName() + ":" + inf.getIP());
            }
            ReportUtil.sureprintln("");
        }
    }

    private void reportNodeReach(String srcNode, String[] nodeList, boolean[] nodeConArray, boolean succ) {
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4081", false, (Object[])new String[]{srcNode}));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8004", false), s_msgBundle.getMessage("8005", false));
        for (int i = 0; i < nodeList.length; ++i) {
            ReportUtil.writeRecord(nodeList[i], this.bool2YesNo(nodeConArray[i]));
        }
        if (succ) {
            ReportUtil.printResult(s_msgBundle.getMessage("4082", false, (Object[])new String[]{srcNode}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4083", false, (Object[])new String[]{srcNode}));
            ReportUtil.printErrorNodes(this.m_resultSet);
        }
    }

    private void reportBadIP(ConMatrix matrix) {
        String[] IPList = matrix.getIPList();
        String[] nodeList = matrix.getNodeList();
        String[] interfaceList = matrix.getInterfaceList();
        boolean[][] conTable = matrix.getMatrixForOutput();
        for (int i = 0; i < nodeList.length; ++i) {
            if (conTable[i][i]) continue;
            String msg = interfaceList == null ? s_msgBundle.getMessage("4084", false, (Object[])new String[]{interfaceList[i] + ":" + IPList[i], nodeList[i]}) : s_msgBundle.getMessage("4084", false, (Object[])new String[]{IPList[i], nodeList[i]});
            ReportUtil.printWarning(msg);
        }
    }

    private void reportMatrix(ConMatrix matrix) {
        String[] IPList = matrix.getIPList();
        String[] nodeList = matrix.getNodeList();
        String[] interfaceList = matrix.getInterfaceList();
        boolean[][] conTable = matrix.getMatrixForOutput();
        boolean headerPrinted = false;
        this.reportBadIP(matrix);
        for (int i = 0; i < nodeList.length; ++i) {
            for (int j = i; j < nodeList.length; ++j) {
                if (i == j) continue;
                if (!headerPrinted) {
                    ReportUtil.writeColHeaders_2eq(s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8007", false), s_msgBundle.getMessage("8008", false));
                    headerPrinted = true;
                }
                if (interfaceList == null) {
                    ReportUtil.writeRecord_2eq(nodeList[i] + "[" + IPList[i] + "]", nodeList[j] + "[" + IPList[j] + "]", this.bool2YesNo(conTable[i][j]));
                    continue;
                }
                ReportUtil.writeRecord_2eq(nodeList[i] + ":" + interfaceList[i], nodeList[j] + ":" + interfaceList[j], this.bool2YesNo(conTable[i][j]));
            }
        }
    }

    private void reportTCPMatrix(TCPMatrix matrix) {
        String serverName = matrix.getServerName();
        String serverIP = matrix.getServerIP();
        String[] IPList = matrix.getClientIPList();
        String[] clientList = matrix.getClientList();
        int[] TCPstatus = matrix.getTCPConmatrix();
        boolean headerPrinted = false;
        matrix.setStatus();
        for (int i = 0; i < clientList.length; ++i) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Processing: i: " + i + " server: " + serverName + ":" + serverIP + " client: " + clientList[i] + ":" + IPList[i] + " Status: " + TCPstatus[i]));
            }
            if (serverIP.contentEquals(IPList[i])) continue;
            if (!headerPrinted) {
                ReportUtil.writeColHeaders_2eq(s_msgBundle.getMessage("8006", false), s_msgBundle.getMessage("8007", false), s_msgBundle.getMessage("8008", false));
                headerPrinted = true;
            }
            String resStr = TCPstatus[i] == 0 ? ReportUtil.PASSED : (TCPstatus[i] == 1 ? ReportUtil.PARTIALLY_SUCCESSFUL : ReportUtil.FAILED);
            ReportUtil.writeRecord_2eq(serverName + ":" + serverIP, clientList[i] + ":" + IPList[i], resStr);
        }
    }

    private String bool2YesNo(boolean t) {
        if (t) {
            return ReportUtil.YES;
        }
        return ReportUtil.NO;
    }

    private void reportIfCon(ConMatrix matrix, String inf, int numNodes) {
        this.reportMatrix(matrix);
        String msg = matrix.getStatus() == 1 && matrix.getNodeList().length >= numNodes ? s_msgBundle.getMessage("4089", false, (Object[])new String[]{inf}) : s_msgBundle.getMessage("4090", false, (Object[])new String[]{inf});
        ReportUtil.printResult(msg);
    }

    private void reportNodeCon(ConMatrix matrix) {
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4091", false, (Object[])new String[]{matrix.getKey()}));
        this.reportMatrix(matrix);
        String[] nodeList = matrix.getUniqueNodeList();
        if (matrix.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("4092", false, (Object[])new String[]{matrix.getKey(), VerificationUtil.strArr2List(nodeList)}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4093", false, (Object[])new String[]{matrix.getKey()}));
        }
    }

    private void reportTCPCon(String subnet, TCPMatrix matrix) {
        ReportUtil.println(LSEP + LSEP + s_msgBundle.getMessage("4120", false, (Object[])new String[]{subnet}));
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Results - " + matrix.toString()));
        }
        this.reportTCPMatrix(matrix);
        if (matrix.getStatus() == 0) {
            ReportUtil.printResult(s_msgBundle.getMessage("4121", false, (Object[])new String[]{subnet}) + LSEP);
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("4122", false, (Object[])new String[]{subnet}) + LSEP);
        }
    }

    public void reportNodeInfo(Vector nodeInfoList) {
        boolean mtuDiff = false;
        String mtuVal = null;
        String errMsg = null;
        String[] mtuSubnetData = null;
        Hashtable<String, Vector<String[]>> mtuDiffTable = new Hashtable<String, Vector<String[]>>();
        Enumeration nodeEnum = nodeInfoList.elements();
        while (nodeEnum.hasMoreElements()) {
            boolean headerPrinted = false;
            NodeInfo nodeInfo = (NodeInfo)nodeEnum.nextElement();
            Enumeration ifEnum = nodeInfo.getInterfaceList().elements();
            while (ifEnum.hasMoreElements()) {
                if (!headerPrinted) {
                    headerPrinted = true;
                    ReportUtil.println(LSEP + LSEP + s_msgBundle.getMessage("4094", false, (Object[])new String[]{nodeInfo.getName()}));
                    ReportUtil.writeColHeaders(s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8011", false), s_msgBundle.getMessage("8050", false), s_msgBundle.getMessage("8051", false), s_msgBundle.getMessage("8049", false), s_msgBundle.getMessage("8052", false));
                }
                mtuSubnetData = new String[5];
                InterfaceInfo inf = (InterfaceInfo)ifEnum.nextElement();
                String infsubnet = inf.getSubnet();
                ReportUtil.writeRecord(inf.getName(), inf.getIP(), inf.getSubnet(), inf.getGateway(), inf.getDefGateway(), inf.getHWAddr(), inf.getMTU());
                Vector<String[]> mtuDiffVect = (Vector<String[]>)mtuDiffTable.get(infsubnet);
                mtuSubnetData[0] = nodeInfo.getName();
                mtuSubnetData[1] = inf.getSubnet();
                mtuSubnetData[2] = inf.getName();
                mtuSubnetData[3] = inf.getIP();
                mtuSubnetData[4] = inf.getMTU();
                if (mtuDiffVect == null) {
                    mtuDiffVect = new Vector<String[]>();
                }
                mtuDiffVect.add(mtuSubnetData);
                mtuDiffTable.put(infsubnet, mtuDiffVect);
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)("\n Added: Node:'" + mtuSubnetData[0] + "' Adapter:'" + mtuSubnetData[2] + "' IP:'" + mtuSubnetData[3] + "' MTU:" + mtuSubnetData[4] + "\nTo Subnet: " + infsubnet));
            }
        }
        Enumeration e = mtuDiffTable.keys();
        block2: while (e.hasMoreElements()) {
            String subnetInterface = (String)e.nextElement();
            Vector subnetVec = (Vector)mtuDiffTable.get(subnetInterface);
            mtuVal = null;
            for (int i = 0; i < subnetVec.size(); ++i) {
                String[] interfaceData = (String[])subnetVec.elementAt(i);
                if (mtuVal == null) {
                    mtuVal = interfaceData[4];
                    continue;
                }
                if (mtuVal.equals(interfaceData[4])) continue;
                this.m_resultSet.addResult(interfaceData[0], 3);
                errMsg = s_msgBundle.getMessage("6020", true, (Object[])new String[]{interfaceData[1]});
                ReportUtil.printError(errMsg);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Different MTU values on subnet: " + interfaceData[1]));
                }
                ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8009", false), s_msgBundle.getMessage("8010", false), s_msgBundle.getMessage("8052", false));
                for (int j = 0; j < subnetVec.size(); ++j) {
                    String[] mtuErr = (String[])subnetVec.elementAt(j);
                    ReportUtil.surewriteRecord(mtuErr[0], mtuErr[2], mtuErr[3], mtuErr[4]);
                }
                ReportUtil.sureprintln(LSEP);
                continue block2;
            }
        }
    }

    private Vector reportMultiNodeException(MultiNodeException mne, String[] nodeList) {
        Vector<String> goodNodes = new Vector<String>();
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            Collection throwables = mne.getThrowables(this.m_nodeList[i]);
            if (null == throwables) {
                goodNodes.add(this.m_nodeList[i]);
                continue;
            }
            this.m_resultSet.addResult(this.m_nodeList[i], 2);
            String errMsg = s_msgBundle.getMessage("4087", false);
            String cause = s_msgBundle.getMessage("6011", false, (Object[])new String[]{this.m_nodeList[i]});
            String action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{this.m_nodeList[i]});
            this.m_resultSet.getResult(this.m_nodeList[i]).addErrorDescription(new ErrorDescription(errMsg, cause, action));
            for (Throwable t : throwables) {
                ReportUtil.printError(t.getMessage());
            }
        }
        return goodNodes;
    }

    public String getDefaultElementName() {
        if (this.m_taskType == 0) {
            return s_msgBundle.getMessage("4402", false);
        }
        return s_msgBundle.getMessage("4401", false);
    }

    public String getDefaultDescription() {
        if (this.m_taskType == 0) {
            return s_msgBundle.getMessage("4452", false);
        }
        return s_msgBundle.getMessage("4451", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    InterfaceList: " + VerificationUtil.strArr2List(this.m_interfaceList));
        sb.append("\n    IPAddressList: " + VerificationUtil.strArr2List(this.m_IPAddrList));
        sb.append("\n    TaskType: " + (this.m_taskType == 0 ? "NODECON" : NODEREACH_KEY));
        sb.append("\n    SourceNode: " + this.m_srcNode);
        return sb.toString();
    }

    public void getNodeConnAPIData(List subnetList) {
        ArrayList<SubnetAndInterfaceInfoImpl> allSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        ArrayList<SubnetAndInterfaceInfoImpl> vipSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        ArrayList<SubnetAndInterfaceInfoImpl> privateSubAndInterfaceInfo = new ArrayList<SubnetAndInterfaceInfoImpl>(1);
        Trace.out((String)("subnetList.size(): " + subnetList.size() + " \n"));
        for (int j = 0; j < subnetList.size(); ++j) {
            String action;
            String cause;
            String errMsg;
            InetAddress inetAddr = null;
            InetAddress inetAddrSubnet = null;
            InetAddress inetAddrSubnet2 = null;
            InterfaceInfo inf2 = null;
            int netType = 4;
            ArrayList<NetworkInterfaceInfoImpl> interfaceInfo = new ArrayList<NetworkInterfaceInfoImpl>();
            Subnet subnet = (Subnet)subnetList.get(j);
            String subnetName = subnet.getSubnet();
            Trace.out((String)("Subnet: #" + j + " Name: " + subnetName));
            try {
                inetAddrSubnet = InetAddress.getByName(subnetName);
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)"Subnet: Unknown Host Exception... \n");
                errMsg = s_msgBundle.getMessage("6013", false);
                cause = s_msgBundle.getMessage("6014", false, (Object[])new String[]{subnetName});
                action = s_msgBundle.getMessage("6016", false, (Object[])new String[]{subnetName});
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
            }
            for (InterfaceInfo inf2 : subnet.getInterfaces()) {
                try {
                    inetAddrSubnet2 = InetAddress.getByName(inf2.getNetMask());
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)"Mask: Unknown Host Exception... \n");
                    errMsg = s_msgBundle.getMessage("6013", false);
                    cause = s_msgBundle.getMessage("6015", false, (Object[])new String[]{inf2.getNetMask()});
                    action = s_msgBundle.getMessage("6016", false, (Object[])new String[]{subnetName});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                }
                Trace.out((String)("Interface Name: " + inf2.getName() + " Type: " + inf2.getNetType()));
                netType = inf2.getNetType();
                try {
                    inetAddr = InetAddress.getByName(inf2.getIP());
                }
                catch (UnknownHostException uhe) {
                    Trace.out((String)"IP: Unknown Host Exception... \n");
                    errMsg = s_msgBundle.getMessage("6013", false);
                    cause = s_msgBundle.getMessage("6017", false, (Object[])new String[]{inf2.getIP()});
                    action = s_msgBundle.getMessage("6012", false, (Object[])new String[]{inf2.getNode()});
                    this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg, cause, action));
                }
                NetworkInterfaceInfoImpl newInterface = new NetworkInterfaceInfoImpl(inf2.getName(), inetAddr, inf2.getNode());
                interfaceInfo.add(newInterface);
            }
            Trace.out((String)("Number of Interface's: " + interfaceInfo.size()));
            SubnetAndInterfaceInfoImpl newSubnet = new SubnetAndInterfaceInfoImpl(inetAddrSubnet.getAddress(), inetAddrSubnet2.getAddress(), netType, interfaceInfo);
            allSubAndInterfaceInfo.add(newSubnet);
            if (newSubnet.getSubnetType() == 1) {
                privateSubAndInterfaceInfo.add(newSubnet);
                continue;
            }
            vipSubAndInterfaceInfo.add(newSubnet);
        }
        this.m_nodeConResSetImpl.setVIPInterfaces(vipSubAndInterfaceInfo);
        this.m_nodeConResSetImpl.setPrivateInterfaces(privateSubAndInterfaceInfo);
        this.m_nodeConResSetImpl.setAvailableSubnets(allSubAndInterfaceInfo);
        if (allSubAndInterfaceInfo == null) {
            this.m_resultSet.addErrorDescription(new ErrorDescription("6005", s_msgBundle));
        } else if (vipSubAndInterfaceInfo == null) {
            this.m_resultSet.addErrorDescription(new ErrorDescription("4101", s_msgBundle));
        } else if (privateSubAndInterfaceInfo == null) {
            this.m_resultSet.addErrorDescription(new ErrorDescription("4102", s_msgBundle));
        }
    }
}

