/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.OCRInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.GetSpaceCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOCRIntegrity
extends Task {
    public static final String OCR_VERSION = "Version";
    public static final String OCR_TOTAL_SPACE = "TotalSpace";
    public static final String OCR_ID = "ID";
    public static final String OCR_INTEGRITY = "Integrity";
    public static final String OCR_DEVICESTATUS = "DeviceStatus";
    public static final String OCR_INTEGRITY_TRUE = "True";
    public static final String OCR_INTEGRITY_FALSE = "False";
    private static boolean s_unix = new SystemFactory().CreateSystem().isUnixSystem();
    private static final String FILE_STATUS_FAILED = "1";

    public TaskOCRIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOCRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOCRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing OCR Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4039", false));
        this.performOCRIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4207", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4208", false));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void performOCRIntegrityChecks() {
        String[] ocrLocations;
        ErrorDescription errDesc;
        ResultSet ocrCheckResultSet = new ResultSet();
        Vector<String> failNodeVect = new Vector<String>();
        Vector<String> succNodeVect = new Vector<String>();
        GlobalExecution globalExec = new GlobalExecution();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        if (validNodeArr == null) {
            return;
        }
        ResultSet isLocalOnlyResultSet = new ResultSet();
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4040", false));
        succNodeVect.clear();
        failNodeVect.clear();
        boolean isLocalOnlyResult = globalExec.checkIsLocalOnly(validNodeArr, isLocalOnlyResultSet);
        Trace.out((String)"\n>>>> TaskOCRIntegrity:: Upload isLocalOnlyResultSet >>>>\n");
        this.m_resultSet.uploadResultSet(isLocalOnlyResultSet);
        Trace.out((String)"AFTER CSS multi-instance verification ... ");
        Hashtable t = isLocalOnlyResultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) continue;
            boolean isLocalOnly = (Boolean)result.getResultInfoSet().firstElement();
            if (isLocalOnly) {
                failNodeVect.add(node);
                Trace.out((String)("CSS is probably configured as Local Instance Only on node: " + node));
                continue;
            }
            succNodeVect.add(node);
            Trace.out((String)("CSS correctly configured for multi Instance on node: " + node));
        }
        if (failNodeVect.size() != 0) {
            if (succNodeVect.size() == 0) {
                ReportUtil.printError(s_msgBundle.getMessage("4041", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                this.m_resultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc2 = new ErrorDescription("4041", s_msgBundle);
                this.m_resultSet.addErrorDescription(errDesc2);
                int i = 0;
                while (i < validNodeArr.length) {
                    String node = validNodeArr[i];
                    errDesc2 = new ErrorDescription(s_msgBundle.getMessage("7596", true, (Object[])new String[]{node}), s_msgBundle, "7596");
                    this.m_resultSet.addErrorDescription(node, errDesc2);
                    ++i;
                }
                return;
            }
            ReportUtil.printWarning(s_msgBundle.getMessage("4042", false));
            ReportUtil.sureprintNodelist(failNodeVect);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(succNodeVect);
            String[] invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
            if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                this.m_resultSet.addResult(invalidNodeArr, 2);
                for (int i = 0; i < invalidNodeArr.length; ++i) {
                    String node = invalidNodeArr[i];
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7596", true, (Object[])new String[]{node}), s_msgBundle, "7596");
                    this.m_resultSet.addErrorDescription(node, errDesc);
                }
            }
            validNodeArr = succNodeVect.toArray(new String[succNodeVect.size()]);
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4200", false) + LSEP);
        }
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            errDesc = new ErrorDescription("5300", s_msgBundle);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        if (VerificationUtil.isVersionPre(activeCRSVer, "11.2")) {
            this.performOcrcheckBasedChecks(validNodeArr, ocrCheckResultSet);
            this.m_resultSet.uploadResultSet(ocrCheckResultSet);
            return;
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        Version currentVersion = new Version();
        String ocrConfigLocation = nativeSystem.getConfigLocation(currentVersion);
        OCRInfo ocrInfo = null;
        try {
            ocrInfo = ClusterInfo.getOCRLocations((Version)currentVersion);
        }
        catch (ClusterInfoException cie) {
            if (Trace.isTraceEnabled()) {
                Trace.out((Exception)((Object)cie));
            }
            Trace.out((String)"ClusterInfoException trying to get OCR locations");
            String msg = s_msgBundle.getMessage("5196", true) + cie.getMessage();
            ReportUtil.printError(msg);
            this.m_resultSet.addErrorDescription(new ErrorDescription("5196", s_msgBundle));
            this.m_resultSet.addResult(validNodeArr, 2);
            return;
        }
        boolean ocrOnASM = false;
        for (String ocrLocation : ocrLocations = ocrInfo.getPaths()) {
            if (!VerificationUtil.isASMPath(ocrLocation)) continue;
            ocrOnASM = true;
            break;
        }
        Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT = new Hashtable<String, List<ASMDiskGroup>>();
        if (ocrOnASM) {
            ArrayList<String> runningASMNodes = new ArrayList<String>();
            ArrayList<String> failedASMNodes = new ArrayList<String>();
            ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil(this.m_nodeList);
            for (String node : this.m_nodeList) {
                try {
                    Trace.out((int)5, (String)("Checking if ASM is running on node " + node));
                    boolean asmrunning = asmdg.isASMRunning(node);
                    if (asmrunning) {
                        Trace.out((int)5, (String)("ASM is running on node " + node));
                        runningASMNodes.add(node);
                        this.m_resultSet.addResult(node, 1);
                        continue;
                    }
                    Trace.out((int)5, (String)("ASM is NOT running on node " + node));
                    failedASMNodes.add(node);
                    this.m_resultSet.addResult(node, 3);
                }
                catch (ASMDiskGroupsUtilException e1) {
                    this.m_resultSet.addResult(node, 2);
                    failedASMNodes.add(node);
                    Trace.out((int)5, (String)("Error checking if ASM is running on node " + node + "." + e1));
                }
            }
            if (failedASMNodes.size() > 0) {
                if (runningASMNodes.size() <= 0) {
                    ReportUtil.printError(LSEP + s_msgBundle.getMessage("4194", true) + LSEP);
                    return;
                }
                ReportUtil.printError(LSEP + s_msgBundle.getMessage("4193", true) + LSEP);
                ReportUtil.printErrorNodes(failedASMNodes.toArray(new String[0]));
                validNodeArr = runningASMNodes.toArray(new String[0]);
            } else {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5108", false));
            }
            ASMDiskGroupsUtil dgutil = new ASMDiskGroupsUtil(validNodeArr);
            try {
                dgutil.getDiskGroups(validNodeArr, this.m_resultSet, asmDiskGroupHT);
            }
            catch (ASMDiskGroupsUtilException e2) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5131", true));
                this.m_resultSet.setStatus();
                return;
            }
        }
        if (s_unix) {
            ResultSet ocrConfigLocRS = new ResultSet();
            this.performOCRLocCheck(validNodeArr, ocrConfigLocation, ocrConfigLocRS);
            this.m_resultSet.uploadResultSet(ocrConfigLocRS);
        }
        String[] arr$ = ocrLocations;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block38: {
                if (i$ >= len$) {
                    if (!this.m_resultSet.allSuccess()) return;
                    ReportUtil.printWarning(s_msgBundle.getMessage("4197", false));
                    return;
                }
                String ocrLocation = arr$[i$];
                boolean verifySharedness = true;
                StorageInfo stInfo = null;
                try {
                    stInfo = new TypeFinder().getStorageInstance(ocrLocation);
                }
                catch (StorageException e1) {
                    Trace.out((String)("StorageException encountered: " + e1));
                    String mesg = s_msgBundle.getMessage("4125", true, (Object[])new String[]{ocrLocation});
                    ErrorDescription errorDesc = new ErrorDescription(mesg);
                    this.m_resultSet.addErrorDescription(errorDesc);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    ReportUtil.printError(mesg + LSEP);
                    break block38;
                }
                ResultSet ocrConfigRS = new ResultSet();
                this.performOCRConfigurationChecks(validNodeArr, ocrLocation, stInfo, ocrConfigRS, asmDiskGroupHT);
                this.m_resultSet.uploadResultSet(ocrConfigRS);
                int storageType = stInfo.getType();
                Trace.out((String)("_st_ = " + stInfo.getType()));
                switch (storageType) {
                    case 2: 
                    case 7: 
                    case 8: 
                    case 13: {
                        break;
                    }
                    case 1: {
                        if (!VerificationUtil.getCurrentOS().equalsIgnoreCase("HP-UX")) break;
                        verifySharedness = false;
                        break;
                    }
                    default: {
                        verifySharedness = false;
                    }
                }
                if (!verifySharedness) {
                    Trace.out((String)("not checking sharedness for " + ocrLocation));
                } else {
                    ResultSet ocrSharednessRS = new ResultSet();
                    this.performOCRSharednessCheck(validNodeArr, ocrLocation, ocrSharednessRS);
                    this.m_resultSet.uploadResultSet(ocrSharednessRS);
                    if (!ocrSharednessRS.anyFailure()) {
                        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4163", false, (Object[])new String[]{ocrLocation}) + LSEP);
                        ResultSet ocrSizeRS = new ResultSet();
                        Trace.out((String)("\nNodes: " + VerificationUtil.strArr2String(validNodeArr) + "\nocrLocation: " + ocrLocation + "\nStorageType: " + storageType + "\nasmDiskGroupHT: " + asmDiskGroupHT.toString() + "\n"));
                        this.performOCRSizeCheck(validNodeArr, ocrLocation, stInfo, ocrSizeRS, asmDiskGroupHT);
                        this.m_resultSet.uploadResultSet(ocrSizeRS);
                    }
                }
            }
            ++i$;
        }
    }

    private void performOCRSizeCheck(String[] nodeList, String ocrLocation, StorageInfo stInfo, ResultSet resultSet, Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT) {
        int nodeCount = 1;
        Command[] cmdArray = new Command[nodeCount];
        StorageSize requiredOCRSize = new StorageSize(Long.parseLong(VDMUtil.getDefaultOcrSize()), StorageUnit.BYTE);
        if (stInfo.getType() == 13) {
            for (String node : nodeList) {
                List<ASMDiskGroup> dgl = asmDiskGroupHT.get(node);
                boolean founddg = false;
                if (dgl != null && dgl.size() > 0) {
                    for (ASMDiskGroup dg1 : dgl) {
                        String mesg;
                        if (!ocrLocation.equalsIgnoreCase("+" + dg1.getName())) continue;
                        founddg = true;
                        StorageSize totalSpace = dg1.getSize();
                        Trace.out((String)("OCR size required=" + requiredOCRSize + " available=" + totalSpace));
                        if (totalSpace.compareTo(requiredOCRSize) >= 0) {
                            mesg = s_msgBundle.getMessage("4161", false, (Object[])new String[]{ocrLocation});
                            ReportUtil.sureprintln(node + ":" + mesg);
                            resultSet.addResult(nodeList, 1);
                            continue;
                        }
                        mesg = s_msgBundle.getMessage("4164", true, (Object[])new String[]{ocrLocation, requiredOCRSize.toString(), totalSpace.toString()});
                        ErrorDescription errorDesc = new ErrorDescription(mesg);
                        resultSet.addErrorDescription(errorDesc);
                        resultSet.addResult(nodeList, 3);
                        ReportUtil.printError(node + ":" + mesg + LSEP);
                    }
                }
                if (founddg) continue;
                String mesg = s_msgBundle.getMessage("4162", true, (Object[])new String[]{ocrLocation});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                resultSet.addErrorDescription(errorDesc);
                resultSet.addResult(nodeList, 2);
                ReportUtil.printError(mesg + LSEP);
            }
        } else {
            String locationTocheck = ocrLocation;
            File ocrFile = new File(locationTocheck);
            boolean useSignature = false;
            if (!s_unix) {
                if (stInfo.getType() == 1) {
                    useSignature = true;
                    locationTocheck = stInfo.getSignature();
                } else if (!ocrFile.isDirectory()) {
                    try {
                        stInfo = new TypeFinder().getStorageInstance(ocrFile.getParent());
                        locationTocheck = ocrFile.getParent();
                    }
                    catch (StorageException e1) {
                        Trace.out((String)("StorageException encountered: " + e1));
                        String mesg = s_msgBundle.getMessage("4125", true, (Object[])new String[]{ocrLocation}) + e1.getMessage();
                        ErrorDescription errorDesc = new ErrorDescription(mesg);
                        this.m_resultSet.addErrorDescription(errorDesc);
                        this.m_resultSet.addResult(nodeList, 2);
                        ReportUtil.printError(mesg + LSEP);
                        return;
                    }
                }
            }
            for (int i = 0; i < nodeCount; ++i) {
                cmdArray[i] = useSignature ? new GetSpaceCommand(nodeList[i], locationTocheck, stInfo.getType()) : new GetSpaceCommand(nodeList[i], locationTocheck, stInfo.getName(), stInfo.getType());
            }
            boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, resultSet);
            if (!cmdResult) {
                String mesg = s_msgBundle.getMessage("4162", true, (Object[])new String[]{ocrLocation});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                resultSet.addErrorDescription(errorDesc);
                resultSet.addResult(nodeList, 2);
                ReportUtil.printError(mesg + LSEP);
                return;
            }
            Hashtable t = resultSet.getResultTable();
            Enumeration nodeKeys = t.keys();
            while (nodeKeys.hasMoreElements()) {
                ErrorDescription errorDesc;
                String mesg;
                String node = (String)nodeKeys.nextElement();
                Result result = (Result)t.get(node);
                if (result.getStatus() != 1) {
                    String mesg2 = s_msgBundle.getMessage("4162", true, (Object[])new String[]{ocrLocation});
                    ErrorDescription errorDesc2 = new ErrorDescription(mesg2);
                    resultSet.setStatus(2);
                    resultSet.addErrorDescription(errorDesc2);
                    resultSet.addResult(nodeList, 2);
                    ReportUtil.printError(mesg2 + LSEP);
                    continue;
                }
                StorageSize totalSpace = new StorageSize(0.0, StorageUnit.BYTE);
                try {
                    StorageInfo st = (StorageInfo)result.getResultInfoSet().get(1);
                    totalSpace = st.getSize();
                    Trace.out((String)("StorageInfoType.getTypeStr() = " + st.getTypeStr() + "StorageInfoType.getType() = " + st.getType()));
                    Trace.out((String)("OCR size required=" + requiredOCRSize + " available=" + totalSpace));
                    if (totalSpace.compareTo(requiredOCRSize) >= 0) {
                        mesg = s_msgBundle.getMessage("4161", false, (Object[])new String[]{ocrLocation});
                        ReportUtil.sureprintln(mesg);
                        continue;
                    }
                    mesg = s_msgBundle.getMessage("4164", true, (Object[])new String[]{ocrLocation, Double.toString(requiredOCRSize.sizeIn(StorageUnit.BYTE)), Double.toString(totalSpace.sizeIn(StorageUnit.BYTE))});
                    errorDesc = new ErrorDescription(mesg);
                    resultSet.addErrorDescription(errorDesc);
                    resultSet.addResult(nodeList, 3);
                    ReportUtil.printError(mesg + LSEP);
                }
                catch (NoSuchElementException e) {
                    Trace.out((String)e.getMessage());
                    mesg = s_msgBundle.getMessage("4165", true, (Object[])new String[]{ocrLocation});
                    errorDesc = new ErrorDescription(mesg);
                    resultSet.addErrorDescription(errorDesc);
                    resultSet.addResult(nodeList, 2);
                    ReportUtil.printError(mesg + LSEP);
                }
                catch (NumberFormatException e) {
                    Trace.out((String)e.getMessage());
                    mesg = s_msgBundle.getMessage("4165", true, (Object[])new String[]{ocrLocation});
                    errorDesc = new ErrorDescription(mesg);
                    resultSet.addErrorDescription(errorDesc);
                    resultSet.addResult(nodeList, 2);
                    ReportUtil.printError(mesg + LSEP);
                }
            }
        }
    }

    private void performOCRSharednessCheck(String[] nodeList, String ocrLocation, ResultSet resultSet) {
        if (VerificationUtil.isASMPath(ocrLocation)) {
            resultSet.addResult(nodeList, 1);
            return;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4166", false, (Object[])new String[]{ocrLocation}) + LSEP);
        VerifyStorage checkPathSt = new VerifyStorage();
        try {
            if (checkPathSt.isShared(ocrLocation, nodeList, OracleFileType.RAC_OCR_VDISK)) {
                String mesg = s_msgBundle.getMessage("4167", false, (Object[])new String[]{ocrLocation});
                ReportUtil.sureprintln(mesg + LSEP);
                resultSet.addResult(nodeList, 1);
            } else {
                String mesg = s_msgBundle.getMessage("4168", true, (Object[])new String[]{ocrLocation});
                ErrorDescription errorDesc = new ErrorDescription(mesg);
                resultSet.addErrorDescription(errorDesc);
                resultSet.addResult(nodeList, 3);
                ReportUtil.printError(mesg + LSEP);
            }
        }
        catch (StorageException e) {
            Trace.out((Exception)e);
            String mesg = s_msgBundle.getMessage("4172", true, (Object[])new String[]{ocrLocation}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(mesg);
            resultSet.addErrorDescription(errorDesc);
            resultSet.addResult(nodeList, 2);
            ReportUtil.printError(mesg + LSEP);
            return;
        }
        catch (MultiNodeException e) {
            Trace.out((Exception)e);
            String mesg = s_msgBundle.getMessage("4172", true, (Object[])new String[]{ocrLocation}) + LSEP + e.getMessage();
            ErrorDescription errorDesc = new ErrorDescription(mesg);
            resultSet.addErrorDescription(errorDesc);
            resultSet.addResult(nodeList, 2);
            ReportUtil.printError(mesg + LSEP);
            return;
        }
    }

    private void performOCRConfigurationChecks(String[] validNodeArr, String ocrLocation, StorageInfo stInfo, ResultSet ocrConfigCheckResultSet, Hashtable<String, List<ASMDiskGroup>> asmDiskGroupHT) {
        if (!s_unix && stInfo.getType() == 1) {
            ocrConfigCheckResultSet.addResult(validNodeArr, 1);
            return;
        }
        ArrayList<String> fileList = new ArrayList<String>();
        if (!VerificationUtil.isASMPath(ocrLocation)) {
            fileList.add(ocrLocation);
        }
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        if (fileList.size() > 0) {
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet fileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(validNodeArr, fileList, fileInfoResultSet);
            ocrConfigCheckResultSet.uploadResultSet(fileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                fileInfoResultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                fileInfoResultSet.addErrorDescription(errDesc);
                return;
            }
            Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
            for (String node : validNodeArr) {
                Result result = (Result)fileInforResultTable.get(node);
                if (result == null || result.getStatus() != 1) continue;
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                nodeFileInfo.put(node, nodeFileList);
            }
        }
        if (!VerificationUtil.isASMPath(ocrLocation)) {
            String mesg;
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4176", false, (Object[])new String[]{ocrLocation}));
            Hashtable<String, List<String>> failedOcrNodes = this.checkFileAttributes(validNodeArr, ocrLocation, nodeFileInfo, VDMUtil.getDefaultOcrOwner(), VerificationUtil.getOraInventoryGroup(), VDMUtil.getDefaultOcrPermissions(), ocrConfigCheckResultSet);
            if (failedOcrNodes.keySet().size() != 0) {
                mesg = s_msgBundle.getMessage("4178", true, (Object[])new String[]{ocrLocation});
                ReportUtil.printError(mesg);
                ReportUtil.printErrorNodes(failedOcrNodes.keySet().toArray(new String[0]));
                for (String node : failedOcrNodes.keySet()) {
                    List<String> failedNodeErrors = failedOcrNodes.get(node);
                    ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strCollection2String(failedNodeErrors, ";"));
                    ocrConfigCheckResultSet.addResult(node, 3);
                    for (String error : failedNodeErrors) {
                        ocrConfigCheckResultSet.addErrorDescription(node, new ErrorDescription(error));
                    }
                }
            } else {
                mesg = s_msgBundle.getMessage("4177", false, (Object[])new String[]{ocrLocation});
                ReportUtil.sureprintln(LSEP + mesg + LSEP);
            }
        } else {
            Vector<String> dgUnavailNodes = new Vector<String>();
            for (String node : this.m_nodeList) {
                List<ASMDiskGroup> dgl = asmDiskGroupHT.get(node);
                if (dgl == null || dgl.size() < 1) {
                    dgUnavailNodes.add(node);
                    continue;
                }
                boolean founddg = false;
                for (ASMDiskGroup dg1 : dgl) {
                    if (!ocrLocation.equalsIgnoreCase("+" + dg1.getName())) continue;
                    founddg = true;
                }
                if (founddg) continue;
                dgUnavailNodes.add(node);
            }
            if (dgUnavailNodes.size() > 0) {
                ReportUtil.printError(LSEP + s_msgBundle.getMessage("4195", true, (Object[])new String[]{ocrLocation}) + LSEP);
                ReportUtil.printErrorNodes(dgUnavailNodes);
            } else {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4196", false, (Object[])new String[]{ocrLocation}) + LSEP);
            }
        }
    }

    private void performOCRLocCheck(String[] validNodeArr, String ocrConfigLocation, ResultSet ocrConfigCheckResultSet) {
        String mesg;
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(ocrConfigLocation);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4173", false, (Object[])new String[]{ocrConfigLocation}));
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet fileInfoResultSet = new ResultSet();
        boolean fileInfoResult = globalExec.getFileInfo(validNodeArr, fileList, fileInfoResultSet);
        Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfo = new Hashtable<String, Hashtable<String, FileInfo>>();
        ocrConfigCheckResultSet.uploadResultSet(fileInfoResultSet);
        Trace.out((String)"After calling globalExec.getFileInfo() ... ");
        if (!fileInfoResult) {
            ReportUtil.printError(s_msgBundle.getMessage("4160", false));
            fileInfoResultSet.addResult(validNodeArr, 2);
            ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
            fileInfoResultSet.addErrorDescription(errDesc);
            return;
        }
        Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
        for (String node : validNodeArr) {
            Result result = (Result)fileInforResultTable.get(node);
            if (result == null || result.getStatus() != 1) continue;
            Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
            nodeFileInfo.put(node, nodeFileList);
        }
        Trace.out((String)"Checking ocr.loc attributes");
        Hashtable<String, List<String>> failedOcrLocNodes = this.checkFileAttributes(validNodeArr, ocrConfigLocation, nodeFileInfo, VDMUtil.getDefaultOcrLocOwner(), VerificationUtil.getOraInventoryGroup(), VDMUtil.getDefaultOcrLocPermissions(), ocrConfigCheckResultSet);
        if (failedOcrLocNodes.keySet().size() != 0) {
            mesg = s_msgBundle.getMessage("4175", true, (Object[])new String[]{ocrConfigLocation});
            ReportUtil.printError(mesg);
            ReportUtil.printErrorNodes(failedOcrLocNodes.keySet().toArray(new String[0]));
            for (String node : failedOcrLocNodes.keySet()) {
                List<String> failedNodeErrors = failedOcrLocNodes.get(node);
                ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strCollection2String(failedNodeErrors, ";"));
                ocrConfigCheckResultSet.addResult(node, 3);
                for (String error : failedNodeErrors) {
                    ocrConfigCheckResultSet.addErrorDescription(node, new ErrorDescription(error));
                }
            }
        } else {
            mesg = s_msgBundle.getMessage("4174", false, (Object[])new String[]{ocrConfigLocation});
            ReportUtil.sureprintln(LSEP + mesg + LSEP);
        }
    }

    private Hashtable<String, List<String>> checkFileAttributes(String[] validNodeArr, String ocrLocation, Hashtable<String, Hashtable<String, FileInfo>> nodeFileInfoTable, String refOwner, String refGroup, String refPermissions, ResultSet resultSet) {
        Hashtable<String, List<String>> failedNodes = new Hashtable<String, List<String>>();
        ArrayList<String> nodeErrors = null;
        for (String node : validNodeArr) {
            nodeErrors = new ArrayList<String>();
            Hashtable<String, FileInfo> nodeFileList = nodeFileInfoTable.get(node);
            if (nodeFileList != null) {
                ErrorDescription error;
                String errorMessage;
                boolean nodeFailed = false;
                FileInfo nodeFileInfo = nodeFileList.get(ocrLocation);
                if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) {
                    resultSet.addResult(node, 3);
                    ErrorDescription error2 = new ErrorDescription(nodeFileInfo.getErrorString());
                    resultSet.addErrorDescription(node, error2);
                    nodeErrors.add(nodeFileInfo.getErrorString());
                    failedNodes.put(node, nodeErrors);
                    nodeFailed = true;
                    continue;
                }
                if (refOwner != null && refOwner.length() > 0 && !nodeFileInfo.getFileOwner().equalsIgnoreCase(refOwner)) {
                    resultSet.addResult(node, 3);
                    errorMessage = s_msgBundle.getMessage("5005", false, (Object[])new String[]{nodeFileInfo.getFileName(), refOwner, nodeFileInfo.getFileOwner()});
                    error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                }
                if (refGroup != null && refGroup.length() > 0 && !nodeFileInfo.getFileGroup().equalsIgnoreCase(refGroup)) {
                    resultSet.addResult(node, 3);
                    errorMessage = s_msgBundle.getMessage("5007", false, (Object[])new String[]{nodeFileInfo.getFileName(), refGroup, nodeFileInfo.getFileGroup()});
                    error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                }
                if (refPermissions != null && refPermissions.length() > 0 && Integer.parseInt(nodeFileInfo.getFilePermissions(), 8) != Integer.parseInt(refPermissions, 8)) {
                    resultSet.addResult(node, 3);
                    errorMessage = s_msgBundle.getMessage("5009", false, (Object[])new String[]{nodeFileInfo.getFileName(), refPermissions, nodeFileInfo.getFilePermissions()});
                    error = new ErrorDescription(errorMessage);
                    resultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                }
                if (!nodeFailed) continue;
                failedNodes.put(node, nodeErrors);
                continue;
            }
            String error = s_msgBundle.getMessage("4160", false);
            nodeErrors.add(error);
            failedNodes.put(node, nodeErrors);
        }
        return failedNodes;
    }

    /*
     * Unable to fully structure code
     */
    private void performOcrcheckBasedChecks(String[] nodeList, ResultSet ocrCheckResultSet) {
        globalExec = new GlobalExecution();
        versionTable = new Hashtable<Object, Vector<Object>>();
        idTable = new Hashtable<Object, Vector<Object>>();
        totalSpaceTable = new Hashtable<Object, Vector<Object>>();
        integrityTable = new Hashtable<Object, Vector<Object>>();
        deviceTable = new Hashtable<Object, Vector<Object>>();
        failNodeVect = new Vector<String>();
        succNodeVect = new Vector<String>();
        ocrCheckResult = globalExec.checkOCRIntegrity(nodeList, ocrCheckResultSet);
        Trace.out((String)"\n>>>> TaskOCRIntegrity:: Upload ocrCheckResultSet >>>>\n");
        this.m_resultSet.uploadResultSet(ocrCheckResultSet);
        Trace.out((String)"TaskOCRIntegrity: After calling checkOCRIntegrity() ... ");
        if (!ocrCheckResult || !ocrCheckResultSet.anySuccess()) {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4043", false) + TaskOCRIntegrity.LSEP);
            this.m_resultSet.addResult(nodeList, 2);
            errDesc = new ErrorDescription("4043", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            for (i = 0; i < nodeList.length; ++i) {
                node = nodeList[i];
                errDesc = new ErrorDescription(TaskOCRIntegrity.s_msgBundle.getMessage("7597", true, (Object[])new String[]{node}), TaskOCRIntegrity.s_msgBundle, "7597");
                this.m_resultSet.addErrorDescription(node, errDesc);
            }
            return;
        }
        t = ocrCheckResultSet.getResultTable();
        e = t.keys();
        succNodeVect.clear();
        failNodeVect.clear();
        while (e.hasMoreElements()) {
            node = (String)e.nextElement();
            result = (Result)t.get(node);
            val = null;
            devStat = null;
            if (result.getStatus() == 1) {
                Trace.out((String)("Checking 'ocrcheck'output for node: '" + node + "'"));
                succNodeVect.add(node);
                rt = (Hashtable)result.getResultInfoSet().firstElement();
                e_rt = rt.keys();
                while (e_rt.hasMoreElements()) {
                    key = (String)e_rt.nextElement();
                    if (key.equalsIgnoreCase("DeviceStatus")) {
                        devStat = (Vector)rt.get(key);
                        Trace.out((String)("\t" + key + "==>" + VerificationUtil.strVect2List(devStat)));
                    } else {
                        val = (String)rt.get(key);
                        Trace.out((String)("\t" + key + "==>" + val));
                    }
                    if (key.equalsIgnoreCase("Version")) {
                        VerificationUtil.updateResultMap(versionTable, val, node);
                        continue;
                    }
                    if (key.equalsIgnoreCase("TotalSpace")) {
                        VerificationUtil.updateResultMap(totalSpaceTable, val, node);
                        continue;
                    }
                    if (key.equalsIgnoreCase("ID")) {
                        VerificationUtil.updateResultMap(idTable, val, node);
                        continue;
                    }
                    if (key.equalsIgnoreCase("Integrity")) {
                        VerificationUtil.updateResultMap(integrityTable, val, node);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("DeviceStatus") || devStat.size() <= 0) continue;
                    for (i = 0; i < devStat.size(); ++i) {
                        VerificationUtil.updateResultMap(deviceTable, devStat.elementAt(i), node);
                    }
                }
                continue;
            }
            failNodeVect.add(node);
            Trace.out((String)("OCR details couldn't be obtained from node: '" + node + "'"));
        }
        if (failNodeVect.size() == 0) {
            Trace.out((String)"'ocrcheck' successfully run on all the nodes");
        } else {
            Trace.out((String)("Failure in running 'ocrcheck' on the nodes: " + VerificationUtil.strVect2List(failNodeVect)));
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4044", false));
            ReportUtil.sureprintNodelist(failNodeVect);
            invalidNodeArr = failNodeVect.toArray(new String[failNodeVect.size()]);
            if (invalidNodeArr != null && invalidNodeArr.length != 0) {
                this.m_resultSet.addResult(invalidNodeArr, 2);
                for (i = 0; i < invalidNodeArr.length; ++i) {
                    node = invalidNodeArr[i];
                    errDesc = new ErrorDescription(TaskOCRIntegrity.s_msgBundle.getMessage("7597", true, (Object[])new String[]{node}), TaskOCRIntegrity.s_msgBundle, "7597");
                    this.m_resultSet.addErrorDescription(node, errDesc);
                }
            }
            if (succNodeVect.size() == 0) {
                this.m_resultSet.addResult(nodeList, 2);
                return;
            }
            ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(succNodeVect);
        }
        Trace.out((String)("Result of OCR Integrity check for nodes: " + VerificationUtil.strVect2List(succNodeVect) + " >>>>>>"));
        if (deviceTable.size() != 0) {
            ReportUtil.printWarning(TaskOCRIntegrity.s_msgBundle.getMessage("4213", false));
            e = deviceTable.keys();
            while (e.hasMoreElements()) {
                devMsg = (String)e.nextElement();
                ReportUtil.sureprintln(devMsg);
            }
        }
        Trace.out((String)("idTable.size() = " + idTable.size()));
        if (idTable.size() == 1) {
            Trace.out((String)("Same ID ('" + idTable.keys().nextElement() + "') obtained from all the nodes"));
            ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4204", false));
        } else if (idTable.size() != 0) {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4046", true) + TaskOCRIntegrity.LSEP);
            errDesc = new ErrorDescription("4046", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            e = idTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                nodeListStr = VerificationUtil.strVect2List((Vector)idTable.get(key));
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4047", false, (Object[])new String[]{key, nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
            return;
        }
        ReportUtil.sureprintln(TaskOCRIntegrity.LSEP + TaskOCRIntegrity.s_msgBundle.getMessage("4201", false));
        correctVersion = VDMUtil.getDefaultOCRVersion();
        if (versionTable.size() == 1) {
            versionFound = (String)versionTable.keys().nextElement();
            Trace.out((String)("Same Version ('" + versionFound + "') obtained from for all the nodes"));
            if (!versionFound.equalsIgnoreCase(correctVersion)) {
                errMsg = TaskOCRIntegrity.s_msgBundle.getMessage("4048", true, (Object[])new String[]{versionFound, correctVersion});
                Trace.out((String)("Incorrect Version of OCR found for all the nodes (versionFound=" + versionFound + " ; correctVersion=" + correctVersion));
                ReportUtil.printError(errMsg);
                this.m_resultSet.addResult(nodeList, 2);
                errDesc = new ErrorDescription(errMsg, TaskOCRIntegrity.s_msgBundle, "4048");
                this.m_resultSet.addErrorDescription(errDesc);
                return;
            }
        } else {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4049", true) + TaskOCRIntegrity.LSEP);
            errDesc = new ErrorDescription("4049", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            e = versionTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                nodeListStr = VerificationUtil.strVect2List(versionTable.get(key));
                if (key.equalsIgnoreCase(correctVersion)) {
                    ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4050", false, (Object[])new String[]{key, nodeListStr}));
                    continue;
                }
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4051", false, (Object[])new String[]{key, nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
            return;
        }
        Trace.out((String)("Correct Version of OCR ('" + versionFound + "') found for all the nodes"));
        ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4202", false, (Object[])new String[]{versionFound}));
        if (totalSpaceTable.size() != 1) {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4052", true) + TaskOCRIntegrity.LSEP);
            e = totalSpaceTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                nodeListStr = VerificationUtil.strVect2List(totalSpaceTable.get(key));
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4053", false, (Object[])new String[]{key, nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
            return;
        }
        totalSpaceFound = (String)totalSpaceTable.keys().nextElement();
        Trace.out((String)("Same total space ('" + totalSpaceFound + "') obtained from for all the nodes"));
        ReportUtil.sureprintln(TaskOCRIntegrity.LSEP + TaskOCRIntegrity.s_msgBundle.getMessage("4205", false));
        if (integrityTable.size() != 1) ** GOTO lbl167
        key = (String)integrityTable.keys().nextElement();
        validIntegrity = key.equalsIgnoreCase("True");
        if (validIntegrity) {
            ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4206", false));
        } else {
            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4055", true) + TaskOCRIntegrity.LSEP);
            errDesc = new ErrorDescription("4055", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(nodeList, 2);
            return;
lbl167:
            // 1 sources

            ReportUtil.printError(TaskOCRIntegrity.s_msgBundle.getMessage("4056", true));
            errDesc = new ErrorDescription("4056", TaskOCRIntegrity.s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            e = integrityTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                keyVal = integrityTable.get(key);
                nodeListStr = VerificationUtil.strVect2List(keyVal);
                if (key.equalsIgnoreCase("True")) {
                    ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4057", false, (Object[])new String[]{nodeListStr}));
                    continue;
                }
                if (!key.equalsIgnoreCase("False")) continue;
                ReportUtil.sureprintln(TaskOCRIntegrity.s_msgBundle.getMessage("4058", false, (Object[])new String[]{nodeListStr}));
            }
            this.m_resultSet.addResult(nodeList, 2);
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4424", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4475", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

