/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOLRIntegrity
extends Task {
    private static final String FILE_STATUS_FAILED = "1";
    private static MessageBundle s_prkcMsgBundle = MessageBundle.getMessageBundle((String)"Prkc");
    public String m_homeType = new String("BOTH");

    public TaskOLRIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskOLRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskOLRIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setHomeType(String homeType) {
        this.m_homeType = homeType;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing OLR Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4109", false));
        this.performOLRIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printWarning(s_msgBundle.getMessage("4198", false));
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4110", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4111", false));
        return false;
    }

    void performOLRIntegrityChecks() {
        String olrHome = null;
        ResultSet olrConfigRS = new ResultSet();
        ArrayList<String> nodeList = new ArrayList<String>();
        String[] validNodeArr = null;
        olrHome = VerificationUtil.getHAorCRSHome(this.m_nodeList, this.m_homeType, nodeList, olrConfigRS);
        this.m_resultSet.uploadResultSet(olrConfigRS);
        if (olrHome == null) {
            Trace.out((int)5, (String)"Could not determine OLR home...");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        Trace.out((int)5, (String)("OLR home is: '" + olrHome + "'"));
        validNodeArr = nodeList.toArray(new String[nodeList.size()]);
        this.performOLRConfigurationChecks(validNodeArr, olrConfigRS, olrHome);
        this.m_resultSet.uploadResultSet(olrConfigRS);
    }

    private void performOLRConfigurationChecks(String[] nodeList, ResultSet resultSet, String haHome) {
        String mesg;
        String mesg2;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4182", false));
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable<Object, Object> failedOlrLocNodes = null;
        if (nativeSys.isUnixSystem()) {
            String olrLocFileName = nativeSys.getOLRConfigLocation("localnode", null);
            ArrayList<String> fileList = new ArrayList<String>();
            fileList.add(olrLocFileName);
            Trace.out((int)5, (String)("olrLocFileName: '" + olrLocFileName + "'"));
            ResultSet olrLocFileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(nodeList, fileList, olrLocFileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!fileInfoResult) {
                olrLocFileInfoResultSet.addResult(nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                olrLocFileInfoResultSet.addErrorDescription(errDesc);
                ReportUtil.printError(s_msgBundle.getMessage("4160", false) + LSEP);
                resultSet.uploadResultSet(olrLocFileInfoResultSet);
                return;
            }
            Trace.out((String)"Checking olr.loc attributes");
            failedOlrLocNodes = this.checkFileAttributes(nodeList, olrLocFileName, olrLocFileInfoResultSet, VDMUtil.getDefaultOlrLocOwner(), VerificationUtil.getOraInventoryGroup(), VDMUtil.getDefaultOlrLocPermissions());
            resultSet.uploadResultSet(olrLocFileInfoResultSet);
        } else {
            failedOlrLocNodes = new Hashtable();
            for (String node : nodeList) {
                NativeResult keyExistsResult;
                String olrLocFileName = nativeSys.getOLRConfigLocation(node, null);
                if (!nativeSys.regKeyExists(node, olrLocFileName, keyExistsResult = new NativeResult())) {
                    resultSet.addResult(node, 3);
                    Object[] args = new String[]{olrLocFileName, node, keyExistsResult.getOSString()};
                    String errMsg = s_msgBundle.getMessage("1118", true, args);
                    failedOlrLocNodes.put(node, Arrays.asList(errMsg));
                    continue;
                }
                resultSet.addResult(node, 1);
            }
        }
        if (failedOlrLocNodes.keySet().size() != 0) {
            mesg2 = s_msgBundle.getMessage("4184", true);
            ReportUtil.printError(LSEP + mesg2 + LSEP);
            ReportUtil.printErrorNodes(failedOlrLocNodes.keySet().toArray(new String[0]));
            for (String node : failedOlrLocNodes.keySet()) {
                List failedNodeErrors = (List)failedOlrLocNodes.get(node);
                ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strList2List(failedNodeErrors));
                resultSet.addResult(node, 3);
                for (String error : failedNodeErrors) {
                    resultSet.addErrorDescription(node, new ErrorDescription(error));
                }
            }
        } else {
            mesg2 = s_msgBundle.getMessage("4183", false);
            ReportUtil.sureprintln(LSEP + mesg2 + LSEP);
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4185", false));
        Hashtable<String, List<String>> failedOlrNodes = new Hashtable<String, List<String>>();
        for (String node : nodeList) {
            Pattern p;
            Matcher m;
            String olrFileName = null;
            String cmdSpec = haHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + nativeSys.getExeName("ocrcheck") + " -config -local";
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Command Syntax: " + cmdSpec));
            }
            ResultSet olrCheckResultSet = new ResultSet();
            Hashtable olrCheckOutput = globalExec.runExeWithOutput(new String[]{node}, cmdSpec, olrCheckResultSet);
            String output = (String)olrCheckOutput.get(node);
            String valText = VerificationUtil.fetchVerificationValue(output);
            String exitStat = VerificationUtil.fetchVerificationResult(output);
            if (exitStat != null && exitStat.contentEquals("0") && (m = (p = Pattern.compile("([^:]*):([\\s]+)Device/File Name([^:]+): (.*)")).matcher(valText.trim())).matches()) {
                olrFileName = m.group(4).trim();
            }
            if (olrFileName == null) {
                ErrorDescription errDesc = new ErrorDescription("4127", s_msgBundle);
                resultSet.addResult(node, 2);
                if (output != null && output.length() != 0) {
                    errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + cmdSpec + LSEP + output);
                }
                failedOlrNodes.put(node, Arrays.asList(errDesc.getErrorMessage()));
                resultSet.addErrorDescription(errDesc);
                if (!Trace.isTraceEnabled()) continue;
                Trace.out((String)("Node: " + node));
                Trace.out((String)("Output: " + output));
                Trace.out((String)("valText: '" + valText + "' "));
                Trace.out((String)("exitStat: '" + exitStat + "'"));
                continue;
            }
            ArrayList<String> olrFileList = new ArrayList<String>();
            olrFileList.add(olrFileName);
            ResultSet olrFileInfoResultSet = new ResultSet();
            boolean olrFileInfoResult = globalExec.getFileInfo(new String[]{node}, olrFileList, olrFileInfoResultSet);
            Trace.out((String)"After calling globalExec.getFileInfo() ... ");
            if (!olrFileInfoResult) {
                String message = s_msgBundle.getMessage("4160", true) + LSEP;
                failedOlrNodes.put(node, Arrays.asList(message));
                resultSet.addResult(node, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                resultSet.addErrorDescription(errDesc);
                continue;
            }
            Trace.out((String)"Checking olr attributes");
            String olrOwner = null;
            String olrGroup = null;
            String olrPermission = null;
            if (nativeSys.isUnixSystem()) {
                olrGroup = VerificationUtil.getOraInventoryGroup();
                olrPermission = VDMUtil.getDefaultOlrPermissions();
                olrOwner = VerificationUtil.isHAConfigured() ? this.getOracleUser(haHome, nodeList) : VDMUtil.getDefaultOlrOwnerCRS();
            }
            failedOlrNodes.putAll(this.checkFileAttributes(new String[]{node}, olrFileName, olrFileInfoResultSet, olrOwner, olrGroup, olrPermission));
            resultSet.uploadResultSet(olrFileInfoResultSet);
        }
        if (failedOlrNodes.keySet().size() != 0) {
            mesg = s_msgBundle.getMessage("4187", true);
            ReportUtil.printError(LSEP + mesg + LSEP);
            ReportUtil.printErrorNodes(failedOlrNodes.keySet().toArray(new String[0]));
            for (String node : failedOlrNodes.keySet()) {
                List failedNodeErrors = (List)failedOlrNodes.get(node);
                ReportUtil.sureprintln(LSEP + "\t" + node + ":" + VerificationUtil.strList2List(failedNodeErrors));
                resultSet.addResult(node, 3);
                for (String error : failedNodeErrors) {
                    resultSet.addErrorDescription(node, new ErrorDescription(error));
                }
            }
        } else {
            mesg = s_msgBundle.getMessage("4186", false);
            ReportUtil.sureprintln(LSEP + mesg + LSEP);
        }
    }

    private Hashtable<String, List<String>> checkFileAttributes(String[] validNodeArr, String fileName, ResultSet fileInfoResultSet, String refOwner, String refGroup, String refPermissions) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        Hashtable<String, List<String>> failedNodes = new Hashtable<String, List<String>>();
        Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
        ArrayList<String> nodeErrors = null;
        for (String node : validNodeArr) {
            nodeErrors = new ArrayList<String>();
            Result result = (Result)fileInforResultTable.get(node);
            if (result != null && result.getStatus() == 1) {
                ErrorDescription error;
                String errorMessage;
                Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
                boolean nodeFailed = false;
                FileInfo nodeFileInfo = (FileInfo)nodeFileList.get(fileName);
                if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) {
                    fileInfoResultSet.addResult(node, 3);
                    ErrorDescription error2 = new ErrorDescription(nodeFileInfo.getErrorString());
                    fileInfoResultSet.addErrorDescription(node, error2);
                    nodeErrors.add(nodeFileInfo.getErrorString());
                    failedNodes.put(node, nodeErrors);
                    nodeFailed = true;
                    continue;
                }
                if (refOwner != null && refOwner.length() > 0 && !nodeFileInfo.getFileOwner().equalsIgnoreCase(refOwner)) {
                    fileInfoResultSet.addResult(node, 3);
                    errorMessage = s_msgBundle.getMessage("5005", false, (Object[])new String[]{nodeFileInfo.getFileName(), refOwner, nodeFileInfo.getFileOwner()});
                    error = new ErrorDescription(errorMessage);
                    fileInfoResultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                }
                if (refGroup != null && refGroup.length() > 0 && !nodeFileInfo.getFileGroup().equalsIgnoreCase(refGroup)) {
                    fileInfoResultSet.addResult(node, 3);
                    errorMessage = s_msgBundle.getMessage("5007", false, (Object[])new String[]{nodeFileInfo.getFileName(), refGroup, nodeFileInfo.getFileGroup()});
                    error = new ErrorDescription(errorMessage);
                    fileInfoResultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                }
                if (refPermissions != null && refPermissions.length() > 0 && !nodeFileInfo.getFilePermissions().equalsIgnoreCase(refPermissions)) {
                    fileInfoResultSet.addResult(node, 3);
                    errorMessage = s_msgBundle.getMessage("5009", false, (Object[])new String[]{nodeFileInfo.getFileName(), refPermissions, nodeFileInfo.getFilePermissions()});
                    error = new ErrorDescription(errorMessage);
                    fileInfoResultSet.addErrorDescription(node, error);
                    nodeErrors.add(errorMessage);
                    nodeFailed = true;
                }
                if (!nodeFailed) continue;
                failedNodes.put(node, nodeErrors);
                continue;
            }
            String error = s_msgBundle.getMessage("4160", false);
            nodeErrors.add(error);
            failedNodes.put(node, nodeErrors);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return failedNodes;
    }

    private String getOracleUser(String haHome, String[] nodeList) {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        String oracleBinary = haHome + File.separator + "bin" + File.separator + new SystemFactory().CreateSystem().getExeName("oracle");
        GlobalExecution globalExec = new GlobalExecution();
        List<String> fileList = Arrays.asList(oracleBinary);
        ResultSet resultSet = new ResultSet();
        boolean fileInfoResult = globalExec.getFileInfo(nodeList, fileList, resultSet);
        Trace.out((String)"After calling globalExec.getFileInfo() ... ");
        if (!fileInfoResult) {
            return null;
        }
        for (String node : nodeList) {
            Result result = (Result)resultSet.getResultTable().get(node);
            if (result == null || result.getStatus() != 1) continue;
            Hashtable nodeFileList = (Hashtable)result.getResultInfoSet().elementAt(0);
            boolean nodeFailed = false;
            FileInfo nodeFileInfo = (FileInfo)nodeFileList.get(oracleBinary);
            if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) continue;
            return nodeFileInfo.getFileOwner();
        }
        return null;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4436", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4487", false);
    }
}

