/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.prov.fixup.PackageFixes;

public class TaskPackage
extends PeerCompatibleTask {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1055", false);
    private String m_name;
    private String m_val;
    private String m_arch;
    private RangeOfValue m_range;

    public TaskPackage(String name, String val, String arch) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("name = " + name + ", val = " + val + ", arch=" + arch));
        }
        this.m_name = name;
        this.m_val = val;
        this.m_arch = arch;
    }

    public TaskPackage(String name, RangeOfValue range, String arch) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("name = " + name + ", range = " + range + ", arch=" + arch));
        }
        this.m_name = name;
        this.m_range = range;
        this.m_arch = arch;
    }

    public boolean performTask() {
        String requiredPackage = null;
        ArrayList<String> multiplePkgsWarningMsgs = new ArrayList<String>();
        requiredPackage = this.m_val != null ? this.m_name + "-" + this.m_val : this.m_name + " " + this.m_range.toString();
        if (this.m_arch != null && this.m_arch.length() > 0) {
            requiredPackage = requiredPackage + " (" + this.m_arch + ")";
        }
        ResultSet rsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getPackage(this.m_nodeList, this.m_name, rsltSet);
        this.m_resultSet.uploadResultSet(rsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, requiredPackage}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        String pkgStatus = ReportUtil.MISSING;
        String comment = null;
        boolean verificationFailed = false;
        while (e.hasMoreElements()) {
            ArrayList<String> fileList;
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            ArrayList<String> pkgsFound = new ArrayList<String>();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 3) {
                verificationFailed = true;
                pkgStatus = ReportUtil.MISSING;
                errDesc = new ErrorDescription("7532", new String[]{requiredPackage, node}, s_msgBundle);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(requiredPackage);
                this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                comment = ReportUtil.FAILED;
            } else if (result.getStatus() == 1) {
                boolean requiredPkgFound = false;
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(requiredPackage);
                Object pkgStatusObj = result.getResultInfoSet().elementAt(0);
                if (pkgStatusObj instanceof String) {
                    pkgStatus = (String)pkgStatusObj;
                    requiredPkgFound = this.matchesVersionRequirement(pkgStatus.substring(this.m_name.length() + "-".length()), null);
                    pkgsFound.add(pkgStatus);
                } else {
                    List packageInfoList = (List)pkgStatusObj;
                    boolean first = true;
                    for (HashMap pkgInfo : packageInfoList) {
                        String avlPkgName = (String)pkgInfo.get("NAME");
                        String avlPkgArch = (String)pkgInfo.get("ARCH");
                        String avlPkgVersion = (String)pkgInfo.get("VERSION");
                        if (!this.matchesArchitectureRequirement(avlPkgArch)) {
                            Trace.out((String)("Package = " + avlPkgName + " Version=" + avlPkgVersion + " Available arch " + avlPkgArch + "' did not meet required architecture =" + this.m_arch));
                            continue;
                        }
                        if (first) {
                            first = true;
                            pkgStatus = avlPkgName + "-" + avlPkgVersion;
                            if (this.m_arch != null && this.m_arch.length() > 0) {
                                pkgStatus = pkgStatus + " (" + avlPkgArch + ")";
                            }
                        }
                        pkgsFound.add(avlPkgName + "-" + avlPkgVersion + " (" + avlPkgArch + ")");
                        if (!this.matchesVersionRequirement(avlPkgVersion, avlPkgArch)) continue;
                        requiredPkgFound = true;
                        pkgStatus = avlPkgName + "-" + avlPkgVersion;
                        if (this.m_arch == null || this.m_arch.length() <= 0) continue;
                        pkgStatus = pkgStatus + " (" + avlPkgArch + ")";
                    }
                    if (pkgsFound.size() > 1) {
                        String msg = s_msgBundle.getMessage("7584", true, (Object[])new String[]{this.m_name, node, VerificationUtil.strCollection2String(pkgsFound)});
                        multiplePkgsWarningMsgs.add(msg);
                        this.m_resultSet.getResult(node).addTraceInfo(msg);
                    }
                }
                if (requiredPkgFound) {
                    comment = ReportUtil.PASSED;
                    this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                } else if (pkgsFound.size() > 0) {
                    verificationFailed = true;
                    comment = ReportUtil.FAILED;
                    errDesc = new ErrorDescription("7533", new String[]{this.m_name, node, requiredPackage, pkgStatus}, s_msgBundle);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                    this.m_resultSet.addResult(node, 3);
                } else {
                    verificationFailed = true;
                    pkgStatus = ReportUtil.MISSING;
                    errDesc = new ErrorDescription("7532", new String[]{requiredPackage, node}, s_msgBundle);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.getResult(node).setHasResultValues(true);
                    this.m_resultSet.getResult(node).setActualValue(pkgStatus);
                    this.m_resultSet.addResult(node, 3);
                    comment = ReportUtil.FAILED;
                }
            } else {
                pkgStatus = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7534", false, (Object[])new String[]{this.m_name, node}));
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                comment = ReportUtil.UNKNOWN;
            }
            if (verificationFailed && this.isFixupReqd() && this.m_name.matches("cvuqdisk") && (fileList = this.getFixupFiles(node, this.m_resultSet)) != null) {
                Map<String, String> groupEnv = Collections.synchronizedMap(new HashMap());
                groupEnv.put("CVUQDISK_GRP", VerificationUtil.getCurrentGroup());
                OipcfFixUpResult fixupRslt = PackageFixes.enableOraclePackages((String)fileList.get(1), (String)fileList.get(0), groupEnv, (String)VerificationUtil.getCVUSubDirPath(), (String[])new String[]{VerificationUtil.getCvuqdiskRPMname()});
                if (fixupRslt.getFixUpResult() != OipcfFixUpResult.PASSED) {
                    String errMsg = s_msgBundle.getMessage("7727", false, (Object[])new String[]{this.m_name, node});
                    OiixException oiEx = fixupRslt.getFixUpException();
                    if (oiEx != null) {
                        errMsg = errMsg + VerificationConstants.LSEP + oiEx.getErrorMessage();
                    }
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)errMsg);
                    }
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    this.addFixupGenError(node, errMsg);
                } else {
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)("Fixup was successfully generated for installing package '" + this.m_name + "' on node '" + node + "'"));
                    }
                    this.m_resultSet.getResult(node).setFixupAvailable(true);
                }
            }
            ReportUtil.writeRecord(node, pkgStatus, requiredPackage, comment);
        }
        if (multiplePkgsWarningMsgs.size() > 0) {
            for (String msg : multiplePkgsWarningMsgs) {
                ReportUtil.printWarning(msg);
            }
        }
        if (this.m_resultSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, requiredPackage}));
        } else {
            this.reportFixupGenErrors();
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, requiredPackage}));
            ReportUtil.printErrorNodes(this.m_resultSet);
        }
        return this.m_resultSet.allSuccess();
    }

    private boolean matchesVersionRequirement(String avlPkgVersion, String avlPkgArch) {
        boolean matched = true;
        if (this.m_val != null) {
            matched &= VerificationUtil.compareVersions(avlPkgVersion, this.m_val, "-") >= 0;
        } else if (this.m_range != null) {
            try {
                matched &= this.m_range.contains(avlPkgVersion);
            }
            catch (InvalidRangeManipulationException e) {
                Trace.out((Exception)e);
            }
        } else {
            matched &= false;
        }
        if (matched) {
            Trace.out((String)("Package version meets the requirement. Package Architecture specified. Required Arch = " + this.m_arch + " Available Arch =" + avlPkgArch));
            matched &= this.matchesArchitectureRequirement(avlPkgArch);
        }
        return matched;
    }

    private boolean matchesArchitectureRequirement(String arch) {
        if (this.m_arch != null && this.m_arch.length() > 0) {
            String archRegEx = this.m_arch.replaceAll("\\*", ".*");
            archRegEx = archRegEx.replaceAll("\\?", ".?");
            return Pattern.matches(archRegEx, arch);
        }
        return true;
    }

    public String getDefaultElementName() {
        String pkgName = this.m_name;
        if (this.m_val != null) {
            pkgName = pkgName + "-" + this.m_val;
        }
        return s_msgBundle.getMessage("4415", false) + ": " + pkgName;
    }

    public String getDefaultDescription() {
        String pkgName = this.m_name;
        if (this.m_val != null) {
            pkgName = pkgName + "-" + this.m_val;
        }
        return s_msgBundle.getMessage("4466", false, (Object[])new String[]{pkgName});
    }

    public ResultSet performPeer() throws VerificationException {
        ResultSet rsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getPackage(this.m_nodeList, this.m_name, rsltSet);
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 3) {
                result.getResultInfoSet().add(0, ReportUtil.MISSING);
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() != 1) continue;
            Object pkgStatusObj = result.getResultInfoSet().elementAt(0);
            ArrayList<String> pkgsFound = new ArrayList<String>();
            if (pkgStatusObj instanceof String) continue;
            List packageInfoList = (List)pkgStatusObj;
            for (HashMap pkgInfo : packageInfoList) {
                String avlPkgName = (String)pkgInfo.get("NAME");
                String avlPkgArch = (String)pkgInfo.get("ARCH");
                String avlPkgVersion = (String)pkgInfo.get("VERSION");
                String avlPkg = avlPkgName + "-" + avlPkgVersion;
                if (this.m_arch != null && this.m_arch.length() > 0) {
                    avlPkg = avlPkg + " (" + avlPkgArch + ")";
                }
                pkgsFound.add(avlPkg);
            }
            result.getResultInfoSet().add(0, VerificationUtil.strCollection2String(pkgsFound));
        }
        return rsltSet;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9975", false, (Object[])new String[]{this.m_name});
    }
}

