/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPeerCompatibility
extends Task {
    private String m_referenceNode;
    private String[] m_PCNodeList;
    private ParamPreReq m_paramPreReq = null;

    public TaskPeerCompatibility() {
        this(null, 1);
    }

    public TaskPeerCompatibility(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public TaskPeerCompatibility(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(multiTaskHandler, actionOnCompletion);
    }

    public void setReferenceNode(String referenceNode) {
        this.m_referenceNode = referenceNode;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing Peer Compatibility verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4600", false));
        if (this.m_referenceNode != null && this.m_referenceNode.trim().length() > 0) {
            if (this.m_nodeList.length == 1 && this.m_referenceNode.equalsIgnoreCase(this.m_nodeList[0])) {
                ReportUtil.printError(s_msgBundle.getMessage("4602", false) + " " + s_msgBundle.getMessage("0007", false));
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription("4602", s_msgBundle));
                return false;
            }
            this.m_PCNodeList = new String[this.m_nodeList.length + 1];
            this.m_PCNodeList[0] = this.m_referenceNode;
            System.arraycopy(this.m_nodeList, 0, this.m_PCNodeList, 1, this.m_nodeList.length);
            Trace.out((String)"==== Reference node added to the effective nodelist");
        } else {
            this.m_PCNodeList = this.m_nodeList;
        }
        List<Task> taskList = null;
        try {
            taskList = TaskFactory.getInstance().getTaskList(VerificationType.SYSREQ_CRS, this.m_PCNodeList, this.m_paramPreReq);
        }
        catch (PreReqNotSupportedException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addResult(this.m_PCNodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            return false;
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            this.m_resultSet.addResult(this.m_PCNodeList, 2);
            return false;
        }
        for (Task task : taskList) {
            this.processTask(task);
        }
        return this.m_resultSet.allSuccess();
    }

    private void processTask(Task task) {
        if (task instanceof TaskContainerFreeSpace) {
            this.performPeerForFreeSpace((TaskContainerFreeSpace)task);
            return;
        }
        if (task.hasSubtasks()) {
            try {
                List<VerificationTask> subTaskList = task.getSubtasks();
                for (VerificationTask subTask : subTaskList) {
                    this.processTask((Task)subTask);
                }
            }
            catch (SubtasksUnavailableException e) {
                Trace.out((Exception)e);
                this.m_resultSet.addResult(this.m_PCNodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_PCNodeList, new ErrorDescription(e.getMessage()));
                ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return;
            }
        }
        if (!(task instanceof PeerCompatibleTask)) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Task " + task.getDefaultElementName() + " is not suitable for peer compatiblity test. Skipping the task."));
            }
            return;
        }
        PeerCompatibleTask pTask = (PeerCompatibleTask)task;
        try {
            ResultSet pTaskRS = pTask.performPeer();
            if (this.m_referenceNode == null || this.m_referenceNode.trim().length() == 0) {
                this.reportCompatibility(pTask.getElementDisplayName(), pTaskRS);
            } else {
                this.m_resultSet.addResult(this.m_referenceNode, 1);
                this.reportCompatibility(pTask.getElementDisplayName(), this.m_referenceNode, pTaskRS);
            }
            this.m_resultSet.uploadResultSet(pTaskRS);
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            this.m_resultSet.addResult(this.m_PCNodeList, 2);
            return;
        }
    }

    private void reportCompatibility(String taskName, ResultSet rset) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1005", false, (Object[])new String[]{taskName}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        Hashtable t = rset.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String instStatus;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                instStatus = this.formatValue(result.getResultInfoSet().elementAt(0));
            } else if (result.getStatus() == 3) {
                instStatus = ReportUtil.UNKNOWN;
                if (result.getResultInfoSet().size() > 0) {
                    instStatus = this.formatValue(result.getResultInfoSet().elementAt(0));
                }
            } else {
                instStatus = ReportUtil.UNKNOWN;
            }
            ReportUtil.surewriteRecord(node, instStatus);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1007", false, (Object[])new String[]{taskName}));
        }
    }

    public void reportCompatibility(String taskName, String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1009", false, (Object[])new String[]{taskName, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable ht = resultSet.getResultTable();
        Result refNodeResult = (Result)ht.get(refNode);
        String refNodeValue = ReportUtil.UNKNOWN;
        int refNodeStatus = refNodeResult.getStatus();
        if (refNodeResult.getResultInfoSet().size() > 0) {
            refNodeValue = this.formatValue(refNodeResult.getResultInfoSet().elementAt(0));
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                resultSet.setStatus();
                continue;
            }
            String nodeValue = ReportUtil.UNKNOWN;
            if (result.getResultInfoSet().size() > 0) {
                nodeValue = this.formatValue(result.getResultInfoSet().elementAt(0));
            }
            if (result.getStatus() == 1) {
                if (refNodeValue.equals(nodeValue)) {
                    comment = ReportUtil.MATCHED;
                } else {
                    result.setStatus(3);
                    resultSet.setStatus();
                    comment = ReportUtil.MISMATCHED;
                }
            } else if (result.getStatus() == 3 && refNodeStatus == result.getStatus()) {
                result.setStatus(1);
                resultSet.setStatus();
                comment = ReportUtil.MATCHED;
            } else {
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, nodeValue, refNodeValue, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{taskName}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{taskName}));
        }
    }

    private void performPeerForFreeSpace(TaskContainerFreeSpace task) {
        List<VerificationTask> taskFreeSpaceArr;
        try {
            taskFreeSpaceArr = task.getSubtasks();
        }
        catch (SubtasksUnavailableException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            this.m_resultSet.addResult(this.m_PCNodeList, 2);
            return;
        }
        LinkedHashMap<String, List<TaskFreeSpace>> freeSpaceHT = new LinkedHashMap<String, List<TaskFreeSpace>>();
        for (VerificationTask freeSpaceVerificationTask : taskFreeSpaceArr) {
            TaskFreeSpace freeSpaceTask = (TaskFreeSpace)freeSpaceVerificationTask;
            for (String location : freeSpaceTask.m_locations) {
                ArrayList<TaskFreeSpace> freeSpaceTaskList = (ArrayList<TaskFreeSpace>)((HashMap)freeSpaceHT).get(location);
                if (freeSpaceTaskList == null) {
                    freeSpaceTaskList = new ArrayList<TaskFreeSpace>();
                    freeSpaceHT.put(location, freeSpaceTaskList);
                }
                freeSpaceTaskList.add(freeSpaceTask);
            }
        }
        if (this.m_referenceNode == null || this.m_referenceNode.trim().length() == 0) {
            this.reportFreeSpaceCompatibility(freeSpaceHT);
        } else {
            this.m_resultSet.addResult(this.m_referenceNode, 1);
            this.reportFreeSpaceCompatibility(this.m_referenceNode, freeSpaceHT);
        }
    }

    private void reportFreeSpaceCompatibility(HashMap<String, List<TaskFreeSpace>> freeSpaceHT) {
        for (String location : freeSpaceHT.keySet()) {
            String taskName = s_msgBundle.getMessage("1056", false);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("1006", false, (Object[])new String[]{taskName, location}));
            ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
            List<TaskFreeSpace> freeSpaceTaskList = freeSpaceHT.get(location);
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                String node = freeSpaceTask.m_nodeFreeSpc;
                String instStatus = freeSpaceTask.m_mountPoint.contentEquals("UNKNOWN") ? ReportUtil.UNKNOWN : this.formatValue(freeSpaceTask.m_availMntSize);
                ReportUtil.surewriteRecord(node, instStatus);
            }
            if (freeSpaceTaskList.size() <= 1) continue;
            ReportUtil.sureprintln(s_msgBundle.getMessage("1008", false, (Object[])new String[]{taskName, location}));
        }
    }

    private void reportFreeSpaceCompatibility(String refNode, HashMap<String, List<TaskFreeSpace>> freeSpaceHT) {
        for (String location : freeSpaceHT.keySet()) {
            boolean noMismatch = true;
            String taskName = s_msgBundle.getMessage("1056", false);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("1010", false, (Object[])new String[]{taskName, location, refNode}));
            ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
            List<TaskFreeSpace> freeSpaceTaskList = freeSpaceHT.get(location);
            String refNodeValue = ReportUtil.UNKNOWN;
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                if (!refNode.equals(freeSpaceTask.m_nodeFreeSpc)) continue;
                if (freeSpaceTask.m_mountPoint.contentEquals("UNKNOWN")) {
                    refNodeValue = ReportUtil.UNKNOWN;
                    break;
                }
                refNodeValue = this.formatValue(freeSpaceTask.m_availMntSize);
                break;
            }
            for (TaskFreeSpace freeSpaceTask : freeSpaceTaskList) {
                String comment;
                String node = freeSpaceTask.m_nodeFreeSpc;
                if (node.equals(refNode)) continue;
                String nodeValue = ReportUtil.UNKNOWN;
                if (!freeSpaceTask.m_mountPoint.contentEquals("UNKNOWN")) {
                    nodeValue = this.formatValue(freeSpaceTask.m_availMntSize);
                }
                if (nodeValue.equals(refNodeValue)) {
                    comment = ReportUtil.MATCHED;
                } else {
                    noMismatch &= false;
                    comment = ReportUtil.MISMATCHED;
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.setStatus();
                }
                ReportUtil.surewriteRecord(node, nodeValue, refNodeValue, comment);
            }
            if (noMismatch) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{taskName}));
                continue;
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{taskName}));
        }
    }

    private String formatValue(Object nodeValue) {
        if (nodeValue instanceof StorageSize) {
            return ReportUtil.unitizeSize((StorageSize)nodeValue);
        }
        return nodeValue.toString();
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4433", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4484", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    ReferenceNode: " + this.m_referenceNode);
        return sb.toString();
    }

    public void setParamPreReq(ParamPreReq preReq) {
        this.m_paramPreReq = preReq;
    }
}

