/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class TaskPhysicalMemory
extends PeerCompatibleTask {
    private StorageSize m_reqMemSize;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1058", false);

    public TaskPhysicalMemory(long size, StorageUnit unit) {
        this.m_reqMemSize = new StorageSize(size, unit);
    }

    public TaskPhysicalMemory(StorageSize size) {
        this.m_reqMemSize = size;
    }

    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet memRsltSet = new ResultSet();
        globalExec.checkMemory(this.m_nodeList, this.m_reqMemSize, memRsltSet);
        this.m_resultSet.uploadResultSet(memRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = memRsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String avl;
            StorageSize avlSS;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(this.m_reqMemSize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avlSS));
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7530", true, (Object[])new String[]{node, ReportUtil.unitizeSize(this.m_reqMemSize)}), s_msgBundle, "7530");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(this.m_reqMemSize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avlSS));
                comment = ReportUtil.FAILED;
            } else {
                avl = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7531", true, (Object[])new String[]{node}), s_msgBundle, "7531");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                comment = ReportUtil.FAILED;
            }
            ReportUtil.writeRecord(node, ReportUtil.unitizeSize(avl, StorageUnit.KBYTE), ReportUtil.unitizeSize(this.m_reqMemSize), comment);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4416", false);
    }

    public String getDefaultDescription() {
        Object[] msgParams = new String[]{ReportUtil.unitizeSize(this.m_reqMemSize)};
        return s_msgBundle.getMessage("4467", false, msgParams);
    }

    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet archRsltSet = new ResultSet();
        globalExec.checkMemory(this.m_nodeList, new StorageSize(0.0, StorageUnit.BYTE), archRsltSet);
        return archRsltSet;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9976", false);
    }
}

