/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskPinNodes
extends Task {
    private String[] m_nodeList;

    public TaskPinNodes(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public boolean performTask() {
        Version verCRSSoft;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet pinRsltSet = new ResultSet();
        String crsHome = null;
        String chkPinHost = null;
        ArrayList<String> nodeList = null;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if ((verCRSSoft = VerificationUtil.getCRSSoftwareVersionObj()) == null || verCRSSoft != null && Version.isPre112((Version)verCRSSoft)) {
            if (Trace.isLevelEnabled((int)5)) {
                if (verCRSSoft == null) {
                    Trace.out((String)"CRS version is null.");
                } else {
                    Trace.out((String)"Version specified was pre-11.2");
                }
            }
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4364", false));
        crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve CRS home");
            }
            this.m_resultSet.addErrorDescription(new ErrorDescription("5301", s_msgBundle));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        nodeList = new ArrayList<String>(Arrays.asList(this.m_nodeList));
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("CRS home is: '" + crsHome + "'"));
        }
        if (this.m_nodeList.length == 0) {
            try {
                chkPinHost = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)("UNKNOWNHOSTEXCEPTION: Local node not found: " + uhe.getMessage()));
                chkPinHost = "localnode";
            }
        } else {
            chkPinHost = this.m_nodeList[0];
        }
        String cmdSpec = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + new SystemFactory().CreateSystem().getExeName("olsnodes") + " -t -n";
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("\nCommand Syntax: " + cmdSpec + "\nCommand Host: '" + chkPinHost + "'"));
        }
        ResultSet chkPinResultSet = new ResultSet();
        Hashtable chkPinOutput = globalExec.runExeWithOutput(new String[]{chkPinHost}, cmdSpec, chkPinResultSet);
        String output = (String)chkPinOutput.get(chkPinHost);
        String cmdOutput = VerificationUtil.fetchVerificationValue(output);
        String exitStat = VerificationUtil.fetchVerificationResult(output);
        if (exitStat != null && exitStat.contentEquals("0")) {
            String[] chkPinOutputLines;
            Trace.out((int)5, (String)"Command succeeded");
            ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
            for (String outLine : chkPinOutputLines = VerificationUtil.string2strArr(cmdOutput, VerificationUtil.LINE_SEPARATOR)) {
                String comment;
                String pinStatus;
                StringTokenizer st = new StringTokenizer(outLine);
                String nodePinName = st.nextToken();
                String nodePinNum = st.nextToken();
                String nodePinStatus = st.nextToken();
                Result nodeResult = null;
                Trace.out((int)5, (String)("\nPinName: '" + nodePinName + "'" + "\nPinNum: '" + nodePinNum + "'" + "\nPinStatus: '" + nodePinStatus + "'"));
                nodeResult = this.m_resultSet.getResult(nodePinName);
                if (!nodeList.contains(nodePinName)) continue;
                if (nodePinStatus.contentEquals("Pinned")) {
                    Trace.out((int)5, (String)"Verification Successful!");
                    nodeList.remove(nodePinName);
                    pinStatus = ReportUtil.PINNED;
                    comment = ReportUtil.PASSED;
                    if (nodeResult != null) {
                        nodeResult.setStatus(1);
                    } else {
                        this.m_resultSet.addResult(nodePinName, 1);
                    }
                } else if (nodePinStatus.contentEquals("Unpinned")) {
                    Trace.out((int)5, (String)"Verification FAILED!");
                    pinStatus = ReportUtil.NOT_PINNED;
                    comment = ReportUtil.FAILED;
                    if (nodeResult != null) {
                        nodeResult.setStatus(3);
                    } else {
                        this.m_resultSet.addResult(nodePinName, 3);
                    }
                } else {
                    Trace.out((int)5, (String)("No Pinned/Unpinned state!: \n" + outLine));
                    continue;
                }
                ReportUtil.writeRecord(nodePinName, pinStatus, comment);
            }
        } else {
            Trace.out((int)5, (String)"Command FAILED!");
            String pinStatus = ReportUtil.UNKNOWN;
            String comment = ReportUtil.UNKNOWN;
            ErrorDescription errDesc = new ErrorDescription("4363", s_msgBundle);
            for (String errNode : this.m_nodeList) {
                Trace.out((String)("olsnodes command failed on node: '" + errNode + "'"));
                this.m_resultSet.addResult(errNode, 2);
                this.m_resultSet.getResult(errNode).addErrorDescription(errDesc);
                ReportUtil.writeRecord(errNode, pinStatus, comment);
            }
            return false;
        }
        if (nodeList.size() <= 0 || this.isFixupReqd()) {
            // empty if block
        }
        if (this.m_resultSet.allSuccess()) {
            Trace.out((int)5, (String)"Returning TRUE");
            ReportUtil.sureprintln(s_msgBundle.getMessage("4362", false));
            return true;
        }
        Trace.out((int)5, (String)"Returning FALSE");
        ReportUtil.printError(s_msgBundle.getMessage("4363", true));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4562", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4563", false);
    }
}

