/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRunLevel
extends PeerCompatibleTask {
    private List<Integer> m_reqLevels = new ArrayList<Integer>();
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1064", false);

    public TaskRunLevel(int currLevel, int reqLevel) {
        this.m_reqLevels.add(reqLevel);
    }

    public TaskRunLevel(int reqLevel) {
        this.m_reqLevels.add(reqLevel);
    }

    public TaskRunLevel(List<Integer> reqLevels) {
        this.m_reqLevels.addAll(reqLevels);
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet runLvlRsltSet = new ResultSet();
        globalExec.checkRunlevel(this.m_nodeList, -1, runLvlRsltSet);
        this.m_resultSet.uploadResultSet(runLvlRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.RUNLEVEL, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = runLvlRsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String avl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avl = (String)result.getResultInfoSet().firstElement();
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(VerificationUtil.strCollection2String(this.m_reqLevels));
                this.m_resultSet.getResult(node).setActualValue(avl);
                boolean match = false;
                for (Integer requiredRunLevel : this.m_reqLevels) {
                    if (!String.valueOf(requiredRunLevel).equals(avl)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    comment = ReportUtil.PASSED;
                } else {
                    comment = ReportUtil.FAILED;
                    errDesc = new ErrorDescription("7564", new String[]{node, VerificationUtil.strCollection2String(this.m_reqLevels)}, s_msgBundle);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 3);
                }
            } else {
                avl = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7565", false, (Object[])new String[]{node}), s_msgBundle.getCause("7565", false), s_msgBundle.getAction("7565", false));
                comment = ReportUtil.FAILED;
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, avl, VerificationUtil.strCollection2String(this.m_reqLevels), comment);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        this.reportFixupGenErrors();
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet runLevelRS = new ResultSet();
        globalExec.checkRunlevel(this.m_nodeList, -1, runLevelRS);
        Hashtable ht = runLevelRS.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() != 3) continue;
            result.setStatus(1);
        }
        return runLevelRS;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1064", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4418", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4469", false);
    }
}

