/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.scan.Scan;
import oracle.cluster.scan.ScanException;
import oracle.cluster.scan.ScanFactory;
import oracle.cluster.scan.ScanListener;
import oracle.cluster.scan.ScanVIP;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNameService;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskScan
extends Task {
    public TaskScan(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskScan(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskScan(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public boolean performTask() {
        NativeSystem nativeSystem;
        List svipList;
        ErrorDescription errDesc;
        int port;
        boolean status;
        boolean lsnrRun;
        boolean vipRun;
        ScanListener scanLsnr;
        LinkedList<ErrorDescription> warnDetails;
        LinkedList<ErrorDescription> errorDetails;
        LinkedList<scanData> scanDetails;
        String runNode;
        String lsnrName;
        String scanName;
        String m_localName;
        block54: {
            m_localName = null;
            Object errMsg = null;
            Object warnMsg = null;
            Object cause = null;
            Object action = null;
            scanName = null;
            lsnrName = null;
            runNode = null;
            Object exceptionMsg = null;
            scanDetails = new LinkedList<scanData>();
            errorDetails = new LinkedList<ErrorDescription>();
            warnDetails = new LinkedList<ErrorDescription>();
            scanLsnr = null;
            vipRun = false;
            lsnrRun = false;
            status = true;
            port = 0;
            errDesc = null;
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"ENTRY");
            }
            this.m_resultSet.setStatus(1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5050", false));
            String exeHome = VerificationUtil.getCRSHome();
            if (exeHome != null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("exeHome = '" + exeHome + "'"));
                }
                try {
                    m_localName = new ClusterwareInfo().getClusterName(exeHome);
                }
                catch (InstallException ie) {
                    // empty catch block
                }
            }
            try {
                if (m_localName == null) {
                    m_localName = VerificationUtil.getLocalHost();
                }
            }
            catch (UnknownHostException uhe) {
                m_localName = "localnode";
                if (!Trace.isLevelEnabled((int)1)) break block54;
                Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + uhe));
            }
        }
        errDesc = new ErrorDescription("5054", s_msgBundle);
        try {
            ScanFactory sf = ScanFactory.getInstance();
            svipList = sf.getScanVIPs();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Number SCAN VIP's found: " + svipList.size()));
            }
        }
        catch (SoftwareModuleException sme) {
            status = false;
            this.m_resultSet.addResult(m_localName, 2);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + sme.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            errorDetails.add(errDesc);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("SOFTWAREMODULEEXCEPTION: \n" + sme.getMessage()));
            }
            ReportUtil.printError(errDesc.getErrorMessage());
            return false;
        }
        catch (NotExistsException nee) {
            status = false;
            this.m_resultSet.addResult(m_localName, 3);
            errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + nee.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            errorDetails.add(errDesc);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NOTEXISTSEXCEPTION: \n" + nee.getMessage()));
            }
            ReportUtil.printError(errDesc.getErrorMessage());
            return false;
        }
        boolean scanNameErr = false;
        boolean scanLsnrErr = false;
        boolean scanErr = false;
        boolean lsnrNameErr = false;
        ArrayList<String> scanNameList = new ArrayList<String>();
        errDesc = new ErrorDescription("5059", s_msgBundle);
        for (ScanVIP svip : svipList) {
            vipRun = false;
            lsnrRun = false;
            runNode = "unknown";
            try {
                scanName = svip.getScanName();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("GOT NAME: " + scanName + "\n"));
                }
                scanLsnr = svip.listener();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT LSNR \n");
                }
                Scan lsnrScan = scanLsnr.scan();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT SCAN \n");
                }
                lsnrName = lsnrScan.getListenerName();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT LSNRNAME \n");
                }
                vipRun = svip.isRunning();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT VIP RUN STATE \n");
                }
                lsnrRun = scanLsnr.isRunning();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT LSNR RUN STATE \n");
                }
                if (vipRun && lsnrRun) {
                    CRSResource crsRes = scanLsnr.crsResource();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT CRS RESOURCE \n");
                    }
                    List runNodes = crsRes.fetchRunningNodes();
                    if (Trace.isLevelEnabled((int)1)) {
                        Trace.out((String)"GOT RUN NODES \n");
                    }
                    if (!runNodes.isEmpty()) {
                        runNode = ((Node)runNodes.get(0)).getName();
                    }
                }
                port = scanLsnr.getPort();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"GOT PORT \n");
                }
                if (scanNameList.contains(scanName)) continue;
                scanNameList.add(scanName);
                scanDetails.add(new scanData(svip, scanName, runNode, scanLsnr, lsnrName, port, vipRun, lsnrRun));
            }
            catch (ScanVIPException sve) {
                status = false;
                this.m_resultSet.addResult(m_localName, 3);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + sve.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("ScanVIPEXCEPTION: \n" + sve.getMessage()));
                }
                if (!scanNameErr) {
                    errorDetails.add(errDesc);
                }
                scanNameErr = true;
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("ScanVIPEXCEPTION: \n" + sve.getMessage()));
            }
            catch (NotExistsException nee) {
                status = false;
                this.m_resultSet.addResult(m_localName, 3);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + nee.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (!scanLsnrErr) {
                    errorDetails.add(errDesc);
                }
                scanLsnrErr = true;
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("NOTEXISTSEXCEPTION: \n" + nee.getMessage()));
            }
            catch (ScanException se) {
                status = false;
                this.m_resultSet.addResult(m_localName, 3);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + se.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("SCANEEXCEPTION: \n" + se.getMessage()));
            }
            catch (CRSException crse) {
                status = false;
                this.m_resultSet.addResult(m_localName, 3);
                errDesc = new ErrorDescription("5056", new String[]{lsnrName}, s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + crse.getMessage());
                this.m_resultSet.addErrorDescription(errDesc);
                if (!scanErr) {
                    errorDetails.add(errDesc);
                }
                scanErr = true;
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("CRSEEXCEPTION: \n" + errDesc.getErrorMessage()));
            }
            catch (SoftwareModuleException sme) {
                status = false;
                this.m_resultSet.addResult(m_localName, 3);
                if (!vipRun && !lsnrRun) {
                    errDesc = new ErrorDescription("5062", new String[]{scanName, lsnrName}, s_msgBundle);
                } else if (!vipRun) {
                    errDesc = new ErrorDescription("5061", new String[]{scanName}, s_msgBundle);
                } else if (!lsnrRun) {
                    errDesc = new ErrorDescription("5056", new String[]{lsnrName}, s_msgBundle);
                }
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + sme.getMessage());
                errorDetails.add(errDesc);
                this.m_resultSet.addErrorDescription(errDesc);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("SOFTWAREMODULEEEXCEPTION: \n" + errDesc.getErrorMessage()));
            }
            catch (NodeException ne) {
                status = false;
                this.m_resultSet.addResult(m_localName, 3);
                errDesc = new ErrorDescription("5060", s_msgBundle);
                errDesc.setErrorMessage(errDesc.getErrorMessage() + LSEP + ne.getMessage());
                errorDetails.add(errDesc);
                this.m_resultSet.addErrorDescription(errDesc);
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("NODEEEXCEPTION: \n" + errDesc.getErrorMessage()));
            }
        }
        boolean headerPrinted = false;
        Integer portID = -1;
        boolean portsMatch = true;
        boolean portsErrMsg = false;
        for (scanData scanItem : scanDetails) {
            if (!headerPrinted) {
                headerPrinted = true;
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("8057", false), s_msgBundle.getMessage("8058", false), s_msgBundle.getMessage("8003", false), s_msgBundle.getMessage("8059", false), s_msgBundle.getMessage("8060", false), s_msgBundle.getMessage("8003", false));
            }
            if (portID == -1) {
                portID = scanItem.getPort();
            }
            if (portID != scanItem.getPort() || portID == -1) {
                portsMatch = false;
            }
            String vipRunning = scanItem.getVipRunning() ? "true" : "false";
            String lsnrRunning = scanItem.getLsnrRunning() ? "true" : "false";
            String portStr = portID.toString();
            ReportUtil.writeRecord(scanItem.getVIPName(), scanItem.getVipNode(), vipRunning, scanItem.getLsnrName(), portStr, lsnrRunning);
            if (!scanItem.getLsnrRunning() || !scanItem.getVipRunning()) {
                status = false;
                errDesc = new ErrorDescription("5056", new String[]{scanItem.getLsnrName()}, s_msgBundle);
                warnDetails.add(errDesc);
                this.m_resultSet.addResult(m_localName, 4);
                this.m_resultSet.getResult(m_localName).addErrorDescription(errDesc);
            }
            if (portsMatch || portsErrMsg) continue;
            status = false;
            portsErrMsg = true;
            errDesc = new ErrorDescription("5057", new String[]{scanItem.getLsnrName()}, s_msgBundle);
            warnDetails.add(errDesc);
            this.m_resultSet.addResult(m_localName, 4);
            this.m_resultSet.getResult(m_localName).addErrorDescription(errDesc);
        }
        for (ErrorDescription warnMsgs : warnDetails) {
            ReportUtil.printWarning(warnMsgs.getErrorMessage());
        }
        for (ErrorDescription errMsgs : errorDetails) {
            ReportUtil.printError(errMsgs.getErrorMessage());
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        if ((nativeSystem = new SystemFactory().CreateSystem()).isUnixSystem()) {
            String oraDevEnv = VerificationUtil.getEnv("CVU_TEST_ENV");
            String nameValue = new String("bigip-bug.us.oracle.com");
            Trace.out((int)5, (String)("CVU_TEST_ENV: '" + oraDevEnv + "'"));
            for (scanData scanEntry : scanDetails) {
                Trace.out((int)5, (String)("\nScan Data : \n" + scanEntry.toString()));
                if (oraDevEnv == null || !oraDevEnv.equalsIgnoreCase("true")) {
                    nameValue = scanEntry.getVIPName();
                }
                TaskNameService taskNS = new TaskNameService(this.m_nodeList, nameValue, this.m_resultSet);
                taskNS.performTask();
            }
        }
        if (status && this.m_resultSet.allSuccess()) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5058", false));
            return true;
        }
        this.m_resultSet.addResult(this.m_nodeList, 3);
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5054", false));
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9500", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9600", false);
    }

    private class scanData {
        private ScanVIP l_vip;
        private String l_vipName;
        private String l_vipNode;
        private ScanListener l_lsnr;
        private String l_lsnrName;
        private int l_portNum;
        private boolean l_vipRunning;
        private boolean l_lsnrRunning;

        private scanData(ScanVIP vip, String vipName, String vipNode, ScanListener lsnr, String lsnrName, int portNum, boolean vipRunning, boolean lsnrRunning) {
            this.l_vip = vip;
            this.l_vipName = vipName;
            this.l_vipNode = vipNode;
            this.l_lsnr = lsnr;
            this.l_lsnrName = lsnrName;
            this.l_portNum = portNum;
            this.l_vipRunning = vipRunning;
            this.l_lsnrRunning = lsnrRunning;
        }

        private ScanVIP getVIP() {
            return this.l_vip;
        }

        private String getVIPName() {
            return this.l_vipName;
        }

        private String getVipNode() {
            return this.l_vipNode;
        }

        private ScanListener getListener() {
            return this.l_lsnr;
        }

        private String getLsnrName() {
            return this.l_lsnrName;
        }

        private int getPort() {
            return this.l_portNum;
        }

        private boolean getVipRunning() {
            return this.l_vipRunning;
        }

        private boolean getLsnrRunning() {
            return this.l_lsnrRunning;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n    vipName: " + this.l_vipName);
            sb.append("\n    vipNode: " + this.l_vipNode);
            sb.append("\n    lsnrName: " + this.l_lsnrName);
            sb.append("\n    port: " + this.l_portNum);
            sb.append("\n    vipRunning: " + this.l_vipRunning);
            sb.append("\n    lsnrRunning: " + this.l_lsnrRunning);
            sb.append("\n");
            return sb.toString();
        }
    }
}

