/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.impl.verification.SharedStorageInfoImpl;
import oracle.cluster.impl.verification.SharedStorageResultSetImpl;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.NFSInfo;
import oracle.ops.verification.framework.storage.NodeStorageInfo;
import oracle.ops.verification.framework.storage.OCFS2Info;
import oracle.ops.verification.framework.storage.OCFSInfo;
import oracle.ops.verification.framework.storage.SharedStorageSet;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.ClassifierTable;
import oracle.ops.verification.util.MultiNodeException;

public class TaskSharedStorageAccess
extends Task {
    private static int DISPLAY_NONE = 0;
    private static int DISPLAY_ERROR = 1;
    private static int DISPLAY_WARNING = 2;
    protected String[] m_storageIDList;
    private boolean m_debugFlag = false;
    private boolean m_checkOCFS = false;
    private boolean m_checkWritableFS = true;
    public StorageThread[] threadList;
    private boolean m_mute = false;
    private boolean m_isOCRLocation = false;
    private boolean m_isVDiskLocation = false;
    private SharedStorageResultSetImpl m_ssResSetImpl = new SharedStorageResultSetImpl();
    private OracleFileType m_oracleFileType = OracleFileType.RAC_DATA_FILES;
    StorageType m_storageElementName;

    public TaskSharedStorageAccess(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskSharedStorageAccess(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskSharedStorageAccess(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setStorageID(String storageID) {
        this.m_storageIDList = new String[]{storageID};
    }

    public void setStorageIDlist(String[] storageIDList) {
        this.m_storageIDList = storageIDList;
    }

    public void setStorageElementName(StorageType storageElementName) {
        this.m_storageElementName = storageElementName;
    }

    public void setOutputMuted(boolean mute) {
        this.m_mute = mute;
    }

    public void setOracleFileType(OracleFileType fileType) {
        this.m_oracleFileType = fileType;
    }

    public boolean isOutputMuted() {
        return this.m_mute;
    }

    public void setCheckOCFS(boolean toCheck) {
        this.m_checkOCFS = toCheck;
    }

    public void setCheckWritableFS(boolean toCheck) {
        this.m_checkWritableFS = toCheck;
    }

    public boolean performTask() {
        String msg;
        boolean status;
        block17: {
            status = true;
            Trace.out((String)"Performing SharedStorage Accessibility verification task... ");
            if (!this.m_mute) {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4059", false));
            }
            Vector allSets = new Vector();
            if (null == this.m_storageIDList) {
                try {
                    int numNodes = this.m_nodeList.length;
                    NodeStorageInfo[] nodeInfoList = new NodeStorageInfo[numNodes];
                    for (int i = 0; i < numNodes; ++i) {
                        nodeInfoList[i] = new NodeStorageInfo(this.m_nodeList[i]);
                    }
                    VerifyStorage verifySt = new VerifyStorage();
                    verifySt.findSharedStorage(nodeInfoList, allSets, this.m_oracleFileType);
                    int minNodesReq = numNodes < 2 ? numNodes : 2;
                    this.reportNodeInfoError(nodeInfoList);
                    if (this.m_mute) break block17;
                    if (!this.isAnyShared(allSets, numNodes)) {
                        ReportUtil.sureblankln();
                        ReportUtil.sureprintln(s_msgBundle.getMessage("4150", false));
                        break block17;
                    }
                    this.printDiscoveryResult(allSets, minNodesReq);
                }
                catch (StorageException e) {
                    status = false;
                    Trace.out((Exception)e);
                    ReportUtil.sureprintln(e.getMessage());
                    ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                    this.m_resultSet.addErrorDescription(errDesc);
                }
            } else {
                StorageThread t;
                int i;
                int numStorage = this.m_storageIDList.length;
                this.threadList = new StorageThread[numStorage];
                for (i = 0; i < numStorage; ++i) {
                    this.threadList[i] = new StorageThread(this.m_nodeList, this.m_storageIDList[i], this.m_checkOCFS, this.m_checkWritableFS);
                    this.threadList[i].setName("t_" + this.m_storageIDList[i]);
                }
                for (i = 0; i < numStorage; ++i) {
                    t = this.threadList[i];
                    Trace.out((int)5, (String)("==> Running " + t.getName()));
                    t.start();
                }
                try {
                    for (i = 0; i < numStorage; ++i) {
                        Trace.out((int)5, (String)("==> Waiting to join " + this.threadList[i].getName()));
                        this.threadList[i].join();
                        Trace.out((int)5, (String)("==> Joined " + this.threadList[i].getName()));
                    }
                }
                catch (InterruptedException e) {
                    Trace.out((String)("\n THREADLIST.JOIN FAILED \n" + e));
                    ReportUtil.printError(s_msgBundle.getMessage("4060", true));
                    ErrorDescription errDesc = new ErrorDescription("4060", s_msgBundle);
                    this.m_resultSet.addErrorDescription(errDesc);
                    status = false;
                }
                for (int i2 = 0; i2 < numStorage; ++i2) {
                    t = this.threadList[i2];
                    t.printMessage();
                    status &= t.getSucc();
                }
            }
        }
        if (!this.m_mute) {
            ReportUtil.sureblankln();
            ReportUtil.sureblankln();
        }
        String nodeListStr = VerificationUtil.strArr2List(this.m_nodeList);
        if (status) {
            msg = s_msgBundle.getMessage("4099", false, (Object[])new String[]{nodeListStr});
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else {
            msg = s_msgBundle.getMessage("4100", false, (Object[])new String[]{nodeListStr});
            this.m_resultSet.addResult(this.m_nodeList, 2);
        }
        if (!this.m_mute) {
            ReportUtil.sureprintln(msg);
        }
        this.m_ssResSetImpl.uploadResultSet(this.m_resultSet);
        return status;
    }

    private boolean isAnyShared(Vector sharedSets, int minNodesReq) {
        boolean retval = false;
        Enumeration setEnum = sharedSets.elements();
        while (setEnum.hasMoreElements()) {
            SharedStorageSet sharedSet = (SharedStorageSet)setEnum.nextElement();
            if (sharedSet.getNumNodes() < minNodesReq) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private void printDiscoveryResult(Vector sharedSets, int minNodesReq) {
        Integer access = -1;
        boolean getAccess = false;
        Enumeration setEnum = sharedSets.elements();
        while (setEnum.hasMoreElements()) {
            SharedStorageSet sharedSet = (SharedStorageSet)setEnum.nextElement();
            if (sharedSet.getNumNodes() < minNodesReq) continue;
            if (!this.m_mute) {
                ReportUtil.sureblankln();
                ReportUtil.surewriteColHeaders(sharedSet.getTypeStr(), s_msgBundle.getMessage("8502", false, (Object[])new String[]{String.valueOf(sharedSet.getNumNodes())}));
            }
            Enumeration storageEnum = sharedSet.getSharedSet().elements();
            Hashtable<String, Vector<String>> pathTable = new Hashtable<String, Vector<String>>();
            Hashtable accessTable = new Hashtable();
            Vector<String> pathList = new Vector<String>();
            Vector<String> nodeList = null;
            ArrayList<Integer> accessList = null;
            FSInfo fsInfo = null;
            Integer fsAccess = -1;
            while (storageEnum.hasMoreElements()) {
                StorageInfo stInfo = (StorageInfo)storageEnum.nextElement();
                String key = stInfo.getName();
                nodeList = (Vector<String>)pathTable.get(key);
                accessList = (ArrayList<Integer>)accessTable.get(key);
                if (stInfo instanceof FSInfo || stInfo instanceof NFSInfo || stInfo instanceof OCFS2Info) {
                    if (stInfo instanceof FSInfo) {
                        fsInfo = (FSInfo)stInfo;
                    } else if (stInfo instanceof NFSInfo) {
                        fsInfo = ((NFSInfo)stInfo).getFSInfo();
                    } else if (stInfo instanceof OCFSInfo) {
                        fsInfo = ((OCFSInfo)stInfo).getFSInfo();
                    } else if (stInfo instanceof OCFS2Info) {
                        fsInfo = ((OCFS2Info)stInfo).getFSInfo();
                    }
                    if (fsInfo != null) {
                        fsAccess = fsInfo.getFSaccess();
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("FileSystem Info for: '" + fsInfo.getFSname() + "'"));
                        }
                    }
                } else {
                    fsInfo = null;
                    fsAccess = 1;
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("StorageInfo for: '" + stInfo.getClass().getName() + "'"));
                    }
                }
                if (fsInfo != null && accessList == null) {
                    accessList = new ArrayList<Integer>();
                    accessTable.put(key, accessList);
                }
                if (fsInfo != null && !accessList.contains(fsAccess)) {
                    accessList.add(fsAccess);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Adding Path: '" + key + "' Access: '" + fsAccess + "'"));
                    }
                }
                if (null == nodeList) {
                    pathList.add(key);
                    nodeList = new Vector<String>();
                    pathTable.put(key, nodeList);
                }
                if (nodeList.contains(stInfo.getNode())) continue;
                nodeList.add(stInfo.getNode());
            }
            String path = null;
            Enumeration pathEnum = pathList.elements();
            String line = null;
            while (pathEnum.hasMoreElements()) {
                path = (String)pathEnum.nextElement();
                nodeList = (Vector)pathTable.get(path);
                accessList = (List)accessTable.get(path);
                Vector lines = TaskSharedStorageAccess.spreadToLines(30, nodeList, " ");
                boolean pathNotPrinted = true;
                Enumeration lineEnum = lines.elements();
                while (lineEnum.hasMoreElements()) {
                    line = (String)lineEnum.nextElement();
                    if (pathNotPrinted) {
                        Trace.out((int)5, (String)("path:" + path));
                        if (!this.m_mute) {
                            ReportUtil.surewriteRecord(path, line);
                        }
                        pathNotPrinted = false;
                        continue;
                    }
                    if (!this.m_mute) {
                        ReportUtil.surewriteRecord("", line);
                    }
                    Trace.out((int)5, (String)line);
                }
                this.m_ssResSetImpl.addSharedStorageInfo(new SharedStorageInfoImpl(sharedSet.getTypeEnum(), path, nodeList.toArray(new String[nodeList.size()])));
                if (accessList == null) continue;
                if (accessList.size() > 1) {
                    ReportUtil.printWarning(s_msgBundle.getMessage("4151", false));
                    continue;
                }
                access = (Integer)accessList.get(0);
                if (access == 1) continue;
                ReportUtil.printWarning(s_msgBundle.getMessage("4152", false));
            }
        }
    }

    private static Vector spreadToLines(int maxChars, Collection strList, String seperator) {
        int curLen = 0;
        boolean lastIndex = false;
        int numCharsLeft = maxChars;
        int sepSize = seperator.length();
        StringBuffer sb = null;
        Vector<String> tempList = new Vector<String>();
        Vector<String> resultLines = new Vector<String>();
        Iterator strIter = strList.iterator();
        int cIndex = 0;
        while (strIter.hasNext()) {
            String curStr = (String)strIter.next();
            curLen = curStr.length() + sepSize;
            if (numCharsLeft - curLen <= 0) {
                sb = new StringBuffer();
                Iterator iter = tempList.iterator();
                while (iter.hasNext()) {
                    String str = (String)iter.next();
                    iter.remove();
                    sb.append(str + seperator);
                }
                resultLines.add(sb.toString());
                numCharsLeft = maxChars;
            }
            tempList.add(curStr);
            numCharsLeft -= curLen;
            ++cIndex;
        }
        Iterator iter = tempList.iterator();
        if (iter.hasNext()) {
            sb = new StringBuffer();
            while (iter.hasNext()) {
                String str = (String)iter.next();
                sb.append(str + seperator);
            }
            resultLines.add(sb.toString());
        }
        return resultLines;
    }

    private void reportNodeInfoError(NodeStorageInfo[] nodeInfoList) {
        Vector errList = new Vector();
        for (int i = 0; i < nodeInfoList.length; ++i) {
            errList.addAll(nodeInfoList[i].getResult().getErrorInfoSet());
        }
        this.reportStorageExceptions(errList, DISPLAY_WARNING);
    }

    private void reportException(Exception e, String subject) {
        String className = e.getClass().getName();
        String MULTINODE_EXCEPTION = "oracle.ops.verification.util.MultiNodeException";
        ReportUtil.printErrorHeader(subject);
        if (MULTINODE_EXCEPTION.equals(className)) {
            Collection errList = ((MultiNodeException)e).getThrowables();
            this.reportStorageExceptions(errList, DISPLAY_NONE);
        } else {
            ReportUtil.sureprintln(e.getMessage());
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.setStatus(2);
        }
    }

    private void reportStorageExceptions(Collection errList, int errorHeader) {
        ClassifierTable table = new ClassifierTable();
        for (StorageException ste : errList) {
            table.put(ste.getMessageKey(), ste);
        }
        Collection superGroup = table.subGroups();
        for (Collection subGroup : superGroup) {
            StorageException ste;
            Iterator steIter = subGroup.iterator();
            Vector<String> nodeVect = new Vector<String>();
            ste = null;
            while (steIter.hasNext()) {
                ste = (StorageException)steIter.next();
                nodeVect.add(ste.getNode());
            }
            if (nodeVect.size() <= 0) continue;
            if (DISPLAY_ERROR == errorHeader) {
                ReportUtil.printError(ste.getMessage());
                ReportUtil.sureprintNodelist(nodeVect);
            } else if (DISPLAY_WARNING == errorHeader) {
                ReportUtil.printWarning(ste.getMessage());
                ReportUtil.sureprintNodelist(nodeVect);
            } else {
                ReportUtil.sureprintln(ste.getMessage());
                ReportUtil.sureprintNodelist(nodeVect);
            }
            ErrorDescription errDesc = new ErrorDescription(ste.getMessage() + LSEP + s_msgBundle.getMessage("7513", false) + LSEP + VerificationUtil.strVect2List(nodeVect));
            this.m_resultSet.addErrorDescription(errDesc);
        }
    }

    public SharedStorageResultSetImpl getSharedStorageResultSetImpl() {
        return this.m_ssResSetImpl;
    }

    private boolean isDebug() {
        return this.m_debugFlag;
    }

    public void setOCRLocationFlag(boolean isOCRLoc) {
        this.m_isOCRLocation = isOCRLoc;
        if (this.m_isOCRLocation) {
            this.m_oracleFileType = OracleFileType.RAC_OCR_VDISK;
            this.setStorageElementName(StorageType.OCR);
        }
    }

    public boolean isOCRLocation() {
        return this.m_isOCRLocation;
    }

    public void setVDiskLocationFlag(boolean isVDiskLoc) {
        this.m_isVDiskLocation = isVDiskLoc;
        if (this.m_isVDiskLocation) {
            this.m_oracleFileType = OracleFileType.RAC_OCR_VDISK;
            this.setStorageElementName(StorageType.VOTING_DISK);
        }
    }

    public boolean isVDiskLocation() {
        return this.m_isVDiskLocation;
    }

    public String getDefaultElementName() {
        if (null == this.m_storageIDList) {
            return s_msgBundle.getMessage("4427", false);
        }
        return s_msgBundle.getMessage("4426", false) + (this.m_storageElementName == null ? "" : ":" + (Object)((Object)this.m_storageElementName)) + ":" + VerificationUtil.strArr2List(this.m_storageIDList);
    }

    public String getDefaultDescription() {
        if (null == this.m_storageIDList) {
            return s_msgBundle.getMessage("4478", false);
        }
        return s_msgBundle.getMessage(this.getStorageSpecificDescMsgID(), false);
    }

    private String getStorageSpecificDescMsgID() {
        if (this.m_storageElementName == null) {
            return "4477";
        }
        switch (this.m_storageElementName) {
            case OCR: {
                return "5459";
            }
            case VOTING_DISK: {
                return "5460";
            }
        }
        return "4477";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    StorageIDList: " + VerificationUtil.strArr2List(this.m_storageIDList));
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StorageThread
    extends Thread {
        protected String m_storageID;
        protected String[] m_nodeList;
        protected String m_message;
        private Exception m_exception;
        private boolean m_checkOCFS = false;
        private boolean m_checkWritableFS = false;
        private boolean m_isShared = false;
        private boolean m_isOCFS = false;
        private boolean m_isRoFsPath = false;
        private Vector<StorageInfo> m_stList = new Vector();
        private boolean m_isNotPartition = false;

        public StorageThread(String[] nodeList, String storageID, boolean checkOCFS, boolean checkWritableFS) {
            this.m_checkOCFS = checkOCFS;
            this.m_nodeList = nodeList;
            this.m_storageID = storageID;
            this.m_checkWritableFS = checkWritableFS;
        }

        @Override
        public void run() {
            File file;
            VerifyStorage verifySt = new VerifyStorage();
            try {
                this.m_isShared = verifySt.isShared(this.m_storageID, this.m_nodeList, this.m_stList, TaskSharedStorageAccess.this.m_oracleFileType);
            }
            catch (StorageException e) {
                Trace.out((String)(" " + e));
                if (null != e.getCause()) {
                    Trace.out((String)("Cause: " + e.getCause()));
                }
                this.m_isShared = false;
                this.m_exception = e;
            }
            catch (MultiNodeException mne) {
                this.m_isShared = false;
                this.m_exception = mne;
            }
            try {
                if (this.m_isShared && this.m_checkOCFS) {
                    this.m_isOCFS = verifySt.isOCFS(this.m_nodeList[0], this.m_storageID);
                }
            }
            catch (StorageException e) {
                Trace.out((String)(" " + e));
                if (null != e.getCause()) {
                    Trace.out((String)("Cause: " + e.getCause()));
                }
                this.m_isOCFS = false;
                this.m_exception = e;
            }
            if (this.m_isShared && this.m_checkWritableFS && ((file = new File(this.m_storageID)).isDirectory() || file.isFile()) && !file.canWrite()) {
                this.m_isRoFsPath = true;
            }
            if (this.m_isShared && (TaskSharedStorageAccess.this.isOCRLocation() || TaskSharedStorageAccess.this.isVDiskLocation()) && this.m_stList.size() > 0 && this.m_stList.firstElement().getType() == 1 && sStorageUtil.getNumDiskPartitions(this.m_stList.firstElement()) != 0) {
                this.m_isNotPartition = true;
            }
        }

        protected boolean isShared() {
            return this.m_isShared;
        }

        public boolean isReadOnly() {
            return this.m_isRoFsPath;
        }

        public Exception getException() {
            return this.m_exception;
        }

        protected boolean isOCFS() {
            return this.m_isOCFS;
        }

        protected boolean getSucc() {
            boolean succ = false;
            succ = this.m_checkOCFS ? this.isOCFS() && this.isShared() : this.isShared();
            return succ;
        }

        public Vector<StorageInfo> getStorageInfoVector() {
            return this.m_stList;
        }

        public String getStoragePath() {
            return this.m_storageID;
        }

        public String getStorageType() {
            return this.m_storageID;
        }

        public void printMessage() {
            if (null == this.m_exception) {
                if (this.m_isShared) {
                    ErrorDescription errDesc;
                    String sharedMsg = VerificationConstants.LSEP + Task.s_msgBundle.getMessage("4061", false, (Object[])new String[]{this.m_storageID});
                    TaskSharedStorageAccess.this.m_resultSet.setStatus(1);
                    if (!TaskSharedStorageAccess.this.m_mute) {
                        ReportUtil.sureprintln(sharedMsg);
                    }
                    if (this.m_checkOCFS && !this.isOCFS()) {
                        String ocfsMsg = Task.s_msgBundle.getMessage("7019", false, (Object[])new String[]{this.m_storageID});
                        if (!TaskSharedStorageAccess.this.m_mute) {
                            ReportUtil.sureprintln(ocfsMsg);
                        }
                        errDesc = new ErrorDescription(ocfsMsg);
                        TaskSharedStorageAccess.this.m_resultSet.addErrorDescription(errDesc);
                        TaskSharedStorageAccess.this.m_resultSet.setStatus(2);
                    }
                    if (this.m_isRoFsPath) {
                        String warnMsg = Task.s_msgBundle.getMessage("0020", true, (Object[])new String[]{this.m_storageID});
                        ReportUtil.printWarning(warnMsg);
                        errDesc = new ErrorDescription(sharedMsg + VerificationConstants.LSEP + warnMsg, Task.s_msgBundle, "0020");
                        TaskSharedStorageAccess.this.m_resultSet.addErrorDescription(errDesc);
                        TaskSharedStorageAccess.this.m_resultSet.setStatus(4);
                    }
                    if (this.m_isNotPartition) {
                        String wrnmsg = null;
                        if (TaskSharedStorageAccess.this.isOCRLocation()) {
                            wrnmsg = Task.s_msgBundle.getMessage("4211", true, (Object[])new String[]{this.m_storageID});
                        } else if (TaskSharedStorageAccess.this.isVDiskLocation()) {
                            wrnmsg = Task.s_msgBundle.getMessage("4212", true, (Object[])new String[]{this.m_storageID});
                        }
                        ReportUtil.printWarning(wrnmsg);
                        errDesc = new ErrorDescription(wrnmsg);
                        TaskSharedStorageAccess.this.m_resultSet.addErrorDescription(errDesc);
                        TaskSharedStorageAccess.this.m_resultSet.setStatus(4);
                    }
                } else {
                    String notSharedMsg = VerificationConstants.LSEP + Task.s_msgBundle.getMessage("4062", false, (Object[])new String[]{this.m_storageID});
                    if (!TaskSharedStorageAccess.this.m_mute) {
                        ReportUtil.sureprintln(notSharedMsg);
                    }
                    ErrorDescription errDesc = new ErrorDescription(notSharedMsg);
                    TaskSharedStorageAccess.this.m_resultSet.addErrorDescription(errDesc);
                    TaskSharedStorageAccess.this.m_resultSet.setStatus(3);
                }
            } else {
                TaskSharedStorageAccess.this.reportException(this.m_exception, this.m_storageID);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StorageType {
        OCR(VerificationUtil.getMessageBundle("Prvf").getMessage("5457", false)),
        VOTING_DISK(VerificationUtil.getMessageBundle("Prvf").getMessage("5458", false));

        private String m_desc;

        private StorageType(String desc) {
            this.m_desc = desc;
        }

        public String toString() {
            return this.m_desc;
        }
    }
}

