/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.ShellType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.fixup.ShellLimitFixes;

public class TaskShellLimits
extends Task {
    private String m_constraintName = null;
    private ShellType m_shellType;
    private ShellLimitType m_limitType;
    private ShellResourceType m_resourceType;
    private long m_limit;
    boolean m_toCheckForMax;

    public TaskShellLimits(ShellType shellType, ShellResourceType resourceType, ShellLimitType limitType, long limit) {
        this.m_shellType = shellType;
        this.m_resourceType = resourceType;
        this.m_limitType = limitType;
        this.m_limit = limit;
        this.m_constraintName = ShellLimitType.HARD.equals((Object)limitType) ? s_msgBundle.getMessage("1067", false) : s_msgBundle.getMessage("1068", false);
    }

    public void checkForMax() {
        this.m_toCheckForMax = true;
    }

    public String getDefaultElementName() {
        if (ShellLimitType.HARD.equals((Object)this.m_limitType)) {
            return s_msgBundle.getMessage("4419", false) + ": " + (Object)((Object)this.m_resourceType);
        }
        return s_msgBundle.getMessage("4443", false) + ": " + (Object)((Object)this.m_resourceType);
    }

    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing shell limit verification task... ");
        }
        if (!VerificationUtil.getCurrentOS().toLowerCase().startsWith("linux")) {
            this.setFixup(false);
        }
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{this.m_constraintName, this.m_resourceType.toString()}));
        this.performShellLimitChecks();
        if (this.m_resultSet.allSuccess()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Successful on all nodes. Retruning true");
            }
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{this.m_constraintName, this.m_resourceType.toString()}));
            return true;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Atleast on node failed. Retruning fail");
        }
        this.reportFixupGenErrors();
        ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{this.m_constraintName, this.m_resourceType.toString()}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void performShellLimitChecks() {
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.SHELL_LIMIT_TYPE, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet limitChkRS = new ResultSet();
        Object limitOutput = null;
        globalExec.getRLimit(this.m_nodeList, System.getProperty("user.name"), this.m_limitType.toString().toLowerCase(), this.m_resourceType.getItemName(), limitChkRS);
        this.m_resultSet.uploadResultSet(limitChkRS);
        Hashtable t = limitChkRS.getResultTable();
        for (String node : this.m_nodeList) {
            String comment;
            Result result = (Result)t.get(node);
            if (result.getStatus() != 1) {
                Object[] msgParams = new String[]{this.m_resourceType.toString(), node};
                String errMsg = null;
                errMsg = this.m_limitType.equals((Object)ShellLimitType.SOFT) ? s_msgBundle.getMessage("4355", false, msgParams) : s_msgBundle.getMessage("4356", false, msgParams);
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                continue;
            }
            String shellLimitOnNodeStr = (String)result.getResultInfoSet().firstElement();
            long shellLimitOnNode = "unlimited".equals(shellLimitOnNodeStr) ? Long.MAX_VALUE : Long.parseLong(shellLimitOnNodeStr);
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setExpectedValue(Long.toString(this.m_limit));
            this.m_resultSet.getResult(node).setActualValue(Long.toString(shellLimitOnNode));
            if (shellLimitOnNode >= this.m_limit) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Sufficient shell limit on node: " + node + ", shell resource type = " + (Object)((Object)this.m_resourceType) + ", shell limit type = " + (Object)((Object)this.m_limitType) + " [Required=" + this.m_limit + ", Available=" + shellLimitOnNode + "]"));
                }
                comment = ReportUtil.PASSED;
            } else {
                ArrayList<String> fileList;
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Insufficient shell limit on node: " + node + ", shell resource type = " + (Object)((Object)this.m_resourceType) + ", shell limit type = " + (Object)((Object)this.m_limitType) + " [Required=" + this.m_limit + ", Available=" + shellLimitOnNode + "]"));
                }
                String errorMessage = null;
                String cause = null;
                String action = null;
                if (this.m_limitType.equals((Object)ShellLimitType.SOFT)) {
                    errorMessage = s_msgBundle.getMessage("4353", true, (Object[])new String[]{this.m_resourceType.toString(), node, Long.toString(this.m_limit), Long.toString(shellLimitOnNode)});
                    cause = s_msgBundle.getCause("4353", false);
                    action = s_msgBundle.getAction("4353", false);
                } else {
                    errorMessage = s_msgBundle.getMessage("4354", true, (Object[])new String[]{this.m_resourceType.toString(), node, Long.toString(this.m_limit), Long.toString(shellLimitOnNode)});
                    cause = s_msgBundle.getCause("4354", false);
                    action = s_msgBundle.getAction("4354", false);
                }
                ErrorDescription errDesc = new ErrorDescription(errorMessage, cause, action);
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 3);
                comment = ReportUtil.FAILED;
                if (this.isFixupReqd() && (fileList = this.getFixupFiles(node, this.m_resultSet)) != null) {
                    OipcrIResult oResult = OipcrResult.FAILED_RESULT;
                    String chkType = "";
                    if (this.m_limitType.equals((Object)ShellLimitType.SOFT)) {
                        if (this.m_resourceType.equals((Object)ShellResourceType.MAX_FILEDESC)) {
                            chkType = "Descriptor SoftLimit Value ";
                        } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_PROC)) {
                            chkType = "Maxproc SoftLimit Value ";
                        }
                    } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_FILEDESC)) {
                        chkType = "Descriptor HardLimit Value ";
                    } else if (this.m_resourceType.equals((Object)ShellResourceType.MAX_PROC)) {
                        chkType = "Maxproc HardLimit Value ";
                    }
                    String sActualValue = chkType + Long.toString(shellLimitOnNode);
                    String sExpectedValue = chkType + Long.toString(this.m_limit);
                    OipcrResultDetails oResData = new OipcrResultDetails((Object)sActualValue, (Object)sExpectedValue, oResult);
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    oResDetails.add(oResData);
                    oResult = new OipcrResult(oResDetails);
                    OipcfFixUpResult fixupRslt = ShellLimitFixes.fixShellLimits(null, (String)node, (OipcrIResult)oResult, fileList);
                    if (fixupRslt.getFixUpResult() != OipcfFixUpResult.PASSED) {
                        String errMsg = null;
                        String causeMsg = null;
                        String actionMsg = null;
                        if (this.m_limitType.equals((Object)ShellLimitType.SOFT)) {
                            errMsg = s_msgBundle.getMessage("7723", true, (Object[])new String[]{this.m_resourceType.toString(), node});
                            causeMsg = s_msgBundle.getCause("7723", false);
                            actionMsg = s_msgBundle.getAction("7723", false);
                        } else {
                            errMsg = s_msgBundle.getMessage("7724", true, (Object[])new String[]{this.m_resourceType.toString(), node});
                            causeMsg = s_msgBundle.getCause("7724", false);
                            actionMsg = s_msgBundle.getAction("7724", false);
                        }
                        OiixException oiEx = fixupRslt.getFixUpException();
                        if (oiEx != null) {
                            errMsg = errMsg + LSEP + oiEx.getErrorMessage();
                        }
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)errMsg);
                        }
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg, causeMsg, actionMsg));
                        this.addFixupGenError(node, errMsg);
                    } else {
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("Fixup was successfully generated for setting " + (Object)((Object)this.m_limitType) + " limit of resource '" + (Object)((Object)this.m_resourceType) + "' on node '" + node + "'"));
                        }
                        this.m_resultSet.getResult(node).setFixupAvailable(true);
                    }
                }
            }
            String limitTypeText = null;
            limitTypeText = this.m_limitType.equals((Object)ShellLimitType.SOFT) ? s_msgBundle.getMessage("8219", false) : s_msgBundle.getMessage("8220", false);
            ReportUtil.writeRecord(node, limitTypeText, Long.toString(shellLimitOnNode), Long.toString(this.m_limit), comment);
        }
    }

    public String getDefaultDescription() {
        Object[] msgParams = new String[]{this.m_resourceType.toString(), Long.toString(this.m_limit)};
        if (ShellLimitType.HARD.equals((Object)this.m_limitType)) {
            return s_msgBundle.getMessage("4489", false, msgParams);
        }
        return s_msgBundle.getMessage("4490", false, msgParams);
    }
}

