/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoader;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoaderException;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.SoftwareDistributionFileInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskSoftwareDistribution
extends Task {
    private static final String FILE_STATUS_FAILED = "1";
    private static final String SD_FILE_LIST_SUFFIX = ".txt";
    private static final String SD_FILE_LIST_PREFIX = "softwareDistributionFileList";
    private static final String TAG_FILE = "FILE";
    private String m_softwareComponent;
    private String m_softwareComponentHome;
    private String m_configFile;
    private String m_release;

    public TaskSoftwareDistribution(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskSoftwareDistribution(String[] nodeList, String configFile, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskSoftwareDistribution(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Performing Software verification task... ");
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4375", false));
        try {
            this.performSoftwareChecks();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4376", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4377", false));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSoftwareChecks() {
        int nodeCount = this.m_nodeList.length;
        String destinationfileName = null;
        String sourceFile = null;
        HashMap compFileList = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        try {
            this.m_configFile = VerificationUtil.getCompSoftwareConfigXmlPath(this.m_release);
            CompSoftwareConfigLoader loader = new CompSoftwareConfigLoader(this.m_configFile, this.m_softwareComponent, this.m_softwareComponentHome);
            File tmpFile = File.createTempFile(SD_FILE_LIST_PREFIX, SD_FILE_LIST_SUFFIX, new File(VerificationUtil.getDestLoc()));
            tmpFile.deleteOnExit();
            FileWriter tmpFileWriter = new FileWriter(tmpFile);
            BufferedWriter writer = new BufferedWriter(tmpFileWriter);
            compFileList = loader.load();
            boolean first = true;
            Iterator compIter = compFileList.keySet().iterator();
            while (compIter.hasNext()) {
                String comp = compIter.next().toString();
                if (this.m_softwareComponent != null && !this.m_softwareComponent.equalsIgnoreCase(comp)) {
                    Trace.out((String)("Check for component " + this.m_softwareComponent + " requested. Skipping files for component: " + comp));
                    continue;
                }
                List fileList = (List)compFileList.get(comp);
                for (int i = 0; i < fileList.size(); ++i) {
                    SoftwareDistributionFileInfo file = (SoftwareDistributionFileInfo)fileList.get(i);
                    writer.write(file.getFileName() + System.getProperty("line.separator"));
                }
            }
            writer.close();
            sourceFile = tmpFile.getAbsolutePath();
            destinationfileName = File.createTempFile(SD_FILE_LIST_PREFIX, SD_FILE_LIST_SUFFIX, new File(VerificationUtil.getDestLoc())).getAbsolutePath();
        }
        catch (CompSoftwareConfigLoaderException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        catch (IOException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5000", false));
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        catch (XmlFilePathException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errorDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((String)("==== Error while reading software distribution configuration: " + e));
            return;
        }
        ResultSet resultSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.copyFile(this.m_nodeList, sourceFile, destinationfileName, resultSet);
        this.m_resultSet.uploadResultSet(resultSet);
        if (!resultSet.anySuccess()) {
            String message = s_msgBundle.getMessage("5001", false);
            ErrorDescription errorDesc = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(message);
            return;
        }
        VerificationCommand[] fileInfoCmdArray = new VerificationCommand[nodeCount];
        for (int j = 0; j < nodeCount; ++j) {
            String[] arg = new String[]{"-getfileinfo", destinationfileName};
            String[] env = null;
            fileInfoCmdArray[j] = new VerificationCommand(this.m_nodeList[j], arg, env);
        }
        resultSet = new ResultSet();
        new GlobalHandler().submit((Command[])fileInfoCmdArray, 0, resultSet);
        this.m_resultSet.uploadResultSet(resultSet);
        if (!resultSet.anySuccess()) {
            String localNodeName;
            try {
                localNodeName = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                localNodeName = "localnode";
            }
            String message = s_msgBundle.getMessage("5002", false, (Object[])new String[]{localNodeName});
            ErrorDescription errorDesc = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(message);
            return;
        }
        Hashtable<String, Hashtable<String, SoftwareDistributionFileInfo>> nodeValues = new Hashtable<String, Hashtable<String, SoftwareDistributionFileInfo>>();
        Vector<String> execkTaskFailedNodes = new Vector<String>();
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand fileInfoCmd = fileInfoCmdArray[nodeIndex];
            Result result = fileInfoCmd.getResult();
            if (result.getStatus() == 1) {
                ErrorDescription errorDesc;
                String node = fileInfoCmd.getNode();
                String outputFileName = fileInfoCmd.getOutput();
                String shortFileName = outputFileName.substring(outputFileName.lastIndexOf(File.separator) + 1);
                String destinationFileName = VerificationUtil.getDestLoc() + node + "." + shortFileName;
                nativeSys.copyFile(node, outputFileName, "localnode", destinationFileName);
                File destinationFile = new File(destinationFileName);
                if (!destinationFile.exists()) {
                    this.m_resultSet.addResult(node, 2);
                    ErrorDescription errorDesc2 = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{node}));
                    this.m_resultSet.addErrorDescription(node, errorDesc2);
                    execkTaskFailedNodes.add(node);
                    continue;
                }
                StringBuffer outputBuffer = new StringBuffer();
                try {
                    String line;
                    BufferedReader destinationFileBR = new BufferedReader(new FileReader(destinationFile));
                    while ((line = destinationFileBR.readLine()) != null) {
                        outputBuffer.append(line);
                    }
                    destinationFileBR.close();
                }
                catch (FileNotFoundException e) {
                    this.m_resultSet.addResult(node, 2);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{node}));
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    execkTaskFailedNodes.add(node);
                    continue;
                }
                catch (IOException e) {
                    this.m_resultSet.addResult(node, 2);
                    errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{node}));
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    execkTaskFailedNodes.add(node);
                    continue;
                }
                finally {
                    nativeSys.removeFile(node, outputFileName);
                    nativeSys.removeFile("localnode", destinationFileName);
                }
                Hashtable<String, SoftwareDistributionFileInfo> fileList = new Hashtable<String, SoftwareDistributionFileInfo>();
                nodeValues.put(node, fileList);
                Vector infStrs = null;
                try {
                    String output = outputBuffer.toString().replaceAll("\n", "");
                    infStrs = GenericUtil.getAllStrByTags(output, TAG_FILE);
                    for (Object fmtdObj : infStrs) {
                        String fmtdStr = (String)fmtdObj;
                        SoftwareDistributionFileInfo fileInfo = new SoftwareDistributionFileInfo();
                        fileInfo.setStatus(GenericUtil.getValueByKey(fmtdStr, "STATUS"));
                        fileInfo.setErrorString(GenericUtil.getValueByKey(fmtdStr, "ERROR"));
                        fileInfo.setFileName(GenericUtil.getValueByKey(fmtdStr, "NAME"));
                        fileInfo.setFileOwner(GenericUtil.getValueByKey(fmtdStr, "USER"));
                        fileInfo.setFileGroup(GenericUtil.getValueByKey(fmtdStr, "GROUP"));
                        fileInfo.setFilePermissions(GenericUtil.getValueByKey(fmtdStr, "PERMISSIONS"));
                        fileList.put(fileInfo.getFileName(), fileInfo);
                    }
                    continue;
                }
                catch (ParsingException p) {
                    Trace.out((Exception)p);
                    this.m_resultSet.addResult(fileInfoCmd.getNode(), 2);
                    ErrorDescription errorDesc3 = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{fileInfoCmd.getNode()}));
                    this.m_resultSet.addErrorDescription(fileInfoCmd.getNode(), errorDesc3);
                    this.m_resultSet.addResult(fileInfoCmd.getNode(), 2);
                    execkTaskFailedNodes.add(fileInfoCmd.getNode());
                    continue;
                }
            }
            this.m_resultSet.addResult(fileInfoCmd.getNode(), 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{fileInfoCmd.getNode()}));
            this.m_resultSet.addErrorDescription(fileInfoCmd.getNode(), errorDesc);
            execkTaskFailedNodes.add(fileInfoCmd.getNode());
        }
        if (!execkTaskFailedNodes.isEmpty()) {
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("5010", false));
            ReportUtil.sureprintNodelist(execkTaskFailedNodes);
        }
        this.reportResults(compFileList, nodeValues);
        resultSet = new ResultSet();
        globalExec.deleteFile(this.m_nodeList, destinationfileName, resultSet);
    }

    private void reportResults(HashMap<String, List<SoftwareDistributionFileInfo>> refCompFileTable, Hashtable<String, Hashtable<String, SoftwareDistributionFileInfo>> nodeExecTaskValues) {
        for (String compName : refCompFileTable.keySet()) {
            Hashtable nodeBasedResultTable = new Hashtable();
            List<SoftwareDistributionFileInfo> refFileList = refCompFileTable.get(compName);
            for (SoftwareDistributionFileInfo refFileInfo : refFileList) {
                SoftwareDistributionFileInfo nodeFileInfo;
                Hashtable<String, String> mismatchAttributeMap;
                ErrorDescription error;
                String errorMessage;
                List<Hashtable<String, String>> mismatchAttributeList;
                String refFileName = refFileInfo.getFileName();
                String refOwner = refFileInfo.getFileOwner();
                String refGroup = refFileInfo.getFileGroup();
                String refPermissions = refFileInfo.getFilePermissions();
                HashMap<String, ArrayList<String>> fileOwnerMap = new HashMap<String, ArrayList<String>>();
                HashMap fileGroupMap = new HashMap();
                HashMap filePermissionsMap = new HashMap();
                ArrayList<String> successfulNodes = new ArrayList<String>();
                Hashtable referenceAttributeMismatchMap = new Hashtable();
                for (String node : nodeExecTaskValues.keySet()) {
                    List<String> nodeList;
                    Hashtable<String, String> mismatchAttributeMap2;
                    ErrorDescription error2;
                    String errorMessage2;
                    Hashtable<String, SoftwareDistributionFileInfo> nodeFileInfoTable = nodeExecTaskValues.get(node);
                    SoftwareDistributionFileInfo nodeFileInfo2 = nodeFileInfoTable.get(refFileName);
                    if (FILE_STATUS_FAILED.equals(nodeFileInfo2.getStatus())) {
                        ArrayList nodeFailedFileList = (ArrayList)nodeBasedResultTable.get(node);
                        if (nodeFailedFileList == null) {
                            nodeFailedFileList = new ArrayList();
                            nodeBasedResultTable.put(node, nodeFailedFileList);
                        }
                        Hashtable<String, String> fileTable = new Hashtable<String, String>();
                        fileTable.put("FILE_NAME", refFileName);
                        fileTable.put("ERROR", nodeFileInfo2.getErrorString());
                        nodeFailedFileList.add(fileTable);
                        this.m_resultSet.addResult(node, 3);
                        ErrorDescription error3 = new ErrorDescription(s_msgBundle.getMessage("5003", false, (Object[])new String[]{refFileName, node, nodeFileInfo2.getErrorString()}));
                        this.m_resultSet.addErrorDescription(node, error3);
                        continue;
                    }
                    if (refOwner != null) {
                        if (!refOwner.equals(nodeFileInfo2.getFileOwner())) {
                            this.m_resultSet.addResult(node, 3);
                            errorMessage2 = s_msgBundle.getMessage("5005", false, (Object[])new String[]{refFileName, refOwner, nodeFileInfo2.getFileOwner()});
                            error2 = new ErrorDescription(errorMessage2);
                            this.m_resultSet.addErrorDescription(node, error2);
                            mismatchAttributeMap2 = new Hashtable<String, String>();
                            mismatchAttributeMap2.put("ATTRIBUTE", "Owner");
                            mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                            mismatchAttributeList = (ArrayList)referenceAttributeMismatchMap.get(node);
                            if (mismatchAttributeList == null) {
                                mismatchAttributeList = new ArrayList();
                                referenceAttributeMismatchMap.put(node, mismatchAttributeList);
                            }
                            mismatchAttributeList.add(mismatchAttributeMap2);
                        }
                    } else if (nodeFileInfo2.getFileOwner() != null) {
                        nodeList = (ArrayList<String>)fileOwnerMap.get(nodeFileInfo2.getFileOwner());
                        if (nodeList == null) {
                            nodeList = new ArrayList<String>();
                            fileOwnerMap.put(nodeFileInfo2.getFileOwner(), (ArrayList<String>)nodeList);
                        }
                        nodeList.add(node);
                    }
                    if (refGroup != null) {
                        if (!refGroup.equals(nodeFileInfo2.getFileGroup())) {
                            this.m_resultSet.addResult(node, 3);
                            errorMessage2 = s_msgBundle.getMessage("5007", false, (Object[])new String[]{refFileName, refGroup, nodeFileInfo2.getFileGroup()});
                            error2 = new ErrorDescription(errorMessage2);
                            this.m_resultSet.addErrorDescription(node, error2);
                            mismatchAttributeMap2 = new Hashtable();
                            mismatchAttributeMap2.put("ATTRIBUTE", "Group");
                            mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                            mismatchAttributeList = (List)referenceAttributeMismatchMap.get(node);
                            if (mismatchAttributeList == null) {
                                mismatchAttributeList = new ArrayList();
                                referenceAttributeMismatchMap.put(node, mismatchAttributeList);
                            }
                            mismatchAttributeList.add(mismatchAttributeMap2);
                        }
                    } else if (nodeFileInfo2.getFileGroup() != null) {
                        nodeList = (List)fileGroupMap.get(nodeFileInfo2.getFileGroup());
                        if (nodeList == null) {
                            nodeList = new ArrayList();
                            fileGroupMap.put(nodeFileInfo2.getFileGroup(), nodeList);
                        }
                        nodeList.add(node);
                    }
                    if (refPermissions != null) {
                        if (Integer.parseInt(refPermissions, 8) != Integer.parseInt(nodeFileInfo2.getFilePermissions(), 8)) {
                            this.m_resultSet.addResult(node, 3);
                            errorMessage2 = s_msgBundle.getMessage("5009", false, (Object[])new String[]{refFileName, refPermissions, nodeFileInfo2.getFilePermissions()});
                            error2 = new ErrorDescription(errorMessage2);
                            this.m_resultSet.addErrorDescription(node, error2);
                            mismatchAttributeMap2 = new Hashtable();
                            mismatchAttributeMap2.put("ATTRIBUTE", "Permissions");
                            mismatchAttributeMap2.put("MESSAGE", errorMessage2);
                            mismatchAttributeList = (List)referenceAttributeMismatchMap.get(node);
                            if (mismatchAttributeList == null) {
                                mismatchAttributeList = new ArrayList();
                                referenceAttributeMismatchMap.put(node, mismatchAttributeList);
                            }
                            mismatchAttributeList.add(mismatchAttributeMap2);
                        }
                    } else if (nodeFileInfo2.getFilePermissions() != null) {
                        nodeList = (List)filePermissionsMap.get(nodeFileInfo2.getFilePermissions());
                        if (nodeList == null) {
                            nodeList = new ArrayList();
                            filePermissionsMap.put(nodeFileInfo2.getFilePermissions(), nodeList);
                        }
                        nodeList.add(node);
                    }
                    successfulNodes.add(node);
                }
                Hashtable nodeAttributeMismatchMap = new Hashtable();
                if (fileOwnerMap.size() > 1) {
                    this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                    errorMessage = s_msgBundle.getMessage("5004", false, (Object[])new String[]{refFileName, fileOwnerMap.toString()});
                    error = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                    for (String node : successfulNodes) {
                        mismatchAttributeMap = new Hashtable<String, String>();
                        nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                        mismatchAttributeMap.put("ATTRIBUTE", "Owner");
                        mismatchAttributeMap.put("MESSAGE", errorMessage);
                        mismatchAttributeList = (List)nodeAttributeMismatchMap.get(node);
                        if (mismatchAttributeList == null) {
                            mismatchAttributeList = new ArrayList();
                            nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                        }
                        mismatchAttributeList.add(mismatchAttributeMap);
                    }
                }
                if (fileGroupMap.size() > 1) {
                    this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                    errorMessage = s_msgBundle.getMessage("5006", false, (Object[])new String[]{refFileName, fileGroupMap.toString()});
                    error = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                    for (String node : successfulNodes) {
                        mismatchAttributeMap = new Hashtable();
                        nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                        mismatchAttributeMap.put("ATTRIBUTE", "Group");
                        mismatchAttributeMap.put("MESSAGE", errorMessage);
                        mismatchAttributeList = (List)nodeAttributeMismatchMap.get(node);
                        if (mismatchAttributeList == null) {
                            mismatchAttributeList = new ArrayList();
                            nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                        }
                        mismatchAttributeList.add(mismatchAttributeMap);
                    }
                }
                if (filePermissionsMap.size() > 1) {
                    this.m_resultSet.addResult(successfulNodes.toArray(new String[0]), 3);
                    errorMessage = s_msgBundle.getMessage("5008", false, (Object[])new String[]{refFileName, filePermissionsMap.toString()});
                    error = new ErrorDescription(errorMessage);
                    this.m_resultSet.addErrorDescription(successfulNodes.toArray(new String[0]), error);
                    for (String node : successfulNodes) {
                        mismatchAttributeMap = new Hashtable();
                        nodeFileInfo = nodeExecTaskValues.get(node).get(refFileName);
                        mismatchAttributeMap.put("ATTRIBUTE", "Permissions");
                        mismatchAttributeMap.put("MESSAGE", errorMessage);
                        mismatchAttributeList = (List)nodeAttributeMismatchMap.get(node);
                        if (mismatchAttributeList == null) {
                            mismatchAttributeList = new ArrayList();
                            nodeAttributeMismatchMap.put(node, mismatchAttributeList);
                        }
                        mismatchAttributeList.add(mismatchAttributeMap);
                    }
                }
                for (String node : successfulNodes) {
                    String message;
                    List nodeMismatchedList = (List)nodeAttributeMismatchMap.get(node);
                    List referenceMismatchedList = (List)referenceAttributeMismatchMap.get(node);
                    ArrayList attributesMismatched = new ArrayList();
                    ArrayList detailedMessage = new ArrayList();
                    StringBuffer errorMessage3 = new StringBuffer();
                    boolean mismatchFound = false;
                    if (nodeMismatchedList != null) {
                        mismatchFound = true;
                        for (Hashtable mismatchedAttributeMap : nodeMismatchedList) {
                            attributesMismatched.add(mismatchedAttributeMap.get("ATTRIBUTE"));
                            detailedMessage.add(mismatchedAttributeMap.get("MESSAGE"));
                        }
                        message = s_msgBundle.getMessage("5011", false, (Object[])new String[]{VerificationUtil.strArr2List(attributesMismatched.toArray(new String[0]))});
                        errorMessage3.append(message);
                    }
                    attributesMismatched = new ArrayList();
                    if (referenceMismatchedList != null) {
                        mismatchFound = true;
                        for (Hashtable mismatchedAttributeMap : referenceMismatchedList) {
                            attributesMismatched.add(mismatchedAttributeMap.get("ATTRIBUTE"));
                            detailedMessage.add(mismatchedAttributeMap.get("MESSAGE"));
                        }
                        message = s_msgBundle.getMessage("5012", false, (Object[])new String[]{VerificationUtil.strArr2List(attributesMismatched.toArray(new String[0]))});
                        errorMessage3.append(message);
                    }
                    if (!mismatchFound) continue;
                    ArrayList nodeFailedFileList = (ArrayList)nodeBasedResultTable.get(node);
                    if (nodeFailedFileList == null) {
                        nodeFailedFileList = new ArrayList();
                        nodeBasedResultTable.put(node, nodeFailedFileList);
                    }
                    Hashtable<String, Object> fileTable = new Hashtable<String, Object>();
                    fileTable.put("FILE_NAME", refFileName);
                    fileTable.put("ERROR", errorMessage3.toString());
                    fileTable.put("DETAILED_ERROR", detailedMessage);
                    nodeFailedFileList.add(fileTable);
                }
            }
            if (nodeBasedResultTable.size() > 0) {
                ReportUtil.sureblankln();
                ReportUtil.surewriteRecord(ReportUtil.COMPONENT + ": " + compName);
                ReportUtil.sureblankln();
                for (String node : nodeBasedResultTable.keySet()) {
                    ReportUtil.surewriteRecord(ReportUtil.NODENAME + ": " + node);
                    int failedCount = 0;
                    for (Hashtable failedFileTable : (List)nodeBasedResultTable.get(node)) {
                        List detailedErrors;
                        if (++failedCount < 5 || ReportUtil.isVerbose()) {
                            ReportUtil.surewriteRecord("  " + failedFileTable.get("FILE_NAME") + "..." + failedFileTable.get("ERROR"));
                        }
                        if ((detailedErrors = (List)failedFileTable.get("DETAILED_ERROR")) == null) continue;
                        for (String detailedError : detailedErrors) {
                            ReportUtil.writeRecord("  \t" + detailedError);
                        }
                    }
                    if (failedCount <= 5 || ReportUtil.isVerbose()) continue;
                    String message = s_msgBundle.getMessage("5013", false, (Object[])new String[]{Integer.toString(failedCount - 5)});
                    ReportUtil.surewriteRecord("  " + message);
                }
            }
            String message = s_msgBundle.getMessage("9602", false, (Object[])new String[]{Integer.toString(refFileList.size())});
            ReportUtil.sureblankln();
            ReportUtil.surewriteRecord(message);
        }
    }

    public void setSoftwareComponent(String softwareComponent) {
        this.m_softwareComponent = softwareComponent;
    }

    public void setSoftwareComponentHome(String softwareComponentHome) {
        this.m_softwareComponentHome = softwareComponentHome;
    }

    public void setRelease(String release) {
        this.m_release = release;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4441", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4494", false);
    }
}

