/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskSpaceAvail
extends Task {
    private String m_location;
    private StorageSize m_reqdSpace = null;

    public TaskSpaceAvail(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskSpaceAvail(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskSpaceAvail(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public void setReqdSpace(long reqdSpace) {
        this.m_reqdSpace = new StorageSize(reqdSpace, StorageUnit.BYTE);
    }

    public void setReqdSpace(StorageSize reqdSpace) {
        this.m_reqdSpace = reqdSpace;
    }

    public boolean performTask() {
        List<VerificationError> vel;
        Trace.out((String)"Performing  Space Availability verification task...");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4000", false));
        ResultSet resultSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        boolean freeSpaceResult = globalExec.getFreeSpace(this.m_nodeList, this.m_location, resultSet);
        Trace.out((String)"TaskSpaceAvail:   getFreeSpace() performed!!");
        ReportUtil.println(LSEP + s_msgBundle.getMessage("4001", false, (Object[])new String[]{this.m_location}));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8012", false), s_msgBundle.getMessage("8019", false), s_msgBundle.getMessage("8001", false));
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            boolean gotSpaceValue = false;
            String comment = ReportUtil.UNKNOWN;
            String tavl = ReportUtil.UNKNOWN;
            if (Trace.isTraceEnabled()) {
                Trace.out((int)1, (String)"Checking result of space check.");
            }
            if (result.getStatus() == 1) {
                long avlSpace = 0L;
                if (Trace.isTraceEnabled()) {
                    Trace.out((int)1, (String)"Result of space check was successful.");
                }
                try {
                    Long lAvl = (Long)result.getResultInfoSet().firstElement();
                    avlSpace = lAvl;
                    StorageSize avlSpaceMS = new StorageSize(avlSpace, StorageUnit.BYTE);
                    tavl = ReportUtil.unitizeSize(avlSpaceMS);
                    if (avlSpaceMS.compareTo(this.m_reqdSpace) >= 0) {
                        Trace.out((String)("Sufficient space available on node: " + node + " [Required=" + this.m_reqdSpace + ", Available=" + avlSpaceMS + "] "));
                        this.m_resultSet.addResult(node, 1);
                        comment = ReportUtil.PASSED;
                    } else {
                        Trace.out((String)("Insufficient space on node: " + node + " [Required=" + this.m_reqdSpace + ", Available=" + avlSpaceMS + "]"));
                        this.m_resultSet.addResult(node, 3);
                        errDesc = new ErrorDescription(s_msgBundle.getMessage("7501", false, (Object[])new String[]{this.m_location, node, ReportUtil.unitizeSize(this.m_reqdSpace)}));
                        this.m_resultSet.addErrorDescription(node, errDesc);
                        comment = ReportUtil.FAILED;
                    }
                    gotSpaceValue = true;
                    this.m_resultSet.getResult(node).setHasResultValues(true);
                    this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(this.m_reqdSpace));
                    this.m_resultSet.getResult(node).setActualValue(tavl);
                }
                catch (NumberFormatException nfe) {
                    Trace.out((Exception)nfe);
                }
            }
            if (!gotSpaceValue) {
                Trace.out((String)("Free space  couldn't be obtained from node: " + node));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7592", true, (Object[])new String[]{this.m_location, node}), s_msgBundle, "7592");
                this.m_resultSet.addResult(node, 2);
                this.m_resultSet.addErrorDescription(node, errDesc);
            }
            ReportUtil.writeRecord(node, tavl, ReportUtil.unitizeSize(this.m_reqdSpace), comment);
        }
        this.m_resultSet.uploadResultSet(resultSet);
        this.m_resultSet.traceResultSet("\n====ResultSet returned by TaskSpaceAvail verification task====\n");
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("4002", false, (Object[])new String[]{this.m_location}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("4003", false, (Object[])new String[]{this.m_location}));
        if (!freeSpaceResult && (vel = this.m_resultSet.getErrors()).size() > 0) {
            ReportUtil.printError(vel.get(0).getErrorMessage());
        }
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4400", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4450", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    Location: " + this.m_location);
        sb.append("\n    RequiredSpace: " + this.m_reqdSpace);
        return sb.toString();
    }
}

