/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Step;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.InvalidStepException;
import oracle.ops.verification.framework.util.RangeOfValue;

public class TaskSwapSize
extends PeerCompatibleTask {
    private StorageSize m_reqdSwapSize;
    private StorageSize m_reqdMinSwapSize;
    private StorageSize m_reqdMaxSwapSize;
    private String m_refElemName;
    private List<Step> m_stepList = new ArrayList<Step>();
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1057", false);

    public TaskSwapSize(double size, StorageUnit unit) {
        this.m_reqdSwapSize = new StorageSize(size, unit);
    }

    public TaskSwapSize(StorageSize size) {
        this.m_reqdSwapSize = size;
    }

    public TaskSwapSize(String refElemName) {
        this.m_refElemName = refElemName;
    }

    public void addStep(RangeOfValue range, StorageUnit unit, float multiplier) throws InvalidStepException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Inside addStep: range = " + range + ", unit = " + (Object)((Object)unit) + ", mulitplier = " + multiplier));
        }
        this.m_stepList.add(new Step(range, unit, multiplier));
    }

    public boolean performTask() {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        if (this.m_refElemName == null) {
            this.performFixedSizeVerification();
        } else {
            this.performStepVerification();
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    void performFixedSizeVerification() {
        GlobalExecution globalExec = new GlobalExecution();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("m_reqswapSize=" + this.m_reqdSwapSize));
        }
        ResultSet swpRsltSet = new ResultSet();
        globalExec.checkSwapSpace(this.m_nodeList, this.m_reqdSwapSize, swpRsltSet);
        this.m_resultSet.uploadResultSet(swpRsltSet);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = swpRsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String avl;
            StorageSize avlSS;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                this.m_resultSet.getResult(node).setHasResultValues(true);
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("reqd=" + this.m_reqdSwapSize + ";avl=" + avl));
                }
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(this.m_reqdSwapSize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avlSS));
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7573", true, (Object[])new String[]{node, ReportUtil.unitizeSize(this.m_reqdSwapSize), ReportUtil.unitizeSize(avlSS)}), s_msgBundle, "7573");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(this.m_reqdSwapSize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avl, StorageUnit.KBYTE));
                comment = ReportUtil.FAILED;
            } else {
                avl = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7574", true, (Object[])new String[]{node}), s_msgBundle, "7574");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                comment = ReportUtil.FAILED;
            }
            ReportUtil.writeRecord(node, ReportUtil.unitizeSize(avl, StorageUnit.KBYTE), ReportUtil.unitizeSize(this.m_reqdSwapSize), comment);
        }
    }

    void performStepVerification() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet swpRsltSet = new ResultSet();
        ResultSet memRsltSet = new ResultSet();
        globalExec.checkSwapSpace(this.m_nodeList, 0L, swpRsltSet);
        this.m_resultSet.uploadResultSet(swpRsltSet);
        globalExec.checkMemory(this.m_nodeList, 0L, memRsltSet, true);
        this.m_resultSet.uploadResultSet(memRsltSet);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable htSwap = swpRsltSet.getResultTable();
        Hashtable htMem = memRsltSet.getResultTable();
        String avlSwpStr = ReportUtil.UNKNOWN;
        String reqdSwpStr = ReportUtil.UNKNOWN;
        Enumeration eSwap = htSwap.keys();
        while (eSwap.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String node = (String)eSwap.nextElement();
            Result resultSwap = (Result)htSwap.get(node);
            Result resultMem = (Result)htMem.get(node);
            if (resultSwap.getStatus() == 1 && resultMem.getStatus() == 1) {
                StorageSize avlSwpBytes = (StorageSize)resultSwap.getResultInfoSet().firstElement();
                StorageSize avlMemBytes = (StorageSize)resultMem.getResultInfoSet().firstElement();
                avlSwpStr = Double.toString(avlSwpBytes.sizeIn(StorageUnit.KBYTE));
                StorageSize reqdSwapMemorySize = this.getRequiredSwapSize(avlMemBytes);
                if (reqdSwapMemorySize == null) {
                    return;
                }
                reqdSwpStr = Double.toString(reqdSwapMemorySize.sizeIn(StorageUnit.KBYTE));
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(reqdSwapMemorySize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avlSwpBytes));
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("avlMemBytes=" + avlMemBytes));
                    Trace.out((String)("avlSwpBytes=" + avlSwpBytes));
                    Trace.out((String)("reqdSwapMemorySize=" + reqdSwapMemorySize));
                }
                if (avlSwpBytes.compareTo(reqdSwapMemorySize) >= 0) {
                    comment = ReportUtil.PASSED;
                } else {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7573", true, (Object[])new String[]{node, ReportUtil.unitizeSize(reqdSwapMemorySize), ReportUtil.unitizeSize(avlSwpBytes)}), s_msgBundle, "7573");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 3);
                    comment = ReportUtil.FAILED;
                }
            } else {
                if (resultSwap.getStatus() != 1) {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7574", true, (Object[])new String[]{node}), s_msgBundle, "7574");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                }
                if (resultMem.getStatus() != 1) {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7531", true, (Object[])new String[]{node}), s_msgBundle, "7531");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                }
                avlSwpStr = ReportUtil.UNKNOWN;
                reqdSwpStr = ReportUtil.UNKNOWN;
                comment = ReportUtil.FAILED;
                this.m_resultSet.addResult(node, 3);
            }
            ReportUtil.writeRecord(node, ReportUtil.unitizeSize(avlSwpStr, StorageUnit.KBYTE), ReportUtil.unitizeSize(reqdSwpStr, StorageUnit.KBYTE), comment);
        }
    }

    private StorageSize getRequiredSwapSize(StorageSize avlMemBytes) {
        StorageSize reqdSwapMemorySize = null;
        boolean stepFound = false;
        StorageUnit unit = StorageUnit.BYTE;
        for (Step step : this.m_stepList) {
            unit = step.getUnit();
            try {
                if (!step.getRange().contains(avlMemBytes)) {
                    continue;
                }
            }
            catch (InvalidRangeManipulationException irme) {
                if (!Trace.isTraceEnabled()) break;
                Trace.out((Exception)irme);
                break;
            }
            stepFound = true;
            reqdSwapMemorySize = new StorageSize(avlMemBytes.sizeIn(unit) * (double)step.getMultiplier(), unit);
            if (!Trace.isTraceEnabled()) break;
            Trace.out((String)("multiplier=" + step.getMultiplier()));
            break;
        }
        if (!stepFound && this.m_reqdMinSwapSize != null) {
            reqdSwapMemorySize = this.m_reqdMinSwapSize;
        }
        if (reqdSwapMemorySize == null) {
            this.m_resultSet.setStatus(2);
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7575", true), s_msgBundle, "7575");
            this.m_resultSet.addErrorDescription(errDesc);
            return null;
        }
        if (this.m_reqdMinSwapSize != null && this.m_reqdMinSwapSize.compareTo(reqdSwapMemorySize) > 0) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("The calculated swap memory " + reqdSwapMemorySize + " is less than the minimum " + this.m_reqdMinSwapSize + " . Using specified minimum as the requirement"));
            }
            reqdSwapMemorySize = this.m_reqdMinSwapSize;
        }
        if (this.m_reqdMaxSwapSize != null && this.m_reqdMaxSwapSize.compareTo(reqdSwapMemorySize) < 0) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("The calculated swap memory " + reqdSwapMemorySize + " is greater than the maximum " + this.m_reqdMaxSwapSize + " . Using specified maximum as the requirement"));
            }
            reqdSwapMemorySize = this.m_reqdMaxSwapSize;
        }
        return reqdSwapMemorySize;
    }

    public void setMinSwapSize(StorageSize size) {
        this.m_reqdMinSwapSize = size;
    }

    public void setMaxSwapSize(StorageSize size) {
        this.m_reqdMaxSwapSize = size;
    }

    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4420", false);
    }

    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4471", false);
    }

    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet archRsltSet = new ResultSet();
        globalExec.checkSwapSpace(this.m_nodeList, new StorageSize(0.0, StorageUnit.BYTE), archRsltSet);
        return archRsltSet;
    }

    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1057", false);
    }
}

