/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.VersionComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUSMDriverChecks
extends Task {
    private static final String STR_INSTALLED = "Installed";
    private static final String STR_LOADED = "Loaded";
    private static final String STR_OPT_INSTALLED = "installed";
    private static final String STR_OPT_LOADED = "loaded";
    private static final String STR_OPT_VERSION = "version";
    private static final String[] m_strCmdOption = new String[]{"installed", "loaded", "version"};
    private static final int OPT_INSTALLED = 0;
    private static final int OPT_LOADED = 1;
    private static final int OPT_VERSION = 2;
    private static final String STR_TRUE = "true";
    private static final String STR_USM_VERSION = "OS/ADVM,ACFS installed version";

    public TaskUSMDriverChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUSMDriverChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUSMDriverChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((int)5, (String)"Performing USM Drivers verification task... ");
        }
        if (!VerificationUtil.isUSMSupported()) {
            Trace.out((String)"ACFS/USM not supported on this platform");
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5160", false));
        try {
            this.performUSMDriverChecks();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5161", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5162", false));
        return false;
    }

    private void performUSMDriverChecks() {
        Trace.out((int)2, (String)"Entry");
        ResultSet resultSet = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        Vector<String> unknownNodes = new Vector<String>();
        boolean ret = this.checkDriversInstalled(this.m_nodeList, resultSet);
        Trace.out((int)5, (String)("Return value from checkDriversInstalled is " + ret));
        this.m_resultSet.uploadResultSet(resultSet);
        if (!ret) {
            Trace.out((int)5, (String)"Complete failure checking driver installed status on all of the nodes");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5156", true));
            return;
        }
        Trace.out((int)5, (String)"Drivers installed check passed on at least one node");
        resultSet.filterResult(succNodes, failNodes, unknownNodes);
        this.reportDriversInstalledStatus(succNodes, failNodes, unknownNodes);
        Trace.out((int)5, (String)"Proceeding to check if drivers loaded");
        if (succNodes.size() > 0) {
            Trace.out((int)5, (String)"Now check if drivers loaded");
            resultSet.clear();
            ret = this.checkDriversLoaded(succNodes, resultSet);
            Trace.out((int)5, (String)("Return value from checkDriversLoaded is " + ret));
            this.m_resultSet.uploadResultSet(resultSet);
            if (ret) {
                Trace.out((int)5, (String)"Drivers loaded check passed on at least one node");
                succNodes.clear();
                failNodes.clear();
                unknownNodes.clear();
                resultSet.filterResult(succNodes, failNodes, unknownNodes);
                this.reportDriversLoadedStatus(succNodes, failNodes, unknownNodes);
            } else {
                Trace.out((int)5, (String)"Complete failure checking driver loaded status on all of the nodes");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5168", true));
                return;
            }
        }
        if (succNodes.size() > 0) {
            String osVersion = null;
            resultSet.clear();
            this.getDriverVersion(succNodes, resultSet);
            osVersion = this.getLocalOSVersion();
            Trace.out((int)5, (String)("Local OS version is = " + osVersion));
            this.m_resultSet.uploadResultSet(resultSet);
            if (osVersion != null && osVersion.length() > 0) {
                Hashtable t = resultSet.getResultTable();
                Enumeration e = t.keys();
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)t.get(node);
                    if (result.getStatus() == 1) {
                        String cmdExecuted;
                        VersionComparator versionComparator = new VersionComparator("-");
                        String rsltOutput = (String)result.getResultInfoSet().firstElement();
                        Trace.out((int)5, (String)("Version received from node " + node + " is >" + rsltOutput + "<"));
                        String nodeVersion = this.parseDriverOutput(rsltOutput);
                        if (nodeVersion != null) {
                            int matched = versionComparator.compare(nodeVersion, osVersion);
                            if (matched >= 0) {
                                ReportUtil.println(s_msgBundle.getMessage("5173", false, (Object[])new String[]{node}));
                                continue;
                            }
                            ReportUtil.sureprintln(s_msgBundle.getMessage("5174", true, (Object[])new String[]{node}));
                            cmdExecuted = (String)result.getCommandInfoSet().firstElement();
                            if (cmdExecuted == null || rsltOutput == null) continue;
                            ReportUtil.println(s_msgBundle.getMessage("0050", false, (Object[])new String[]{cmdExecuted, rsltOutput}));
                            continue;
                        }
                        Trace.out((int)5, (String)("Failed to get USM Drivers Version on node " + node + ". Version checking could not be done."));
                        ReportUtil.sureprintln(s_msgBundle.getMessage("5175", true, (Object[])new String[]{node}));
                        cmdExecuted = (String)result.getCommandInfoSet().firstElement();
                        if (cmdExecuted == null || rsltOutput == null) continue;
                        ReportUtil.println(s_msgBundle.getMessage("0050", false, (Object[])new String[]{cmdExecuted, rsltOutput}));
                        continue;
                    }
                    Trace.out((int)5, (String)("Failed to get USM Drivers Version on node " + node + ". Version checking could not be done."));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5175", true, (Object[])new String[]{node}));
                }
            } else {
                Trace.out((int)5, (String)"Failed to get OS version on the local node. USM Drivers version check could not be done.");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5176", true));
            }
        }
    }

    private boolean checkDriversInstalled(String[] nodeList, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeList, resultSet, 0);
    }

    private boolean checkDriversLoaded(Vector<String> nodeVect, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeVect.toArray(new String[nodeVect.size()]), resultSet, 1);
    }

    private boolean getDriverVersion(Vector<String> nodeVect, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        return this.runDriverCommand(nodeVect.toArray(new String[nodeVect.size()]), resultSet, 2);
    }

    private String getLocalOSVersion() {
        Trace.out((int)2, (String)"Entry");
        String osversion = null;
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet knlvResultSet = new ResultSet();
        String localHost = null;
        try {
            localHost = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            localHost = "localnode";
            Trace.out((String)"UKE use local node constant");
        }
        globalExec.getKernelVersion(new String[]{localHost}, knlvResultSet);
        Result result = (Result)knlvResultSet.getResultTable().get(localHost);
        if (result.getStatus() == 1) {
            osversion = (String)result.getResultInfoSet().firstElement();
            Trace.out((int)5, (String)("Result.OPERATION_SUCCESSFUL:: available kernel version=" + osversion));
        }
        return osversion;
    }

    private boolean runDriverCommand(String[] nodeList, ResultSet resultSet, int cmdOption) {
        Trace.out((int)2, (String)"Entry");
        boolean ret = false;
        VerificationCommand[] driverCmdArray = new VerificationCommand[nodeList.length];
        Trace.out((int)5, (String)("Node List to runDriverCommand " + Arrays.asList(nodeList)));
        String stateCmd = VerificationUtil.getUSMDriverStatePath();
        for (int j = 0; j < nodeList.length; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd, m_strCmdOption[cmdOption]};
            Trace.out((int)5, (String)("Driver command args: " + Arrays.asList(arg)));
            String[] env = null;
            driverCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])driverCmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((int)5, (String)("Global failure executing driver command " + m_strCmdOption[cmdOption]));
            String message = s_msgBundle.getMessage("5177", false, (Object[])new String[]{m_strCmdOption[cmdOption]});
            ErrorDescription errorDesc = new ErrorDescription(message);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(message);
            return false;
        }
        block5: for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            VerificationCommand driverCmd = driverCmdArray[nodeIndex];
            Result result = driverCmd.getResult();
            if (result.getStatus() != 1) continue;
            String node = driverCmd.getNode();
            String output = driverCmd.getOutput();
            result.addResultInfo(output);
            result.addCommandInfo(driverCmd.getExecCommand());
            Trace.out((int)5, (String)("Output from driver command " + m_strCmdOption[cmdOption] + " is =" + output));
            switch (cmdOption) {
                case 0: 
                case 1: {
                    if (output.contains(STR_TRUE)) continue block5;
                    result.setStatus(3);
                    continue block5;
                }
                case 2: {
                    if (output.contains(STR_USM_VERSION)) continue block5;
                    result.setStatus(3);
                    continue block5;
                }
                default: {
                    result.setStatus(3);
                }
            }
        }
        return true;
    }

    private void reportDriversInstalledStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes) {
        Trace.out((int)5, (String)"Reporting Drivers Installed Status");
        this.reportDriversStatus(succNodes, failNodes, unknownNodes, "5163", "5156", "5165", "5166", STR_INSTALLED);
    }

    private void reportDriversLoadedStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes) {
        Trace.out((int)5, (String)"Reporting Drivers Loaded Status");
        this.reportDriversStatus(succNodes, failNodes, unknownNodes, "5167", "5168", "5169", "5170", STR_LOADED);
    }

    private void reportDriversStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes, String passmsg, String allfailmsg, String failmsg, String unknownmsg, String whatmsg) {
        Trace.out((int)5, (String)("Reporting " + whatmsg + " Drivers Status:"));
        if (succNodes.size() > 0) {
            Trace.out((int)5, (String)("USM Drivers " + whatmsg + " on node " + succNodes));
            ReportUtil.println(s_msgBundle.getMessage(passmsg, false) + LSEP + succNodes);
        } else {
            Trace.out((int)5, (String)("USM Drivers not " + whatmsg + " on all of the nodes"));
            ReportUtil.sureprintln(s_msgBundle.getMessage(allfailmsg, true));
        }
        if (failNodes.size() > 0) {
            Trace.out((int)5, (String)("USM Drivers not " + whatmsg + " on following nodes: " + LSEP + failNodes));
            ReportUtil.sureprintln(s_msgBundle.getMessage(failmsg, true) + LSEP + failNodes);
        }
        if (unknownNodes.size() > 0) {
            Trace.out((int)5, (String)("Unable to determine if USM Drivers " + whatmsg + " on following nodes: " + LSEP + unknownNodes));
            ReportUtil.sureprintln(s_msgBundle.getMessage(unknownmsg, true) + LSEP + failNodes);
        }
    }

    private String parseDriverOutput(String rsltOutput) {
        StringBuffer parseOutput = null;
        Trace.out((int)2, (String)"Entry");
        Trace.out((int)5, (String)("String to be parsed: >" + rsltOutput + "<"));
        if (rsltOutput != null && rsltOutput.contains(STR_USM_VERSION)) {
            int sp;
            parseOutput = new StringBuffer(rsltOutput);
            int eq = parseOutput.indexOf("=");
            int slash = parseOutput.indexOf("/", eq);
            String tmp1 = parseOutput.substring(eq + 1, slash);
            parseOutput = new StringBuffer(tmp1);
            while ((sp = parseOutput.indexOf(" ")) >= 0) {
                parseOutput.deleteCharAt(sp);
            }
            Trace.out((int)5, (String)("Parsed output of usm driver version is >" + parseOutput + "<"));
            return new String(parseOutput);
        }
        return null;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4498", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4448", false);
    }
}

