/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.asm.DiskGroup;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.ASMDiskGroup;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUSMIntegrity
extends Task {
    private boolean m_asmrunning;
    private boolean m_mute;
    private String[] m_dgList;
    private VerificationType m_vtype;
    private boolean m_checkASMRunning = true;
    private boolean m_DiskGroupCheck = false;
    private boolean m_OCRonASM;
    private boolean m_asmCheckOnly = false;
    private String m_fileSystem = null;

    public TaskUSMIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUSMIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUSMIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void doCheckASMRunning(boolean asmRunning) {
        this.m_checkASMRunning = asmRunning;
    }

    public void setNoDiskGroupCheck(boolean noDGCheck) {
        this.m_DiskGroupCheck = noDGCheck;
    }

    public void setVerificationType(VerificationType vtype) {
        this.m_vtype = vtype;
    }

    public void setFileSystem(String fileSystem) {
        this.m_fileSystem = fileSystem;
    }

    public void setOCRonASM(boolean isOCRonASM) {
        this.m_OCRonASM = isOCRonASM;
    }

    @Override
    public boolean performTask() {
        if (this.m_OCRonASM) {
            if (!VerificationUtil.isUSMSupported()) {
                return true;
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5154", false));
            Trace.out((String)"OCR detected on ASM. Starting USM Integrity checks...");
        } else {
            Trace.out((String)"Performing ASM/USM Integrity verification task... ");
            if (this.m_asmCheckOnly) {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4391", false));
            } else {
                if (!VerificationUtil.isUSMSupported()) {
                    return true;
                }
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4388", false));
            }
        }
        this.performUSMIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            if (this.m_asmCheckOnly) {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4392", false));
            } else {
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4389", false));
            }
            return true;
        }
        if (this.m_asmCheckOnly) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4393", false));
        } else {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4390", false));
        }
        return false;
    }

    void performUSMIntegrityChecks() {
        if (this.m_checkASMRunning) {
            ArrayList<String> runningASMNodes = new ArrayList<String>();
            ArrayList<String> failedASMNodes = new ArrayList<String>();
            Trace.out((String)"Starting ASM Running check on all nodes...");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5107", false));
            ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil(this.m_nodeList);
            for (String node : this.m_nodeList) {
                try {
                    Trace.out((int)5, (String)("Checking if ASM is running on node " + node));
                    boolean asmrunning = asmdg.isASMRunning(node);
                    if (asmrunning) {
                        Trace.out((int)5, (String)("ASM is running on node " + node));
                        runningASMNodes.add(node);
                        this.m_resultSet.addResult(node, 1);
                        continue;
                    }
                    Trace.out((int)5, (String)("ASM is NOT running on node " + node));
                    failedASMNodes.add(node);
                    this.m_resultSet.addResult(node, 3);
                }
                catch (ASMDiskGroupsUtilException e) {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5137", true, (Object[])new String[]{node}));
                    this.m_resultSet.addResult(node, 2);
                    Trace.out((int)5, (String)("Error checking if ASM is running on node " + node + "." + e));
                }
            }
            this.m_resultSet.setStatus();
            this.reportASMRunningStatus(runningASMNodes, failedASMNodes);
            Trace.out((int)5, (String)"ASM Running check on all nodes completed.");
        }
        if (!this.m_DiskGroupCheck) {
            if (this.m_vtype == VerificationType.PREREQ_DB_INST) {
                this.checkDiskGroupsforDB();
            } else {
                this.checkDiskGroupsASM();
            }
        }
        if (this.m_fileSystem == null) {
            Trace.out((int)5, (String)"fileSystem is NULL.");
            return;
        }
        Trace.out((int)5, (String)("Checking fileSystem: '" + this.m_fileSystem + "'"));
        TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(this.m_nodeList);
        String[] fileSystemList = new String[]{this.m_fileSystem};
        taskSSAccess.setStorageIDlist(fileSystemList);
        boolean ssaStatus = taskSSAccess.performTask();
        ResultSet ssaRset = taskSSAccess.getResultSet();
        Trace.out((String)"==== Uploading results from ssaRset");
        this.m_resultSet.uploadResultSet(ssaRset);
    }

    private void reportASMRunningStatus(List<String> runningASMNodes, List<String> failedASMNodes) {
        Trace.out((int)2, (String)"Entry");
        Trace.out((int)5, (String)"Reporting ASM Running status for the nodes");
        Trace.out((int)5, (String)("No of nodes running ASM = " + runningASMNodes.size()));
        Trace.out((int)5, (String)("No of nodes NOT running ASM = " + failedASMNodes.size()));
        if (runningASMNodes.size() == this.m_nodeList.length) {
            Trace.out((int)5, (String)"ASM is running on all cluster nodes.");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5108", false));
        } else if (failedASMNodes.size() == this.m_nodeList.length) {
            Trace.out((int)5, (String)"ASM is NOT running on all cluster nodes.");
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5109", true));
        } else if (failedASMNodes.size() > 0) {
            String nodel = new String();
            for (String nodenm : failedASMNodes) {
                nodel = nodel + nodenm + ",";
            }
            ReportUtil.println(LSEP + s_msgBundle.getMessage("5110", true, (Object[])new String[]{nodel}));
        }
        Trace.out((int)2, (String)"Exit");
    }

    private boolean checkDiskGroupsforDB() {
        boolean getdg;
        Trace.out((int)2, (String)"Entry");
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("5139", false));
        if (this.m_dgList == null || this.m_dgList.length == 0) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5138", true));
            return false;
        }
        ASMDiskGroupsUtil dgutil = new ASMDiskGroupsUtil(this.m_nodeList);
        Hashtable<String, List<ASMDiskGroup>> htdg = new Hashtable<String, List<ASMDiskGroup>>();
        Hashtable<String, ASMDiskGroup> htreqddg = new Hashtable<String, ASMDiskGroup>();
        ResultSet dgResultSet = new ResultSet();
        try {
            getdg = dgutil.getDiskGroups(this.m_nodeList, dgResultSet, htdg);
        }
        catch (ASMDiskGroupsUtilException e) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5131", true));
            this.m_resultSet.uploadResultSet(dgResultSet);
            this.m_resultSet.setStatus();
            return false;
        }
        this.m_resultSet.uploadResultSet(dgResultSet);
        if (getdg) {
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("5143", false));
            for (String dgnm : this.m_dgList) {
                Vector<String> unavailnodes = new Vector<String>();
                for (String node : this.m_nodeList) {
                    List<ASMDiskGroup> dgl = htdg.get(node);
                    if (dgl == null || dgl.size() < 1) {
                        unavailnodes.add(node);
                        continue;
                    }
                    boolean founddg = false;
                    for (ASMDiskGroup dg1 : dgl) {
                        if (!dg1.getName().equals(dgnm)) continue;
                        if (htreqddg.get(dgnm) == null) {
                            htreqddg.put(dgnm, dg1);
                        }
                        founddg = true;
                    }
                    if (founddg) continue;
                    unavailnodes.add(node);
                }
                if (unavailnodes.size() > 0) {
                    if (unavailnodes.size() < this.m_nodeList.length) {
                        ReportUtil.sureprintln(s_msgBundle.getMessage("5144", true, (Object[])new String[]{dgnm, unavailnodes.toString()}));
                        continue;
                    }
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5145", true, (Object[])new String[]{dgnm}));
                    continue;
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("5146", false, (Object[])new String[]{dgnm}));
            }
            ReportUtil.sureblankln();
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(s_msgBundle.getMessage("5148", false));
            if (htreqddg != null && htreqddg.size() > 0) {
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("5133", false), s_msgBundle.getMessage("5134", false), s_msgBundle.getMessage("5135", false));
                Enumeration dgenum = htreqddg.keys();
                while (dgenum.hasMoreElements()) {
                    String dgnam = (String)dgenum.nextElement();
                    ASMDiskGroup adg = (ASMDiskGroup)htreqddg.get(dgnam);
                    ReportUtil.writeRecord(adg.getName(), Double.toString(adg.getSize().sizeIn(StorageUnit.MBYTE)), Double.toString(adg.getFree().sizeIn(StorageUnit.MBYTE)));
                    if (!(adg.getFree().sizeIn(StorageUnit.MBYTE) < 400.0)) continue;
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5136", false, (Object[])new String[]{adg.getName(), new Long(400L).toString()}));
                    Trace.out((String)("INSUFFICIENT SIZE OF DISKGROUP" + adg.getName() + ": MIN REQD=" + 400L + ", DISKGROUP SIZE=" + adg.getSize()));
                }
            } else {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5132", true));
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5140", false));
            return true;
        }
        ReportUtil.sureprintln(s_msgBundle.getMessage("5131", false));
        ReportUtil.sureprintln(s_msgBundle.getMessage("5140", false));
        return false;
    }

    private void checkDiskGroupsASM() {
        Trace.out((int)2, (String)"Entry");
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil(this.m_nodeList);
        Trace.out((int)5, (String)"Starting ASM DiskGroup check...");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5111", false));
        List<DiskGroup> dgLocal = null;
        try {
            dgLocal = asmdg.getDiskGroups();
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((int)5, (String)("Exception when getting disk groups list from ASM" + e));
            ReportUtil.sureprintln(s_msgBundle.getMessage("5112", true));
        }
        if (dgLocal != null && dgLocal.size() > 0) {
            Trace.out((int)5, (String)"DiskGroup Check: At least ONE Disk Group found.");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5113", false));
        } else {
            Trace.out((int)5, (String)"DiskGroup Check: WARNING - No Disk Groups have been configured.");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5114", true));
        }
        Trace.out((int)5, (String)"DiskGroup Check: Completed.");
    }

    public void setASMChecksOnly(boolean asmonly) {
        this.m_asmCheckOnly = asmonly;
    }

    public boolean getASMChecksOnlyFlag() {
        return this.m_asmCheckOnly;
    }

    public void setASMDGList(String[] dgList) {
        this.m_dgList = dgList;
    }

    public void setASMDGList(String dgName) {
        this.setASMDGList(new String[]{dgName});
    }

    public String[] getASMDGList() {
        return this.m_dgList;
    }

    @Override
    public String getDefaultElementName() {
        if (this.m_asmCheckOnly) {
            return s_msgBundle.getMessage("6500", false);
        }
        return s_msgBundle.getMessage("4447", false);
    }

    @Override
    public String getDefaultDescription() {
        if (this.m_asmCheckOnly) {
            return s_msgBundle.getMessage("6700", false);
        }
        return s_msgBundle.getMessage("4497", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

