/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.USMDevInfo;
import oracle.ops.verification.framework.storage.USMDevInfoException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUSMUdevChecks
extends Task {
    private String m_owner = null;
    private String m_group = null;
    private String m_perms = null;
    private StorageEntity m_stEntity = StorageEntity.USM;
    private String[] m_UdevCheckPaths = new String[0];
    private String[] m_UdevCheckFileSystems = new String[0];
    private String m_stEntityString = null;
    private static final String TAG_USMDEV = "USMDEV";
    private static final String STRING_CSS_USER = "CSS_USER";

    public TaskUSMUdevChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUSMUdevChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUSMUdevChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (Trace.isTraceEnabled()) {
            Trace.out((int)5, (String)"Performing udev checks for USM ");
        }
        switch (this.m_stEntity) {
            case USM: {
                this.m_stEntityString = s_msgBundle.getMessage("9803", false);
                break;
            }
            case OCR: {
                this.m_stEntityString = s_msgBundle.getMessage("9804", false);
                break;
            }
            case VDISK: {
                this.m_stEntityString = s_msgBundle.getMessage("9805", false);
                break;
            }
            default: {
                this.m_stEntityString = s_msgBundle.getMessage("9803", false);
            }
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5191", false, (Object[])new String[]{this.m_stEntityString}));
        this.performUdevChecks();
        if (this.m_resultSet.allSuccess()) {
            Trace.out((int)5, (String)"ResultSet shows alll Success");
            ReportUtil.printResult(s_msgBundle.getMessage("5178", false, (Object[])new String[]{this.m_stEntityString}));
            ReportUtil.sureblankln();
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        ReportUtil.printResult(s_msgBundle.getMessage("5179", false, (Object[])new String[]{this.m_stEntityString}));
        ReportUtil.sureblankln();
        return false;
    }

    private void performUdevChecks() {
        sTaskFreeSpace sTask;
        Trace.out((int)2, (String)"Entry");
        if (!this.getStorageAttributes()) {
            Trace.out((String)"Failed to get storage attributes. Cannot proceed with Udev attributes checks.");
            ReportUtil.printError(s_msgBundle.getMessage("9806", true));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        ClusterInfo ci = null;
        VoteDiskInfo[] vdiskArr = null;
        String[] ocrLocations = null;
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> fileSystemList = new ArrayList<String>();
        StorageInfo stInfo = null;
        String voteLoc = null;
        String ocrLoc = null;
        String fileSystem = null;
        String savFileSystem = null;
        int i = 0;
        if (this.isOCRUDevCheck()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Doing OCRUdevCheck");
            }
            try {
                ci = new ClusterInfo(VerificationUtil.getCRSHome());
                ocrLocations = ClusterInfo.getOCRLocations((Version)new Version()).getPaths();
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)"ClusterInfoException trying to get OCR locations");
                ReportUtil.printError(s_msgBundle.getMessage("5196", true) + cie.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return;
            }
            for (i = 0; i < ocrLocations.length; ++i) {
                ocrLoc = ocrLocations[i];
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("OCR location Path " + i + " = " + ocrLoc));
                }
                if (VerificationUtil.isASMPath(ocrLoc)) continue;
                try {
                    stInfo = new TypeFinder().getStorageInstance(ocrLoc);
                }
                catch (StorageException e) {
                    Trace.out((String)("StorageException attempting to get storage type for: " + ocrLoc));
                    continue;
                }
                fileSystem = ocrLoc;
                while (stInfo.getType() == 5) {
                    sTask = new sTaskFreeSpace();
                    Command[] cmdArray = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(ocrLoc);
                    cmdArray[0] = new RunGenericCommand("localnode", cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, freeSpcRsltSet);
                    Hashtable t = freeSpcRsltSet.getResultTable();
                    Enumeration e = t.keys();
                    fileSystem = "UNKNOWN";
                    while (e.hasMoreElements()) {
                        String node = (String)e.nextElement();
                        Result result = (Result)t.get(node);
                        if (result.getStatus() != 1) continue;
                        String cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut, 0);
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)("Parsing ocrLoc: " + ocrLoc + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                pathList.add(ocrLoc);
                fileSystemList.add(fileSystem);
            }
        } else if (this.isVDiskUDevCheck()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Doing VDiskUdevCheck");
            }
            try {
                ci = new ClusterInfo(VerificationUtil.getCRSHome());
                vdiskArr = ci.getVoteDiskLocations();
            }
            catch (ClusterInfoException cie) {
                Trace.out((String)"ClusterInfoException trying to get voting disk locations");
                ReportUtil.printError(s_msgBundle.getMessage("5197", true) + cie.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("No of Voting disks found = " + vdiskArr.length));
            }
            for (i = 0; i < vdiskArr.length; ++i) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Voting Disk Path " + i + " = " + vdiskArr[i].getPath()));
                }
                if (vdiskArr[i].isASMPath() == 1) continue;
                voteLoc = vdiskArr[i].getPath();
                try {
                    stInfo = new TypeFinder().getStorageInstance(voteLoc);
                }
                catch (StorageException e) {
                    Trace.out((String)("StorageException attempting to get storage type for: " + voteLoc));
                    continue;
                }
                fileSystem = voteLoc;
                while (stInfo.getType() == 5) {
                    sTask = new sTaskFreeSpace();
                    Command[] cmdArray = new Command[1];
                    ResultSet freeSpcRsltSet = new ResultSet();
                    String cmd = sTask.getCommand(voteLoc);
                    cmdArray[0] = new RunGenericCommand("localnode", cmd);
                    boolean cmdResult = new GlobalHandler().submit(cmdArray, 0, freeSpcRsltSet);
                    Hashtable t = freeSpcRsltSet.getResultTable();
                    Enumeration e = t.keys();
                    fileSystem = "UNKNOWN";
                    while (e.hasMoreElements()) {
                        String node = (String)e.nextElement();
                        Result result = (Result)t.get(node);
                        if (result.getStatus() != 1) continue;
                        String cmdOut = VerificationUtil.fetchVerificationValue((String)result.getResultInfoSet().firstElement());
                        fileSystem = sTask.getData(cmdOut, 0);
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)("Parsing VoteLoc: " + voteLoc + " to: " + fileSystem));
                    }
                    if (savFileSystem == null) {
                        savFileSystem = fileSystem;
                    } else {
                        if (fileSystem.contentEquals(savFileSystem)) break;
                        savFileSystem = fileSystem;
                    }
                    try {
                        stInfo = new TypeFinder().getStorageInstance(fileSystem);
                    }
                    catch (StorageException se) {
                        Trace.out((String)("StorageException getting storage type for: " + fileSystem));
                        break;
                    }
                }
                if (stInfo.getType() != 1) continue;
                pathList.add(voteLoc);
                fileSystemList.add(fileSystem);
            }
        }
        this.m_UdevCheckPaths = pathList.toArray(new String[pathList.size()]);
        this.m_UdevCheckFileSystems = fileSystemList.toArray(new String[fileSystemList.size()]);
        if (this.m_UdevCheckPaths.length == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"m_UdevCheckPaths is empty!!");
            }
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return;
        }
        ResultSet udevResultSet = new ResultSet();
        this.getUdevAttributes(this.m_nodeList, udevResultSet);
        this.m_resultSet.uploadResultSet(udevResultSet);
        if (udevResultSet.anySuccess()) {
            if (this.isUSMUDevCheck()) {
                this.reportUdevCheckResult(udevResultSet);
            } else if (this.isAnyLocationOnDisk()) {
                this.reportUdevPathCheckResult(udevResultSet);
            }
        }
    }

    private boolean getStorageAttributes() {
        switch (this.m_stEntity) {
            case USM: {
                this.m_owner = VerificationUtil.getUSMDeviceOwner();
                this.m_group = this.getASMAdminGroup();
                this.m_perms = this.getUSMDevPerms();
                break;
            }
            case OCR: {
                this.m_owner = VerificationUtil.getOCROwner();
                this.m_group = this.getOCRGroup();
                this.m_perms = VerificationUtil.getOCRPermissions();
                break;
            }
            case VDISK: {
                this.m_owner = TaskUSMUdevChecks.getVDiskOwner();
                this.m_group = this.getVDiskGroup();
                this.m_perms = VerificationUtil.getVDiskPermissions();
                break;
            }
        }
        return this.m_owner != null && this.m_group != null && this.m_perms != null;
    }

    private void reportUdevCheckResult(ResultSet resultSet) {
        this.reportUdevCheckResult(resultSet, null);
    }

    private void reportUdevCheckResult(ResultSet resultSet, String path2Check) {
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        String hdrName = s_msgBundle.getMessage("5180", false);
        String hdrOwner = s_msgBundle.getMessage("5181", false);
        String hdrGroup = s_msgBundle.getMessage("5182", false);
        String hdrPerms = s_msgBundle.getMessage("5183", false);
        String hdrResult = s_msgBundle.getMessage("5192", false);
        boolean pathSpecified = path2Check != null;
        String distID = VerificationUtil.getUniqueDistributionID();
        USMDevInfo usmDev = null;
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                Vector udevVect = result.getResultInfoSet();
                if (udevVect.size() > 0) {
                    ReportUtil.writeColHeaders(hdrName, hdrOwner, hdrGroup, hdrPerms, hdrResult);
                    int j = 0;
                    int i = udevVect.size();
                    while (j < udevVect.size()) {
                        Boolean pathFoundinUdev = false;
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("udevVect size: " + udevVect.size() + " i: " + i + " j: " + j));
                        }
                        if (distID.startsWith("SUSE")) {
                            usmDev = (USMDevInfo)udevVect.get(j);
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)("Getting SUSE udevVect object: " + j));
                            }
                        } else {
                            usmDev = (USMDevInfo)udevVect.get(i - 1);
                            if (Trace.isLevelEnabled((int)5)) {
                                Trace.out((String)("Getting udevVect object: " + (i - 1)));
                            }
                        }
                        if (pathSpecified) {
                            pathFoundinUdev = usmDev.match(path2Check);
                        }
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("Found usmDev: Name: '" + usmDev.getName() + "' Owner: '" + usmDev.getOwner() + "' Group: '" + usmDev.getGroup() + "' Permissions: '" + usmDev.getPerms() + "'\n pathSecified: '" + pathSpecified + "' pathFoundinUdev: '" + pathFoundinUdev + "'"));
                        }
                        if (!pathSpecified || pathSpecified && pathFoundinUdev.booleanValue()) {
                            Vector<String> unmatch = new Vector<String>();
                            boolean match = this.compareAttrib(usmDev, unmatch);
                            if (match) {
                                Trace.out((int)5, (String)("Check for device " + usmDev.getName() + " passed."));
                                ReportUtil.writeRecord(usmDev.getName(), usmDev.getOwner(), usmDev.getGroup(), usmDev.getPerms(), ReportUtil.PASSED);
                                break;
                            }
                            Trace.out((int)5, (String)("Check for device " + usmDev.getName() + " failed."));
                            ReportUtil.sureprintln(s_msgBundle.getMessage("5184", true, (Object[])new String[]{node + ":" + (pathSpecified ? path2Check : usmDev.getName()), unmatch.toString()}));
                            this.m_resultSet.addResult(node, 3);
                            break;
                        }
                        ++j;
                        --i;
                    }
                    ReportUtil.blankln();
                    continue;
                }
                Trace.out((int)5, (String)("No udev entries found on node " + node));
                ReportUtil.sureprintln(s_msgBundle.getMessage("5185", true, (Object[])new String[]{node}));
                this.m_resultSet.addResult(node, 3);
                continue;
            }
            Trace.out((int)5, (String)("Check for UDev device entries failed on node " + node));
            ReportUtil.sureprintln(s_msgBundle.getMessage("5186", true, (Object[])new String[]{node}));
            this.m_resultSet.addResult(node, 2);
        }
    }

    private boolean isAnyLocationOnDisk() {
        Vector<String> diskList = new Vector<String>();
        StorageInfo stInfo = null;
        String localNode = null;
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            localNode = new String("LocalNode");
        }
        for (String path2Check : this.m_UdevCheckPaths) {
            if (VerificationUtil.isASMPath(path2Check)) {
                if (!Trace.isLevelEnabled((int)5)) continue;
                Trace.out((String)("Skipping ASM path: " + path2Check));
                continue;
            }
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Checking storage type for location " + path2Check));
            }
            try {
                stInfo = new TypeFinder().getStorageInstance(path2Check);
            }
            catch (StorageException e) {
                Trace.out((String)("StorageException attempting to get storage type for " + path2Check));
                ReportUtil.sureprintln(s_msgBundle.getMessage("9800", true, (Object[])new String[]{path2Check}) + LSEP + e.getMessage());
                ReportUtil.sureblankln();
                this.m_resultSet.addResult(localNode, 2);
                continue;
            }
            if (stInfo.getType() == 1) {
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("Location " + path2Check + " is of type DISK"));
                }
                diskList.add(path2Check);
                continue;
            }
            Trace.out((String)("Storage " + path2Check + "is not of type DISK, skipping Udev checks"));
        }
        if (diskList.size() > 0) {
            this.m_UdevCheckPaths = diskList.toArray(new String[diskList.size()]);
            return true;
        }
        return false;
    }

    private void reportUdevPathCheckResult(ResultSet resultSet) {
        for (String path2Check : this.m_UdevCheckPaths) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Checking and reporting result for path " + path2Check));
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5198", false, (Object[])new String[]{path2Check}));
            this.reportUdevCheckResult(resultSet, path2Check);
        }
    }

    private boolean compareAttrib(USMDevInfo usmDev, Vector<String> unmatch) {
        boolean match = true;
        String Found = s_msgBundle.getMessage("0052", false);
        String Expected = s_msgBundle.getMessage("0053", false);
        if (!usmDev.getOwner().equals(this.m_owner)) {
            Trace.out((int)5, (String)("Owners NOT equal: usmDev '" + usmDev.getOwner() + "' m_owner '" + this.m_owner + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5181", false) + ": " + Found + "'" + usmDev.getOwner() + "' " + Expected + "'" + this.m_owner + "'"));
        }
        if (!usmDev.getGroup().equals(this.m_group)) {
            Trace.out((int)5, (String)("Groups NOT equal: usmDev '" + usmDev.getGroup() + "' m_group '" + this.m_group + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5182", false) + ": " + Found + "'" + usmDev.getGroup() + "' " + Expected + "'" + this.m_group + "'"));
        }
        if (!usmDev.getPerms().equals(this.m_perms)) {
            Trace.out((int)5, (String)("Perms NOT equal: usmDev '" + usmDev.getPerms() + "' m_perms '" + this.m_perms + "'"));
            match = false;
            unmatch.add(new String(s_msgBundle.getMessage("5183", false) + ": " + Found + "'" + usmDev.getPerms() + "' " + Expected + "'" + this.m_perms + "'"));
        }
        return match;
    }

    private String getUSMDevPerms() {
        return VerificationUtil.getDefaultUSMDevPerms();
    }

    private boolean getUdevAttributes(String[] nodeList, ResultSet resultSet) {
        Trace.out((int)2, (String)"Entry");
        VerificationCommand[] udevCmdArray = new VerificationCommand[nodeList.length];
        String[] udevPaths = new String[this.m_UdevCheckFileSystems.length];
        String udevList = null;
        Trace.out((int)5, (String)("Node List to udevCommand " + Arrays.asList(nodeList)));
        for (int i = 0; i < this.m_UdevCheckFileSystems.length; ++i) {
            udevPaths[i] = this.m_UdevCheckFileSystems[i].replaceFirst("/dev/", "");
        }
        udevList = VerificationUtil.strArr2List(udevPaths);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nm_UdevCheckPaths: " + VerificationUtil.strArr2List(this.m_UdevCheckPaths) + "\nm_UdevCheckFileSystems: " + VerificationUtil.strArr2List(this.m_UdevCheckFileSystems) + "\nudevList: " + udevList + "\n"));
        }
        for (int j = 0; j < nodeList.length; ++j) {
            String[] arg;
            String[] env = null;
            if (this.isUSMUDevCheck()) {
                arg = new String[]{"-getusmdevinfo", udevList};
                Trace.out((int)5, (String)(" Get usm device info command args: " + Arrays.asList(arg)));
            } else {
                arg = new String[]{"-getudevinfo", udevList};
                Trace.out((int)5, (String)(" Get udev info command args: " + Arrays.asList(arg)));
            }
            udevCmdArray[j] = new VerificationCommand(nodeList[j], arg, env);
        }
        new GlobalHandler().submit((Command[])udevCmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((int)5, (String)"Global failure executing getusmdevinfo command. ");
            String message = s_msgBundle.getMessage("5187", true);
            ErrorDescription errorDesc = new ErrorDescription(message);
            resultSet.addErrorDescription(nodeList, errorDesc);
            ReportUtil.printError(message);
            this.m_resultSet.addResult(nodeList, 2);
            return false;
        }
        for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            VerificationCommand udevCmd = udevCmdArray[nodeIndex];
            String node = udevCmd.getNode();
            Result result = udevCmd.getResult();
            if (udevCmd.getVfyCode() == 0 && result.getStatus() == 1) {
                String output = udevCmd.getOutput();
                Vector<USMDevInfo> usmdevVect = new Vector<USMDevInfo>();
                this.parseUsmDevCmdOutput(output, usmdevVect, node);
                result.addResultInfo(usmdevVect);
                Trace.out((int)5, (String)("Output from get udev usm command is =" + output));
                continue;
            }
            String message = s_msgBundle.getMessage("9802", true, (Object[])new String[]{node});
            String errmsg = udevCmd.getError();
            ErrorDescription errorDesc = null;
            if (errmsg != null) {
                errorDesc = new ErrorDescription(message + VerificationConstants.LINE_SEPARATOR + errmsg);
                ReportUtil.printError(message + VerificationConstants.LINE_SEPARATOR + errmsg);
            } else {
                errorDesc = new ErrorDescription(message);
                ReportUtil.printError(message);
            }
            resultSet.addErrorDescription(node, errorDesc);
            resultSet.getResult(node).setStatus(3);
        }
        resultSet.setStatus();
        return true;
    }

    private void parseUsmDevCmdOutput(String output, Vector<USMDevInfo> usmdevVect, String node) {
        Vector usmDevStr = null;
        try {
            usmDevStr = GenericUtil.getAllStrByTags(output, TAG_USMDEV);
        }
        catch (ParsingException e) {
            Trace.out((int)5, (String)("Error parsing device command output:" + usmDevStr));
            this.m_resultSet.getResult(node).setStatus(2);
            this.m_resultSet.getResult(node).setHasResultValues(true);
            this.m_resultSet.getResult(node).setActualValue(usmDevStr.toString() + e);
            this.m_resultSet.setStatus(2);
        }
        if (usmDevStr.size() > 0) {
            for (int i = 0; i < usmDevStr.size(); ++i) {
                Trace.out((int)5, (String)("Device String [" + i + "]=" + (String)usmDevStr.get(i)));
                boolean ret = false;
                USMDevInfo usminfo = null;
                try {
                    usminfo = new USMDevInfo();
                    ret = usminfo.parse((String)usmDevStr.get(i));
                }
                catch (USMDevInfoException e) {
                    Trace.out((int)5, (String)("Error parsing the following output on node " + node + ": \"" + (String)usmDevStr.get(i) + "\""));
                }
                if (ret) {
                    Trace.out((int)5, (String)"Adding new USMDevInfo to node vector");
                    usmdevVect.add(usminfo);
                    continue;
                }
                Trace.out((int)5, (String)("Error parsing the following output on node " + node + ": \"" + (String)usmDevStr.get(i) + "\""));
            }
        }
    }

    private String getASMAdminGroup() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String crsHomeForASM = VerificationUtil.getCRSHome();
        String asmGroup = null;
        try {
            asmGroup = nativeSystem.getASMAdminGroup(crsHomeForASM);
        }
        catch (NativeException e) {
            Trace.out((String)("ERROR: Problem in getting ASMADMIN group from CRS Home: '" + crsHomeForASM + "'"));
            Trace.out((Exception)((Object)e));
            String errorMsg = s_msgBundle.getMessage("5151", true, (Object[])new String[]{crsHomeForASM});
            ReportUtil.printError(errorMsg);
            return null;
        }
        return asmGroup;
    }

    public void setOwner(String owner) {
        this.m_owner = owner;
    }

    public void setGroup(String group1) {
        this.m_group = group1;
    }

    public void setPerms(String perms) {
        this.m_perms = perms;
    }

    public void setUSMUDevCheck() {
        this.m_stEntity = StorageEntity.USM;
    }

    public void setOCRUDevCheck() {
        this.m_stEntity = StorageEntity.OCR;
    }

    public void setVDiskUDevCheck() {
        this.m_stEntity = StorageEntity.VDISK;
    }

    public boolean isUSMUDevCheck() {
        return this.m_stEntity == StorageEntity.USM;
    }

    public boolean isOCRUDevCheck() {
        return this.m_stEntity == StorageEntity.OCR;
    }

    public boolean isVDiskUDevCheck() {
        return this.m_stEntity == StorageEntity.VDISK;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4449", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4499", false);
    }

    public static String getVDiskOwner() {
        try {
            Util hasUtil = new Util();
            return hasUtil.getOracleUser(VerificationUtil.getCRSHome(), null);
        }
        catch (UtilException e) {
            Trace.out((String)"Couldn't get vdisk owner");
            return null;
        }
    }

    public String getVDiskGroup() {
        return VerificationUtil.getOraInventoryGroup();
    }

    public String getOCRGroup() {
        return VerificationUtil.getOraInventoryGroup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StorageEntity {
        USM,
        OCR,
        VDISK;

    }
}

